/*
 *  
 *  $Id: seleccionardiagnostico.cpp 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/checkbox.h>
#include "seleccionardiagnostico.h"
#include <sstream>
#include <api/ientorno.h>
#include <api/icontroladorimportacionpacs.h>
#include <wx/msgdlg.h>
#include <api/icontroladorhistorial.h>
#include "../../exportacion/tagsprivados.h"

namespace GNKVisualizator {
	namespace GUI {

		SeleccionarDiagnostico::SeleccionarDiagnostico (wxWindow* pParent, const std::string& ruta,GNC::GCS::IEntorno* pEntorno):SeleccionarDiagnosticoBase(pParent)
		{
			m_pEntorno = pEntorno;

			m_uidEstudio = std::string("");
			m_pListaDiagnosticos->AddRoot(wxT("Raiz"));
			//ojo, en atencion primaria no se comparten los diagnosticos por estudio sino que se comparten por serie
			GNC::GCS::IControladorHistorial::ListaModelosEstudios estudiosDiagnosticos = pEntorno->GetControladorHistorial()->GetEstudiosDiagnosticosSeriePath(ruta, UID_APRIM);
			for(GNC::GCS::IControladorHistorial::ListaModelosEstudios::iterator it = estudiosDiagnosticos.begin(); it != estudiosDiagnosticos.end(); it++){
				wxTreeItemId idItem = m_pListaDiagnosticos->AppendItem(m_pListaDiagnosticos->GetRootItem(),wxString::FromUTF8((*it).m_nombreMedico.c_str()));
				m_pListaDiagnosticos->SetItemText(idItem,1,wxString::FromUTF8((*it).m_horaEstudio.c_str()));
				wxDateTime fecha;
				fecha.ParseFormat(wxString::FromUTF8((*it).m_fechaEstudio.c_str()),wxT("%Y-%m-%d"));
				m_pListaDiagnosticos->SetItemText(idItem,2,fecha.Format(_("%m/%d/%Y")));
				m_pListaDiagnosticos->SetItemText(idItem,3,wxString::FromUTF8((*it).m_descripcionEstudio.c_str()));
				m_pListaDiagnosticos->SetItemText(idItem,4,wxString::FromUTF8((*it).m_uidEstudio.c_str()));
			}

			wxTreeItemIdValue val;
			wxTreeItemId idItem = m_pListaDiagnosticos->GetFirstChild(m_pListaDiagnosticos->GetRootItem(),val);
			if(idItem.IsOk()) {
				m_pListaDiagnosticos->SelectItem(idItem);
			}
			m_button1->SetFocus();
			Layout();
		}

		SeleccionarDiagnostico::~SeleccionarDiagnostico ()
		{
			m_pEntorno = NULL;
		}

		bool SeleccionarDiagnostico::Mostrar() {
			if(m_pListaDiagnosticos->GetChildrenCount(m_pListaDiagnosticos->GetRootItem()) == 0) {
				return false;
			} else {
				return true;
			}
		}

		std::string SeleccionarDiagnostico::GetUIDEstudioDiagnostico() {
			return m_uidEstudio;
		}

		void SeleccionarDiagnostico::OnAceptarClick(wxCommandEvent& event)
		{
			if(m_pCheckNuevo->IsChecked()){
				//m_uidEstudio = m_pEntorno->GetControladorImportacionPACS()->GetUID();
				m_uidEstudio = std::string("");
				EndModal(wxID_OK);
			} else if (m_pListaDiagnosticos->GetSelection().IsOk()){
				m_uidEstudio = m_pListaDiagnosticos->GetItemText(m_pListaDiagnosticos->GetSelection(),4).ToUTF8();
				EndModal(wxID_OK);
			} else {
				wxMessageBox(_("Select a diagnosis"), _("Info"), wxOK | wxICON_INFORMATION, this);
				event.Skip(false);
			}
		}

		void SeleccionarDiagnostico::OnNuevoDiagnosticoClick(wxCommandEvent& event)
		{
			m_pListaDiagnosticos->Enable(!m_pCheckNuevo->IsChecked());
		}
	}
}
