/*
 *  
 *  $Id: pasodatosgenerales.cpp 3715 2011-04-15 13:11:53Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/ientorno.h>
#include <wx/msgdlg.h>
#include <wx/filedlg.h>
#include <wx/valtext.h>
#include <wx/busyinfo.h>
#include <wx/image.h>
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/msgdlg.h>
#include <wx/confbase.h>
#include <api/idicommanager.h>
#include <api/ientorno.h>
#include <string>
#include <sstream>
#include <cmath>


#include <api/icontroladorcomandos.h>
#include <commands/comandopacs.h>

#include "pasodatosgenerales.h"
#include <api/internacionalizacion.h>
#include <export/tagsprivadoscomunes.h>
#include "../../comandos/comandodicomizacionintegracion.h"
#include <api/icontroladorcomandos.h>
#include "../../exportacion/tagsprivados.h"

namespace GNKVisualizator {
	namespace GUI {

		PasoDatosGenerales::PasoDatosGenerales(wxWindow* pParent,IWizard* pWizard,GnkPtr<TipoWizardImportacion> datosPersistentes,const std::string &dirTemporal,GNC::GCS::IEntorno * pEntorno):PanelDatosGeneralesBase(pParent),IPasoWizard(pWizard)
		{
/*			SetScrollbars(10, 10, 50, 50, 0, 0, false);
			AdjustScrollbars();*/

			Hide();
			m_dicomizado = false;
			m_pEntorno=pEntorno;
			m_pDatosPersistentes=datosPersistentes;

			m_dirTemporal=dirTemporal;

			wxTextValidator OnlyNum = wxTextValidator(wxFILTER_NUMERIC);
			m_pPacienteAltura->SetValidator(OnlyNum);
			m_pPacientePeso->SetValidator(OnlyNum);

			wxDateTime date = wxDateTime::Now();
			m_pEstudioTime->SetDateTimeValue(date);
			m_pSerieTime->SetDateTimeValue(date);
		}

		PasoDatosGenerales::~PasoDatosGenerales()
		{
		}


//region "Metodos heredados de Ipasowizard"

		void PasoDatosGenerales::Attach(wxSizer *sizer){
			//se mira a ver si los ficheros del panel estan correctamente etiquetados...
			if(m_pDatosPersistentes->m_pModeloImportacion.IsValid()) {
				m_pPacienteId->Enable(false);				
				m_pPacienteNombre->Enable(false);
				m_pPacienteApellido1->Enable(false);
				m_pPacienteApellido2->Enable(false);
			} else {
				m_pPacienteId->SetBackgroundColour(wxColor(255, 213, 213));
				m_pPacienteId->SetFocus();
			}

			//estudio
			if(m_pDatosPersistentes->EstudioDescripcion!=""){
				m_pEstudioDescripcion->SetValue(wxString::FromUTF8(m_pDatosPersistentes->EstudioDescripcion.c_str()));
			}

			if(m_pDatosPersistentes->EstudioFecha!=""){
				wxDateTime fecha;
				fecha.ParseFormat(wxString::FromUTF8(m_pDatosPersistentes->EstudioFecha.c_str()),wxT("%Y%m%d"));
				if(fecha.IsValid()){
					m_pEstudioFecha->SetValue(fecha);
				}
			}

			if(m_pDatosPersistentes->EstudioHora!=""){
				wxDateTime fecha;
				fecha.ParseFormat(wxString::FromUTF8(m_pDatosPersistentes->EstudioHora.c_str()),wxT("%H%M%S"));
				if(fecha.IsValid()){
					m_pEstudioTime->SetDateTimeValue(fecha);
				}
			}

			//serie
			if(m_pDatosPersistentes->SerieDescripcion!=""){
				m_pSerieDescripcion->SetValue(wxString::FromUTF8(m_pDatosPersistentes->SerieDescripcion.c_str()));
			}

			if(m_pDatosPersistentes->SerieFecha!=""){
				wxDateTime fecha;
				fecha.ParseFormat(wxString::FromUTF8(m_pDatosPersistentes->SerieFecha.c_str()),wxT("%Y%m%d"));
				if(fecha.IsValid()){
					m_pSerieFecha->SetValue(fecha);
				}
			}

			if(m_pDatosPersistentes->SerieHora!=""){
				wxDateTime fecha;
				fecha.ParseFormat(wxString::FromUTF8(m_pDatosPersistentes->SerieHora.c_str()),wxT("%H%M%S"));
				if(fecha.IsValid()){
					m_pSerieTime->SetDateTimeValue(fecha);
				}
			}

			//paciente
			if(m_pDatosPersistentes->PacienteNombre!=""){
				m_pPacienteNombre->SetValue(wxString::FromUTF8(m_pDatosPersistentes->PacienteNombre.c_str()));
			}
			if(m_pDatosPersistentes->PacienteApellido1!=""){
				m_pPacienteApellido1->SetValue(wxString::FromUTF8(m_pDatosPersistentes->PacienteApellido1.c_str()));
			}
			if(m_pDatosPersistentes->PacienteApellido2!=""){
				m_pPacienteApellido2->SetValue(wxString::FromUTF8(m_pDatosPersistentes->PacienteApellido2.c_str()));
			}

			if(m_pDatosPersistentes->PacienteIdentificador!=""){
				m_pPacienteId->SetValue(wxString::FromUTF8(m_pDatosPersistentes->PacienteIdentificador.c_str()));
			}

			if(m_pDatosPersistentes->PacienteFechaNacimiento!=""){
				wxDateTime fecha;
				fecha.ParseFormat(wxString::FromUTF8(m_pDatosPersistentes->PacienteFechaNacimiento.c_str()),wxT("%Y%m%d"));
				if(fecha.IsValid()){
					m_pPacienteFechaNacimiento->SetValue(fecha);
				}
			}

			if(m_pDatosPersistentes->PacienteAltura!=""){
				std::istringstream is (m_pDatosPersistentes->PacienteAltura);
				float altura = 0.0f;
				is >> altura;
				altura *= 100.0f;
				wxString wstraltura;
				wstraltura << ((int)altura);
				m_pPacienteAltura->SetValue(wstraltura);
			}

			if(m_pDatosPersistentes->PacientePeso!=""){
				m_pPacientePeso->SetValue(wxString::FromUTF8(m_pDatosPersistentes->PacientePeso.c_str()));
			}

			if(m_pDatosPersistentes->PacienteSexo!=""){
				if(m_pDatosPersistentes->PacienteSexo.compare("M")==0){
					m_pPacienteSexo->SetSelection(0);
				}else if(m_pDatosPersistentes->PacienteSexo.compare("F")==0){
					m_pPacienteSexo->SetSelection(1);
				}else if(m_pDatosPersistentes->PacienteSexo.compare("O")==0){
					m_pPacienteSexo->SetSelection(2);
				}else{
					m_pPacienteSexo->SetSelection(3);
				}
			}

			Show(true);

			sizer->Add(this,10, wxEXPAND);
			this->GetParent()->Layout();
		}

		void PasoDatosGenerales::Detach(wxSizer *sizer){
			Hide();
			sizer->Detach(this);
			sizer->GetContainingWindow()->Layout();
		}

		std::string PasoDatosGenerales::GetTitle(){
			return _Std("Overview data of DICOM files");
		}

		std::string PasoDatosGenerales::GetSubTitle(){
			return _Std("DICOM data from the files to be generated can be populated");
		}

		bool PasoDatosGenerales::Siguiente(){
			return true;
		}

		bool PasoDatosGenerales::Anterior(){
			return true;
		}

		bool PasoDatosGenerales::Cancelar(){
			return true;
		}

		bool PasoDatosGenerales::Validar(){
			bool correcto =  true;
			if(ValidarDatosGenerales())
			{
				if(!m_dicomizado) {
					m_dicomizado = Dicomizar();
					correcto = m_dicomizado;
				}
			} else {
				correcto = false;
			}
			return correcto;
		}

		bool PasoDatosGenerales::ValidarDatosGenerales() {
			wxString mensaje = wxEmptyString;

			if (m_pPacienteId->GetValue().IsEmpty()) {
				mensaje += _("\n* The patient ID is required.");
			}

			if(m_pPacienteApellido1->GetValue().size() + m_pPacienteApellido2->GetValue().size() + m_pPacienteNombre->GetValue().size() > 61) {
				mensaje += _("\n* Concatenation of patient name and surnames can't be higher than 61.");
			}

			if(!ValidarDouble(std::string(m_pPacienteAltura->GetValue().ToUTF8()),0.0f,400.0f, false, false)){
				mensaje += _("\n* The format of the height in centimeters is not correct. ");
			}

			if ( m_pPacienteFechaNacimiento->GetValue().IsLaterThan(m_pEstudioFecha->GetValue()) ) {
				mensaje += _("\n* The patient's birth date is after the date of study");
			}

			if(!ValidarDouble(std::string(m_pPacientePeso->GetValue().ToUTF8()),0.0f,400.0f, false, false)){
				mensaje += _("\n* The format of the weight is not correct. Valid range is between 0 and 400 Kg.");
			}

			if(mensaje != wxEmptyString){
				wxMessageBox(_("The following errors have occurred when validating fields") + mensaje, _("Error validating fields"), wxICON_ERROR);

				return false;
			} else {
				m_pDatosPersistentes->PacienteAltura=GetPacienteAltura();
				m_pDatosPersistentes->PacienteApellido1=GetPacienteApellido1();
				m_pDatosPersistentes->PacienteApellido2=GetPacienteApellido2();
				m_pDatosPersistentes->PacienteEdad=GetPacienteEdad();
				m_pDatosPersistentes->PacienteFechaNacimiento=GetPacienteFechaNacimiento();
				m_pDatosPersistentes->PacienteIdentificador=GetPacienteIdentificador();
				m_pDatosPersistentes->PacienteNombre=GetPacienteNombre();
				m_pDatosPersistentes->PacientePeso=GetPacientePeso();
				m_pDatosPersistentes->PacienteSexo=GetPacienteSexo();
				m_pDatosPersistentes->EstudioDescripcion=GetEstudioDescripcion();
				m_pDatosPersistentes->EstudioFecha=GetEstudioFecha();
				m_pDatosPersistentes->EstudioHora=GetEstudioTime();
				m_pDatosPersistentes->SerieDescripcion=GetSerieDescripcion();
				m_pDatosPersistentes->SerieFecha=GetSerieFecha();
				m_pDatosPersistentes->SerieHora=GetSerieTime();
				return true;
			}
		}

		bool PasoDatosGenerales::Dicomizar() 
		{
			for(ListaFicheros::const_iterator it=m_pListaFicheros->begin(); it!= m_pListaFicheros->end(); it++) {
				std::string rutaFichero = (*it);
				GNKVisualizator::GUI::TipoWizardImportacion::TFicheroDicomizacionGNKVisualizator ficheroADicomizar;
				ficheroADicomizar.pathImagen = rutaFichero;

				m_pDatosPersistentes->m_listaFicherosADicomizar.push_back(ficheroADicomizar);
			}

			RellenarTagsComunes(m_pDatosPersistentes->baseImagenes);
			GADAPI::ComandoDicomizacionIntegracionParams* pDicomParams = new GADAPI::ComandoDicomizacionIntegracionParams(m_pDatosPersistentes,m_pEntorno,m_dirTemporal);
			GADAPI::ComandoDicomizacionIntegracion* pDicomCmd = new GADAPI::ComandoDicomizacionIntegracion(pDicomParams);
			m_pEntorno->GetControladorComandos()->ProcessAsync(_Std("Performing tasks of integration ..."),pDicomCmd,NULL);
			//se limpia la lista porque ya avisaremos de los nuevos ficheros
			m_pListaFicheros->clear();
			//
			return true;
			
		}

		void PasoDatosGenerales::RellenarTagsComunes(GIL::DICOM::TipoJerarquia& base)
		{
			std::string tag;

			//institucion
			wxString wxTmp;
			if(m_pDatosPersistentes->NombreCentro == "" ){
				wxConfigBase::Get()->Read(wxT("/GinkgoCore/Estacion/CentroNombre"),&wxTmp,wxEmptyString);
				if(wxTmp != wxEmptyString){
					base.tags[std::string("0008|0080")] = std::string(wxTmp.ToUTF8());
				}
			} else {
				base.tags[std::string("0008|0080")] = m_pDatosPersistentes->NombreCentro;
			}

			//nombre del medico responsable de la institucion
			if(m_pDatosPersistentes->NombreMedico == ""){
				wxConfigBase::Get()->Read(wxT("/GinkgoCore/Estacion/NombreMedico"),&wxTmp,wxEmptyString);
				if(wxTmp != wxEmptyString){
					base.tags[std::string("0008|0090")] = std::string(wxTmp.ToUTF8());
				}
			} else {
				base.tags[std::string("0008|0090")] = m_pDatosPersistentes->NombreMedico;
			}

			base.tags[std::string("0008|0070")] = std::string("Metaemotion S.L.");

			base.tags[std::string("0008|1090")] = std::string("Ginkgo Atención Primaria");

			//uid de aprimaria
			base.tags[std::string("0018|1030")] = UID_APRIM;

			base.tags[std::string("0008|0020")] = m_pDatosPersistentes->EstudioFecha;

			base.tags[std::string("0008|0030")] =  m_pDatosPersistentes->EstudioHora;

			base.tags[std::string("0008|1030")] = m_pDatosPersistentes->EstudioDescripcion;

			//uid de la serie
			if(m_pDatosPersistentes->SerieUID!=""){
				base.tags[std::string("0020|000e")] = m_pDatosPersistentes->SerieUID;
			}

			//si procede referenciar estudio
			if(m_pDatosPersistentes->StudyInstanceUID!=""){
				base.tags[std::string("0020|000d")] = m_pDatosPersistentes->StudyInstanceUID;
			}

			if(m_pDatosPersistentes->AccessionNumber!="") {
				base.tags[std::string("0008|0050")] = m_pDatosPersistentes->AccessionNumber;
			}

			//fecha serie
			base.tags[std::string("0008|0021")] = m_pDatosPersistentes->SerieFecha;

			//hora serie
			base.tags[std::string("0008|0031")] = m_pDatosPersistentes->SerieHora;

			//descripcion serie
			base.tags[std::string("0008|103e")] = m_pDatosPersistentes->SerieDescripcion;

			//fecha imagen
			base.tags[std::string("0008|0022")] = m_pDatosPersistentes->SerieFecha;
			//hora imagen
			base.tags[std::string("0008|0032")] = m_pDatosPersistentes->SerieHora;
			//descripcion imagen
			base.tags[std::string("0020|4000")] = m_pDatosPersistentes->SerieDescripcion;


			base.tags[std::string("0010|0010")] = m_pDatosPersistentes->PacienteNombre + "^" + m_pDatosPersistentes->PacienteApellido1 + "^" + m_pDatosPersistentes->PacienteApellido2;

			base.tags[std::string("0010|0020")] = m_pDatosPersistentes->PacienteIdentificador;

			base.tags[std::string("0010|1010")] = m_pDatosPersistentes->PacienteEdad;

			base.tags[std::string("0010|0030")] = m_pDatosPersistentes->PacienteFechaNacimiento;

			base.tags[std::string("0010|0040")] = m_pDatosPersistentes->PacienteSexo;

			base.tags[std::string("0010|1020")] = m_pDatosPersistentes->PacienteAltura;

			base.tags[std::string("0010|1030")] = m_pDatosPersistentes->PacientePeso;
		}
	//endregion

		std::string PasoDatosGenerales::GetPacienteNombre(){
			return std::string(m_pPacienteNombre->GetValue().ToUTF8());
		}

		std::string PasoDatosGenerales::GetPacienteApellido1(){
			return std::string(m_pPacienteApellido1->GetValue().ToUTF8());
		}

		std::string PasoDatosGenerales::GetPacienteApellido2(){
			return std::string(m_pPacienteApellido2->GetValue().ToUTF8());
		}

		std::string PasoDatosGenerales::GetPacienteIdentificador(){
			return std::string(m_pPacienteId->GetValue().ToUTF8());
		}

		std::string PasoDatosGenerales::GetPacienteFechaNacimiento(){
			return std::string(m_pPacienteFechaNacimiento->GetValue().Format(wxT("%Y%m%d")).ToUTF8());
		}

		std::string PasoDatosGenerales::GetPacienteEdad()
		{
			int edad = CalcularEdad();
			std::ostringstream os;
			os.fill('0');
			os.width(3);
			os << edad << "Y";
			return os.str();
		}

		std::string PasoDatosGenerales::GetPacientePeso(){
			std::string peso = std::string(m_pPacientePeso->GetValue().ToUTF8());
			if (peso.size() == 0) {
				peso = "0";
			}
			return peso;
		}

		std::string PasoDatosGenerales::GetPacienteAltura(){
			std::istringstream is (std::string(m_pPacienteAltura->GetValue().ToUTF8()));
			float altura = 0.0f;
			is >> altura;
			altura = std::floor(altura);
			altura /= 100.0f;
			std::ostringstream os;
			os << altura;
			return os.str();
		}

		std::string PasoDatosGenerales::GetPacienteSexo(){
			std::string str;
			switch(m_pPacienteSexo->GetSelection()){
				case 0:
					str = std::string("M");
					break;
				case 1:
					str = std::string("F");
					break;
				case 2:
					str = std::string("O");
					break;
			}
			return str;
		}

		void PasoDatosGenerales::OnKillFocusEstudioTimeControl(wxFocusEvent &event){
				if(!m_pEstudioTime->GetDateTimeValue().IsValid()){
					wxDateTime ahora = wxDateTime::Now();
					m_pEstudioTime->SetDateTimeValue(ahora);
				}
			}

			void PasoDatosGenerales::OnCheckBoxReferenciarEstudioClick(wxCommandEvent &event){
				if(m_pCheckReferenciarEstudio->IsChecked()){
					//buscar fichero DCM
					wxFileDialog referenciarDialogo (this, _("Refer Study"), wxT(""), wxT(""), _("DICOM Files (*.dcm)|*.dcm"), wxFD_SAVE);
					int response = referenciarDialogo.ShowModal();
					if (response == wxID_OK) {
						wxString fPath = referenciarDialogo.GetPath();
						std::string filePath(fPath.ToUTF8());

						//leer dicom...
						GIL::DICOM::IDICOMManager*	pDICOMManager= m_pEntorno->GetControladorImportacionPACS()->CrearInstanciaDeDICOMManager();
						GIL::DICOM::TipoJerarquia base;
						pDICOMManager->CargarFichero(filePath, base);

						std::string tag;
						if(base.getTag(std::string("0008|0020"),tag)){//fecha estudio
							wxDateTime fecha;
							fecha.ParseFormat(wxString::FromUTF8(tag.c_str()),wxT("%Y%m%d"));
							if(fecha.IsValid()){
								m_pEstudioFecha->SetValue(fecha);
							}
						}

						if(base.getTag(std::string("0008|0030"),tag)){//hora estudio
							wxDateTime fecha;
							fecha.ParseFormat(wxString::FromUTF8(tag.c_str()),wxT("%H%M%S"));
							if(fecha.IsValid()){
								m_pEstudioTime->SetDateTimeValue(fecha);
							}
						}

						if(base.getTag(std::string("0008|1030"),tag)){//descripcion estudio
							m_pEstudioDescripcion->SetValue(wxString::FromUTF8(tag.c_str()));
						}

						if(base.getTag(std::string("0020|000d"),tag)){//uid estudio
							m_pDatosPersistentes->StudyInstanceUID=tag;
						}

						if(base.getTag(std::string("0010|0010"),tag)){//nombre del paciente
							if(tag.find_first_of('^')!=std::string::npos){
								m_pDatosPersistentes->PacienteNombre = tag.substr(0,tag.find_first_of('^'));
								tag = tag.substr(tag.find_first_of('^')+1,tag.size()-1);
								if(tag.find_first_of('^')!=std::string::npos){
									m_pDatosPersistentes->PacienteApellido1 = tag.substr(0,tag.find_first_of('^'));
									tag = tag.substr(tag.find_first_of('^')+1,tag.size()-1);
									if(tag.find_first_of('^')!=std::string::npos){
										m_pDatosPersistentes->PacienteApellido2 = tag.substr(0,tag.find_first_of('^'));
										tag = tag.substr(tag.find_first_of('^')+1,tag.size()-1);
									}
								}
							}
						}

						if(base.getTag(std::string("0010|0020"),tag)){//id del paciente
							m_pDatosPersistentes->PacienteIdentificador=tag;
						}

						if(base.getTag(std::string("0010|0030"),tag)){//fecha nacimiento
							m_pDatosPersistentes->PacienteFechaNacimiento=tag;
						}

						if(base.getTag(std::string("0010|1010"),tag)){//edad
							m_pDatosPersistentes->PacienteEdad=tag;
						}

						if(base.getTag(std::string("0010|1020"),tag)){//talla
							m_pDatosPersistentes->PacienteAltura=tag;
						}

						if(base.getTag(std::string("0010|1030"),tag)){//peso
							m_pDatosPersistentes->PacientePeso=tag;
						}

						if(base.getTag(std::string("0010|0040"),tag)){//sexo
							m_pDatosPersistentes->PacienteSexo=tag;
						}

						m_pEntorno->GetControladorImportacionPACS()->LiberarInstanciaDeDICOMManager(pDICOMManager);

						//EnableComponents(false);
					} else {
						m_pCheckReferenciarEstudio->SetValue(false);
					}
				} else{
					m_pDatosPersistentes->StudyInstanceUID="";
					//EnableComponents(true);
				}

			}

			void PasoDatosGenerales::EnableComponents(bool enable){
				m_pEstudioDescripcion->Enable(enable);
				m_pEstudioFecha->Enable(enable);
				m_pEstudioTime->Enable(enable);
				m_pSerieDescripcion->Enable(enable);
				m_pSerieFecha->Enable(enable);
				m_pSerieTime->Enable(enable);
			}


			std::string PasoDatosGenerales::GetEstudioFecha(){
				if(m_pEstudioFecha->GetValue().IsValid()){
					return std::string(m_pEstudioFecha->GetValue().Format(wxT("%Y%m%d")).ToUTF8());
				}else{
					return std::string("");
				}
			}

			std::string PasoDatosGenerales::GetEstudioTime(){
				if(m_pEstudioTime->GetDateTimeValue().IsValid()){
					return std::string(m_pEstudioTime->GetDateTimeValue().Format(wxT("%H%M%S")).ToUTF8());
				}else{
					return std::string("");
				}
			}

			std::string PasoDatosGenerales::GetEstudioDescripcion(){
				return std::string(m_pEstudioDescripcion->GetValue().ToUTF8());
			}

			void PasoDatosGenerales::OnKillFocusSerieTimeControl(wxFocusEvent &event){
			if(!m_pSerieTime->GetDateTimeValue().IsValid()){
				wxDateTime ahora = wxDateTime::Now();
				m_pSerieTime->SetDateTimeValue(ahora);
			}
		}

		void PasoDatosGenerales::OnCheckBoxReferenciarSerieClick(wxCommandEvent &event){
			if(m_pCheckReferenciarSerie->IsChecked()){
				//buscar fichero DCM
				wxFileDialog referenciarDialogo (this, _("Series reference"), wxT(""), wxT(""), _("DICOM Files (*.dcm) | *.dcm"), wxFD_SAVE);
				int response = referenciarDialogo.ShowModal();
				if (response == wxID_OK) {
					wxString fPath = referenciarDialogo.GetPath();
					std::string filePath(fPath.ToUTF8());

					//leer dicom...
					GIL::DICOM::IDICOMManager*	pDICOMManager= m_pEntorno->GetControladorImportacionPACS()->CrearInstanciaDeDICOMManager();
					GIL::DICOM::TipoJerarquia base;
					pDICOMManager->CargarFichero(filePath, base);
					std::string tag;

					//se pillan los tags ...
					if(base.getTag(std::string("0008|0021"),tag)){//fecha serie
						wxDateTime fecha;
						fecha.ParseFormat(wxString::FromUTF8(tag.c_str()),wxT("%Y%m%d"));
						if(fecha.IsValid()){
							m_pSerieFecha->SetValue(fecha);
						}
					}

					if(base.getTag(std::string("0008|0031"),tag)){//hora serie
						wxDateTime fecha;
						fecha.ParseFormat(wxString::FromUTF8(tag.c_str()),wxT("%H%M%S"));
						if(fecha.IsValid()){
							m_pSerieTime->SetDateTimeValue(fecha);
						}
					}

					if(base.getTag(std::string("0008|103e"),tag)){//descripcion serie
						m_pSerieDescripcion->SetValue(wxString::FromUTF8(tag.c_str()));
					}

					if(base.getTag(std::string("0008|0020"),tag)){//fecha estudio
						m_pDatosPersistentes->EstudioFecha = tag;
					}

					if(base.getTag(std::string("0008|0030"),tag)){//hora estudio
						m_pDatosPersistentes->EstudioHora = tag;
					}

					if(base.getTag(std::string("0008|1030"),tag)){//descripcion estudio
						m_pDatosPersistentes->EstudioDescripcion = tag;
					}

					if(base.getTag(std::string("0020|000d"),tag)){//uid estudio
						m_pDatosPersistentes->StudyInstanceUID=tag;
					}

					if(base.getTag(std::string("0020|000e"),tag)){//uid serie
						m_pDatosPersistentes->SerieUID=tag;
					}

					if(base.getTag(std::string("0010|0010"),tag)){//nombre del paciente
						if(tag.find_first_of('^')!=std::string::npos){
							m_pDatosPersistentes->PacienteNombre = tag.substr(0,tag.find_first_of('^'));
							tag = tag.substr(tag.find_first_of('^')+1,tag.size()-1);
							if(tag.find_first_of('^')!=std::string::npos){
								m_pDatosPersistentes->PacienteApellido1 = tag.substr(0,tag.find_first_of('^'));
								tag = tag.substr(tag.find_first_of('^')+1,tag.size()-1);
								if(tag.find_first_of('^')!=std::string::npos){
									m_pDatosPersistentes->PacienteApellido2 = tag.substr(0,tag.find_first_of('^'));
									tag = tag.substr(tag.find_first_of('^')+1,tag.size()-1);
								}
							}
						}
					}

					if(base.getTag(std::string("0010|0020"),tag)){//id del paciente
						m_pDatosPersistentes->PacienteIdentificador=tag;
					}

					if(base.getTag(std::string("0010|0030"),tag)){//fecha nacimiento
						m_pDatosPersistentes->PacienteFechaNacimiento=tag;
					}

					if(base.getTag(std::string("0010|1010"),tag)){//edad
						m_pDatosPersistentes->PacienteEdad=tag;
					}

					if(base.getTag(std::string("0010|1020"),tag)){//talla
						m_pDatosPersistentes->PacienteAltura=tag;
					}

					if(base.getTag(std::string("0010|1030"),tag)){//peso
						m_pDatosPersistentes->PacientePeso=tag;
					}

					if(base.getTag(std::string("0010|0040"),tag)){//sexo
						m_pDatosPersistentes->PacienteSexo=tag;
					}

					m_pEntorno->GetControladorImportacionPACS()->LiberarInstanciaDeDICOMManager(pDICOMManager);

					//EnableComponents(false);
				} else {
					m_pCheckReferenciarSerie->SetValue(false);
				}
			} else{
				m_pDatosPersistentes->SerieUID="";
				//EnableComponents(true);
			}

		}

		std::string PasoDatosGenerales::GetSerieFecha(){
			if(m_pSerieFecha->GetValue().IsValid()){
				return std::string(m_pSerieFecha->GetValue().Format(wxT("%Y%m%d")).ToUTF8());
			}else{
				return std::string("");
			}
		}

		std::string PasoDatosGenerales::GetSerieTime(){
			if(m_pSerieTime->GetDateTimeValue().IsValid()){
				return std::string(m_pSerieTime->GetDateTimeValue().Format(wxT("%H%M%S")).ToUTF8());
			}else{
				return std::string("");
			}
		}

		std::string PasoDatosGenerales::GetSerieDescripcion(){
			return std::string(m_pSerieDescripcion->GetValue().ToUTF8());
		}

		int PasoDatosGenerales::CalcularEdad()
		{
			wxDateTime fechaEstudio = m_pEstudioFecha->GetValue();
			wxDateTime fechaNacimiento = m_pPacienteFechaNacimiento->GetValue();
			int edad = 0;
			if( (fechaEstudio.GetMonth() > fechaNacimiento.GetMonth()) ||
				(fechaEstudio.GetMonth() == fechaNacimiento.GetMonth() && fechaEstudio.GetDay() >= fechaNacimiento.GetDay()) ){
				edad = fechaEstudio.GetYear() - fechaNacimiento.GetYear();
			} else {
				edad = fechaEstudio.GetYear() - fechaNacimiento.GetYear() - 1;
			}
			return edad;
		}
	}
}
