/*
 *
 *  $Id: visualizatorcontroller.cpp 3685 2011-04-13 06:16:18Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/wx.h>
#include <wx/notebook.h>
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/config.h>
#include <set>
#include "visualizatorcontroller.h"

#include "../herramientas/herramientamapacolor.h"
#include "../herramientas/herramientaoverlays.h"
#include "../herramientas/reconstructiontool.h"

#include "../../recursos/plantillas/plantillasaprimresourcemanager.h"

#include "../dialogos/contenedorherramientas.h"
#include "../dialogos/importacion/pasodatosgenerales.h"
#include "../dialogos/importacion/datospersistentesimportacion.h"
#include "../dialogos/seleccionardiagnostico/seleccionardiagnostico.h"
#include "../vistas/vista2d.h"
#include "../vistas/waveformview.h"
#include <visualizator/estudios/visualizatorstudy.h>
#include <visualizator/license.h>

#include <api/ientorno.h>
#include <api/ivista.h>
#include <api/imodelodicom.h>
#include <api/icontroladorcarga.h>
#include <api/icontroladorhistorial.h>

#include <api/icontroladorpermisos.h>

#include <api/icontroladorherramientas.h>

#include <api/icontroladorimportacionpacs.h>
#include <api/icontroladorvistas.h>

#include <api/icontroladorcarga.h>
#include <main/controllers/controladorcarga.h>

#include <vector>
#include <string>
#include <sstream>
#include <iostream>
#include <api/internacionalizacion.h>
#include <api/icontroladorinternacionalizacion.h>
#include "../../recursos/aprimresourcemanager.h"
#include "../exportacion/tagsprivados.h"


/* Constructor */
GNKVisualizator::ControladorAtencionPrimaria::ControladorAtencionPrimaria(GNC::GCS::IEntorno* pEntorno) : GNC::GCS::IControladorModulo(pEntorno, UID_APRIM,0, "atencionprimaria")
{
	//primero de todo registramos nuestro catalogo para la internacionalizacion de las cadenas
	{
		pEntorno->GetControladorInternacionalizacion()->AddCatalog("visualizator");
	}

	//registramos los permisos
	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria",_Std("Ginkgo CADx viewer"), "dicomizador",_Std("Simple importation of images"),false, "", true);
	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria",_Std("Ginkgo CADx viewer"),"plantillas",_Std("Basic templates"), false, "", true);
	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria",_Std("Ginkgo CADx viewer"),"vista2d",_Std("Medical viewer"), false, "", true);
	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria",_Std("Ginkgo CADx viewer"),"waveform",_Std("Waveform viewer"), false, "", true);
	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria",_Std("Ginkgo CADx viewer"),"reconstruction",_Std("3D Reconstruction"), false, "", true);

	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria.reconstruction",_Std("3D Reconstruction"),"orthogonalmpr3d",_Std("3D Orthogonal Multi-Planar Reconstruction (MPR)"), false, "", false);
	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria.reconstruction",_Std("3D Reconstruction"),"mip3d",_Std("3D Maximun Intensity Projection (MIP)"), false, "", false);
	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria.reconstruction",_Std("3D Reconstruction"),"volumerengering3d",_Std("3D Volume Rendering"), false, "", true);
	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria.reconstruction",_Std("3D Reconstruction"),"surfacerendering3d",_Std("3D Surface Rendering"), false, "", true);
	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria.reconstruction",_Std("3D Reconstruction"),"endoscopy3d",_Std("3D Endoscopy"), false, "", false);

	m_pEntorno->GetControladorPermisos()->AddDefinicionPermiso("atencionprimaria.vista2d",_Std("Medical viewer"),"guardar cambios",_Std("Save changes with Medical viewer"), true, "", true);


	m_pEntorno = pEntorno;
	m_Nombre = VISUALIZATOR_DESCRIPTION;
	m_CopyRight = "(c) 2009 MetaEmotion S.L.";
	m_Author = "MetaEmotion S.L.";
	m_VersionMayor   = VISUALIZATOR_VERSION;
	m_VersionMinor   = VISUALIZATOR_SUB_VERSION;
	m_VersionRelease = VISUALIZATOR_SUB_RELEASE;
	m_CodeName       = VISUALIZATOR_CODENAME;
	std::ostringstream oversion;
	oversion << VISUALIZATOR_VERSION << "."<< VISUALIZATOR_SUB_VERSION << "." << VISUALIZATOR_SUB_RELEASE;
	m_Version = oversion.str();

	// Codigos LOINC de los informes de A. Primaria.
	m_ListaInformes.push_back(GNC::GCS::IdHL7("TUID" + m_SID, "0", _Std("Ginkgo CADx visualizator Report"), "LN", "", "","v1.0"));


	// Codigos LOINC de los Estudios que genera A. Primaria
	m_ListaEstudios["EstudioOriginal"]= GNC::GCS::IdHL7("EstudioOriginal", "121018", "Study Instance UID", "DCM", "HD", "","v1.0");
	
	// Codigos LOINC de los registros HL7 que genera A. Primaria
	m_ListaRegistros["SerieOriginal"] = GNC::GCS::IdHL7("SerieOriginal", "112002", "Series Instance UID", "DCM", "HD", "","v1.0");
	m_ListaRegistros["IDPacs"] = GNC::GCS::IdHL7("IDPacs", "ARCHIVE", "IDPACS", "DCM", "HD", "","v1.0");
	m_ListaRegistros["Imagen"] = GNC::GCS::IdHL7("Imagen", "121126", "SOP Instance UID", "DCM", "HD", "","v1.0");
	m_ListaRegistros["SOPClass"] = GNC::GCS::IdHL7("SOPClass", "121127", "SOP Class ID", "DCM", "HD", "","v1.0");

	m_pPanelContenedorCustom = NULL;

	//registrar herramientas
	GNC::GCS::IControladorHerramientas* cH = m_pEntorno->GetControladorHerramientas();
	cH->RegistrarHerramienta(new GNKVisualizator::HerramientaMapaColor());
	cH->RegistrarHerramienta(new GNKVisualizator::HerramientaOverlays());
	cH->RegistrarHerramienta(new GNKVisualizator::ReconstructionTool(m_pEntorno->GetControladorPermisos()));

}

GNKVisualizator::ControladorAtencionPrimaria::~ControladorAtencionPrimaria()
{
	//desregistrar herramienta
	GNKVisualizator::IHerramientaMapaColor* hMapa;
	GNKVisualizator::IHerramientaOverlays*  hOverlays;
	GNKVisualizator::IReconstructionTool*   hReconstruction;
	GNC::GCS::IControladorHerramientas* cH = m_pEntorno->GetControladorHerramientas();
	try {
		hMapa = cH->ObtenerHerramientaConcreta<GNKVisualizator::IHerramientaMapaColor>(GNKVisualizator::IHerramientaMapaColor::ID);
		if (hMapa != NULL) {
			cH->DesRegistrarHerramienta(hMapa);
			delete hMapa;
		}
		hOverlays = cH->ObtenerHerramientaConcreta<GNKVisualizator::IHerramientaOverlays>(GNKVisualizator::IHerramientaOverlays::ID);
		if (hOverlays != NULL) {
			cH->DesRegistrarHerramienta(hOverlays);
			delete hOverlays;
		}
		hReconstruction = cH->ObtenerHerramientaConcreta<GNKVisualizator::IReconstructionTool>(GNKVisualizator::IReconstructionTool::ID);
		if (hReconstruction != NULL) {
			cH->DesRegistrarHerramienta(hReconstruction);
			delete hReconstruction;
		}
	}
	catch (GNC::GCS::ControladorHerramientasException& ex) {
		std::cerr << "Error al registrar herramientas de Oftal: No se pudo subscribir la herramienta: " << ex.getCause() << std::endl;
	}


	unsigned int i;
	for (i = 0; i < m_ListaModos.size(); ++i) {
		delete m_ListaModos[i];
	}
	m_ListaModos.clear();

	EliminarPaneles();
	if (m_pPanelContenedorCustom != NULL) {
		delete m_pPanelContenedorCustom;
		m_pPanelContenedorCustom = NULL;
	}
	#if defined(_GINKGO_DEBUG) && defined(_WINDOWS)
	//cairo_debug_reset_static_data();
	//_CrtDumpMemoryLeaks();
	#endif
}

void GNKVisualizator::ControladorAtencionPrimaria::RegistrarVistas()
{
	GNC::GCS::ModoControlador::TipoListaModalidades listaModalidades;
	//TODO meter las modalidades que soporta...
	listaModalidades.push_back(std::string("MR")); //resonancia
	listaModalidades.push_back(std::string("CR")); //computed radiography
	listaModalidades.push_back(std::string("US")); //ultrasonido
	listaModalidades.push_back(std::string("BI")); //biomagnetic image
	listaModalidades.push_back(std::string("CT")); //computed tomography
	listaModalidades.push_back(std::string("XA")); //XRAY angiografia
	listaModalidades.push_back(std::string("SC")); //secondary capture
	listaModalidades.push_back(std::string("NM")); //nuclear medicine
	listaModalidades.push_back(std::string("CD")); //Color flow doppler
	listaModalidades.push_back(std::string("DD")); //Duplex Doppler
	listaModalidades.push_back(std::string("DG")); //Diaphanography
	listaModalidades.push_back(std::string("ES")); //Endoscopy
	listaModalidades.push_back(std::string("LS")); //Laser surface scan
	listaModalidades.push_back(std::string("PT")); //Positron emission tomography (PET)
	listaModalidades.push_back(std::string("RG")); //Radiographic imaging
	listaModalidades.push_back(std::string("ST")); //Single-photon emission computed tomography (SPECT)
	listaModalidades.push_back(std::string("MG")); //Mammography
	listaModalidades.push_back(std::string("IO")); //Intra-Oral
	listaModalidades.push_back(std::string("TG")); //Thermography
	listaModalidades.push_back(std::string("RF")); //Radio Fluoroscopy
	listaModalidades.push_back(std::string("RTIMAGE")); //Radiotherapy Image
	listaModalidades.push_back(std::string("RTDOSE")); //Radiotherapy Dose
	listaModalidades.push_back(std::string("RTSTRUCT")); //Radiotherapy Structure Set
	listaModalidades.push_back(std::string("RTPLAN")); //Radiotherapy Plan
	listaModalidades.push_back(std::string("RTRECORD")); //RT Treatment Record
	listaModalidades.push_back(std::string("HC")); //Hard Copy
	listaModalidades.push_back(std::string("DX")); //Digital Radiography
	listaModalidades.push_back(std::string("PX")); //Panoramic X-Ray
	listaModalidades.push_back(std::string("GM")); //General Microscopy
	listaModalidades.push_back(std::string("SM")); //Slide Microscopy
	listaModalidades.push_back(std::string("XC")); //External-camera Photography
	listaModalidades.push_back(std::string("PR")); //Presentation State
	//listaModalidades.push_back(std::string("SR")); //SR Document
	listaModalidades.push_back(std::string("IVUS")); //Intravascular Ultrasound
	listaModalidades.push_back(std::string("OP")); //Stereometric Relationship
	listaModalidades.push_back(std::string("OT")); //Other
	listaModalidades.push_back(std::string("SMR")); //Intra-oral Radiography
	listaModalidades.push_back(std::string("OCT")); //Optical Coherence Tomography
	listaModalidades.push_back(std::string("OT"));  //Other
	listaModalidades.push_back(std::string("OPR")); //Ophthalmic Refraction
	listaModalidades.push_back(std::string("OPV")); //Ophthalmic Visual Field
	listaModalidades.push_back(std::string("OPM")); //Ophthalmic Mapping
	listaModalidades.push_back(std::string("KO"));  //Key Object Selection
	listaModalidades.push_back(std::string("SEG")); //Segmentation
	listaModalidades.push_back(std::string("REG")); //Registration
	listaModalidades.push_back(std::string("OPT")); //Ophthalmic Tomography
	listaModalidades.push_back(std::string("BDUS"));//Bone Densitometry (ultrasound)
	listaModalidades.push_back(std::string("BMD")); //Bone Densitometry (X-Ray)

	if(m_pEntorno->GetControladorPermisos()->Get("atencionprimaria", "vista2d")) {
		m_ListaModos.push_back(new GNC::GCS::ModoControlador(0, _Std("Medical Image Viewer"), listaModalidades, true));
	}

	listaModalidades.clear();
	listaModalidades.push_back(std::string("ECG")); //Electrocardiography
	listaModalidades.push_back(std::string("HD")); //Hemodynamic Waveform
	if(m_pEntorno->GetControladorPermisos()->Get("atencionprimaria", "waveform")) {
		m_ListaModos.push_back(new GNC::GCS::ModoControlador(1, _Std("Waveform viewer"), listaModalidades, true));
	}
}

/* Abre un estudio de manera no interactiva desde un directorio y devuelve su controlador específico */
GNC::GCS::IVista* GNKVisualizator::ControladorAtencionPrimaria::AbrirVista(int modo, ListaDescriptoresSerie& series, const std::string& uidEstudioDiagnostico)
{
	GNC::GCS::IVista* pVista = NULL;

	// TODO: El workflow de la vista PASI es el OPTIMO AHORA.
	if (modo < 0 || modo >= (int) m_ListaModos.size()) {
		//TODO: Excepción
		return NULL;
	}

	//si no se soporta alguna modalidad pues se ignora
	std::set<std::string> uidsSeries;
	GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion;
	{
		for(ListaDescriptoresSerie::iterator it = series.begin(); it!= series.end(); it++){
			if(m_ListaModos[modo]->SupportsModalityFile((*it).m_modalidad, (*it).m_uidTransferSyntax))
			{
				uidsSeries.insert((*it).m_uidSerie);
			}
		}
	}
	//

	/*ESTO SIRVE PARA NO SEPARAR POR SERIES...
	std::list<std::string> listaUIDSerie;
	std::vector<std::string> rutas;
	GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion = NULL;
	for(ListaDescriptoresSerie::iterator it = series.begin(); it!=series.end(); it++){
		listaUIDSerie.push_back((*it).m_uidSerie);
		if(!m_ListaModos[modo]->SoportaModalidad((*it).m_modalidad)){
			//mensaje de error!!
			wxMessageBox(_("Derma view does not support modality studies") + wxString::FromUTF8((*it).m_modalidad.c_str()), _("Error"), wxICON_ERROR);
			return NULL;
		}
		if((*it).m_pModeloIntegracion.IsValid()) {
			pModeloIntegracion = (*it).m_pModeloIntegracion;
		}
		std::vector<std::string> rutasSerie = m_pEntorno->GetControladorHistorial()->GetPathsSerieOrdenados((*it).m_uidSerie);
		for (std::vector<std::string>::iterator it = rutasSerie.begin(); it != rutasSerie.end(); ++it) {
			rutas.push_back((*it));
		}
	}
	{
	*/

	for(std::set<std::string>::iterator it = uidsSeries.begin(); it!= uidsSeries.end(); it++)
	{
		std::vector<std::string> rutas = m_pEntorno->GetControladorHistorial()->GetPathsSerieOrdenados((*it));

		GNC::GCS::IControladorVistas* pCtrlVistas = m_pEntorno->GetControladorVistas();
		wxWindow* pVentanaPadre = NULL;

		if (rutas.size() == 0)
		{
			return NULL;
		}

		//primero de todo seleccionar diagnostico
		std::string uidDiagnosticoSeleccionado = uidEstudioDiagnostico;
		if(!SeleccionarDiagnostico(rutas[0],uidDiagnosticoSeleccionado))
		{
			//no quiere continuar, se cancela la carga
			return NULL;
		}

		{//comienza la deshabilitacion
			pVentanaPadre = pCtrlVistas->GetRootWindow();
			pCtrlVistas->Freeze();
			try{
				if (modo == m_ListaModos[0]->GetId()) {
					wxWindowDisabler disabler;
					InsertarPaneles();
					GnkPtr<GNKVisualizator::VisualizatorStudy> estudio = new GNKVisualizator::VisualizatorStudy();
					estudio->ListaUIDsSerie.push_back((*it));
					estudio->Entorno = m_pEntorno;
					estudio->Modulo = this;
					estudio->VentanaPadre = pVentanaPadre;
					estudio->InicializarContextoEstudio(rutas, uidDiagnosticoSeleccionado, GNC::GCS::IContextoEstudio::TMF_UNDiagnostico);
					pVista = new GNKVisualizator::Vista2D(estudio);
					pCtrlVistas->Registrar(pVista);
				} else if (modo == m_ListaModos[1]->GetId()) {
					wxWindowDisabler disabler;
					InsertarPaneles();
					GnkPtr<GNKVisualizator::ECGStudy> estudio = new GNKVisualizator::ECGStudy();
					estudio->ListaUIDsSerie.push_back((*it));
					estudio->Entorno = m_pEntorno;
					estudio->Modulo = this;
					estudio->VentanaPadre = pVentanaPadre;
					estudio->InicializarContextoEstudio(rutas, uidDiagnosticoSeleccionado, GNC::GCS::IContextoEstudio::TMF_UNDiagnostico);
					pVista = new GNKVisualizator::WaveFormView(estudio);
					pCtrlVistas->Registrar(pVista);
				}
			}
			catch(GNC::GCS::VistaException &ex){
				if (pVista != NULL) {
					pCtrlVistas->Destruir(pVista);
				}
				pCtrlVistas->Thaw();
				wxString mensaje = wxString::FromUTF8(ex.GetCause().c_str());
				wxMessageDialog dialogo( m_pEntorno->GetVentanaRaiz(), mensaje, _("Error opening study"),  wxOK | wxICON_INFORMATION);
				dialogo.ShowModal();
				return NULL;
			}
			catch (...) {
				if (pVista != NULL) {
					pCtrlVistas->Destruir(pVista);
				}
				pCtrlVistas->Thaw();
				wxMessageDialog dialogo( m_pEntorno->GetVentanaRaiz(), _("Error opening study"), _("Error opening study"),  wxOK | wxICON_INFORMATION);
				dialogo.ShowModal();
				return NULL;
			}
			pCtrlVistas->Thaw();
		}//fin deshabilitacion

		if (pVista == NULL ) {
			pCtrlVistas->Freeze();
			EliminarPaneles();
			pCtrlVistas->Destruir(pVista);
			pCtrlVistas->Thaw();
			return NULL;
		}
		else {
			m_pEntorno->GetControladorCarga()->CargaAsincrona(pVista, pModeloIntegracion, uidDiagnosticoSeleccionado);
		}
	}

	return pVista;
}


// Selecciona el diagnostico. Metodo sincrono con la interfaz.
bool GNKVisualizator::ControladorAtencionPrimaria::SeleccionarDiagnostico(const std::string& rutaFichero, std::string& uidEstudioDiagnostico)
{
	bool continuar = true;
	if(uidEstudioDiagnostico == "")
	{
		GNKVisualizator::GUI::SeleccionarDiagnostico dialogSeleccionarDiagnostico(m_pEntorno->GetVentanaRaiz(),rutaFichero,m_pEntorno);
		if(dialogSeleccionarDiagnostico.Mostrar()) {
			switch(dialogSeleccionarDiagnostico.ShowModal())
			{
				case wxID_OK:
					uidEstudioDiagnostico = dialogSeleccionarDiagnostico.GetUIDEstudioDiagnostico();
					break;
				case wxID_CANCEL:
					continuar = false;
					break;
			}
		}
	}
	return continuar;
}


bool GNKVisualizator::ControladorAtencionPrimaria::SoportaImportacion() const
{
	return m_pEntorno->GetControladorPermisos()->Get("atencionprimaria", "dicomizador");
}

GNKVisualizator::ControladorAtencionPrimaria::TipoListaPlantillas& GNKVisualizator::ControladorAtencionPrimaria::GetPlantillas(){
	if(m_pEntorno->GetControladorPermisos()->Get("dermatologia","plantillas")) {
		if(m_listaPlantillas.size() == 0){
		}
	} else {
		m_listaPlantillas.clear();
	}
	return m_listaPlantillas;
}

void GNKVisualizator::ControladorAtencionPrimaria::GetPasosImportacion(IWizard* pWizard,std::list<IPasoWizard*> &listaPasos, wxWindow* pParent, std::string &dirTemporal, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion){
	GNKVisualizator::GUI::TipoWizardImportacion* datosPersistentes = new GNKVisualizator::GUI::TipoWizardImportacion(pModeloIntegracion);

	IPasoWizard* paso=new GNKVisualizator::GUI::PasoDatosGenerales(pParent,pWizard,datosPersistentes,dirTemporal,m_pEntorno);
	listaPasos.push_back(paso);
}

//region "Manipulacion de paneles extra (Herramientas, etc.)"

void GNKVisualizator::ControladorAtencionPrimaria::InsertarPaneles()
{
	if (m_pPanelContenedorCustom == NULL) {
		m_pPanelContenedorCustom = new GNKVisualizator::GUI::ContenedorHerramientas(m_pEntorno->GetVentanaRaiz());
		m_pPanelContenedorCustom->Freeze();
		m_pPanelContenedorCustom->Show(false);
		m_pEntorno->GetControladorVistas()->InsertarPanelIzquierdo(m_pPanelContenedorCustom, _Std("DICOM Tags").c_str());
		m_pPanelContenedorCustom->Layout();
		m_pPanelContenedorCustom->ActualizarVirtualSize();
		m_pPanelContenedorCustom->Thaw();
	}
}

void GNKVisualizator::ControladorAtencionPrimaria::EliminarPaneles()
{
	m_pEntorno->GetControladorVistas()->EliminarPanel(m_pPanelContenedorCustom);
	m_pPanelContenedorCustom=NULL;
}

void GNKVisualizator::ControladorAtencionPrimaria::MostrarPaneles(bool izquierdo , bool derecho )
{
	if (m_pPanelContenedorCustom != NULL && izquierdo) {
		m_pPanelContenedorCustom->Freeze();
		m_pEntorno->GetControladorVistas()->MostrarPanel(m_pPanelContenedorCustom);
		m_pPanelContenedorCustom->Layout();
		m_pPanelContenedorCustom->ActualizarVirtualSize();
		m_pPanelContenedorCustom->Thaw();
	}
}

void GNKVisualizator::ControladorAtencionPrimaria::OcultarPaneles(bool izquierdo, bool derecho)
{
	if ( m_pPanelContenedorCustom != NULL && izquierdo) {
		m_pPanelContenedorCustom->Freeze();
		m_pEntorno->GetControladorVistas()->OcultarPanel(m_pPanelContenedorCustom);
		m_pPanelContenedorCustom->Layout();
		m_pPanelContenedorCustom->ActualizarVirtualSize();
		m_pPanelContenedorCustom->Thaw();
	}
}
//endregion

