/*
 *  
 *  $Id: importationpersistentdata.h 3681 2011-04-12 10:53:31Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <string>
#include <vector>
#include <yasper/yasper.h>
#include <api/imodelointegracion.h>
#include <sstream>

#include <api/icontroladorimportacionpacs.h>

namespace FooExtension {
	namespace GUI {
		typedef struct ImportationPersistentData {
			//Institution
			std::string InstitutionName, PhysicianName;
			//Series data
			std::string SeriesDate,SeriesTime,SeriesDescription,SeriesUID,SeriesModality,SeriesSopClassID;
			int InstanceNumber;
			//Study data
			std::string AccessionNumber,StudyDate,StudyTime,StudyDescription,StudyInstanceUID;
			//datos del paciente
			std::string PatientName,PatientFirstSurname, PatientSecondSurname,PatientId, PatientBirthDate,PatientAge,PatientSex;

			GIL::DICOM::TipoJerarquia baseImages;

			typedef struct TDicomizedFile {
				std::string imagePath;
				std::string sopInstanceUID;
				std::string pathDCM;
				std::string sopClassUID;
			} TDicomizedFile;
			typedef std::list<TDicomizedFile> TFileList;
			
			TFileList m_dicomizedFiles;
			

			ImportationPersistentData(){				
				InstanceNumber = 0;
			}
			
		}ImportationPersistentData;
	};
};
