/*
 *  
 *  $Id: generaldata.h 3681 2011-04-12 10:53:31Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwizard.h>
#include "importationpanelbase.h"
#include <string>
#include <vector>
#include "importationpersistentdata.h"
#include <api/idicomizador.h>
#include <wx/ginkgostyle/ginkgostyle.h>

namespace GNC {
	namespace GCS {
		class IEntorno;
	}
}

namespace FooExtension {
	namespace GUI {

		class GeneralData: public GeneralDataBase,public IPasoWizard
		{
			public:
				GeneralData(wxWindow* pParent,IWizard* pWizard,const std::string &dirTemporal, GnkPtr<FooExtension::GUI::ImportationPersistentData> datosPersistentes,GNC::GCS::IEntorno * pEntorno);
				~GeneralData();

				//this method tells importation step that it has to attach to the wizard (attach and show)
				virtual void Attach(wxSizer *sizer);
				//this method tells importation step that it has to be dettached from the wizard
				virtual void Detach(wxSizer *sizer);
				//returns step title
				virtual std::string GetTitle();
				//returns step subtitle
				virtual std::string GetSubTitle();
				//returns true if allows next button
				virtual bool Siguiente();
				//returns true if allows back button
				virtual bool Anterior();
				//returns true if allows cancel button
				virtual bool Cancelar();
				//it's called when wizard asks step to validate data
				virtual bool Validar();
				
				virtual bool ValidateData();


				virtual void FillInCommonTags(GIL::DICOM::TipoJerarquia& base);

			//endregion
			protected:
				virtual std::string GetPatientName();
				virtual std::string GetPatientFirstSurname();
				virtual std::string GetPatientSecondSurname();
				virtual std::string GetPatientId();
				virtual std::string GetPatientBirthDate();
				virtual std::string GetPatientAge();
				virtual std::string GetPatientSex();

				void OnKillFocusEstudioTimeControl(wxFocusEvent &event);

				virtual std::string GetStudyDate();
				virtual std::string GetStudyTime();
				virtual std::string GetStudyDescription();

				void OnKillFocusSerieTimeControl(wxFocusEvent &event);

				virtual std::string GetSeriesDate();
				virtual std::string GetSeriesTime();
				virtual std::string GetSeriesDescription();



				GnkPtr<FooExtension::GUI::ImportationPersistentData> m_pPersistentData;
				GNC::GCS::IEntorno *             m_pEntorno;

				// Helpers: AutoEdad
				int CalculateAge();
		};
	}
}
