/*
 *  $Id: gnkvideo.cpp 3681 2011-04-12 10:53:31Z tovar $
 *  Proyecto Ginkgo
 *
 *  Copyright 2008 MetaEmotion S.L. All rights reserved.
 *
 */
#include "fooextension.h"
#include "fooextension/controllers/fooextensioncontroller.h"
#include <api/ientorno.h>
#include <api/internacionalizacion.h>
#include <iostream>
#include <wx/config.h>
#include <wx/msgdlg.h>
#include "fooextension/license.h"


//it's required to call this macro
IMPLEMENT_PrivateExtension(GnkFooExtension)

//parameters are related with provider, version... sid is the extension id, it's used to know if a file has been imported by this extension
//this information will be used in viewer open preference
GnkFooExtension::GnkFooExtension(): PrivateExtension(FOO_EXTENSION_SID, FOO_EXTENSION_PROVIDER, FOO_EXTENSION_DESCRIPTION, FOO_EXTENSION_VERSION, FOO_EXTENSION_SUB_VERSION, FOO_EXTENSION_SUB_RELEASE)
{
}

GnkFooExtension::~GnkFooExtension()
{
}

//returns extension controller module
GNC::GCS::IControladorModulo* GnkFooExtension::InitializeLibrary(GNC::GCS::IEntorno* pEntorno)
{
	return new FooExtension::FooExtensionController(pEntorno);
}

//here you can implement your own security policy
bool GnkFooExtension::IsActivated()
{
	return true;
}

//this extension is free to use
void GnkFooExtension::ShowActivationDialog(wxWindow* pParent)
{	
	wxMessageBox(_("FooExtension is Open Source"), _("Info"));
}

