/*
 *  
 *  $Id: wregla.h 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwidgets.h>
#include <api/iwidgetsmanager.h>
#include <api/widgetserializable.h>
#include <api/icontroladoreventos.h>
#include <widgets/openglhelper.h>

class wxXmlNode;

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtkSmartPointer.h>
#include <vtkImageData.h>

namespace GNC {
	namespace GCS {
		namespace Widgets {

			class WRegla;

			class WReglaBuilder : public GNC::GCS::Widgets::IWidgetBuilder {
			public:

				typedef GNC::GCS::Vector TVector;
				typedef GNC::GCS::Nodo   TNodo;
				typedef GNC::GCS::Matriz TMatriz;

				WReglaBuilder(GNC::GCS::IWidgetsManager* pManager);

				~WReglaBuilder();

				virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton&);

				virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&);

				virtual void Render(GNC::GCS::Contexto3D* c);

				virtual GNC::GCS::Widgets::TipoCursor GetCursor();

			protected:

				bool                           m_MouseDown;
				WRegla*                       m_pReglaTemp;

			};

			class WRegla : public GNC::GCS::Widgets::IWidget, public GNC::GCS::Widgets::IWidgetSerializable, GNC::GCS::IObservador {

			public:
				GNC::GCS::Nodo                           m_Vertices[2];

//region "Constructor y destructor"

			public:

				typedef GNC::GCS::Vector TVector;
				typedef GNC::GCS::Matriz TMatriz;

				//static const unsigned int m_NumNodos = 100;

				#define m_TamFuente 16.0f
				#define m_AnchoMaximo 150.0f

				GNC::GCS::Vector m_StartPointMov;

				WRegla(IWidgetsManager* pManager, long vid, GNC::GCS::Nodo nodos[2], const char* nombre = "");

				~WRegla();

//endregion

				//region "Serializado y desserializado"
				WRegla(IWidgetsManager* pManager, long vid, wxXmlNode* nodo);

				wxXmlNode* Serializar(const std::string& nombreMedico);

				//endregion


				//region "Interfaz especifica"

				virtual bool SoportaAutoBorrado() const {
					return true;
				}

				virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton&);

				virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&);

				virtual bool HitTest(float x, float y, float umbral);

				virtual bool HitTest(GNC::GCS::Vector* vertices, int numVertices);

				virtual void Render(GNC::GCS::Contexto3D* c);

				virtual void OffscreenRender(Contexto3D* c);

				virtual float Distancia() {
					return m_Distancia;
				}

				//endregion

				//region menu contextual
				virtual bool GetMenuContextual(wxMenu* pMenu, wxWindow* pParent) ;
				//endregion

				virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

				//region "Estado interno"
			private:
				bool            m_MouseDown;
				//endregion

				//region "Propiedades geometricas"
			private:
				GNC::GCS::Nodo   m_Centro;
				GNC::GCS::Vector m_CentroAntiguo;
				float            m_Angulo;
				float            m_Pendiente;

				GNC::GCS::Vector m_Escala;
				GNC::GCS::Vector m_TamTexto;
				std::string      m_Texto;
				typedef struct TexturaRegla {
					std::string texto;
					TexturaCairo* m_textura;
					TexturaRegla()
					{
						m_textura = new GNC::GCS::TexturaCairo();
						m_textura->ActivarInterpolacion();
						texto = "";
					}
					~TexturaRegla()
					{
						m_textura->Descargar();
						delete m_textura;
					}
				} TexturaRegla;
				typedef std::map<void*,TexturaRegla*> TMapaRecursos;
				TMapaRecursos m_mapaRecursos;
				TexturaRegla* GetTextura(GNC::GCS::IWidgetsRenderer* renderer);

				friend std::ostream& operator<<(std::ostream& out, const WRegla& w) {
					out << "[ P0=" << w.m_Vertices[0] << ", P1=" << w.m_Vertices[1] <<
					", Centro=" << w.m_Centro << ", Angulo=" << w.m_Angulo << "=" << w.m_Angulo*180.0f/M_PI <<
					", Pendiente=" << w.m_Pendiente << ", Longitud=" << w.m_Distancia << ", CursorPoint=" << w.m_PosCursor << " ]";
					return out;
				}

			public:
				float            m_Distancia;

			public:

				void Recalcular(GNC::GCS::IWidgetsRenderer* renderer);

				virtual void LiberarRecursos(GNC::GCS::IWidgetsRenderer* pKey);

			public:
				//endregion
				virtual void InsertarPropiedades(TListaMapasPropiedades &listaMapaPropiedades);
			};
		}
	}
}
