/*
 *  
 *  $Id: ginkgosqlite.h 3630 2011-03-29 11:28:08Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <wx/wxsqlite3/wxsqlite3.h>
#ifndef _WIN32
#include <unistd.h>
#define Sleep sleep
#define strcpy_s strcpy
#define strcat_s strcat
#endif

//version of ginkgo bbdd
#define GINKGO_BBDD_VERSION 2

//#define _GINKGO_TRACE

/** Timeout values on busy or lock conditions   **/
/** if you observe lock errors you might try to **/
/** increase the values.                        **/

int AbrirConexion(wxSQLite3Database& dataBase,const std::string& DBFileName)
{
	if(dataBase.IsOpen()) {
		return (0);
	}

	dataBase.Open(FROMPATH(DBFileName),wxEmptyString, WXSQLITE_OPEN_READWRITE|WXSQLITE_OPEN_CREATE);

	dataBase.EnableForeignKeySupport(true);

	dataBase.ExecuteUpdate(wxT("PRAGMA recursive_triggers = true;"));

#ifdef _GINKGO_TRACE

	dataBase.ExecuteUpdate(wxT("PRAGMA parser_trace  = true;"));

#endif

	 return 1;
}

//true if you have to reload
bool CheckReloadGinkgoDBVersion(wxSQLite3Database& dataBase) 
{
	try {
		wxSQLite3StatementBuffer bufSQL;
		bufSQL.Format("SELECT Value FROM MetadataBBDD WHERE Property ='Version'");
		wxSQLite3ResultSet result = dataBase.ExecuteQuery(bufSQL);
		if (result.NextRow()) {
			int version = result.GetInt(0, -1);
			return version < GINKGO_BBDD_VERSION;
		} else {
			return true;
		}
	}catch (wxSQLite3Exception& ) {
		return true;
	}
}

int CreateGinkgoDB(wxSQLite3Database& dataBase,const char *DBFileName)
{
	if (!AbrirConexion(dataBase, DBFileName)) {
		return (0);
	}
    /** Create Tables del Historial: **/

    /** 1. Tabla de pacientes **/
	wxString sentencia(wxT(""));
	sentencia << wxT("CREATE TABLE Pacientes (");
	sentencia << wxT("IDPaciente VARCHAR(70) PRIMARY KEY,");
   sentencia << wxT("Nombre VARCHAR(100),");
   sentencia << wxT("FechaNacimiento DATE,");
	sentencia << wxT("Sexo CHAR);");
	dataBase.ExecuteUpdate(sentencia);

	 /** 1. Tabla de estudios **/
	sentencia = wxEmptyString;
   sentencia << wxT("CREATE TABLE Estudios (");
	sentencia << wxT("UIDEstudio VARCHAR(70) PRIMARY KEY,");
   sentencia << wxT("Descripcion VARCHAR(100),");
   sentencia << wxT("NombreMedico VARCHAR(200),");
   sentencia << wxT("Fecha DATE,");
	sentencia << wxT("Hora TIME,");
	sentencia << wxT("IDPaciente VARCHAR(70) REFERENCES Pacientes(IDPaciente) ON UPDATE CASCADE ON DELETE CASCADE);");
	dataBase.ExecuteUpdate(sentencia);

	 /** 1. Tabla de series **/
	sentencia = wxEmptyString;
   sentencia << wxT("CREATE TABLE Series (");
	sentencia << wxT("UIDSerie VARCHAR(70) PRIMARY KEY,");
   sentencia << wxT("Descripcion VARCHAR(100),");
   sentencia << wxT("Fecha DATE,");
	sentencia << wxT("Hora TIME,");
	sentencia << wxT("UIDEstudio VARCHAR(70) REFERENCES Estudios(UIDEstudio) ON UPDATE CASCADE ON DELETE CASCADE);");
	dataBase.ExecuteUpdate(sentencia);

	 /** 1. Tabla de ficheros **/
	sentencia = wxEmptyString;
   sentencia << wxT("CREATE TABLE Ficheros (");
#ifdef _WIN32
	sentencia << wxT("Path VARCHAR(256) PRIMARY KEY COLLATE NOCASE,");
#else
	sentencia << wxT("Path VARCHAR(256) PRIMARY KEY,");
#endif
	sentencia << wxT("UIDFichero VARCHAR(70),");
	sentencia << wxT("Modalidad VARCHAR(2),");
   sentencia << wxT("Descripcion VARCHAR(100),");
	sentencia << wxT("UIDImportador VARCHAR(70),");
   sentencia << wxT("Fecha DATE,");
	sentencia << wxT("Hora TIME,");
	sentencia << wxT("TransferSyntaxUID VARCHAR(70),"); //transfer syntax to know if we can read it
	sentencia << wxT("UIDSerie VARCHAR(70) REFERENCES Series(UIDSerie) ON UPDATE CASCADE ON DELETE CASCADE);");
	dataBase.ExecuteUpdate(sentencia);

	sentencia = wxEmptyString;
   sentencia << wxT("CREATE Index IndiceUIDFichero ");
	sentencia << wxT("ON Ficheros(");
   sentencia << wxT("UIDFichero);");
	dataBase.ExecuteUpdate(sentencia);

	/** 1. Tabla de caracteristicas ficheros para ordenacion **/

	sentencia = wxEmptyString;
   sentencia << wxT("CREATE TABLE TagsFicheros (");
#ifdef _WIN32
	sentencia << wxT("Path VARCHAR(256) PRIMARY KEY COLLATE NOCASE REFERENCES Ficheros(Path) ON UPDATE CASCADE ON DELETE CASCADE,");
#else
	sentencia << wxT("Path VARCHAR(256) PRIMARY KEY REFERENCES Ficheros(Path) ON UPDATE CASCADE ON DELETE CASCADE,");
#endif
	sentencia << wxT("Orientation CHAR,");//A,C,S, O
	sentencia << wxT("PatientPositionX DOUBLE,");//patients position en la coordenada que interesa
	sentencia << wxT("PatientPositionY DOUBLE,");//patients position en la coordenada que interesa
	sentencia << wxT("PatientPositionZ DOUBLE,");//patients position en la coordenada que interesa
	sentencia << wxT("SliceLocation DOUBLE,");//slice location
	sentencia << wxT("Height INTEGER,");	//altura imagen
	sentencia << wxT("Width INTEGER,");		//anchura imagen
	sentencia << wxT("InstanceNumber DOUBLE,"); //instance number
   sentencia << wxT("ContentTime TIME,");	//content time (ordenar por hora)
	sentencia << wxT("ContentDate DATE)"); //content date (ordenar por fecha)
	dataBase.ExecuteUpdate(sentencia);

	//tabla de referencias...
	sentencia = wxEmptyString;
   sentencia << wxT("CREATE TABLE ReferenciasFicheros (");
	sentencia << wxT("UIDFicheroOrigen VARCHAR(70),");
   sentencia << wxT("UIDFicheroDestino VARCHAR(70));");
	dataBase.ExecuteUpdate(sentencia);

	//version table
	sentencia = wxEmptyString;
	sentencia << wxT("CREATE TABLE MetadataBBDD (");
	sentencia << wxT("Property VARCHAR(70) PRIMARY KEY, ");
	sentencia << wxT("Value    VARCHAR(70));");
	dataBase.ExecuteUpdate(sentencia);

	//insert version value
	sentencia = wxEmptyString;
	sentencia << wxT("INSERT INTO MetadataBBDD (Property, Value) VALUES ('Version',") << GINKGO_BBDD_VERSION << wxT(");");
	dataBase.ExecuteUpdate(sentencia);


	//indexes
	sentencia = wxEmptyString;
   sentencia << wxT("CREATE Index IndiceOrigen ");
	sentencia << wxT("ON ReferenciasFicheros(");
   sentencia << wxT("UIDFicheroOrigen);");
	dataBase.ExecuteUpdate(sentencia);

	sentencia = wxEmptyString;
   sentencia << wxT("CREATE Index IndiceDestino ");
	sentencia << wxT("ON ReferenciasFicheros(");
   sentencia << wxT("UIDFicheroDestino);");
	dataBase.ExecuteUpdate(sentencia);

	 /*Triggers de mantenimiento*/

	 //si se borran todos los ficheros de una serie se borra la serie
	sentencia = wxEmptyString;
	sentencia << wxT("CREATE TRIGGER delete_fichero1 AFTER DELETE ON Ficheros ");
	sentencia << wxT("FOR EACH ROW ");
		sentencia << wxT("WHEN ((SELECT Path FROM Ficheros WHERE UIDSerie = OLD.UIDSerie) IS NULL) ");
		sentencia << wxT("BEGIN ");
		sentencia << wxT("DELETE FROM Series WHERE UIDSerie = OLD.UIDSerie; ");
	sentencia << wxT("END;");
	dataBase.ExecuteUpdate(sentencia);

	//si se borran todos los ficheros con un uid se borran sus referencias
	sentencia = wxEmptyString;
	sentencia << wxT("CREATE TRIGGER delete_fichero2 AFTER DELETE ON Ficheros ");
	sentencia << wxT("FOR EACH ROW ");
		sentencia << wxT("WHEN ((SELECT UIDFichero FROM Ficheros WHERE UIDFichero = OLD.UIDFichero) IS NULL) ");
		sentencia << wxT("BEGIN ");
		sentencia << wxT("DELETE FROM ReferenciasFicheros WHERE UIDFicheroOrigen = OLD.UIDFichero; ");
	sentencia << wxT("END;");
	dataBase.ExecuteUpdate(sentencia);



	 //si se borran todas las series de un estudio se borra el estudio
	sentencia = wxEmptyString;
	sentencia << wxT("CREATE TRIGGER delete_serie AFTER DELETE ON Series ");
	sentencia << wxT("FOR EACH ROW ");
		sentencia << wxT("WHEN ((SELECT UIDSerie FROM Series WHERE UIDEstudio = OLD.UIDEstudio) IS NULL) ");
		sentencia << wxT("BEGIN ");
		sentencia << wxT("DELETE FROM Estudios WHERE UIDEstudio = OLD.UIDEstudio; ");
	sentencia << wxT("END;");
	dataBase.ExecuteUpdate(sentencia);


	 //si se borran todos los estudios de un paciente se borra el paciente
	sentencia = wxEmptyString;
	sentencia << wxT("CREATE TRIGGER delete_estudio AFTER DELETE ON Estudios ");
	sentencia << wxT("FOR EACH ROW ");
		sentencia << wxT("WHEN ((SELECT UIDEstudio FROM Estudios WHERE IDPaciente = OLD.IDPaciente) IS NULL) ");
		sentencia << wxT("BEGIN ");
		sentencia << wxT("DELETE FROM Pacientes WHERE IDPaciente = OLD.IDPaciente; ");
	sentencia << wxT("END;");
	dataBase.ExecuteUpdate(sentencia);


    return(1);

}

int AbrirConexionThumbnails(wxSQLite3Database& dataBase,const std::string& DBFileName)
{
	if(dataBase.IsOpen()) {
		return (0);
	}

	dataBase.Open(FROMPATH(DBFileName),wxEmptyString, WXSQLITE_OPEN_READWRITE|WXSQLITE_OPEN_CREATE);

	 return 1;
}

int CreateGinkgoDBThumbnails(wxSQLite3Database& dataBase,const std::string& DBFileName)
{
	if (!AbrirConexionThumbnails(dataBase, DBFileName)) {
		return (0);
	}
    /** Create Tables del Historial: **/

	wxString sentencia(wxT(""));
    /** 1. Tabla de thumbnails **/
	sentencia = wxEmptyString;
   sentencia << wxT("CREATE TABLE Thumbnails (");
	sentencia << wxT("IDPaciente VARCHAR(70) ,");
	sentencia << wxT("UIDEstudio VARCHAR(70),");
	sentencia << wxT("UIDSerie VARCHAR(70),");
#ifdef _WIN32
	sentencia << wxT("Path VARCHAR(256) COLLATE NOCASE PRIMARY KEY,");
#else
	sentencia << wxT("Path VARCHAR(256) PRIMARY KEY,");
#endif
	sentencia << wxT("Ancho INTEGER,");
	sentencia << wxT("Alto INTEGER,");
	sentencia << wxT("Thumbnail BLOB);");
	dataBase.ExecuteUpdate(sentencia);
   return(1);

}




