/*
 *  
 *  $Id: herramientawindowlevel.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <wx/aui/aui.h>
#include <wx/stattext.h>
#include <wx/combobox.h>
#include <wx/valtext.h>
#include <wx/textctrl.h>

#include <api/globals.h>
#include <api/internacionalizacion.h>
#include "herramientawindowlevel.h"
#include <api/iwidgetsmanager.h>
#include <resources/ginkgoresourcemanager.h>
#include <main/entorno.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorlog.h>
#include <eventos/eventosginkgo.h>
#include <api/inotificadoresherramientas.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>
#include <vtkImageData.h>
#include <vtkPointData.h>

#include <vtkImageData.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkSmartPointer.h>
#include <vtkObject.h>
#include <vtkPointData.h>
#include <vtkImageData.h>
#include <vtkLookupTable.h>
#include <vtkImageActor.h>
#include <vtkRenderWindow.h>
#include <vtkRenderer.h>

#define COMBO_WINDOW_LEVEL 1221
#define RESETEAR_WINDOWLEVEL 1222
#define COMBO_WINDOW_LEVEL_PREDEFINIDO 1223
#define TEXTCTRL_WLW_MANUAL 1224
#define TEXTCTRL_WLL_MANUAL 1225
#define WWTEXT 1226
#define WLTEXT 1227

namespace GNC {
	namespace GUI {
		class HerramientaOpcionesWindowLevelGUI : public AUI_NAMESPACE wxAuiToolBar {
		public:
			HerramientaOpcionesWindowLevelGUI(wxWindow* pParent, GNC::HerramientaWindowLevel* pHerramienta):AUI_NAMESPACE wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize, AUI_NAMESPACE wxAUI_TB_DEFAULT_STYLE | AUI_NAMESPACE wxAUI_TB_HORZ_TEXT )
			{
				m_labelUserDefined = _Std("User Defined");

				m_pHerramienta = pHerramienta;

				SetToolBitmapSize( wxSize( 16,16 ) );

				AddLabel(wxID_ANY, _("Profile"), 35);

				m_pComboBox = new wxComboBox(this,COMBO_WINDOW_LEVEL, _("DICOM Window/Level"), wxDefaultPosition, wxDefaultSize, 0, NULL, wxCB_DROPDOWN|wxCB_READONLY );
				AddControl( m_pComboBox, _("DICOM Window/Level"));
				AddSeparator();


				AddLabel(wxID_ANY, _(" WW"), 20);
				m_textCtrlWW = new wxTextCtrl( this, TEXTCTRL_WLW_MANUAL, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER );
				AddControl( m_textCtrlWW, _("Manual Window/Level"));
				m_textCtrlWW->SetValidator( wxTextValidator( wxFILTER_NUMERIC ) );
				AddLabel(wxID_ANY, _(" WL"), 20);
				m_textCtrlWL = new wxTextCtrl( this, TEXTCTRL_WLL_MANUAL, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_PROCESS_ENTER );
				AddControl( m_textCtrlWL, _("Manual Window/Level"));
				m_textCtrlWL->SetValidator( wxTextValidator( wxFILTER_NUMERIC ) );

				AddSeparator();
				AddTool( RESETEAR_WINDOWLEVEL, _("Reset"), GinkgoResourcesManager::BarraWindowLevel::GetIcoReset(), _("Reset Window/Level") );

				Realize();
				m_opcionPersonal = -1;

				Layout();

				// Connect Events
				this->Connect( COMBO_WINDOW_LEVEL, wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnComboBoxChanged ) );
				this->Connect( TEXTCTRL_WLW_MANUAL, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnTextEntered1 ) );
				this->Connect( TEXTCTRL_WLL_MANUAL, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnTextEntered1 ) );
				this->Connect( RESETEAR_WINDOWLEVEL, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnBResetearClick ) );
			}

			~HerramientaOpcionesWindowLevelGUI(){
				// Disconnect Events
				this->Disconnect( RESETEAR_WINDOWLEVEL, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnBResetearClick ) );
				this->Disconnect( COMBO_WINDOW_LEVEL, wxEVT_COMMAND_COMBOBOX_SELECTED, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnComboBoxChanged ) );
				this->Disconnect( TEXTCTRL_WLW_MANUAL, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnTextEntered1 ) );
				this->Disconnect( TEXTCTRL_WLL_MANUAL, wxEVT_COMMAND_TEXT_ENTER, wxCommandEventHandler( HerramientaOpcionesWindowLevelGUI::OnTextEntered1 ) );
			}

			virtual void OnBResetearClick( wxCommandEvent&  ){
				m_pHerramienta->Resetear();
			}

			virtual void OnComboBoxChanged( wxCommandEvent&  ){
				wxString wLStr, wWStr;
				GNC::GCS::IContratoWindowLevel::WindowLevel selectedWL;

				selectedWL=((*m_pListaWindowLevels)[m_pComboBox->GetCurrentSelection()]);
				m_pHerramienta->SetWindowLevel((*m_pListaWindowLevels)[m_pComboBox->GetCurrentSelection()]);
				wWStr << selectedWL.m_window;
				wLStr << selectedWL.m_level;
				m_textCtrlWW->SetValue(wWStr);
				m_textCtrlWL->SetValue(wLStr);
			}

			virtual void OnTextEntered1( wxCommandEvent&  ){
				double newWindowWidth = 0.0f;
				double newWindowLevel = 0.0f;
				double newWindowWidthClamped = newWindowWidth;
				double newWindowLevelClamped = newWindowLevel;

				wxString strW, strL;

				m_textCtrlWW->GetValue().ToDouble(&newWindowWidth);
				m_textCtrlWL->GetValue().ToDouble(&newWindowLevel);

				m_pHerramienta->ClampWindowLevel(newWindowWidth, newWindowLevel, newWindowWidthClamped, newWindowLevelClamped);

				if (newWindowWidth != newWindowWidthClamped)
				{
					m_textCtrlWW->SetValue(wxString::Format(wxT("%.2f"), newWindowWidthClamped));
				}
				if (newWindowLevel != newWindowLevelClamped)
				{
					m_textCtrlWL->SetValue(wxString::Format(wxT("%.2f"), newWindowLevelClamped));
				}

				ModificarOpcionPersonal(newWindowWidthClamped, newWindowLevelClamped);
			}

			void ConfigurarCombo(GNC::GCS::IContratoWindowLevel::ListaWindowLevels* pListaWindowLevels, const std::string& m_labelCurrent, double window, double level){
				m_pListaWindowLevels = pListaWindowLevels;
				m_pComboBox->Clear();
				m_opcionPersonal = -1;

				if((*m_pListaWindowLevels).size()>0){
					int i=0;
					int seleccionado = -1;
					for(GNC::GCS::IContratoWindowLevel::ListaWindowLevels::iterator it = (*m_pListaWindowLevels).begin(); it!= (*m_pListaWindowLevels).end(); it++,i++){
						wxString str = wxString::FromUTF8((*it).m_label.c_str()) + wxString::Format(wxT(": %.2f/%.2f"),(*it).m_window,(*it).m_level);
						m_pComboBox->AppendString( str );
						if((*it).m_label == m_labelCurrent){
							seleccionado = i;
							if((*it).m_userDefined){
								m_opcionPersonal = i;
							}
						}
					}
					if(seleccionado!=-1){
						m_pComboBox->SetSelection(seleccionado);
					} else {
						ModificarOpcionPersonal(window,level);
					}
				} else {
					ModificarOpcionPersonal(window,level);
				}
			}


			void AddWindowLevelPersonal(double window, double level)
			{
				//si no esta ya pues se añade
				wxString str = wxString::FromUTF8(m_labelUserDefined.c_str());
				str += wxString::Format(wxT(": %.2f/%.2f"),window,level);
				m_pComboBox->AppendString(str);
				m_opcionPersonal = m_pComboBox->GetCount() - 1;
				m_pComboBox->SetSelection(m_opcionPersonal);
				GNC::GCS::IContratoWindowLevel::WindowLevel wl(m_labelUserDefined, window, level,true);
				(*m_pListaWindowLevels).push_back(wl);
				m_pHerramienta->SetWindowLevel(wl);
			}

			void SetWindowLevel(double window, double level) {
				int i=0;
				int seleccionado = -1;
				for(GNC::GCS::IContratoWindowLevel::ListaWindowLevels::iterator it = (*m_pListaWindowLevels).begin(); it!= (*m_pListaWindowLevels).end(); it++,i++){
					if((*it).m_window == window && (*it).m_level == level){
						seleccionado = i;
						break;
					}
				}
				if(seleccionado!=-1){
					m_pComboBox->SetSelection(seleccionado);
				} else {
					ModificarOpcionPersonal(window, level);
				}
				CambiaWLTextControls(window,level);
			}

			void ModificarOpcionPersonal(double window, double level) {
				//primero se busca
				if(m_opcionPersonal == -1){
					int i = 0;
					for(GNC::GCS::IContratoWindowLevel::ListaWindowLevels::iterator it = (*m_pListaWindowLevels).begin(); it!= (*m_pListaWindowLevels).end(); it++,i++){
						if((*it).m_userDefined) {
							m_opcionPersonal = i;
							m_pComboBox->SetSelection(m_opcionPersonal);
							break;
						}
					}
				}
				//si sigue siendo -1 se agrega
				if(m_opcionPersonal == -1) {
					AddWindowLevelPersonal(window,level);
				} else {
					wxString str = wxString::FromUTF8(m_labelUserDefined.c_str());
					wxString strW;
					wxString strL;
					str += wxString::Format(wxT(": %.2f/%.2f"),window,level);
					strW << window;
					strL << level;
					m_pComboBox->SetString(m_opcionPersonal,str);
					m_pComboBox->SetSelection(m_opcionPersonal);
					m_textCtrlWW->SetValue(strW);
					m_textCtrlWL->SetValue(strL);
					(*m_pListaWindowLevels)[m_opcionPersonal].m_window = window;
					(*m_pListaWindowLevels)[m_opcionPersonal].m_level = level;
					m_pHerramienta->SetWindowLevel((*m_pListaWindowLevels)[m_opcionPersonal]);
				}
			}

			void CambiaWLTextControls(double window,double level)
			{
				wxString strW;
				wxString strL;

				strW << window;
				strL << level;

				m_textCtrlWW->SetValue(strW);
				m_textCtrlWL->SetValue(strL);
			}

			GNC::HerramientaWindowLevel* m_pHerramienta;
			wxComboBox* m_pComboBox;
			wxTextCtrl* m_textCtrlWW;
			wxTextCtrl* m_textCtrlWL;
			wxStaticText* m_staticTextWW;
			wxStaticText* m_staticTextWL;
			int m_opcionPersonal;
			GNC::GCS::IContratoWindowLevel::ListaWindowLevels* m_pListaWindowLevels;
			std::string m_labelUserDefined;

		};
	}
}

//----------------------------------------------------------------------

GNC::HerramientaWindowLevel::HerramientaWindowLevel()
{

	m_Descripcion = _Std("Window/Level");

	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoWindowLevel();
}

GNC::HerramientaWindowLevel::~HerramientaWindowLevel()
{
}


//region "Realizaci�n de la interfaz IHerramienta"

void GNC::HerramientaWindowLevel::CrearPaneles( wxPanel* panel )
{
	m_pAbstractPanelHerramientaOpciones = new GNC::GUI::HerramientaOpcionesWindowLevelGUI(panel,this);
}

void GNC::HerramientaWindowLevel::ConectarContratoFalso(bool activar) {
	if (TContratableWindowLevel::m_pListaActiva == NULL || TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin();
	TContratableWidgets::IteradorListaContratos itWidgets = TContratableWidgets::m_pListaActiva->begin();

	for (; itWindowLevel != TContratableWindowLevel::m_pListaActiva->end() && itWidgets != TContratableWidgets::m_pListaActiva->end(); itWindowLevel++,itWidgets++) {
		TContratoWidgets* pC = (*itWidgets);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE( "HerramientaWindowLevel: Conectando contrato falso de vista " << TContratableWindowLevel::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
			else {
				GTRACE( "HerramientaWindowLevel: Desconectando contrato falso de vista " << TContratableWindowLevel::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}
}

void GNC::HerramientaWindowLevel::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWindowLevel::EstablecerVistaActiva(pVista);
	TContratableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::TContratableWindowLevel::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaWindowLevel::ConectarContratos(bool activar)
{
	if (TContratableWindowLevel::m_pListaActiva == NULL || TContratableWidgets::m_pListaActiva == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pWindowLevelBuilder != NULL) {
				delete m_pWindowLevelBuilder;
				m_pWindowLevelBuilder = NULL;
			}
		}
		return;
	}

	// Recorrido de los contratos.
	TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin();
	TContratableWidgets::IteradorListaContratos itWidgets = TContratableWidgets::m_pListaActiva->begin();

	for (; itWindowLevel != TContratableWindowLevel::m_pListaActiva->end() && itWidgets != TContratableWidgets::m_pListaActiva->end(); itWindowLevel++,itWidgets++) {
		TContratoWidgets* pCW = (*itWidgets);
		TContratoWindowLevel* pCWL = (*itWindowLevel);
		if (pCW->Inicializado()) {
			if (activar) {
				GTRACE("HerramientaWindowLevel: Conectando contratos de vista " << pCW->GetViewer() );
				// Subscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				// Usamos de Id de grupo el valor del puntero de la herramienta, que es unico y no cambia
				m_pWindowLevelBuilder = new GNC::GCS::Widgets::WWindowLevelBuilder(pCW->GetManager(), (unsigned long)this);
				m_pWindowLevelBuilder->SetObservador(this);
				((GNC::GUI::HerramientaOpcionesWindowLevelGUI*)m_pAbstractPanelHerramientaOpciones)->ConfigurarCombo(&pCWL->m_listaWindowLevels, pCWL->m_labelCurrent, pCW->GetViewer()->GetWindow(), pCW->GetViewer()->GetColorLevel());
				//((GNC::GUI::HerramientaOpcionesWindowLevelGUI*)m_pAbstractPanelHerramientaOpciones)->MostrarSiCT(pCWL->m_isCT);
				pCW->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pCW->GetManager()->SetCursor(m_pWindowLevelBuilder->GetCursor());
				GNC::GCS::ControladorEventos::Instance()->Registrar(this, GNC::GCS::Eventos::EventoModificacionImagen(TContratableWindowLevel::m_pVistaActiva));
			}
			else {
				GTRACE( "HerramientaWindowLevel: Desconectando contratos de vista " << pCW->GetViewer() );
				if (m_pWindowLevelBuilder != NULL) {
					delete m_pWindowLevelBuilder;
					m_pWindowLevelBuilder = NULL;
				}
				pCW->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pCW->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				GNC::GCS::ControladorEventos::Instance()->DesRegistrar(this);
			}
		}
	}
}

//endregion

void GNC::HerramientaWindowLevel::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
{
	if (Conectada()) {
		if (evt->GetCodigoEvento() == ginkgoEVT_Core_ModificacionImagen) {
			GNC::GCS::Eventos::EventoModificacionImagen* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionImagen*>(evt);
				if (pEvt == NULL) {
					std::cerr << "Error al interpretar evento como evento de modificación de imagen: Evento = " << evt << std::endl;
					return;
				}
				if (pEvt->GetTipo() == GNC::GCS::Eventos::EventoModificacionImagen::SliceCambiado) {
					//se actualiza el combo
					// Recorrido de los contratos.
					TContratableWindowLevel::IteradorListaContratos itWindowLevel = TContratableWindowLevel::m_pListaActiva->begin();
					TContratableWidgets::IteradorListaContratos itWidgets = TContratableWidgets::m_pListaActiva->begin();

					for (; itWindowLevel != TContratableWindowLevel::m_pListaActiva->end() && itWidgets != TContratableWidgets::m_pListaActiva->end(); itWindowLevel++,itWidgets++) {
						TContratoWidgets* pCW = (*itWidgets);
						TContratoWindowLevel* pCWL = (*itWindowLevel);
						if (pCW->Inicializado()) {
							((GNC::GUI::HerramientaOpcionesWindowLevelGUI*)m_pAbstractPanelHerramientaOpciones)->ConfigurarCombo(&pCWL->m_listaWindowLevels, pCWL->m_labelCurrent, pCW->GetViewer()->GetWindow(), pCW->GetViewer()->GetColorLevel());
						}
					}
				}
		}
	}
}

//region "Realización de la interfaz IHerramienta"

void GNC::HerramientaWindowLevel::OnStart() {
	TContratableWidgets::IteradorListaContratos itWidgets = TContratableWidgets::m_pListaActiva->begin();
	for (; itWidgets != TContratableWidgets::m_pListaActiva->end(); itWidgets++) {
		TContratoWidgets* pCW = (*itWidgets);
		vtkGinkgoImageViewer* pIV = pCW->GetViewer();
		double window = pIV->GetColorWindow();
		double level = pIV->GetColorLevel();
		m_WindowLevelInicial[pCW] = GNC::GCS::IContratoWindowLevel::WindowLevel(window, level);
	}
}


void GNC::HerramientaWindowLevel::OnAjuste(TVector& start, TVector& stop) {
	GTRACE("GNC::HerramientaWindowLevel::OnAjuste()");

	TContratableWidgets::IteradorListaContratos itWidgets = TContratableWidgets::m_pListaActiva->begin();
	for (; itWidgets != TContratableWidgets::m_pListaActiva->end(); itWidgets++) {
		TContratoWidgets* pCW = (*itWidgets);
		vtkGinkgoImageViewer* pIV = pCW->GetViewer();

		GNC::GCS::IContratoWindowLevel::WindowLevel& wlInicial = m_WindowLevelInicial[pCW];

		int* size = pIV->GetRenderWindow()->GetSize();

		TVector delta = ((stop - start) * 2) / TVector(size[0], size[1]);

		GTRACE("delta     " << delta << " window inicial: "<<wlInicial.m_window << " level inicial " << wlInicial.m_level)

		if (std::abs(wlInicial.m_window) > 0.01) {
			delta.x *= wlInicial.m_window;
		}
		else {
			delta.x *= (wlInicial.m_window < 0 ? -0.01 : 0.01);
		}
		if (std::abs(wlInicial.m_level) > 0.01) {
			delta.y *= wlInicial.m_level;
		}
		else {
			delta.y *= (wlInicial.m_level < 0 ? -0.01 : 0.01);
		}

		// Abs so that direction does not flip

		if (wlInicial.m_window < 0.0) {
			delta.x *= -1.0f;
		}
		if (wlInicial.m_level < 0.0) {
			delta.y *= -1.0f;
		}

		// Compute new window level

		double newWindow = delta.x + wlInicial.m_window;
		double newLevel = wlInicial.m_level - delta.y;

		GTRACE("delta final     " << delta << " new window "<<newWindow<<" new level "<<newLevel)

		// Stay away from zero and really

		newWindow = std::max((double)0.01f, newWindow);
		if (std::abs(newLevel) < 0.01)
		{
			newLevel = 0.01*(newLevel < 0 ? -1 : 1);
		}

		double newClampedWindow = newWindow;
		double newClampedLevel = newLevel;
		ClampWindowLevel(newWindow, newLevel, newClampedWindow, newClampedLevel);

		((GNC::GUI::HerramientaOpcionesWindowLevelGUI*)m_pAbstractPanelHerramientaOpciones)->ModificarOpcionPersonal(newClampedWindow,newClampedLevel);
	}
}

void GNC::HerramientaWindowLevel::OnEnd() {
	m_WindowLevelInicial.clear();
}

//endregion

//region "metodos propios de la herramienta window/level"

void GNC::HerramientaWindowLevel::ClampWindowLevel(double window, double level, double& clampedWindow, double& clampedLevel) {
	TContratableWidgets::IteradorListaContratos itWidgets = TContratableWidgets::m_pListaActiva->begin();
	TContratableWindowLevel::IteradorListaContratos itWL = TContratableWindowLevel::m_pListaActiva->begin();
	clampedWindow = window;
	clampedLevel = level;
	/*
	double range[2];
	for (; itWidgets != TContratableWidgets::m_pListaActiva->end() && itWL != TContratableWindowLevel::m_pListaActiva->end(); itWidgets++,itWL++) {
		TContratoWidgets* pCW = (*itWidgets);
		TContratoWindowLevel* pCWL = (*itWL);
		if (pCW != NULL && pCWL != NULL) {
			vtkGinkgoImageViewer* pIV = pCW->GetViewer();
			if (pIV != NULL) {
				vtkImageData* pImg = pIV->GetInput();
				pImg->GetScalarRange(range);
				clampedWindow = std::min( std::max(window, (double)1.0f), (range[1] - range[0]) );
				clampedLevel = std::min( std::max( level, range[0]), range[1] );

				if (clampedLevel != level || clampedWindow != window) {
					LOG_DEBUG("W/L", window << "/" << level << " clamped to  " << clampedWindow << "/" << clampedLevel);
				}
			}
		}
	}
	*/

}


void GNC::HerramientaWindowLevel::SetWindowLevel(const GNC::GCS::IContratoWindowLevel::WindowLevel& wl){
	if(Habilitada()){
		wxString wLStr, wWStr;
		for (TContratableWindowLevel::IteradorListaContratos itWL = TContratableWindowLevel::m_pListaActiva->begin(); itWL != TContratableWindowLevel::m_pListaActiva->end(); itWL++) {
			TContratoWindowLevel* pCWL = (*itWL);
			pCWL->m_labelCurrent = wl.m_label;
		}
		
		GTRACE("GNC::HerramientaWindowLevel::Resetear()");
		GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(TContratableWindowLevel::m_pVistaActiva,GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada, -1);
		pEvt->SetWindow(wl.m_window);
		pEvt->SetLevel(wl.m_level);
		GNC::Entorno::Instance()->GetControladorEventos()->ProcesarEvento(pEvt);
	}
}

void GNC::HerramientaWindowLevel::Resetear() {
	GTRACE("GNC::HerramientaWindowLevel::Resetear()");
	TContratableWidgets::IteradorListaContratos itWidgets = TContratableWidgets::m_pListaActiva->begin();
	wxString wLStr, wWStr;
	for (; itWidgets != TContratableWidgets::m_pListaActiva->end() ; itWidgets++) {
		TContratoWidgets* pCW = (*itWidgets);
		vtkGinkgoImageViewer* pIV = pCW->GetViewer();

		GNC::GCS::Eventos::EventoModificacionImagen* pEvt = new GNC::GCS::Eventos::EventoModificacionImagen(TContratableWindowLevel::m_pVistaActiva,GNC::GCS::Eventos::EventoModificacionImagen::VisualizacionImagenModificada, -1);
		
		pEvt->EnableResetWindowLevel();

		GNC::Entorno::Instance()->GetControladorEventos()->ProcesarEvento(pEvt);

		double window = pIV->GetWindow();
		double level = pIV->GetLevel();
		((GNC::GUI::HerramientaOpcionesWindowLevelGUI*)m_pAbstractPanelHerramientaOpciones)->SetWindowLevel(window,level);
	}
}

//endregion


