/*
 *  
 *  $Id: herramientapaneltags.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <wx/menu.h>
#include <api/globals.h>
#include "herramientapaneltags.h"
#include <api/internacionalizacion.h>
#include <eventos/eventosginkgo.h>
#include <main/controllers/controladoreventos.h>

#include <resources/ginkgoresourcemanager.h>
#include <api/icontextoestudio.h>

#define ACTIVAR_TAGS  1551
namespace GNC {
	namespace GUI {
		class EventHandlerPanelTags: public wxEvtHandler {
		public:
			EventHandlerPanelTags(wxWindow* pParent, GNC::HerramientaPanelTags* pHerramienta):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				m_pParent->Connect(ACTIVAR_TAGS, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerPanelTags::OnActivarPanelClick),NULL,this);
				m_pParent->Connect(ACTIVAR_TAGS, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerPanelTags::OnUpdatePanelUI),NULL,this);
			}
			~EventHandlerPanelTags()
			{
				m_pParent->Disconnect(wxID_ANY, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerPanelTags::OnActivarPanelClick),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerPanelTags::OnUpdatePanelUI),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnActivarPanelClick( wxCommandEvent& event )
			{
				m_pHerramienta->SolicitarActivacion();
				event.Skip(false);
			}

			void OnUpdatePanelUI(wxUpdateUIEvent& event) {
				if(m_pHerramienta->IsVisible()) {
					event.SetText(_("Hide DICOM tags panel"));	
				} else {
					event.SetText(_("Show DICOM tags panel"));	
				}
			}

			GNC::HerramientaPanelTags* m_pHerramienta;
			wxWindow* m_pParent;			
		};

		class MenuHerramientaPanelTags : public wxMenuItem {
		public:
			MenuHerramientaPanelTags(wxWindow* pParent, wxMenu* pMenuPadre, GNC::HerramientaPanelTags* pHerramienta):wxMenuItem(pMenuPadre,ACTIVAR_TAGS,wxT("Mostrar el panel de tags DICOM"),wxT("Mostrar/Ocultar el panel de tags DICOM"),wxITEM_NORMAL) {
				pEventHandler = new EventHandlerPanelTags(pParent,pHerramienta);	
#ifdef __WXMSW__
				SetBitmaps(GinkgoResourcesManager::IconosHerramientas::GetIcoMostrarOcultarTags());
#else
				//	SetBitmap(GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla());
#endif
			}

			~MenuHerramientaPanelTags() 
			{
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerPanelTags* pEventHandler;
		};
	}
}

//----------------------------------------------------------------------

GNC::HerramientaPanelTags::HerramientaPanelTags()
{
	m_Descripcion = _Std("Show / Hide DICOM tags panel");
	m_IsMenu = true;
	m_pPanelTags = NULL;
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoMostrarOcultarTags();
}

GNC::HerramientaPanelTags::~HerramientaPanelTags()
{
}

bool GNC::HerramientaPanelTags::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	pMenuParent->Append(new GNC::GUI::MenuHerramientaPanelTags(pParent,pMenuParent,this));	
	return true;
}

//region "Realizaci�n de la interfaz IHerramienta"

void GNC::HerramientaPanelTags::CrearPaneles( wxPanel* /*panel*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

bool GNC::HerramientaPanelTags::IsVisible()
{
	bool isVisible =false;

	if (m_pPanelTags != NULL) {
		isVisible = m_pPanelTags->IsVisiblePanelTags();
	}
			
	return isVisible;
}
void GNC::HerramientaPanelTags::SolicitarActivacion()
{
	GTRACE("GNC::HerramientaWindowLevel::Resetear()");
	if (m_pPanelTags != NULL) {
		if (!IsVisible()) {
			if (m_pVistaActiva != NULL) {
				m_pPanelTags->SetEstudio(m_pVistaActiva->GetEstudio());
			} else {
				m_pPanelTags->SetEstudio(NULL);
			}
		}
		m_pPanelTags->MostrarOcultarPanelTags();
	}
}

void GNC::HerramientaPanelTags::ConectarContratoFalso(bool ) {
	if (TContratablePanelTags::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
	
}

void GNC::HerramientaPanelTags::SetVistaActiva(GNC::GCS::IVista* pVista) {
	//se desconecta de los eventos de la vista anterior y se conecta a esta...
	if (m_pVistaActiva != NULL)
	{
		GNC::GCS::Eventos::EventoModificacionImagen evt(m_pVistaActiva);
		GNC::GCS::ControladorEventos::Instance()->DesRegistrar(this,evt);
	}

	TContratablePanelTags::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaReset::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");

	if (m_pPanelTags != NULL) {
		if (m_pVistaActiva != NULL)
		{
			GNC::GCS::Eventos::EventoModificacionImagen evt(m_pVistaActiva);
			GNC::GCS::ControladorEventos::Instance()->Registrar(this,evt);
		}

		if (pVista != NULL && IsVisible()) {
			m_pPanelTags->SetEstudio(pVista->GetEstudio());
		} else {
			m_pPanelTags->SetEstudio(NULL);
		}
	}

}

void GNC::HerramientaPanelTags::ConectarContratos(bool )
{
	if (TContratablePanelTags::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	
}

//endregion

void GNC::HerramientaPanelTags::SetVentanaTags(GNC::GCS::IPanelHerramientaTags* pWindow)
{
	m_pPanelTags = pWindow;
}


void GNC::HerramientaPanelTags::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
{
	if ( evt->GetCodigoEvento() == ginkgoEVT_Core_ModificacionImagen) {
		GNC::GCS::Eventos::EventoModificacionImagen* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionImagen*>(evt);
		if (pEvt->GetTipo() == GNC::GCS::Eventos::EventoModificacionImagen::SliceCambiado || pEvt->GetTipo() == GNC::GCS::Eventos::EventoModificacionImagen::ImagenCargada) {
			if (m_pPanelTags != NULL) {
				if (IsVisible()) {
					if (m_pVistaActiva != NULL) {
						m_pPanelTags->SetEstudio(m_pVistaActiva->GetEstudio());
					} else {
						m_pPanelTags->SetEstudio(NULL);
					}
				}
			}
		}
	}
}


