/*
 *  
 *  $Id: herramientanota.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/iwidgetsmanager.h>
#include "herramientanota.h"
#include <widgets/wnota.h>
#include <api/internacionalizacion.h>

#include <resources/ginkgoresourcemanager.h>

#include <iostream>

#include <wx/dc.h>
#include <wx/dcclient.h>
#include <wx/dcscreen.h>
#include <wx/brush.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>
#include <wx/xml/xml.h>

GNC::HerramientaNota::HerramientaNota()
{
	m_Activa = false;
	m_pNotaBuilder = NULL;
	m_pAbstractPanelHerramientaOpciones = NULL;

	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoAnotacion();
	m_Descripcion = _Std("Text Note");
}

GNC::HerramientaNota::~HerramientaNota()
{
}


wxXmlNode* GNC::HerramientaNota::Serializar(GNC::GCS::IVista* pVista, long vid, const std::string nombreMedicoSerializa)
{
	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	//se cogen todas los widgets anotacion de los contratos con ese vid
	GNC::GCS::ListaWidgets listaWidgets;
	for (ICConcreto::IteradorMapaContratos it = ICConcreto::m_Contratos.begin(); it != ICConcreto::m_Contratos.end(); it++) {
		if((*it).first == pVista){
			for (ICConcreto::IteradorListaContratos it2 = (*it).second->begin(); it2 != (*it).second->end(); it2++) {
				GNC::GCS::IContratoWidgets* pC = (*it2);
				GNC::GCS::ListaWidgets listaWidgetsTmp;
				pC->GetManager()->GetListaWidgetsSubVista(vid, listaWidgetsTmp);
				listaWidgets.splice(listaWidgets.begin(),listaWidgetsTmp);
			}
		}
	}

	wxXmlNode* resultado = NULL;
	if(listaWidgets.size()>0){
		resultado = new wxXmlNode(NULL,wxXML_ELEMENT_NODE,wxT("annotation"));
		resultado->AddProperty(wxT("id"),wxString::Format(wxT("%d"),this->ID));
		for (GNC::GCS::IWidgetsManager::IteradorListaWidgets it = listaWidgets.begin();  it!= listaWidgets.end(); it++){
			GNC::GCS::Widgets::WCajaTexto* pTexto = dynamic_cast<GNC::GCS::Widgets::WCajaTexto*>((*it));
			if( pTexto != NULL){
				resultado->AddChild(pTexto->Serializar(nombreMedicoSerializa));
			}
		}
	}
	return resultado;
}

void GNC::HerramientaNota::Deserializar(GNC::GCS::IVista* pVista, long vid, wxXmlNode* nodo)
{
	if(nodo->GetPropVal(wxT("id"),wxT("")) != wxString::Format(wxT("%d"),this->ID)){
		std::cerr<< "Ha ocurrido un error al desserializar la herramienta nota"<<std::endl;
	}

	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;

	for (ICConcreto::IteradorMapaContratos it = ICConcreto::m_Contratos.begin(); it != ICConcreto::m_Contratos.end(); it++) {
		if((*it).first == pVista){

			for (ICConcreto::IteradorListaContratos it2 = (*it).second->begin(); it2 != (*it).second->end(); it2++) {
				GNC::GCS::IContratoWidgets* pC = (*it2);

				GNC::GCS::ListaWidgets listaWidgets;

				wxXmlNode *child = nodo->GetChildren();
				while (child) {
					GNC::GCS::Widgets::WCajaTexto* pWidget = new GNC::GCS::Widgets::WCajaTexto(pC->GetManager(), vid, child);
					listaWidgets.push_back(pWidget);
					child = child->GetNext();
				}

				for (GNC::GCS::IWidgetsManager::IteradorListaWidgets itWidgets = listaWidgets.begin();  itWidgets!= listaWidgets.end(); itWidgets++){
					pC->GetManager()->InsertarWidget((*itWidgets),false);
				}
			}
		}
	}
}

//region "Realizaci�n de la interfaz IHerramienta"

void GNC::HerramientaNota::CrearPaneles( wxPanel* /*panel*/ )
{
	m_pAbstractPanelHerramientaOpciones = NULL;
}

void GNC::HerramientaNota::ConectarContratoFalso(bool activar) {
	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	if (ICConcreto::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (ICConcreto::IteradorListaContratos it = ICConcreto::m_pListaActiva->begin(); it != ICConcreto::m_pListaActiva->end(); it++) {
		GNC::GCS::IContratoWidgets* pC = (*it);
		if (activar) {
			pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
			pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			pC->GetManager()->Render();
			GTRACE("HerramientaNota: Conectando contrato falso de vista " << ICConcreto::m_pVistaActiva);
		}
		else {
			pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
			pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			GTRACE("HerramientaNota: Desconectando contrato falso de vista " << ICConcreto::m_pVistaActiva);
		}
	}
}

void GNC::HerramientaNota::SetVistaActiva(GNC::GCS::IVista* pVista) {
	GNC::GCS::IContratable<GNC::GCS::IContratoWidgets>::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaNota::SetVistaActiva(" <<  pVista << ")");
}

void GNC::HerramientaNota::ConectarContratos(bool activar)
{
	typedef  GNC::GCS::IContratable<GNC::GCS::IContratoWidgets> ICConcreto;
	if (ICConcreto::m_pListaActiva == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pNotaBuilder != NULL) {
				delete m_pNotaBuilder;
				m_pNotaBuilder = NULL;
			}
		}
		return;
	}

	for (ICConcreto::IteradorListaContratos it = ICConcreto::m_pListaActiva->begin(); it != ICConcreto::m_pListaActiva->end(); it++) {
		GNC::GCS::IContratoWidgets* pC = (*it);
		if (activar) {
			GTRACE("HerramientaNota: Conectando contratos de vista " << ICConcreto::m_pVistaActiva);
			m_pNotaBuilder = new GNC::GCS::Widgets::WNotaBuilder(pC->GetManager());
			pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
			pC->GetManager()->SetCursor(m_pNotaBuilder->GetCursor());
			pC->GetManager()->Render();
		}
		else {
			GTRACE( "HerramientaNota: Desconectando contratos de vista " << ICConcreto::m_pVistaActiva );
			if (m_pNotaBuilder != NULL) {
				delete m_pNotaBuilder;
				m_pNotaBuilder = NULL;
			}
			pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
			pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
		}
	}
}

//endregion

//region "Eventos refinados desde los paneles"

//endregion
