/*
 *  
 *  $Id: herramientalupa.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <api/globals.h>
#include <wx/wx.h>
#include <wx/aui/aui.h>

#include "herramientalupa.h"
#include <api/ievento.h>
#include <api/iwidgetsmanager.h>
#include <eventos/eventosginkgo.h>
#include <api/inotificadoresherramientas.h>
#include <resources/ginkgoresourcemanager.h>
#include <main/controllers/controladoreventos.h>
#include <api/internacionalizacion.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtk/vtkginkgoimageviewer.h>
#include <vtkImageData.h>
#include <vtkPointData.h>
#include <vtkImageActor.h>
#include <vtkImageData.h>
#include <vtkRenderWindowInteractor.h>
#include <vtkSmartPointer.h>
#include <vtkObject.h>
#include <vtkLookupTable.h>
#include <vtkRenderWindow.h>
#include <vtkRenderer.h>

#define SELECCION_ZOOM_IN  1231
#define SELECCION_ZOOM_OUT 1232

namespace GNC {
	namespace GUI {

		class HerramientaOpcionesLupaGUI : public AUI_NAMESPACE wxAuiToolBar {
		public:
			HerramientaOpcionesLupaGUI(wxWindow* pParent, GNC::HerramientaLupa* pHerramienta): AUI_NAMESPACE wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize)
			{
				m_pHerramienta=pHerramienta;

				SetToolBitmapSize( wxSize( 16,16 ) );

				AddTool( SELECCION_ZOOM_IN, _("Zoom +"), GinkgoResourcesManager::BarraLupa::GetIcoZoomIn(), _("Zoom +"), wxITEM_CHECK );
				ToggleTool(SELECCION_ZOOM_IN,true);
				AddTool( SELECCION_ZOOM_OUT, _("Zoom -"), GinkgoResourcesManager::BarraLupa::GetIcoZoomOut(), _("Zoom -"), wxITEM_CHECK  );

				Realize();

				Layout();

				// Connect Events
				this->Connect( SELECCION_ZOOM_IN, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesLupaGUI::OnZoomInClick ) );
				this->Connect( SELECCION_ZOOM_OUT, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesLupaGUI::OnZoomOutClick ) );
			}

			~HerramientaOpcionesLupaGUI(){
				// Disconnect Events
				this->Disconnect( SELECCION_ZOOM_IN, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesLupaGUI::OnZoomInClick ) );
				this->Disconnect( SELECCION_ZOOM_OUT, wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( HerramientaOpcionesLupaGUI::OnZoomOutClick ) );
			}

			virtual void OnZoomInClick( wxCommandEvent& event ){
				m_pHerramienta->SetModo(MZ_In);
				ToggleTool(SELECCION_ZOOM_IN,true);
				ToggleTool(SELECCION_ZOOM_OUT,false);
				event.Skip(false);
			}

			virtual void OnZoomOutClick( wxCommandEvent& event ){
				m_pHerramienta->SetModo(MZ_Out);
				ToggleTool(SELECCION_ZOOM_IN,false);
				ToggleTool(SELECCION_ZOOM_OUT,true);
				event.Skip(false);
			}

			virtual ModoZoom GetModoActivo() {
				if (GetToolToggled(SELECCION_ZOOM_IN)) {
					return MZ_In;
				}
				else {
					return MZ_Out;
				}
			}

			GNC::HerramientaLupa* m_pHerramienta;
		};
	}
}

//----------------------------------------------------------------------

GNC::HerramientaLupa::HerramientaLupa()
{
	m_Descripcion = _Std("Magnifying glass");
	m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoZoom();
}

GNC::HerramientaLupa::~HerramientaLupa()
{
	if (m_pAbstractPanelHerramientaOpciones != NULL) {
		m_pAbstractPanelHerramientaOpciones->Destroy();
		m_pAbstractPanelHerramientaOpciones = NULL;
	}
}

// Eventos refinados desde los paneles
void GNC::HerramientaLupa::SetModo(ModoZoom modo)
{
	if (modo == MZ_In) {
		m_pLupaBuilder->SetModo(GNC::GCS::Widgets::ML_Aumentar);
	}
	else {
		m_pLupaBuilder->SetModo(GNC::GCS::Widgets::ML_Disminuir);
	}
}

//region "Realizaci�n de la interfaz IHerramienta"

void GNC::HerramientaLupa::CrearPaneles( wxPanel* /*panel*/ )
{
	//m_pAbstractPanelHerramientaOpciones = new GNC::GUI::HerramientaOpcionesLupaGUI(pParent,this);
	m_pAbstractPanelHerramientaOpciones = NULL;
}

void GNC::HerramientaLupa::ConectarContratoFalso(bool activar) {
	if (TContratableWidgets::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}

	for (TContratableWidgets::IteradorListaContratos it = TContratableWidgets::m_pListaActiva->begin(); it != TContratableWidgets::m_pListaActiva->end(); it++) {
		TContratoWidgets* pC = (*it);
		if (pC->Inicializado()) {
			if (activar) {
				GTRACE( "HerramientaLupa: Conectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
				pC->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
				pC->GetManager()->Render();
			}
			else {
				GTRACE( "HerramientaLupa: Desconectando contrato falso de vista " << TContratableWidgets::m_pVistaActiva );
				pC->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}
}

void GNC::HerramientaLupa::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableWidgets::EstablecerVistaActiva(pVista);
	GTRACE("GNC::TContratableLupa::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaLupa::ConectarContratos(bool activar)
{
	if (TContratableWidgets::m_pListaActiva == NULL) {
		if (activar) {
			std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		} else {
			if (m_pLupaBuilder != NULL) {
				delete m_pLupaBuilder;
				m_pLupaBuilder = NULL;
			}
		}
		return;
	}

	// Recorrido de los contratos.
	TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin();
	for ( ; it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
		TContratoWidgets* pCW = (*it1);
		if (pCW->Inicializado()) {
			if (activar) {
				GTRACE("HerramientaLupa: Conectando contratos de vista " << pCW->m_pVista);
				// Subscribimos los eventos de la ventana a un metodo especifico del panel de esta herramienta
				GNC::GCS::Widgets::ModoLupa modo = GNC::GCS::Widgets::ML_Aumentar;
				/*if (((GNC::GUI::HerramientaOpcionesLupaGUI*)(m_pAbstractPanelHerramientaOpciones))->GetModoActivo() == MZ_Out) {
					modo = GNC::GCS::Widgets::ML_Disminuir;
				}*/
				// Usamos de Id de grupo el valor del puntero de la herramienta, que es unico y no cambia
				m_pLupaBuilder = new GNC::GCS::Widgets::WLupaBuilder(pCW->GetManager(), modo, (unsigned long)this);
				//m_pLupaBuilder->SetObservador(this);
				pCW->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pCW->GetManager()->SetCursor(m_pLupaBuilder->GetCursor());
				pCW->GetManager()->Render();
			}
			else {
				GTRACE( "HerramientaLupa: Desconectando contratos de vista " << pCW->m_pVista );
				if (m_pLupaBuilder != NULL) {
					delete m_pLupaBuilder;
					m_pLupaBuilder = NULL;
				}
				pCW->GetViewer()->SetInteractionStyle(vtkGinkgoImageViewer::ZOOM_INTERACTION);
				pCW->GetManager()->SetCursor(GNC::GCS::Widgets::CUR_FLECHA);
			}
		}
	}

	if (activar) {
		GNC::GCS::Eventos::EventoModificacionImagen evt1(TContratableWidgets::m_pVistaActiva);
		GNC::GCS::ControladorEventos::Instance()->Registrar(this, evt1);
	} else {
		GNC::GCS::Eventos::EventoModificacionImagen evt1(TContratableWidgets::m_pVistaActiva);
		GNC::GCS::ControladorEventos::Instance()->DesRegistrar(this,evt1);
	}
}

//endregion

//region Interfaz de eventos ginkgo

void GNC::HerramientaLupa::PreProcesarEvento(GNC::GCS::Eventos::IEvento* /*evt*/, GNC::GCS::IControladorEventos::TipoListaPunterosEventos& /*lista*/)
{

}

void GNC::HerramientaLupa::ProcesarEvento(GNC::GCS::Eventos::IEvento *evt)
{
	if (evt == NULL) {
		std::cerr << "Error: Evento nulo" << std::endl;
		return;
	}
	switch (evt->GetCodigoEvento()) {
		case ginkgoEVT_Core_ModificacionImagen:
			{
				GNC::GCS::Eventos::EventoModificacionImagen* pEvt = dynamic_cast<GNC::GCS::Eventos::EventoModificacionImagen*>(evt);
				if (pEvt != NULL && pEvt->GetTipo() == GNC::GCS::Eventos::EventoModificacionImagen::ImagenRecalibrada) {
					//si hay recalibrado y esta activa la herramienta volvemos a configurarla
					if(m_Activa){
						if (TContratableWidgets::m_pListaActiva == NULL) {
							return;
						}

						// Recorrido de los contratos.
						TContratableWidgets::IteradorListaContratos it1 = TContratableWidgets::m_pListaActiva->begin();
						for ( ; it1 != TContratableWidgets::m_pListaActiva->end(); it1++) {
							//TContratoWidgets* pCW = (*it1);
							//m_pLupaBuilder->SetImageData(pCW->GetViewer()->GetImageActor()->GetInput());
						}
					}
				}
			}
			break;
		default:
			break;
	}
}

//endregion

