/*
 *  
 *  $Id: herramientalayoutventana.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <wx/menu.h>
#include <api/globals.h>
#include "herramientalayoutventana.h"
#include <api/internacionalizacion.h>
#include <api/icontextoestudio.h>

#include <resources/ginkgoresourcemanager.h>

#define ADD_FILA  1601
#define ADD_COL	1602
#define DEL_FILA  1603
#define DEL_COL	1604

#define LAY_1_1	1605
#define LAY_1_2	1606
#define LAY_2_1	1607
#define LAY_2_2	1608
#define LAY_3_3	1609
#define LAY_4_4	1610

//layouts por defecto...
namespace GNC {
	namespace GUI {
	class MenuHerramientaLayoutVentana : public wxMenu {
			public:
			MenuHerramientaLayoutVentana(wxWindow* pParent, GNC::HerramientaLayoutVentana* pHerramienta):wxMenu() {
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;

				wxMenuItem* addCol = new wxMenuItem(this,ADD_COL,_("Add Column"),_("Add a column"));
				wxMenuItem* addFila = new wxMenuItem(this,ADD_FILA,_("Add Row"),_("Add a Row"));
				wxMenuItem* delCol = new wxMenuItem(this,DEL_COL,_("Remove Column"),_("Deleting a Column"));
				wxMenuItem* delFila = new wxMenuItem(this,DEL_FILA,_("Remove Row"),_("Deleting a Row"));

				wxMenuItem* lay1x1 = new wxMenuItem(this,LAY_1_1,_("1x1"),_("1x1 Layout"));
				wxMenuItem* lay1x2= new wxMenuItem(this,LAY_1_2,_("1x2"),_("1x2 Layout"));
				wxMenuItem* lay2x1 = new wxMenuItem(this,LAY_2_1,_("2x1"),_("2x1 Layout"));
				wxMenuItem* lay2x2 = new wxMenuItem(this,LAY_2_2,_("2X2"),_("2x2 Layout"));
				wxMenuItem* lay3x3 = new wxMenuItem(this,LAY_3_3,_("3x3"),_("3x3 Layout"));
				wxMenuItem* lay4x4 = new wxMenuItem(this,LAY_4_4,_("4x4"),_("4x4 Layout"));
				
				#ifdef __WXMSW__
					addCol->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoAddColumna());
					addFila->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoAddFila());
					delCol->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoDelColumna());
					delFila->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoDelFila());
					lay1x1->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoLayout1x1());
					lay1x2->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoLayout1x2());
					lay2x1->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoLayout2x1());
					lay2x2->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoLayout2x2());
					lay3x3->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoLayout3x3());
					lay4x4->SetBitmaps(GinkgoResourcesManager::BarraLayout::GetIcoLayout4x4());
				#else
					addCol->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoAddColumna());
					addFila->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoAddFila());
					delCol->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoDelColumna());
					delFila->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoDelFila());
					lay1x1->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoLayout1x1());
					lay1x2->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoLayout1x2());
					lay2x1->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoLayout2x1());
					lay2x2->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoLayout2x2());
					lay3x3->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoLayout3x3());
					lay4x4->SetBitmap(GinkgoResourcesManager::BarraLayout::GetIcoLayout4x4());
				#endif					

				Append(addCol);
				Append(addFila);
				AppendSeparator();
				Append(delCol);
				Append(delFila);

				AppendSeparator();

				Append(lay1x1);
				Append(lay1x2);
				Append(lay2x1);
				Append(lay2x2);
				Append(lay3x3);
				Append(lay4x4);

				m_pParent->Connect(addCol->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnAddColumna),NULL,this);
				m_pParent->Connect(addFila->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnAddFila),NULL,this);
				m_pParent->Connect(delCol->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnDelColumna),NULL,this);
				m_pParent->Connect(delFila->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnDelFila),NULL,this);

				m_pParent->Connect(lay1x1->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay1x1),NULL,this);
				m_pParent->Connect(lay1x2->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay1x2),NULL,this);
				m_pParent->Connect(lay2x1->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay2x1),NULL,this);
				m_pParent->Connect(lay2x2->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay2x2),NULL,this);
				m_pParent->Connect(lay3x3->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay3x3),NULL,this);
				m_pParent->Connect(lay4x4->GetId(),wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay4x4),NULL,this);

				m_pParent->Connect(addCol->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnAddColumnaUpdate),NULL,this);
				m_pParent->Connect(addFila->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnAddFilaUpdate),NULL,this);
				m_pParent->Connect(delCol->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnDelColumnaUpdate),NULL,this);
				m_pParent->Connect(delFila->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnDelFilaUpdate),NULL,this);

				m_pParent->Connect(lay1x1->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay1x1Update),NULL,this);
				m_pParent->Connect(lay1x2->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay1x2Update),NULL,this);
				m_pParent->Connect(lay2x1->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay2x1Update),NULL,this);
				m_pParent->Connect(lay2x2->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay2x2Update),NULL,this);
				m_pParent->Connect(lay3x3->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay3x3Update),NULL,this);
				m_pParent->Connect(lay4x4->GetId(), wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay4x4Update),NULL,this);

				m_pParent->Connect(m_pHerramienta->ID, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnUpdateMenuLayout),NULL,this);
			}

			~MenuHerramientaLayoutVentana() {
				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnAddColumna),NULL,this);
				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnAddFila),NULL,this);
				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnDelColumna),NULL,this);
				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnDelFila),NULL,this);

				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay1x1),NULL,this);
				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay1x2),NULL,this);
				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay2x1),NULL,this);
				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay2x2),NULL,this);
				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay3x3),NULL,this);
				m_pParent->Disconnect(wxID_ANY,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( MenuHerramientaLayoutVentana::OnLay4x4),NULL,this);

				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnAddColumnaUpdate),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnAddFilaUpdate),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnDelColumnaUpdate),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnDelFilaUpdate),NULL,this);
				
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay1x1Update),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay1x2Update),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay2x1Update),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay2x2Update),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay3x3Update),NULL,this);
				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnLay4x4Update),NULL,this);

				m_pParent->Disconnect(wxID_ANY, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(MenuHerramientaLayoutVentana::OnUpdateMenuLayout),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnAddFila(wxCommandEvent& )
			{
				m_pHerramienta->AddFila();
			}

			void OnAddColumna(wxCommandEvent& )
			{
				m_pHerramienta->AddColumna();
			}

			void OnDelFila(wxCommandEvent& )
			{
				m_pHerramienta->DelFila();
			}

			void OnDelColumna(wxCommandEvent& )
			{
				m_pHerramienta->DelColumna();
			}
			
			void OnLay1x1(wxCommandEvent& )
			{
				m_pHerramienta->SetLayoutVentana(1,1);
			}

			void OnLay1x2(wxCommandEvent& )
			{
				m_pHerramienta->SetLayoutVentana(1,2);
			}

			void OnLay2x1(wxCommandEvent& )
			{
				m_pHerramienta->SetLayoutVentana(2,1);
			}

			void OnLay2x2(wxCommandEvent& )
			{
				m_pHerramienta->SetLayoutVentana(2,2);
			}

			void OnLay3x3(wxCommandEvent& )
			{
				m_pHerramienta->SetLayoutVentana(3,3);
			}

			void OnLay4x4(wxCommandEvent& )
			{
				m_pHerramienta->SetLayoutVentana(4,4);
			}

			void OnAddColumnaUpdate(wxUpdateUIEvent& event) 
			{
				event.Enable(m_pHerramienta->PuedeAgregar());
			}

			void OnAddFilaUpdate(wxUpdateUIEvent& event) 
			{
				
				event.Enable(m_pHerramienta->PuedeAgregar());
			}

			void OnDelColumnaUpdate(wxUpdateUIEvent& event) 
			{
				
				event.Enable(m_pHerramienta->PuedeEliminarColumna());
			}

			void OnDelFilaUpdate(wxUpdateUIEvent& event) 
			{
				
				event.Enable(m_pHerramienta->PuedeEliminarFila());
			}

			void OnLay1x1Update(wxUpdateUIEvent& event) 
			{	
				event.Enable(m_pHerramienta->Soporta(1,1));
			}

			void OnLay1x2Update(wxUpdateUIEvent& event) 
			{	
				event.Enable(m_pHerramienta->Soporta(1,2));
			}

			void OnLay2x1Update(wxUpdateUIEvent& event) 
			{	
				event.Enable(m_pHerramienta->Soporta(2,1));
			}

			void OnLay2x2Update(wxUpdateUIEvent& event) 
			{	
				event.Enable(m_pHerramienta->Soporta(2,2));
			}

			void OnLay3x3Update(wxUpdateUIEvent& event) 
			{	
				event.Enable(m_pHerramienta->Soporta(3,3));
			}

			void OnLay4x4Update(wxUpdateUIEvent& event) 
			{	
				event.Enable(m_pHerramienta->Soporta(4,4));
			}

			void OnUpdateMenuLayout(wxUpdateUIEvent& event) 
			{
				event.Enable(m_pHerramienta->Habilitada());
			}

			GNC::HerramientaLayoutVentana* m_pHerramienta;
			wxWindow* m_pParent;
		};
	}
}

//----------------------------------------------------------------------

GNC::HerramientaLayoutVentana::HerramientaLayoutVentana()
{
	m_Descripcion = _Std("Window Layout");
	m_IsMenu = true;
	//m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoMostrarOcultarTags();
}

GNC::HerramientaLayoutVentana::~HerramientaLayoutVentana()
{
}

bool GNC::HerramientaLayoutVentana::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	wxMenu* pMenu = new GNC::GUI::MenuHerramientaLayoutVentana(pParent,this);	
	pMenuParent->Append(ID,wxString::FromUTF8(m_Descripcion.c_str()), pMenu);
	return true;
}

wxMenu* GNC::HerramientaLayoutVentana::GetMenu(wxWindow* pParent)
{
	return new GNC::GUI::MenuHerramientaLayoutVentana(pParent,this);
}

//region "Realizaci�n de la interfaz IHerramienta"

void GNC::HerramientaLayoutVentana::CrearPaneles( wxPanel* /*panel*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

void GNC::HerramientaLayoutVentana::SetLayoutVentana(int filas, int columnas)
{
	if(Habilitada()){
		for (TContratableLayoutVentana::IteradorListaContratos it1 = TContratableLayoutVentana::m_pListaActiva->begin(); it1 != TContratableLayoutVentana::m_pListaActiva->end(); it1++) {
			GNC::GCS::IContratoLayoutVentana* pC = (*it1);
			pC->SetLayoutVentana(filas,columnas);
		}
	}
}

void GNC::HerramientaLayoutVentana::AddFila()
{
	if(Habilitada()){
		for (TContratableLayoutVentana::IteradorListaContratos it1 = TContratableLayoutVentana::m_pListaActiva->begin(); it1 != TContratableLayoutVentana::m_pListaActiva->end(); it1++) {
			GNC::GCS::IContratoLayoutVentana* pC = (*it1);
			int filas = pC->GetFilas()+1;
			int columnas = pC->GetColumnas();
			pC->SetLayoutVentana(filas,columnas);
		}
	}
}

void GNC::HerramientaLayoutVentana::AddColumna()
{
	if(Habilitada()){
		for (TContratableLayoutVentana::IteradorListaContratos it1 = TContratableLayoutVentana::m_pListaActiva->begin(); it1 != TContratableLayoutVentana::m_pListaActiva->end(); it1++) {
			GNC::GCS::IContratoLayoutVentana* pC = (*it1);
			int filas = pC->GetFilas();
			int columnas = pC->GetColumnas()+1;
			pC->SetLayoutVentana(filas,columnas);
		}
	}
}

void GNC::HerramientaLayoutVentana::DelFila()
{
	if(Habilitada()){
		for (TContratableLayoutVentana::IteradorListaContratos it1 = TContratableLayoutVentana::m_pListaActiva->begin(); it1 != TContratableLayoutVentana::m_pListaActiva->end(); it1++) {
			GNC::GCS::IContratoLayoutVentana* pC = (*it1);
			int filas = pC->GetFilas()-1;
			int columnas = pC->GetColumnas();
			pC->SetLayoutVentana(filas,columnas);
		}
	}
}

void GNC::HerramientaLayoutVentana::DelColumna()
{
	if(Habilitada()){
		for (TContratableLayoutVentana::IteradorListaContratos it1 = TContratableLayoutVentana::m_pListaActiva->begin(); it1 != TContratableLayoutVentana::m_pListaActiva->end(); it1++) {
			GNC::GCS::IContratoLayoutVentana* pC = (*it1);
			int filas = pC->GetFilas();
			int columnas = pC->GetColumnas()-1;
			pC->SetLayoutVentana(filas,columnas);
		}
	}
}

bool GNC::HerramientaLayoutVentana::PuedeAgregar()
{
	if(Habilitada()){
		for (TContratableLayoutVentana::IteradorListaContratos it1 = TContratableLayoutVentana::m_pListaActiva->begin(); it1 != TContratableLayoutVentana::m_pListaActiva->end(); it1++) {
			GNC::GCS::IContratoLayoutVentana* pC = (*it1);
			if( pC->GetFilas() * pC->GetColumnas() >= (pC->m_MaxSlice-pC->m_MinSlice +1))
			{
				return false;
			}
		}
		return true;
	} else {
		return false;
	}
}

bool GNC::HerramientaLayoutVentana::Soporta(int filas, int columnas)
{
	if(Habilitada()){
		for (TContratableLayoutVentana::IteradorListaContratos it1 = TContratableLayoutVentana::m_pListaActiva->begin(); it1 != TContratableLayoutVentana::m_pListaActiva->end(); it1++) {
			GNC::GCS::IContratoLayoutVentana* pC = (*it1);
			int zocalos = filas * columnas;
			int slices = pC->m_MaxSlice - pC->m_MinSlice +1;
			
			if(zocalos-slices  >= std::min(filas,columnas))
			{
				return false;
			}
		}
		return true;
	} else {
		return false;
	}
}

bool GNC::HerramientaLayoutVentana::PuedeEliminarFila()
{
	if(Habilitada()){
		for (TContratableLayoutVentana::IteradorListaContratos it1 = TContratableLayoutVentana::m_pListaActiva->begin(); it1 != TContratableLayoutVentana::m_pListaActiva->end(); it1++) {
			GNC::GCS::IContratoLayoutVentana* pC = (*it1);
			if( pC->GetFilas() <=1)
			{
				return false;
			}
		}
		return true;
	} else {
		return false;
	}
}
bool GNC::HerramientaLayoutVentana::PuedeEliminarColumna()
{
	if(Habilitada()){
		for (TContratableLayoutVentana::IteradorListaContratos it1 = TContratableLayoutVentana::m_pListaActiva->begin(); it1 != TContratableLayoutVentana::m_pListaActiva->end(); it1++) {
			GNC::GCS::IContratoLayoutVentana* pC = (*it1);
			if( pC->GetColumnas() <=1)
			{
				return false;
			}
		}
		return true;
	} else {
		return false;
	}
}

void GNC::HerramientaLayoutVentana::ConectarContratoFalso(bool ) {
	if (TContratableLayoutVentana::m_pListaActiva == NULL) {
		//std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
}

void GNC::HerramientaLayoutVentana::SetVistaActiva(GNC::GCS::IVista* pVista) {
	TContratableLayoutVentana::EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaReset::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaLayoutVentana::ConectarContratos(bool )
{
	if (TContratableLayoutVentana::m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
	
}

//endregion



