/*
 *  
 *  $Id: herramientaelevacion.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <export/iherramientaelevacion.h>
#include <widgets/welevacion.h>
#include <api/api.h>


namespace GNC {

	typedef enum TipoAccionElevacion {
		TAE_AUMENTAR,
		TAE_DISMINUIR
	} TipoAccionElevacion;

	class EXTAPI HerramientaElevacion : public GNC::GCS::IHerramientaElevacion, public GNC::GCS::Widgets::Elevacion::IObservadorElevacion {
	public:
		HerramientaElevacion();
		~HerramientaElevacion();

//region "Realización de la interfaz IHerramienta"
		// Setup de paneles
		virtual void CrearPaneles( wxPanel* panel );

//endregion

		virtual void ConectarContratoFalso(bool activar);
		virtual void SetVistaActiva(GNC::GCS::IVista* pVista);
		virtual void ConectarContratos(bool activar);

//region "metodos propios de la herramienta de elevacion"

		void OnPuntoInsertado(float x, float y) ;

		void OnTerminarInsertar() ;

		void AjustarSensibilidad(float valorNormalizado);

		void AjustarRadio(float valor);

		void SetTipoAccion(GNC::TipoAccionElevacion tipoAccion);

//endregion

//region "Eventos refinados desde los paneles"

//endregion

	protected:
		GNC::GCS::Widgets::WElevacionBuilder*               m_pElevacionBuilder;
		GNC::GCS::Widgets::Elevacion::ListaRepresentaciones m_RepresentacionesElevacion;

		typedef std::list<GNC::GCS::Vector>           TipoPuntosInsertados;
		typedef std::list<GNC::GCS::Vector>::iterator TipoIteradorPuntosInsertados;

		TipoPuntosInsertados     m_PuntosInsertados;
		GNC::TipoAccionElevacion m_TipoAccion;

		float m_sensibilidad;
		float m_radio;

	};
}
