/*
 *  
 *  $Id: herramientadeshacer.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <wx/menu.h>
#include <resources/ginkgoresourcemanager.h>
#include <main/entorno.h>
#include <api/globals.h>
#include <main/controllers/controladoracciones.h>
#include <api/internacionalizacion.h>
#include <api/icontextoestudio.h>

#include "herramientadeshacer.h"


//----------------------------------------------------------------------
#define ID_DESHACER  1721
#define ID_REHACER   1722

namespace GNC {
	namespace GUI {
		class EventHandlerDeshacer: public wxEvtHandler {
		public:
			EventHandlerDeshacer(wxWindow* pParent, GNC::HerramientaDeshacer* pHerramienta):wxEvtHandler()
			{
				m_pParent = pParent;
				m_pHerramienta=pHerramienta;
				m_pParent->Connect(ID_DESHACER, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerDeshacer::OnDeshacer),NULL,this);
				m_pParent->Connect(ID_DESHACER, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerDeshacer::OnUpdateDeshacerUI),NULL,this);
				m_pParent->Connect(ID_REHACER, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerDeshacer::OnRehacer),NULL,this);
				m_pParent->Connect(ID_REHACER, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerDeshacer::OnUpdateRehacerUI),NULL,this);
			}
			~EventHandlerDeshacer()
			{
				m_pParent->Disconnect(ID_DESHACER, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerDeshacer::OnDeshacer),NULL,this);
				m_pParent->Disconnect(ID_DESHACER, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerDeshacer::OnUpdateDeshacerUI),NULL,this);
				m_pParent->Disconnect(ID_REHACER, wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( EventHandlerDeshacer::OnRehacer),NULL,this);
				m_pParent->Disconnect(ID_REHACER, wxEVT_UPDATE_UI, wxUpdateUIEventHandler(EventHandlerDeshacer::OnUpdateRehacerUI),NULL,this);
				m_pParent = NULL;
				m_pHerramienta = NULL;
			}

			void OnDeshacer(wxCommandEvent& event)
			{
				m_pHerramienta->Deshacer();
				event.Skip(false);
			}

			void OnUpdateDeshacerUI(wxUpdateUIEvent& event) {
				std::string titulo;
				event.Enable(m_pHerramienta->PuedeDeshacer(titulo));
				std::stringstream ss;
				ss << _Std("Undo") << titulo << "\tCtrl+z";
				event.SetText(wxString::FromUTF8(ss.str().c_str()));				
				event.Skip(false);
			}

			void OnRehacer(wxCommandEvent& event)
			{
				m_pHerramienta->Rehacer();
				event.Skip(false);
			}

			void OnUpdateRehacerUI(wxUpdateUIEvent& event) {
				std::string titulo;
				event.Enable(m_pHerramienta->PuedeRehacer(titulo));
				std::stringstream ss;
				ss << _Std("Redo ") << titulo << "\tCtrl+y";
				event.SetText(wxString::FromUTF8(ss.str().c_str()));
				event.Skip(false);
			}

			GNC::HerramientaDeshacer* m_pHerramienta;
			wxWindow* m_pParent;			
		};

		class MenuItemDeshacer : public wxMenuItem {
		public:
			MenuItemDeshacer(wxWindow* pParent, wxMenu* pMenuPadre, GNC::HerramientaDeshacer* pHerramienta):wxMenuItem(pMenuPadre,ID_DESHACER,_("Undo\tCtrl+z"),wxT("Undo"),wxITEM_NORMAL) {
				pEventHandler = new EventHandlerDeshacer(pParent,pHerramienta);	
#ifdef __WXMSW__
			//	SetBitmaps(GinkgoResourcesManager::IconosHerramientas::GetIcoMostrarOcultarTags());
#else
				//	SetBitmap(GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla());
#endif
			}

			~MenuItemDeshacer() 
			{
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerDeshacer* pEventHandler;
		};

		class MenuItemRehacer : public wxMenuItem {
		public:
			MenuItemRehacer(wxWindow* pParent, wxMenu* pMenuPadre, GNC::HerramientaDeshacer* pHerramienta):wxMenuItem(pMenuPadre,ID_REHACER,_("Redo\tCtrl+y"),_("Redo"),wxITEM_NORMAL) {
				pEventHandler = new EventHandlerDeshacer(pParent,pHerramienta);	
#ifdef __WXMSW__
			//	SetBitmaps(GinkgoResourcesManager::IconosHerramientas::GetIcoMostrarOcultarTags());
#else
				//	SetBitmap(GinkgoResourcesManager::BarraRejilla::GetIcoVerRejilla());
#endif
			}

			~MenuItemRehacer() 
			{
				if(pEventHandler != NULL) {
					delete pEventHandler;
					pEventHandler = NULL;
				}
			}

			EventHandlerDeshacer* pEventHandler;
		};
		
	}
}


GNC::HerramientaDeshacer::HerramientaDeshacer()
{
	m_Descripcion = _Std("Undo");
	m_IsMenu = true;
	//m_Icono = GinkgoResourcesManager::IconosHerramientas::GetIcoDesencajar();
}

GNC::HerramientaDeshacer::~HerramientaDeshacer()
{
}

bool GNC::HerramientaDeshacer::AppendInMenu(wxWindow* pParent, wxMenu* pMenuParent)
{
	pMenuParent->Append(new GNC::GUI::MenuItemDeshacer(pParent,pMenuParent,this));
	pMenuParent->Append(new GNC::GUI::MenuItemRehacer(pParent,pMenuParent,this));
	return true;
}

//region "Realización de la interfaz IHerramienta"

void GNC::HerramientaDeshacer::CrearPaneles( wxPanel* /*pParent*/ )
{
	m_pAbstractPanelHerramientaOpciones =  NULL;
}

void GNC::HerramientaDeshacer::SolicitarActivacion()
{
}
void GNC::HerramientaDeshacer::Deshacer()
{
	if(Habilitada()) {
		return GNC::GCS::ControladorAcciones::Instance()->Deshacer(m_pVistaActiva);
	}
}

void GNC::HerramientaDeshacer::Rehacer()
{
	if(Habilitada()) {
		return GNC::GCS::ControladorAcciones::Instance()->Hacer(m_pVistaActiva);
	}
}

bool GNC::HerramientaDeshacer::PuedeDeshacer(std::string& nombreAccion)
{
	if(Habilitada()) {
		return GNC::GCS::ControladorAcciones::Instance()->PuedeDeshacer(m_pVistaActiva,nombreAccion);
	} else {
		return false;
	}
}
bool GNC::HerramientaDeshacer::PuedeRehacer(std::string& nombreAccion)
{
	if(Habilitada()) {
		return GNC::GCS::ControladorAcciones::Instance()->PuedeHacer(m_pVistaActiva,nombreAccion);
	} else {
		return false;
	}	
}


void GNC::HerramientaDeshacer::ConectarContratoFalso(bool ) {
	if (m_pListaActiva == NULL) {
		std::cerr << "Error: Se trato de activar el modo deshabilitado de una vista sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
	
}

void GNC::HerramientaDeshacer::SetVistaActiva(GNC::GCS::IVista* pVista) {
	EstablecerVistaActiva(pVista);
	GTRACE("GNC::HerramientaDesencajar::EstablecerVistaActiva(pVista);::SetVistaActiva(" <<  pVista << ")");
}

// FIXME: Aviso!!!! para que funcione deben contratarse contratos pareados obligatorios y en el mismo orden
void GNC::HerramientaDeshacer::ConectarContratos(bool )
{
	if (m_pListaActiva == NULL) {
		std::cerr << "Error: Se trataron de conectar contratos sin haber asignado la vista activa. Error en la logica de activacion. Accion ignorada" << std::endl;
		return;
	}
	
}

//endregion


