/*
 *  
 *  $Id: selectfiles.cpp 3700 2011-04-15 07:34:44Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/datetime.h>
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/regex.h>
#include <wx/radiobox.h>
#include <wx/filename.h>
#include <wx/config.h>

#include <string>
//#define _GINKGO_TRACE
#include <api/globals.h>

#include "selectfiles.h"
#include <api/icontextoestudio.h>

#include <main/entorno.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <iostream>
#include <api/internacionalizacion.h>
#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladorvistas.h>
#include <api/icontextoestudio.h>
#include <main/controllers/dcmtk/dicomservers.h>
#include <main/gui/dicombrowsercomponent.h>
#include <commands/comandopacs.h>
#include <commands/comandomergediagnosticwithimage.h>

namespace GNC {
	namespace GUI {

		SelectFiles::SelectFiles(wxWindow* pParent, const TListUIDs& uids,IWizard* pWizard):SelectFilesBase(pParent),IPasoWizard(pWizard)
		{
			m_ListaServidoresPACS.clear();
			for (DicomServerHolder* sl = DicomServerList::Instance()->GetList(); sl != NULL; sl = sl->next) {
				m_ListaServidoresPACS.push_back(wxString::FromAscii(sl->server.ID.c_str()));
			}
			m_pPACSListaServidores->Clear();
			m_pPACSListaServidores->Append(m_ListaServidoresPACS);

			if(m_pPACSListaServidores->GetCount()>0){
				//se selecciona el pacs por defecto
				m_pPACSListaServidores->SetSelection(0);
				wxConfigBase * config = wxConfigBase::Get();
				//se actualiza el fichero de configuracion
				config->SetPath(wxT("/GinkgoCore/SubirPACS"));
				wxString pacsDefecto;
				config->Read(wxT("PACSDefecto"),&pacsDefecto,wxT(""));
				for (unsigned int i =0; i< m_pPACSListaServidores->GetCount(); ++i) {
					if (m_pPACSListaServidores->GetString(i) == pacsDefecto) {
						m_pPACSListaServidores->Select(i);
						break;
					}
				}
			} else {
			//	m_pPACSListaServidores->Show(false);
				m_pPACSListaServidores->AppendString(_("There is no any PACS configured"));
				m_pPACSListaServidores->SetSelection(0);
				m_pPACSListaServidores->Disable();
			}

			//first create IModeloDICOM of files stored in the repository
			{
				GNC::GCS::IControladorHistorial::ListaModelosSeries seriesList;
				GNC::GCS::ControladorHistorial::Instance()->GetAllModelosSerie(seriesList, uids);
				IModeloDicom model;
				for (GNC::GCS::IControladorHistorial::ListaModelosSeries::iterator it = seriesList.begin(); it != seriesList.end(); ++it)
				{
					std::string sex(&(*it).m_sexo,1);
					model.InsertarPaciente((*it).m_idPaciente, (*it).m_nombrePaciente, (*it).m_fechaNacimiento, sex);
					model.InsertarEstudio((*it).m_idPaciente, (*it).m_uidEstudio, "", (*it).m_descripcionEstudio, (*it).m_modalidad, (*it).m_fechaEstudio, (*it).m_horaEstudio, "");
					std::ostringstream numSlices;
					numSlices << (*it).m_numeroSlices;
						model.InsertarSerie((*it).m_uidEstudio, (*it).m_uidSerie, (*it).m_modalidad, (*it).m_fechaSerie, (*it).m_horaSerie, (*it).m_descripcionSerie, numSlices.str(), "");
				}
				m_pFileSelection->SetModel(model);
			}

			//get diagnostic models
			{
				GNC::GCS::IControladorHistorial::ListaModelosSeries seriesList;
				GNC::GCS::ControladorHistorial::Instance()->GetAllModelosSerieDiagnostico(seriesList, uids);
				IModeloDicom model;
				for (GNC::GCS::IControladorHistorial::ListaModelosSeries::iterator it = seriesList.begin(); it != seriesList.end(); ++it)
				{
					std::string sex(&(*it).m_sexo,1);
					model.InsertarPaciente((*it).m_idPaciente, (*it).m_nombrePaciente, (*it).m_fechaNacimiento, sex);
					model.InsertarEstudio((*it).m_idPaciente, (*it).m_uidEstudio, "", (*it).m_descripcionEstudio, (*it).m_modalidad, (*it).m_fechaEstudio, (*it).m_horaEstudio, "");
				}
				m_pFileSelection->SetDiagnosticModel(model);
			}
		}

		SelectFiles::~SelectFiles()
		{
		}

		std::string SelectFiles::GetServerSeleccionado()
		{
			if (!m_pPACSListaServidores->IsEnabled()) {
				return std::string("");
			}
			ssize_t selection = m_pPACSListaServidores->GetSelection();
			if (selection < 0 || selection >= (int) m_ListaServidoresPACS.Count()) {
				return std::string("");
			}
			std::string id = std::string(m_ListaServidoresPACS[selection].To8BitData());
			return id;
		}

		//region "Metodos heredados de Ipasowizard"

		void SelectFiles::Attach(wxSizer *sizer){
			Show(true);
			sizer->Add(this,10, wxEXPAND);
			this->GetParent()->Layout();
		}

		void SelectFiles::Detach(wxSizer *sizer){
			Hide();
			sizer->Detach(this);
			sizer->GetContainingWindow()->Layout();
		}

		std::string SelectFiles::GetTitle(){
			return _Std("Select the DICOM files you wish to upload");
		}

		std::string SelectFiles::GetSubTitle(){
			return "";
		}

		bool SelectFiles::Siguiente(){
			return true;
		}

		bool SelectFiles::Anterior(){
			return false;
		}

		bool SelectFiles::Cancelar(){
			return true;
		}

		bool SelectFiles::Validar(){
			if(GetServerSeleccionado()!=""){
				wxConfigBase * config = wxConfigBase::Get();
				//se actualiza el fichero de configuracion
				config->SetPath(wxT("/GinkgoCore/SubirPACS"));
				config->Write(wxT("PACSDefecto"),m_pPACSListaServidores->GetStringSelection());

				//adquirimos desde dicomdir
				std::list<std::string> seriesList = m_pFileSelection->GetSelectedUIDs(false); //series instances uids
				std::list<std::string> diagnosticList = m_pFileSelection->GetSelectedUIDs(true); //study instances uids

				//check if diagnostics are modified...
				if (diagnosticList.size() > 0) {
					std::list<std::string> modifiedDiagnosticsList;
					GNC::GCS::ControladorVistas::TipoListaVistas viewList = GNC::GCS::ControladorVistas::Instance()->GetVistas();
					for (GNC::GCS::ControladorVistas::TipoListaVistas::const_iterator it = viewList.begin(); it != viewList.end(); ++it) {
						if ((*it)->EstaModificada()) {
							modifiedDiagnosticsList.push_back((*it)->GetEstudio()->GetUIDEstudioDiagnostico());
						}
					}
					bool modified = false;
					for (std::list<std::string>::iterator itUpload = diagnosticList.begin(); itUpload != diagnosticList.end() && !modified; ++itUpload) {
						for (std::list<std::string>::iterator itModified = modifiedDiagnosticsList.begin(); itModified != modifiedDiagnosticsList.end(); ++itModified) {
							if ((*itUpload) == (*itModified)) {
								modified = true;
								break;
							}
						}
					}
					if (modified) {
						int answer = wxMessageBox(_("There are selected diagnostics with pending modifications\nDo you want to save it before uploading?"),_("Save"), wxYES_NO , this);
						if (answer == wxYES) {
							for (GNC::GCS::ControladorVistas::TipoListaVistas::const_iterator it = viewList.begin(); it != viewList.end(); ++it) {
								if ((*it)->EstaModificada()) {
									std::string uidDiagnosis = (*it)->GetEstudio()->GetUIDEstudioDiagnostico();
									for (std::list<std::string>::iterator itUpload = diagnosticList.begin(); itUpload != diagnosticList.end(); ++itUpload) {
										if ((*itUpload) == uidDiagnosis) {
											(*it)->Guardar();
											break;
										}
									}
								}
							}									
						}
					}
				}

				if(seriesList.size() == 0 && diagnosticList.size() == 0) {
					wxMessageBox(_("Select Series you want to upload"), _("Info"),
						wxOK | wxICON_INFORMATION, this);
					return false;
				} else {
					//upload series...
					if(seriesList.size() > 0)
					{
						for (std::list<std::string>::iterator it = seriesList.begin(); it != seriesList.end(); ++it) {
							std::vector<std::string> paths;
							GNC::GCS::IControladorHistorial::VectorPaths pathsSeries = GNC::GCS::ControladorHistorial::Instance()->GetPathsSerieOrdenados((*it));
							for (GNC::GCS::IControladorHistorial::VectorPaths::iterator itPaths = pathsSeries.begin(); itPaths != pathsSeries.end(); ++itPaths)
							{
								paths.push_back(*itPaths);
							}
							GADAPI::ComandoPACSParams * pParams = new GADAPI::ComandoPACSParams(GetServerSeleccionado(), paths, NULL);

							GADAPI::ComandoPACS * pCmd = new GADAPI::ComandoPACS(pParams);
							GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Uploading to the PACS ..."),pCmd, NULL);
						}											
					}
					//upload diagnostics
					if(diagnosticList.size() > 0)
					{
						for (std::list<std::string>::iterator it = diagnosticList.begin(); it != diagnosticList.end(); ++it) {
							GADAPI::ComandoMergeDiagnosticWithImageParams * pParams = new GADAPI::ComandoMergeDiagnosticWithImageParams(GetServerSeleccionado(), (*it));

							GADAPI::ComandoMergeDiagnosticWithImage * pCmd = new GADAPI::ComandoMergeDiagnosticWithImage(pParams);
							GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Creating new images ..."),pCmd, NULL);						
						}
					}
					return true;
				}

				/*	{
				std::vector<std::string> rutas;
				if(GetUploadOriginalImages()) {
				//original images
				rutas = m_pVista->GetRutasImagenes();

				GADAPI::ComandoPACSParams * pParams = new GADAPI::ComandoPACSParams(pSeleccionar->GetServerSeleccionado(), rutas, m_pVista->GetEstudio()->GetModeloIntegracion());

				GADAPI::ComandoPACS * pCmd = new GADAPI::ComandoPACS(pParams);
				GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Uploading to the PACS ..."),pCmd, NULL);
				} else {
				GADAPI::ComandoMergeDiagnosticWithImageParams * pParams = new GADAPI::ComandoMergeDiagnosticWithImageParams(pSeleccionar->GetServerSeleccionado(), m_pVista->GetEstudio());

				GADAPI::ComandoMergeDiagnosticWithImage * pCmd = new GADAPI::ComandoMergeDiagnosticWithImage(pParams);
				GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(_Std("Creating new images ..."),pCmd, m_pVista);
				}
				}*/

				return true;
			} else {
				wxMessageBox(_("Select a valid PACS server"), _("Info"),
					wxOK | wxICON_INFORMATION, this);
				return false;
			}
		}
		//endregion
	}
}
