/*
 *  
 *  $Id: ventanacontrollogs.cpp 3781 2011-04-27 10:13:05Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <main/controllers/log4cplus/guiappender.h>
#include <set>
#include <fstream>
#include <sstream>
#include <wx/wx.h>
#include <wx/log.h>
#include <wx/filedlg.h>
#include <wx/msgdlg.h>
#include <api/internacionalizacion.h>
#include "ventanacontrollogs.h"

#include <resources/ginkgoresourcemanager.h>
#define LOGGER "VentanaControlLogs"
#include <main/controllers/controladorlog.h>
#include <main/entorno.h>

IMPLEMENT_DYNAMIC_CLASS(LogAsyncEvent, wxEvent)

#define COL_FECHA           0
#define COL_NIVEL           1
#define COL_MENSAJE			2

namespace GNC {
	namespace GUI {

		VentanaControlLogs* VentanaControlLogs::m_pInstance = NULL;

		VentanaControlLogs* VentanaControlLogs::Instance()
		{
			if(m_pInstance == NULL) {
				m_pInstance = new VentanaControlLogs();
			}
			return m_pInstance;
		}

		void VentanaControlLogs::CerrarSiAbierta()
		{
			if(m_pInstance != NULL)
			{
				m_pInstance->Close(true);
				m_pInstance = NULL;
			}
		}

		void VentanaControlLogs::Refrescar()
		{
		}

		//region Interfaz ILogger

		void VentanaControlLogs::Append(const GNC::GCS::Logging::LogEvent& le)
		{
			LogAsyncEvent lae(le);
			this->AddPendingEvent(lae);
		}

		//endregion

		VentanaControlLogs::VentanaControlLogs() : VentanaControlLogsBase(NULL)
		{
			wxIcon icono;
			icono.CopyFromBitmap(GinkgoResourcesManager::Logos::GetLogoGinkgo32x32());
			this->SetIcon(icono);

			// Setup del treeList
			m_pMessages->AddRoot(wxT("Root"));
			m_pMessages->Connect(wxEVT_COMMAND_TREE_ITEM_MENU, wxTreeEventHandler( VentanaControlLogs::OnTreeItemMenu ), NULL, this);

			// Setup del combobox de niveles

			GNC::GCS::ControladorLog::Instance()->GetLogLevelsMap(m_MapaLogLevels);

			int i = 0;

			for (GNC::GCS::IControladorLog::MapaLogLevels::iterator it = m_MapaLogLevels.begin(); it != m_MapaLogLevels.end(); it++, i++)
			{
				m_pComboNivel->Insert(wxString::FromUTF8((*it).second.c_str()), 0);
			}

			// Setup del nivel actual

			wxString nivelActual = wxString::FromUTF8(m_MapaLogLevels[GNC::GCS::ControladorLog::Instance()->GetActiveLogLevel()].c_str());

			bool notfound = true;
			for (int i = 0; notfound && i < (int)m_pComboNivel->GetCount(); i++)
			{
				if (nivelActual == m_pComboNivel->GetString(i) ) {
					m_pComboNivel->Select(i);
					notfound = false;
				}
			}

			this->Connect(wxEVT_LOG_ASYNC, LogAsyncEventHandler(VentanaControlLogs::OnLogAsync), NULL, this);

			this->Connect( m_menuItemGuardar->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaControlLogs::OnGuardarRegistros ) );
			this->Connect( m_menuItemLimpiar->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaControlLogs::OnLimpiarClick ) );
            this->Connect( m_menuItemSalir->GetId(), wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler( VentanaControlLogs::OnSalirClick ) );

			Layout();

			gnkLog4cplus::GUIAppender::Instance()->Attach(this);

			Show();
		}

		VentanaControlLogs::~VentanaControlLogs()
		{
			m_pInstance = NULL;
			gnkLog4cplus::GUIAppender::Instance()->Attach(NULL);

		}

		void VentanaControlLogs::OnClose( wxCloseEvent& event )
		{
			this->Disconnect(wxEVT_LOG_ASYNC, LogAsyncEventHandler(VentanaControlLogs::OnLogAsync), NULL, this);
			gnkLog4cplus::GUIAppender::Instance()->Attach(NULL);

			event.Skip();
		}

		void VentanaControlLogs::OnLogAsync(LogAsyncEvent& event)
		{
			Freeze();
			m_pRegistros->AppendText(wxString::FromUTF8(event.LogEvent.formattedmsg.c_str()));

			wxTreeItemId root = m_pMessages->GetRootItem();
			const wxString thread = wxString::FromUTF8(event.LogEvent.thread.c_str());
			
			wxTreeItemId itemThread = m_pMessages->FindItem(root,thread, wxTL_MODE_NAV_LEVEL|wxTL_MODE_FIND_EXACT);
			if (!itemThread.IsOk()) {
				itemThread = m_pMessages->AppendItem(root, thread);
			}
			wxTreeItemId itemMessage = m_pMessages->AppendItem(itemThread, wxString::FromUTF8(event.LogEvent.logger.c_str()));
			m_pMessages->SetItemText(itemMessage,1,wxString::FromUTF8(event.LogEvent.level.c_str()));
			m_pMessages->SetItemText(itemMessage,2,wxString::FromUTF8(event.LogEvent.timestamp.c_str()));
			const wxString wxMsg = wxString::FromUTF8(event.LogEvent.msg.c_str());
			m_pMessages->SetItemText(itemMessage,3,wxMsg);

			if (event.LogEvent.level == "ERROR" || event.LogEvent.level == "WARN") {
				m_pMessages->SetItemBold(itemMessage);
			}
			m_pMessages->SetItemToolTip(itemMessage, wxMsg);

			m_pMessages->Expand(itemThread);
			Thaw();
		}

		void VentanaControlLogs::OnGuardarRegistros( wxCommandEvent& /*event*/ )
		{
			wxFileDialog seleccionarFichero (this, _("Save logs"), wxT(""), wxT(""), _("Log file (*.log) | *.log | Text file (*.txt) | *.txt"),wxFD_SAVE);
			int response = seleccionarFichero.ShowModal();
			if (response == wxID_OK) {
				if(wxFileExists(seleccionarFichero.GetPath())) {
					response = wxMessageBox(_("File exists\nWould you like to overwrite it?"),_("Overwrite"),wxYES_NO | wxCANCEL,this);
					if(response != wxYES) {
						return;
					}
				}

				std::ofstream fout;
				std::ostringstream sout;
				try {
					fout.open(TOPATH(seleccionarFichero.GetPath()));
				}
				catch (std::exception& ex)
				{
					sout << _Std("File couldn't be stored ") << seleccionarFichero.GetPath().ToUTF8() << " : " << ex.what();
					wxMessageBox(wxString::FromUTF8(sout.str().c_str()),_("Error"),wxICON_ERROR);
					return;
				}

				if (!fout)
				{
					sout << _Std("File couldn't be stored ") << seleccionarFichero.GetPath().ToUTF8();
					wxMessageBox(wxString::FromUTF8(sout.str().c_str()),_("Error"),wxICON_ERROR);
					return;
				}

				try {
					fout << m_pRegistros->GetValue().ToUTF8();
				}
				catch (std::exception& ex)
				{
					sout << _Std("File couldn't be stored ") << seleccionarFichero.GetPath().ToUTF8() << " : " << ex.what();
					wxMessageBox(wxString::FromUTF8(sout.str().c_str()),_("Error"),wxICON_ERROR);
					return;
				}

				try {
					fout.close();
				}
				catch (std::exception& ex)
				{
					sout << _Std("Could not write to file") << seleccionarFichero.GetPath().ToUTF8() << " : " << ex.what();
					wxMessageBox(wxString::FromUTF8(sout.str().c_str()),_("Error"),wxICON_ERROR);
				}
			}
		}

		void VentanaControlLogs::OnNivelChoice( wxCommandEvent& /*event*/ )
		{

			int nivel = GNC::GCS::ControladorLog::Instance()->GetLogLevelCode(std::string(m_pComboNivel->GetStringSelection().ToUTF8()));

			GNC::GCS::ControladorLog::Instance()->SetActiveLogLevel(nivel);

		}

		void VentanaControlLogs::LimpiarRegistros()
		{
			m_pMessages->DeleteRoot();
			m_pMessages->AddRoot(wxT("Root"));
			m_pRegistros->Clear();
		}

		void VentanaControlLogs::OnSalirClick( wxCommandEvent& /*event*/ )
		{
			Close();
		}

		void VentanaControlLogs::OnKeyDown( wxKeyEvent& event )
		{
			if (event.GetKeyCode() == WXK_ESCAPE) {
				Close();
				event.Skip(false);
			}
			else {
				event.Skip();
			}
		}

		void VentanaControlLogs::OnTreeItemMenu(wxTreeEvent &event)
		{
			if (!event.GetItem().IsOk() || event.GetItem() != m_pMessages->GetSelection())
				return;
			wxMenu popupMenu;
			popupMenu.Append(0,_("Show node plain text"));
			popupMenu.Connect(0,wxEVT_COMMAND_MENU_SELECTED, wxCommandEventHandler(VentanaControlLogs::OnShowPlainText),NULL, this);
			
			m_pMessages->PopupMenu(&popupMenu);
		}

		void VentanaControlLogs::OnShowPlainText(wxCommandEvent &)
		{
			wxTreeItemId idItem = m_pMessages->GetSelection();
			if (!idItem.IsOk()) {
				return;
			}
			
			wxString strTmp;
			if (m_pMessages->GetItemParent(idItem) == m_pMessages->GetRootItem()) {
				wxString threadId = m_pMessages->GetItemText(idItem);
				//se recorren los hijos
				wxTreeItemIdValue cookie;
				wxTreeItemId child = m_pMessages->GetFirstChild(idItem, cookie);
				while (child.IsOk()) {
					strTmp += m_pMessages->GetItemText(child, 2) + wxT(" [") + threadId + wxT("] ") + m_pMessages->GetItemText(child, 1) + wxT(" ") + m_pMessages->GetItemText(child) + wxT(" ") + m_pMessages->GetItemText(child, 3) + wxT("\n");
					child = m_pMessages->GetNextChild(idItem, cookie);
				}
			} else {
				wxString threadId = m_pMessages->GetItemText(m_pMessages->GetItemParent(idItem));

				strTmp = m_pMessages->GetItemText(idItem, 2) + wxT(" [") + threadId + wxT("] ") + m_pMessages->GetItemText(idItem, 1) + wxT(" ") + m_pMessages->GetItemText(idItem) + wxT(" ") + m_pMessages->GetItemText(idItem, 3) + wxT("\n");
			}

			ShowPlainTextDialog* pDlg = new ShowPlainTextDialog(this);
			pDlg->m_pLogText->SetValue(strTmp);
			pDlg->Show();
		}

	}

}
