/*
 *  
 *  $Id: acceptlicensedialog.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "acceptlicensedialog.h"
#include <wx/config.h>
#include <main/entorno.h>
#include <api/globals.h>
#include <main/licencia.h>
#include <string>
#include <sstream>
#include <api/internacionalizacion.h>

GNC::GUI::AcceptLicenseDialog::AcceptLicenseDialog(wxWindow* pPadre):GNC::GUI::AcceptLicenseDialogBase(pPadre)
{
	std::stringstream is;
	is << _Std("Ginkgo CADx license agreement version  ") << GNC::Entorno::Instance()->GetGinkgoVersion() << std::endl;	
	is << std::endl;	
	is << GINKGO_MENSAJE_LICENCIA << std::endl;
	is << std::endl;
	is << GNC::Entorno::Instance()->GetGinkgoCopyRight() << " MetaEmotion Healthcare " ;
	is << "http://healthcare.metaemotion.com" << std::endl;
	is << "contacto@metaemotion.com";

	m_pTextoLicencia->SetValue(wxString::FromUTF8(is.str().c_str()));
	Layout();
	m_buttonAceptar->SetFocus();
}

GNC::GUI::AcceptLicenseDialog::~AcceptLicenseDialog()
{
}

void GNC::GUI::AcceptLicenseDialog::OnAceptarClick(wxCommandEvent &event)
{
	wxConfigBase * config = wxConfigBase::Get();
	//se actualiza el fichero de configuracion
	config->SetPath(wxT("/GinkgoCore/Estacion"));
	config->Write(wxT("CheckForUpdates"),m_pCheckForUpdates->GetValue());
	config->Flush();
	event.Skip(true);
}
