/*
 *
 *  $Id: aboutdialog.cpp 3673 2011-04-11 13:49:47Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "aboutdialog.h"
#include <api/globals.h>
#include <api/internacionalizacion.h>
#include <main/entorno.h>
#include <main/controllers/controladorextensiones.h>
#include <resources/ginkgoresourcemanager.h>
#include "dialogolicenciasopensource.h"
#include <wx/ginkgostyle/ginkgostyle.h>

AboutDialog::AboutDialog(wxWindow* pPadre):AboutDialogBase(pPadre)
{
	m_pHeader->SetSubtitle(_("Open Source DICOM CADx environment"));

	m_pCreditsText->Clear();
	m_pCreditsText->SetDefaultStyle(wxRichTextAttr());
	m_pCreditsText->BeginFontSize(12);
	m_pCreditsText->BeginBold();
	m_pCreditsText->WriteText(_("Ginkgo CADx v"));
	m_pCreditsText->WriteText(wxString::FromUTF8(GNC::Entorno::Instance()->GetGinkgoVersion().c_str()));
	m_pCreditsText->EndBold();
	m_pCreditsText->BeginFontSize(11);
	m_pCreditsText->BeginTextColour(wxColour(0,110,165));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->BeginURL(wxT("http://www.ginkgo-cadx.com/"));
	m_pCreditsText->WriteText(wxT("www.ginkgo-cadx.com"));
	m_pCreditsText->EndTextColour();
	m_pCreditsText->EndURL();
	m_pCreditsText->BeginFontSize(10);
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(wxString::FromUTF8(GNC::Entorno::Instance()->GetGinkgoCopyRight().c_str()) + wxT(" "));
	m_pCreditsText->BeginURL(wxT("http://healthcare.metaemotion.com/"));
	m_pCreditsText->BeginTextColour(wxColour(0,110,165));
	m_pCreditsText->WriteText(wxT("MetaEmotion Healthcare"));
	m_pCreditsText->EndTextColour();
	m_pCreditsText->EndURL();
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->BeginBold();
	m_pCreditsText->WriteText(_("Translators"));
	m_pCreditsText->EndBold();
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(_("Japanese: Noriya Yokohama"));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->BeginBold();
	m_pCreditsText->WriteText(_("Greetings"));
	m_pCreditsText->EndBold();
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(_("Ross Boswell: PACS compliance testing"));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(_("Andre Alvim Tolentino: Printing issues"));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(_("Generalitat de Catalunya: ECG compliance support"));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(wxT("\n"));
	m_pCreditsText->WriteText(_("We want to thanks "));
	m_pCreditsText->BeginURL(wxT("http://www.saludcastillayleon.es/"));
	m_pCreditsText->BeginTextColour(wxColour(0,110,165));
	m_pCreditsText->WriteText(wxT("Sacyl"));
	m_pCreditsText->EndTextColour();
	m_pCreditsText->EndURL();
	m_pCreditsText->WriteText(_(" for all their support in Ginkgo CADx creation!"));



	m_pCreditsText->EndFontSize();

	Layout();
}

AboutDialog::~AboutDialog()
{

}

void AboutDialog::OnLicenciasOpenSource(wxCommandEvent &)
{
	DialogoLicenciasOpenSource dlg (this);
	dlg.ShowModal();
}

void AboutDialog::OnSize(wxSizeEvent &event)
{
	Layout();
	event.Skip(true);
}

void AboutDialog::OnTextURL(wxTextUrlEvent &event)
{
	wxLaunchDefaultBrowser(event.GetString());
}

