/*
 *  
 *  $Id: selectimagesimportation.h 3571 2011-03-21 09:51:24Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwizard.h>
#include "pasosimportacionbase.h"
#include <api/icontroladorimportacionpacs.h>
#include <api/ientorno.h>
#include <api/icontroladormodulo.h>
#include <yasper/yasper.h>
#include <string>
#include <vector>


namespace GIL
{
	class IModeloIntegracion;
}

namespace GNC {
	namespace GCS {
		class Plantilla;
	}
}

namespace GNC {
	namespace GUI {

		class SelectImagesImportation: public SelectImagesImportationBase, public IPasoWizard
		{
			public:
				SelectImagesImportation(wxWindow* pParent, std::string& dirTemp, IWizard* pWizard, GNC::GCS::IControladorModulo::TipoListaPlantillas& listaPlantillas, bool reescalar, GnkPtr<GIL::IModeloIntegracion>& pModeloIntegracion);
				~SelectImagesImportation();
			
			protected:
				
				std::string                                                 m_dirTemp;
				std::map<wxMemoryImageThumbnailItem*, GNC::GCS::Plantilla*> m_mapaPlantillas;
				bool                                                        m_reescalar;
				GnkPtr<GIL::IModeloIntegracion>                             m_pModeloIntegracion;
				bool                                                        m_CustomPathSetted;

				virtual wxArrayString GetSelectedPaths();
				virtual void AddImagen(bool includeDir=false, const wxString& path = wxEmptyString);
				virtual void OnFicheroActivado(wxTreeEvent &event);
				virtual void OnAddClick(wxCommandEvent &event);
				virtual void OnDeleteClick(wxCommandEvent &event);
				virtual void OnThumbLeftDClickSelected(wxCommandEvent& event);
				virtual void OnImagenesKeyDown(wxKeyEvent &event);
				virtual void OnPlantillasDClick(wxCommandEvent& event);		
				virtual void OnLocalTemplateClick(wxCommandEvent& event);
				virtual void OnTreeBeginLDrag(wxTreeEvent &event);

				virtual void OnUbicacionClick(wxCommandEvent& event);

			//region "Metodos heredados de IPasoWizard"
				virtual void Attach(wxSizer *sizer);

				virtual void Detach(wxSizer *sizer);

				virtual std::string GetTitle();

				virtual std::string GetSubTitle();

				virtual bool Siguiente();

				virtual bool Anterior();

				virtual bool Cancelar();

				virtual bool Validar();
			//endregion

		};
	};
};
