/*
 *  
 *  $Id: selectimagesimportation.cpp 3571 2011-03-21 09:51:24Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>
#include <sstream>

#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <wx/confbase.h>
#include <wx/file.h>
#include <wx/dnd.h>
#include <wx/dir.h>
#include <wx/busyinfo.h>
#include <api/internacionalizacion.h>
#include <wx/ginkgostyle/ginkgostyle.h>

#include <api/imodelointegracion.h>
#include <api/math/geometria.h>
#include <resources/ginkgoresourcemanager.h>

#include <yasper/yasper.h>
#include <main/entorno.h>

#include "selectimagesimportation.h"
#include <api/icontextoestudio.h>

#define TAB_FICHEROS 0
#define TAB_PLANTILLAS 1

/*#include <itkRGBPixel.h>
#include <itkImage.h>
#include <itkImageFileWriter.h>
#include <itkImageFileReader.h>*/
namespace GNC {
	namespace GUI {
		//////////////////////BEGIN D&D/////////////////////////
		class wxDnDImportacion : public wxCustomDataObject
		{
		public:
			wxDnDImportacion(bool arrancaIzquierda = true)
			{
				m_format.SetId(wxT("DnDImportacionFormat"));
				SetFormat(m_format);

				m_arrancaIzquierda = arrancaIzquierda;
			}
			bool ArrancaIzquierda()
			{
				return m_arrancaIzquierda;
			}
			// implement base class pure virtuals
			// ----------------------------------
			virtual wxDataFormat GetPreferredFormat(Direction WXUNUSED(dir)) const
			{
				return m_format;
			}
			virtual size_t GetFormatCount(Direction /*dir*/) const
			{
				size_t nFormats = 1;
				return nFormats;
			}
			virtual void GetAllFormats(wxDataFormat *formats, Direction /*dir*/) const
			{
				formats[0] = m_format;
			}
			virtual size_t GetDataSize() const
			{
				return sizeof(m_arrancaIzquierda);
			}
			virtual bool GetDataHere(void *buf) const
			{
				(*((bool*)buf)) = m_arrancaIzquierda;
				return true;
			}
			virtual bool SetData(size_t /*len*/, const void *buf)
			{
				m_arrancaIzquierda = (*(const bool*)buf);
				return true;
			}
			// Must provide overloads to avoid hiding them (and warnings about it)
			virtual size_t GetDataSize(const wxDataFormat&) const
			{
				return GetDataSize();
			}
			virtual bool GetDataHere(const wxDataFormat&, void *buf) const
			{
				return GetDataHere(buf);
			}
			virtual bool SetData(const wxDataFormat&, size_t len, const void *buf)
			{
				return SetData(len, buf);
			}

		private:
			bool m_arrancaIzquierda;
			wxDataFormat m_format;
			DECLARE_NO_COPY_CLASS(wxDnDImportacion)
		};

		class wxDropTargetImportacion: public wxDropTarget
		{
		public:
			wxDropTargetImportacion(bool aceptaIzquierda = true)
			{
				SetDataObject(new wxDnDImportacion);
				SetDefaultAction(wxDragCopy);
				m_aceptaIzquierda = aceptaIzquierda;
			}

			~wxDropTargetImportacion()
			{
			}

			virtual wxDragResult OnData(wxCoord /*x*/, wxCoord /*y*/, wxDragResult def)
			{
				if ( !GetData() )
					  return wxDragNone;

				 wxDnDImportacion *dobj = (wxDnDImportacion *)m_dataObject;
				 return (dobj->ArrancaIzquierda() && m_aceptaIzquierda) || (!dobj->ArrancaIzquierda() && !m_aceptaIzquierda) ? def : wxDragNone;
			}

		private:
			bool m_aceptaIzquierda;
		};
		//////////////////////END D&D/////////////////////////

		SelectImagesImportation::SelectImagesImportation(wxWindow* pParent,std::string& dirTemp, IWizard* pWizard, GNC::GCS::IControladorModulo::TipoListaPlantillas& listaPlantillas, bool reescalar, GnkPtr<GIL::IModeloIntegracion>& pModeloIntegracion) : SelectImagesImportationBase(pParent), IPasoWizard(pWizard)
		{			
			SetScrollbars(10, 10, 50, 50, 0, 0, false);
			AdjustScrollbars();

			m_pModeloIntegracion = pModeloIntegracion;
			Hide();
			m_dirTemp = dirTemp;
			m_reescalar = reescalar;
			m_CustomPathSetted = true;

#if defined(_WIN32) || defined(__WXMAC__)
			m_pArchivoDirControl->SetFilter(_("Images (*.jpg;*.jpeg;*.bmp;*.png;*.tif;*.tiff)|*.jpg;*.jpeg;*.bmp;*.png;*.tif;*.tiff|JPEG Images (*.jpg;*.jpeg)|*.jpg;*.jpeg|BMP Images (*.bmp)|*.bmp|PNG Images (*.png)|*.png|TIFF Images (*.tif;*.tiff)|*.tif;*.tiff|All files(*.*)|*.*"));
#else
			m_pArchivoDirControl->SetFilter(_("Images (*.jpg;*.jpeg;*.bmp;*.png;*.tif;*.tiff)|*.jpg;*.jpeg;*.bmp;*.png;*.tif;*.tiff;*.JPG;*.JPEG;*.BMP;*.PNG;*.TIF;*.TIFF|JPEG Images (*.jpg;*.jpeg)|*.jpg;*.jpeg;*.JPG;*.JPEG|BMP Images (*.bmp)|*.bmp;*BMP|PNG Images (*.png)|*.png;*PNG|TIFF Images (*.tif;*.tiff)|*.tif;*.tiff;*TIF;*TIFF|All files (*.*)|*.*"));
#endif

			if(listaPlantillas.size() == 0){
				m_panelFilesInputHeader->Show(false);
			}else{
				m_panelFilesInputHeader->Show(true);
				for(GNC::GCS::IControladorModulo::TipoListaPlantillas::iterator it = listaPlantillas.begin(); it != listaPlantillas.end(); it++){
					wxImage img((*it)->GetImagen()->ConvertToImage());
					wxMemoryImageThumbnailItem* item = new wxMemoryImageThumbnailItem(wxString::FromUTF8((*it)->GetNombre().c_str()), img);
					m_pPlantillas->Append(item);
					m_mapaPlantillas[item] = (*it);
				}
				m_pPlantillas->Connect(wxEVT_COMMAND_THUMBNAIL_LEFT_DCLICK,wxCommandEventHandler(SelectImagesImportation::OnPlantillasDClick),NULL,this);
			}

			/* if (m_pModeloIntegracion)*/ {
				GNC::GCS::IEntorno::MapaUbicaciones& mapa = GNC::Entorno::Instance()->GetUbicaciones();
				if (mapa.size() == 0) {
					m_pBotoneraUbicaciones->Show(false);
				}
				else {

					wxButton* btd = new wxButton(m_pPanelUbicaciones, wxID_ANY, _("Default"));
					btd->SetToolTip(_("Default Path"));
					m_pBotoneraUbicaciones->Add(btd, 0, wxEXPAND, 2);						
					btd->Connect(wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(SelectImagesImportation::OnUbicacionClick), NULL, this);

					for (GNC::GCS::IEntorno::MapaUbicaciones::iterator it = mapa.begin(); it != mapa.end(); it++) {
						GIL::Ubicacion& u = (*it).second;
						wxButton* bt = new wxButton(m_pPanelUbicaciones, wxID_ANY, wxString::FromUTF8(u.Titulo.c_str()));
						bt->SetToolTip(wxString::FromUTF8(u.Descripcion.c_str()));
						m_pBotoneraUbicaciones->Add(bt, 0, wxEXPAND, 2);						
						bt->Connect(wxEVT_COMMAND_BUTTON_CLICKED, wxCommandEventHandler(SelectImagesImportation::OnUbicacionClick), NULL, this);
					}
					m_pBotoneraUbicaciones->Show(true);
				}
			}


			{
				wxConfigBase * config = wxConfigBase::Get();
				//se actualiza el fichero de configuracion
				config->SetPath(wxT("/GinkgoCore/Importacion"));
				wxString wxPathDefecto;
				config->Read(wxT("PathDefecto"),&wxPathDefecto,wxT(""));
				if(wxFileExists(wxPathDefecto) || wxDirExists(wxPathDefecto)) {
					m_pArchivoDirControl->SetPath(wxPathDefecto);
				}
			}

			m_pImagenes->Connect(wxEVT_COMMAND_THUMBNAIL_LEFT_DCLICK,wxCommandEventHandler(SelectImagesImportation::OnThumbLeftDClickSelected),NULL,this);
			m_pImagenes->Connect(wxEVT_KEY_DOWN, wxKeyEventHandler(SelectImagesImportation::OnImagenesKeyDown),NULL,this);
			m_pImagenes->SetDropTarget(new wxDropTargetImportacion(true));
			Layout();
		}

		SelectImagesImportation::~SelectImagesImportation()
		{
			m_pImagenes->Disconnect(wxEVT_COMMAND_THUMBNAIL_LEFT_DCLICK,wxCommandEventHandler(SelectImagesImportation::OnThumbLeftDClickSelected),NULL,this);
		}

		void SelectImagesImportation::OnFicheroActivado(wxTreeEvent &event){
			AddImagen();
			event.Skip();
		}

		void SelectImagesImportation::OnAddClick(wxCommandEvent &event){
			AddImagen(true);
			event.Skip();
		}

		void SelectImagesImportation::OnThumbLeftDClickSelected(wxCommandEvent& event)
		{
			while(m_pImagenes->GetSelection()!=-1){
				m_pImagenes->Delete(m_pImagenes->GetSelection());
			}
			event.Skip();
		}

		void SelectImagesImportation::OnImagenesKeyDown(wxKeyEvent &event)
		{
			if (event.GetKeyCode() == WXK_DELETE || event.GetKeyCode() == WXK_BACK) {
				while(m_pImagenes->GetSelection()!=-1){
					m_pImagenes->Delete(m_pImagenes->GetSelection());
				}
				event.Skip(false);
			}
			else
			{
				event.Skip(true);
			}
		}

		void SelectImagesImportation::OnPlantillasDClick(wxCommandEvent& /*event*/){
			AddImagen();
		}

		void SelectImagesImportation::OnDeleteClick(wxCommandEvent &event){
			while(m_pImagenes->GetSelection()!=-1){
				m_pImagenes->Delete(m_pImagenes->GetSelection());
			}
			event.Skip();
		}

		void SelectImagesImportation::AddImagen(bool includeDir, const wxString& path){
			wxBusyInfo info(_("Creating Thumbnail..."));
			if(m_radioBtnLocalFile->GetValue()){
				wxString pathBuscar = path;
				if(pathBuscar == wxEmptyString) {
					pathBuscar = m_pArchivoDirControl->GetPath();
				}

				//se actualiza el fichero de configuracion
				if (m_CustomPathSetted) {
					wxConfigBase::Get()->SetPath(wxT("/GinkgoCore/Importacion"));
					wxConfigBase::Get()->Write(wxT("PathDefecto"),wxPathOnly(pathBuscar));
					wxConfigBase::Get()->Flush();
				}

				if (wxFileName::IsFileReadable(pathBuscar) && m_pImagenes->FindItemForFilename(pathBuscar)==-1) {
					wxImageThumbnailItem* pItem = new wxImageThumbnailItem(pathBuscar);
					m_pImagenes->Insert( pItem, m_pImagenes->GetCount());
				} else if(includeDir && wxFileName::IsDirReadable(pathBuscar)){
					//se meten todos los jpgs, BMP, PNG,  Y TIFF
					wxArrayString arrStr;
					arrStr.Add(wxT("jpg"));
					arrStr.Add(wxT("jpeg"));
					arrStr.Add(wxT("bmp"));
					arrStr.Add(wxT("png"));
					arrStr.Add(wxT("tiff"));
					wxDir dir;
					if (dir.Open(pathBuscar)) {
						wxString nombreFichero;
						bool cont = dir.GetFirst(&nombreFichero, wxT("*"), wxDIR_FILES);
						while (cont) {
							if(pathBuscar.GetChar(pathBuscar.size()-1) == wxFileName::GetPathSeparator()) {
								nombreFichero = pathBuscar + nombreFichero;
							}  else {
								nombreFichero = pathBuscar + wxFileName::GetPathSeparator() + nombreFichero;
							}
							wxFileName fileName(nombreFichero);
							if(arrStr.Index(fileName.GetExt().Lower()) !=  wxNOT_FOUND) {
								if(m_pImagenes->FindItemForFilename(nombreFichero)==-1){
									wxImageThumbnailItem* pItem = new wxImageThumbnailItem(nombreFichero);
									m_pImagenes->Insert( pItem, m_pImagenes->GetCount());
								}
							}
							cont = dir.GetNext(&nombreFichero);
						}
					}
				} else if(!wxFileName::IsFileReadable(pathBuscar) && !wxFileName::IsDirReadable(pathBuscar)) {
					wxMessageBox(_("The file or directory can't be acquired, make sure that you have read permissions on it"),
						_("Error"), wxOK | wxICON_INFORMATION, this);
				}
			} else {
				//se copia el fichero al directorio temporal para trabajar con el en jpg
				wxArrayInt seleccionadas = m_pPlantillas->GetSelections();
				for(wxArrayInt::iterator it = seleccionadas.begin(); it != seleccionadas.end(); it++){
					wxMemoryImageThumbnailItem* item = (wxMemoryImageThumbnailItem*)m_pPlantillas->GetItem((*it));
					GNC::GCS::Plantilla* plantilla= m_mapaPlantillas[item];
					wxString destino = FROMPATH(m_dirTemp) + wxFileName::GetPathSeparator() + FROMPATH(plantilla->GetNombre()) + wxT(".jpg");
					//si no lo hemos incluido ya...
					if(m_pImagenes->FindItemForFilename(destino)==-1){
						wxImage img = plantilla->GetImagen()->ConvertToImage();
						img.SetOption(wxIMAGE_OPTION_QUALITY,100);
						img.SaveFile(destino);
						wxImageThumbnailItem* pItem = new wxImageThumbnailItem(destino);
						m_pImagenes->Insert( pItem, m_pImagenes->GetCount());
					}
				}
			}
		}

		wxArrayString SelectImagesImportation::GetSelectedPaths(){
			wxArrayString resultado;
			for(int i=0;i<m_pImagenes->GetCount();++i){
				wxImageThumbnailItem* item=dynamic_cast<wxImageThumbnailItem*>(m_pImagenes->GetItem(i));
				if(item!=NULL){
					resultado.push_back(item->GetFilename());
				}
			}
			return resultado;
		}

		void SelectImagesImportation::OnLocalTemplateClick(wxCommandEvent& )
		{
			m_pArchivoDirControl->Show(m_radioBtnLocalFile->GetValue());
			if (m_radioBtnLocalFile->GetValue()) {
				if (GNC::Entorno::Instance()->GetUbicaciones().empty()) {
					m_pBotoneraUbicaciones->Show(false);
				}
				else {
					m_pBotoneraUbicaciones->Show(true);
				}
			}
			else {
				m_pBotoneraUbicaciones->Show(false);
			}
			m_pPlantillas->Show(m_radioBtnTemplate->GetValue());
			m_panelFilesInput->Layout();
			Layout();
		}

		void SelectImagesImportation::OnTreeBeginLDrag(wxTreeEvent & event)
		{
			wxTreeItemId item = event.GetItem();
			//antes de que se borre la seleccion...
			if(!item.IsOk())
				return;
			//esta "ñapa" es necesaria ya que se deselecciona el item al comenzar a arrastrar
			wxDirItemData* data = (wxDirItemData*) m_pArchivoDirControl->GetTreeCtrl()->GetItemData(item);
			wxString path = data->m_path;

			wxDnDImportacion myData;
			wxDropSource dragSource(myData,this);
			wxDragResult result = dragSource.DoDragDrop(wxDrag_AllowMove);
			if (result == wxDragCopy) {
				AddImagen(true,path);
			}
			event.Skip(true);
		}

		void SelectImagesImportation::OnUbicacionClick(wxCommandEvent& event)
		{
			/*if (m_pModeloIntegracion)*/ {
				wxButton* bt = dynamic_cast<wxButton*>(event.GetEventObject());
				if (bt != NULL) {
					std::string titulo(bt->GetLabel().ToUTF8());
					GNC::GCS::IEntorno::MapaUbicaciones& mapa = GNC::Entorno::Instance()->GetUbicaciones();
					GNC::GCS::IEntorno::MapaUbicaciones::iterator it = mapa.find(titulo);
					if (it != mapa.end()) {
						std::string path = (*it).second.GetRutaFormateada(m_pModeloIntegracion);
						m_pArchivoDirControl->Freeze();
						m_pArchivoDirControl->CollapseTree();
						m_pArchivoDirControl->SetPath(wxString::FromUTF8(path.c_str()));
						m_pArchivoDirControl->ExpandPath(m_pArchivoDirControl->GetPath());
						m_pArchivoDirControl->Thaw();
						m_CustomPathSetted = false;
					}
					else if (titulo == _Std("Default") )
					{
						wxConfigBase * config = wxConfigBase::Get();
						config->SetPath(wxT("/GinkgoCore/Importacion"));
						wxString wxPathDefecto;
						config->Read(wxT("PathDefecto"),&wxPathDefecto,wxT(""));
						m_pArchivoDirControl->Freeze();
						m_pArchivoDirControl->CollapseTree();
						m_pArchivoDirControl->SetPath(wxPathDefecto);
						m_pArchivoDirControl->ExpandPath(m_pArchivoDirControl->GetPath());
						m_pArchivoDirControl->Thaw();
						m_CustomPathSetted = true;
					}
				}
				else {
					m_CustomPathSetted = true;
				}
			}
			/*else {
				m_CustomPathSetted = true;
			}
			*/

		}

//region "Metodos heredados de Ipasowizard"

		void SelectImagesImportation::Attach(wxSizer *sizer){
			Show(true);
			sizer->Add(this, 1, wxEXPAND);
			this->GetParent()->Layout();
		}

		void SelectImagesImportation::Detach(wxSizer *sizer){
			Hide();
			sizer->Detach(this);
			sizer->GetContainingWindow()->Layout();
		}

		std::string SelectImagesImportation::GetTitle(){
			return _Std("Image selection");
		}

		std::string SelectImagesImportation::GetSubTitle(){
			return _Std("You must select the images you want to import");
		}

		bool SelectImagesImportation::Siguiente(){
			return true;
		}

		bool SelectImagesImportation::Anterior(){
			return false;
		}

		bool SelectImagesImportation::Cancelar(){
			return true;
		}

		bool SelectImagesImportation::Validar(){
			wxArrayString paths=this->GetSelectedPaths();
			if(paths.GetCount()==0){
				wxMessageBox(_("You must select at least one image"), _("Info"),
					 wxOK | wxICON_INFORMATION, this);
				return false;
			}

			m_pListaFicheros->clear();

			wxString wxDirTemp = FROMPATH(m_dirTemp);

			int dims[2] = {-1,-1};
			//dimensiones del mas grande
			GNC::GCS::Vector vectorMaximo(-1.0,-1.0);
			GNC::GCS::Vector vectorOrigen(0.0,0.0);
			//
			bool redimensionar = false;
			//se leen las imagenes para ver que tengan la misma dimension
			for(wxArrayString::iterator it=paths.begin();it!=paths.end();++it){
				if(!wxFileName::FileExists((*it))){
					wxString str(_("The file"));
					wxMessageBox(str <<(*it) <<_(" doesn't exist"), _("Info"),
					 wxOK | wxICON_INFORMATION, this);
					m_pListaFicheros->clear();
					//el fichero no existe
					return false;
				}
				wxImage img((*it));
				if(img.Ok())
				{
					if(dims[0]==-1 && dims[1]==-1){
						dims[0]=img.GetWidth();
						dims[1]=img.GetHeight();
						vectorMaximo.x =(double) std::max<double>(img.GetWidth(),img.GetHeight());
						vectorMaximo.y =(double) std::min<double>(img.GetWidth(),img.GetHeight());
					} else {
						if(!( (dims[0] == img.GetWidth() && dims[1] == img.GetHeight()) || (dims[1] == img.GetWidth() && dims[0] == img.GetHeight()) )){
							redimensionar = true;
							GNC::GCS::Vector v1((double)std::max<double>(img.GetWidth(),img.GetHeight()),(double)std::min<double>(img.GetWidth(),img.GetHeight()));
							if(!v1.DentroDeBoundingBox(vectorOrigen,vectorMaximo)){
								vectorMaximo.x = std::max<double>(vectorMaximo.x,v1.x);
								vectorMaximo.y = std::max<double>(vectorMaximo.y,v1.y);
							}
						}
					}

					wxFileName fileName((*it));
					std::string path(TOPATH((*it)));
					m_pListaFicheros->push_back(path);
				} else {
					wxString str(_("The file"));
					wxMessageBox(str <<(*it) <<_(" couldn't be readed"), _("Info"),
					 wxOK | wxICON_INFORMATION, this);
					m_pListaFicheros->clear();
					return false;
				}
			}

			//por ultimo si hay que redimensionar se redimensionan proporcionalmente y se rellena con negros
			if (redimensionar && m_reescalar){
				int answer = wxMessageBox(_("All images must have the same dimensions.\nDo you want to continue resizing the images to the size of the largest?"),_("Different dimensions between images"), wxYES_NO , this);
				if (answer == wxNO) {
					m_pListaFicheros->clear();
					//el fichero no existe
					return false;
				}
				wxBusyInfo infoDlg(_("Scaling images, may take a while ..."), this);
				for(ListaFicheros::iterator it = m_pListaFicheros->begin(); it!= m_pListaFicheros->end(); it++){
					wxImage img(FROMPATH((*it)));
					if(!( (vectorMaximo.x == img.GetWidth() && vectorMaximo.y == img.GetHeight()) || (vectorMaximo.x == img.GetWidth() && vectorMaximo.y == img.GetHeight()) )){
						//primero se rescala proporcionalmente
						double scale;
						if(img.GetHeight() > img.GetWidth()){
							scale = (double)vectorMaximo.x / img.GetHeight();
						} else {
							scale = (double)vectorMaximo.x / img.GetWidth();
						}
						img = img.Rescale(img.GetWidth()*scale,img.GetHeight()*scale,wxIMAGE_QUALITY_HIGH);
						//se cambia el tamaño hasta el maximo
						if(img.GetHeight() > img.GetWidth()){
							wxPoint punto((vectorMaximo.y / 2) - ((float)img.GetWidth()/2),0);
							img = img.Resize(wxSize(vectorMaximo.y,vectorMaximo.x),punto,0,0,0);
						} else {
							wxPoint punto(0,(vectorMaximo.y / 2) - ((float)img.GetHeight()/2));
							img = img.Resize(wxSize(vectorMaximo.x,vectorMaximo.y),punto,0,0,0);
						}

						wxFileName fileName(FROMPATH((*it)));
						wxString nombreImagenTemporal = wxDirTemp + wxFileName::GetPathSeparator() + fileName.GetName() + wxString::Format(wxT("%d"),rand()) + wxT(".jpg");
						while(wxFile::Exists(nombreImagenTemporal))
						{
							//si existe se busca uno que no exista
							nombreImagenTemporal= wxDirTemp + wxFileName::GetPathSeparator() + fileName.GetName() + wxString::Format(wxT("%d"),rand()) + wxT(".jpg");
						}
						img.SetOption(wxIMAGE_OPTION_QUALITY,100);
						img.SaveFile(nombreImagenTemporal);
						(*it) = TOPATH(nombreImagenTemporal);

					}
				}
			}

			//
			return true;
		}
	//endregion
	}
}
