/*
 *  
 *  $Id: parametrosprincipales.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwizard.h>
#include "pasosexportacionbase.h"
#include "datospersistentesexportacion.h"
#include <string>
#include <vector>

namespace GNC {
	namespace GCS {
		class IContratoExportacion;
		class IVista;
	}
	namespace GUI {

		class ParametrosPrincipales: public ParametrosPrincipalesBase,public IPasoWizard
		{
			public:
				

				ParametrosPrincipales(wxWindow* pParent,IWizard* pWizard,GnkPtr<TipoWizardExportacion> pDatosPersistentes, GNC::GCS::IEntorno* pEntorno);
				~ParametrosPrincipales();
				void SetTags(GIL::DICOM::TipoJerarquia & base,wxPGPropArg idPadre,GIL::DICOM::IDICOMManager*	pDICOMManager);

			protected:			
				GnkPtr<TipoWizardExportacion> m_pDatosPersistentes;
				GNC::GCS::IEntorno* m_pEntorno;

				void OnChoiceFormatoDestino(wxCommandEvent &event);

				//anonimizacion
				GIL::DICOM::TipoJerarquia m_base;
				wxString m_valorAnonimizado;
			public:
				void GetTagsAnonimizados(GIL::DICOM::TipoJerarquia & base);

			protected:
				void OnCheckAnonimizar(wxCommandEvent &event);

				void OnCheckNombreApellidos(wxCommandEvent &event);

				void OnCheckIdPaciente(wxCommandEvent &event);

				void OnCheckInstituciones(wxCommandEvent &event);

				void OnCheckComentarios(wxCommandEvent &event);

				void OnCheckConfiguracion(wxCommandEvent &event);

				void Anonimizar(std::string& clave, bool anonimizar);

				void OnPropertyChanged(wxPropertyGridEvent& event);

				void OnPropertyDobleClick(wxPropertyGridEvent& event);
				//

				bool Seleccionardirectorio();


			//region "Metodos heredados de IPasoWizard"
				virtual void Attach(wxSizer *sizer);

				virtual void Detach(wxSizer *sizer);

				virtual std::string GetTitle();

				virtual std::string GetSubTitle();

				virtual bool Siguiente();

				virtual bool Anterior();

				virtual bool Cancelar();

				virtual bool Validar();
			//endregion

		};
	};
};
