/*
 *  
 *  $Id: parametrosprincipales.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>
#include <sstream>

#include <wx/file.h>
#include <wx/dir.h>
#include <wx/dirdlg.h>
#include <wx/msgdlg.h>
#include <wx/confbase.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <wx/propgrid/propgrid.h>

#include <api/ientorno.h>
#include <api/ivista.h>
#include <export/icontratoscore.h>
#include <api/icontextoestudio.h>

#include <wx/file.h>
#include <wx/dir.h>
#include <wx/dirdlg.h>
#include <wx/msgdlg.h>
#include <wx/confbase.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <wx/propgrid/propgrid.h>
#include <api/internacionalizacion.h>
#include <wx/ginkgostyle/ginkgostyle.h>

#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladorcomandos.h>
#include <commands/comandoexportacion.h>
#include <commands/comandomergediagnosticwithimage.h>
#include "parametrosprincipales.h"

namespace GNC {
	namespace GUI {

		ParametrosPrincipales::ParametrosPrincipales(wxWindow* pParent,IWizard* pWizard,GnkPtr<TipoWizardExportacion> pDatosPersistentes, GNC::GCS::IEntorno* pEntorno):ParametrosPrincipalesBase(pParent),IPasoWizard(pWizard)
		{
			m_pEntorno = pEntorno;
			m_pDatosPersistentes = pDatosPersistentes;
			//si es IContratoExportacionImages pues se deja a todos los formatos sino solo dicom
			GNC::GCS::IContratoExportacionImages* pContratoImages = dynamic_cast<GNC::GCS::IContratoExportacionImages*>(m_pDatosPersistentes->m_pVista);
			if(pContratoImages == NULL){
				//solo DICOM
				m_pFormatoDestino->Delete(3);
				m_pFormatoDestino->Delete(2);
				m_pFormatoDestino->Delete(1);
			}
			else{
				//pillamos los mapas
				typedef GNC::GCS::IContratoExportacionImages::MapaMapasValoracion MapaMapasValoracion;
				m_pDatosPersistentes->m_mapasValoracion = pContratoImages->GetMapasValoracion();
				if(m_pDatosPersistentes->m_mapasValoracion.size() == 0) {
					m_pTituloMapas->Show(false);
					m_pMapasCheck->Show(false);
				} else {
					for(MapaMapasValoracion::iterator it= m_pDatosPersistentes->m_mapasValoracion.begin(); it!= m_pDatosPersistentes->m_mapasValoracion.end(); it++) {
						int item = m_pMapasCheck->Append(wxString::FromUTF8((*it).first.c_str()));
						m_pMapasCheck->Check(item,(*it).second);
					}
				}
			}

			m_base = (*m_pDatosPersistentes->m_pVista->GetEstudio()->GetTagsImagenDeImagenActiva());


			std::string pathActivo;
			GIL::DICOM::IDICOMManager*	pDICOMManager= pEntorno->GetControladorImportacionPACS()->CrearInstanciaDeDICOMManager();

		
			SetTags(m_base,m_pListaAtributos->GetRoot(),pDICOMManager);

			pEntorno->GetControladorImportacionPACS()->LiberarInstanciaDeDICOMManager(pDICOMManager);

			wxConfigBase * config = wxConfigBase::Get();
			config->Read(wxT("/GinkgoCore/Exportacion/ValorDefectoAnonimizacion"),&m_valorAnonimizado,wxEmptyString);

			//por defecto el check de configuracion esta checkeado
			wxCommandEvent evt;
			OnCheckConfiguracion(evt);

			m_pPanelCampos->Enable(false);
			m_pPanelCampos->Refresh(false);
			m_pListaAtributos->Refresh(false);

			//diagnosticos
			std::vector<std::string> listaDiagnosticos = m_pDatosPersistentes->m_pVista->GetRutasDiagnosticos();
			if(listaDiagnosticos.size()==0) {
				m_pCheckExportarDiagnostico->SetValue(false);
				m_pCheckExportarDiagnostico->Enable(false);
			} else {
				GNC::GCS::ControladorHistorial::ModeloDCM modelo = GNC::GCS::ControladorHistorial::Instance()->GetModeloDCM(listaDiagnosticos[0]);
				std::ostringstream ostr;
				ostr << "(" << modelo.m_nombreMedico << "; " << modelo.m_horaEstudio << "; " << modelo.m_fechaEstudio << "; " << modelo.m_descripcionEstudio << ")";
				m_pDescripcionDiagnostico->SetLabel(wxString::FromUTF8(ostr.str().c_str()));
			}

			Layout();

			m_pListaAtributos->Connect(wxEVT_PG_CHANGED,wxPropertyGridEventHandler(ParametrosPrincipales::OnPropertyChanged),NULL,this);
			m_pListaAtributos->Connect(wxEVT_PG_DOUBLE_CLICK,wxPropertyGridEventHandler(ParametrosPrincipales::OnPropertyDobleClick),NULL,this);
		}

		ParametrosPrincipales::~ParametrosPrincipales()
		{
			m_pListaAtributos->Disconnect(wxEVT_PG_CHANGED,wxPropertyGridEventHandler(ParametrosPrincipales::OnPropertyChanged),NULL,this);
			m_pListaAtributos->Disconnect(wxEVT_PG_DOUBLE_CLICK,wxPropertyGridEventHandler(ParametrosPrincipales::OnPropertyDobleClick),NULL,this);
			m_pEntorno = NULL;
		}

		void ParametrosPrincipales::SetTags(GIL::DICOM::TipoJerarquia & base,wxPGPropArg idPadre,GIL::DICOM::IDICOMManager*	pDICOMManager) {
			for(GIL::DICOM::TipoJerarquia::ListaTags::iterator it = base.tags.begin(); it!= base.tags.end(); it++){
				wxString helpString = wxString::FromUTF8(pDICOMManager->GetDescription((*it).first).c_str());
				wxStringProperty* prop = NULL;
				wxString valor;
				if((*it).second.size()>100) {
					valor=wxT("Datos");
				} else {
					valor = wxString::FromUTF8((*it).second.c_str());
				}

				if(helpString.size()>0){
					helpString = wxT("(") + wxString::FromUTF8((*it).first.c_str()) + wxT(") ") + helpString;
					prop = new wxStringProperty(helpString,
						wxPG_LABEL,valor);
				}else{
					prop = new wxStringProperty(wxString::FromUTF8((*it).first.c_str()),
						wxPG_LABEL,valor);
				}
				prop->SetHelpString(wxString::FromUTF8((*it).first.c_str()));
				m_pListaAtributos->AppendIn(idPadre, prop);
			}

			for(GIL::DICOM::TipoJerarquia::ListaJerarquias::iterator it = base.secuencias.begin(); it!=base.secuencias.end(); it++){
				wxStringProperty* prop = NULL;
				wxString helpString = wxString::FromUTF8(pDICOMManager->GetDescription((*it).tagName).c_str());
				if(helpString.size()>0){
					helpString = wxT("(") + wxString::FromUTF8((*it).tagName.c_str()) + wxT(") ") + helpString;
					prop = new wxStringProperty(helpString,
						wxPG_LABEL,wxEmptyString);
				}else{
					prop = new wxStringProperty(wxString::FromUTF8((*it).tagName.c_str()),
						wxPG_LABEL,wxEmptyString);
				}
				prop->SetHelpString(wxString::FromUTF8((*it).tagName.c_str()));
				if(m_pListaAtributos->GetProperty(prop->GetName()) != NULL) {
					////////////////////////////////////std::cout<<"hasdfasdf";
				}
				wxPGId pIdSequencia = m_pListaAtributos->AppendIn(idPadre,prop);

				//recursion
				int i=0;
				for(GIL::DICOM::TipoJerarquia::ListaJerarquias::iterator it2 = (*it).items.begin(); it2!= (*it).items.end(); it2++, i++) {
					wxPGPropArg pIdItem = m_pListaAtributos->AppendIn(pIdSequencia,new wxStringProperty(wxString::Format(wxT("Item %d"),i),wxPG_LABEL,wxEmptyString));
					SetTags((*it2),pIdItem,pDICOMManager);
				}
			}
		}

		void ParametrosPrincipales::OnChoiceFormatoDestino(wxCommandEvent &)
		{
			switch(m_pFormatoDestino->GetSelection()){
				case 0:
					m_pPanelAnonimizar->Show(true);
					m_pCheckExportarDiagnostico->Show(true);
					m_pDescripcionDiagnostico->Show(true);
					m_pPanelContenido->Show(false);
					m_pSep1->Show(false);
					m_pPanelJpeg->Show(false);
					break;
				case 1:
					m_pPanelAnonimizar->Show(false);
					m_pCheckExportarDiagnostico->Show(false);
					m_pDescripcionDiagnostico->Show(false);
					m_pPanelContenido->Show(true);
					m_pSep1->Show(true);
					m_pPanelJpeg->Show(true);
					break;
				case 2:
				case 3:
					m_pPanelAnonimizar->Show(false);
					m_pCheckExportarDiagnostico->Show(false);
					m_pDescripcionDiagnostico->Show(false);
					m_pPanelContenido->Show(true);
					m_pSep1->Show(false);
					m_pPanelJpeg->Show(false);
					break;
			}
			Layout();
		}


		//anonimizacion
		void ParametrosPrincipales::GetTagsAnonimizados(GIL::DICOM::TipoJerarquia & base)
		{
			base.tags.clear();
			for(wxPGProperty* it=m_pListaAtributos->GetFirst();it!=NULL;it=m_pListaAtributos->GetNextSiblingProperty(it)){
				if(it->IsFlagSet(wxPG_PROP_MODIFIED)){
					std::string clave(it->GetHelpString().ToUTF8());
					std::string valor(it->GetValueAsString().ToUTF8());
					base.tags[clave] = valor;
				}
			}
		}

		void ParametrosPrincipales::OnCheckAnonimizar(wxCommandEvent &){
			m_pPanelCampos->Enable(m_pCheckAnonimizar->GetValue());
			Layout();
		}

		void ParametrosPrincipales::OnCheckNombreApellidos(wxCommandEvent &){
			//se anonimiza 0010|0010 (nombre del paciente)
			std::string clave("0010|0010");
			Anonimizar(clave,m_pCheckNombrePaciente->IsChecked());
		}

		void ParametrosPrincipales::OnCheckIdPaciente(wxCommandEvent &){
			//se anonimiza 0010|0020" (id del paciente)
			std::string clave("0010|0020");
			Anonimizar(clave,m_pCheckIdPaciente->IsChecked());
		}

		void ParametrosPrincipales::OnCheckInstituciones(wxCommandEvent &){
			//se anonimiza (0008,0080) Institution Name
			std::string clave("0008|0080");
			Anonimizar(clave,m_pCheckInstituciones->IsChecked());
		}

		void ParametrosPrincipales::OnCheckComentarios(wxCommandEvent &){
			//descripcion del estudio, serie e imagenes
			//estudio
			{
				std::string clave("0008|1030");
				Anonimizar(clave,m_pCheckComentarios->IsChecked());
			}
			//serie
			{
				std::string clave("0008|103e");
				Anonimizar(clave,m_pCheckComentarios->IsChecked());
			}
			//imagen
			{
				std::string clave("0020|4000");
				Anonimizar(clave,m_pCheckComentarios->IsChecked());
			}
		}

		void ParametrosPrincipales::OnCheckConfiguracion(wxCommandEvent &){
			//se cargan los tags y se anonimizan...
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/Exportacion/TagsAnonimizacion"));
			wxString str;
			long dummy;

			bool bCont = config->GetFirstGroup(str, dummy);
			while ( bCont ) {
				config->SetPath(str);
				wxString grupo;
				wxString elemento;
				config->Read(wxT("Grupo"),&grupo,wxEmptyString);
				config->Read(wxT("Elemento"),&elemento,wxEmptyString);

				wxString wxClave = grupo + wxT("|") + elemento;
				std::string clave(wxClave.ToUTF8());

				if(clave == std::string("0010|0010")){
					m_pCheckNombrePaciente->SetValue(m_pCheckConfiguracion->IsChecked());
				}else if(clave == std::string("0010|0020")){
					m_pCheckIdPaciente->SetValue(m_pCheckConfiguracion->IsChecked());
				} else if(clave == std::string("0008|0080")){
					m_pCheckIdPaciente->SetValue(m_pCheckInstituciones->IsChecked());
				}

				Anonimizar(clave,m_pCheckConfiguracion->IsChecked());

				config->SetPath(wxT(".."));
				bCont = config->GetNextGroup(str, dummy);
			}

		}

		void ParametrosPrincipales::Anonimizar(std::string& clave, bool anonimizar)
		{
			wxString value = m_valorAnonimizado;

			if(!anonimizar){
				std::string tmp;
				if(m_base.getTag(clave,tmp)){
					value = wxString::FromUTF8(tmp.c_str());
				}
			}

			for(wxPGProperty* it=m_pListaAtributos->GetFirst();it!=NULL;it=m_pListaAtributos->GetNextSiblingProperty(it)){
				if(it->GetHelpString() == wxString::FromUTF8(clave.c_str())){
					it->SetValueFromString(value);
					if(anonimizar){
						m_pListaAtributos->SetPropertyCell(it->GetId(),0,it->GetLabel(),wxNullBitmap,*wxWHITE,*wxRED);
						m_pListaAtributos->SetPropertyCell(it->GetId(),1,it->GetValue(),wxNullBitmap,*wxWHITE,*wxRED);
					}else{
						m_pListaAtributos->SetPropertyCell(it->GetId(),0,it->GetLabel());
						m_pListaAtributos->SetPropertyCell(it->GetId(),1,it->GetValue());
					}
					it->ChangeFlag(wxPG_PROP_MODIFIED,anonimizar);
					m_pListaAtributos->RefreshProperty(it);
					return;
				}
			}
		}

		void ParametrosPrincipales::OnPropertyChanged(wxPropertyGridEvent& event) {
			if(m_pCheckAnonimizar->IsChecked()){
				wxPGProperty* selected= event.GetProperty();
				m_pListaAtributos->SetPropertyCell(selected->GetId(),0,selected->GetLabel(),wxNullBitmap,*wxWHITE,*wxRED);
				m_pListaAtributos->SetPropertyCell(selected->GetId(),1,selected->GetValue(),wxNullBitmap,*wxWHITE,*wxRED);
			} else {
				std::string clave(event.GetProperty()->GetHelpString().ToUTF8());
				Anonimizar(clave,false);
			}
		}

		void ParametrosPrincipales::OnPropertyDobleClick(wxPropertyGridEvent& event){
			if(m_pCheckAnonimizar->IsChecked()){
				std::string clave(event.GetProperty()->GetHelpString().ToUTF8());
				Anonimizar(clave,!event.GetProperty()->IsFlagSet(wxPG_PROP_MODIFIED));
			} 
		}

//region "Metodos heredados de Ipasowizard"

		void ParametrosPrincipales::Attach(wxSizer *sizer){
			Show(true);
			sizer->Add(this,10, wxEXPAND);
			this->GetParent()->Layout();
		}

		void ParametrosPrincipales::Detach(wxSizer *sizer){
			Hide();
			sizer->Detach(this);
			sizer->GetContainingWindow()->Layout();
		}

		std::string ParametrosPrincipales::GetTitle(){
			return _Std("DICOM Export");
		}

		std::string ParametrosPrincipales::GetSubTitle(){
			return _Std("Select the format and the images you want to export");
		}

		bool ParametrosPrincipales::Siguiente(){
			return true;
		}

		bool ParametrosPrincipales::Anterior(){
			return false;
		}

		bool ParametrosPrincipales::Cancelar(){
			return true;
		}

		bool ParametrosPrincipales::Validar(){
			switch(m_pFormatoDestino->GetSelection()){
				case 0:
					m_pDatosPersistentes->m_formatoDestino = DICOM;
					GetTagsAnonimizados(m_pDatosPersistentes->m_base);
					m_pDatosPersistentes->m_incluirTagsGinkgo = !m_pCheckAtributosPrivadosGinkgo->IsChecked();
					m_pDatosPersistentes->m_exportarDiagnostico = m_pCheckExportarDiagnostico->IsChecked();
					break;
				case 1:
					m_pDatosPersistentes->m_formatoDestino = JPEG;
					break;
				case 2:
					m_pDatosPersistentes->m_formatoDestino = BMP;
					break;
				case 3:
					m_pDatosPersistentes->m_formatoDestino = PNG;
					break;
				default:
					m_pDatosPersistentes->m_formatoDestino = DICOM;
			}

			if(m_pOrigen->GetSelection() == 0 ){
				m_pDatosPersistentes->m_ficheroActual=true;
			}else{
				m_pDatosPersistentes->m_ficheroActual=false;
			}

			//mapas de valoracion
			if(m_pDatosPersistentes->m_formatoDestino != DICOM) {
				for(unsigned int i = 0; i< m_pMapasCheck->GetCount(); i++) {
					std::string strTmp(m_pMapasCheck->GetString(i).ToUTF8());
					m_pDatosPersistentes->m_mapasValoracion[strTmp] = m_pMapasCheck->IsChecked(i);
				}
			}
			m_pDatosPersistentes->m_incluirWidgets = m_pIncluirWidgets->IsChecked();

			if(m_pDatosPersistentes->m_formatoDestino == JPEG){
				m_pDatosPersistentes->m_jpegCalidad = m_pSliderCalidad->GetValue();
			}

			//pillamos el directorio...
			return Seleccionardirectorio();

		}
	//endregion

		bool ParametrosPrincipales::Seleccionardirectorio()
		{
			//se pregunta al usuario donde los quiere guardar
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/Exportacion"));

			wxString wxPathDefecto;
			config->Read(wxT("PathDefecto"),&wxPathDefecto,wxT(""));
			wxDirDialog seleccionarDirectorio(this,_("Select the directory where the files will be stored"),wxPathDefecto,wxDD_DEFAULT_STYLE|wxDD_NEW_DIR_BUTTON);
			int response = seleccionarDirectorio.ShowModal();
			if (response == wxID_OK)
			{
				wxString wxPath = seleccionarDirectorio.GetPath();

				if( !wxDirExists(wxPath) ){
					wxMessageDialog dialog(NULL,_("The selected directory does not exist\nWould you like to create?"),_("Info"),wxYES_NO|wxICON_INFORMATION);
					if ( dialog.ShowModal() == wxID_NO)
					{
						return false;;
					}
					if(!wxFileName::Mkdir(wxPath)){
						wxMessageBox(_("There was an error creating directory"), _("Info"),
							wxOK | wxICON_INFORMATION, this);
						return false;
					}
				}

				m_pDatosPersistentes->m_pathDestino = TOPATH(wxPath);

				if (m_pDatosPersistentes->m_exportarDiagnostico && m_pDatosPersistentes->m_formatoDestino == GNC::GUI::DICOM) {
					GADAPI::ComandoMergeDiagnosticWithImageParams* pParams = new GADAPI::ComandoMergeDiagnosticWithImageParams(m_pDatosPersistentes->m_pathDestino, m_pDatosPersistentes->m_pVista->GetEstudio(), m_pDatosPersistentes->m_base, m_pDatosPersistentes->m_incluirTagsGinkgo, m_pDatosPersistentes->m_ficheroActual);
					GADAPI::ComandoMergeDiagnosticWithImage* pCmd = new GADAPI::ComandoMergeDiagnosticWithImage(pParams);
					GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Exporting images ..."), pCmd, m_pDatosPersistentes->m_pVista);
				} else {
					GADAPI::ComandoExportacionParams* pParams = new GADAPI::ComandoExportacionParams(m_pDatosPersistentes);
					GADAPI::ComandoExportacion* pCmd = new GADAPI::ComandoExportacion(pParams);
					GNC::GCS::ControladorComandos::Instance()->ProcessAsync(_Std("Exporting images ..."), pCmd, m_pDatosPersistentes->m_pVista);
				}

				wxConfigBase * config = wxConfigBase::Get();
				//se actualiza el fichero de configuracion
				config->SetPath(wxT("/GinkgoCore/Exportacion"));
				config->Write(wxT("PathDefecto"),wxPath);
				config->Flush();
				return true;
			} else {
				return false;
			}
		}
	};

};
