/*
 *  
 *  $Id: datospersistentesexportacion.h 3521 2011-03-16 14:54:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */

#pragma once

#include <string>
#include <vector>
#include <api/idicommanager.h>
#include <export/icontratoscore.h>

namespace GNC {
	namespace GCS {
		class IVista;
	}
}


namespace GNC {
	namespace GUI {
		typedef enum {DICOM, BMP, JPEG, PNG} FormatoDestino;

		typedef struct TipoWizardExportacion{
			std::string   m_pathDestino;

			GNC::GCS::IVista* m_pVista;
			//parametros principales
			FormatoDestino m_formatoDestino;
			bool m_ficheroActual;

			//exportacion ginkgo
			GIL::DICOM::TipoJerarquia m_base;
			bool m_incluirTagsGinkgo;
			bool m_exportarDiagnostico;

			//imagenes
			bool m_incluirWidgets;
			typedef GNC::GCS::IContratoExportacionImages::MapaMapasValoracion MapaMapasValoracion;
			MapaMapasValoracion m_mapasValoracion;

			//jpeg
			int m_jpegCalidad;
			
			TipoWizardExportacion(){
				m_pathDestino="";
				m_formatoDestino=DICOM;							
				m_incluirTagsGinkgo=true;
				m_exportarDiagnostico=true;
				m_ficheroActual=true;
				m_pVista=NULL;
				m_incluirWidgets = false;
				m_jpegCalidad = 95;
			}

			~TipoWizardExportacion(){
				m_pVista=NULL;
				m_mapasValoracion.clear();
			}

		} TipoWizardExportacion;
	}
}
