/*
 *  
 *  $Id: editordicom.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include "editordicombase.h"
#include <api/iwizard.h>
#include <api/ivista.h>
#include <api/icontroladorimportacionpacs.h>


#include <string>
#include <vector>

namespace GNC {
	namespace GUI {

		class EditorDICOM: public EditorDICOMBase
		{
			public:
				EditorDICOM(wxWindow* pParent,std::string pathActivo, GIL::DICOM::IControladorImportacionPACS* pImportacion);

				EditorDICOM(wxWindow* pParent,GIL::DICOM::TipoJerarquia& base, GIL::DICOM::IControladorImportacionPACS* pImportacion);
				~EditorDICOM();

				void GetTagsEditados(GIL::DICOM::TipoJerarquia & base);

			protected:
				std::string m_ruta;
				GIL::DICOM::TipoJerarquia m_base;
				wxString m_valorAnonimizado;


				void OnCheckAnonimizar(wxCommandEvent &event);

				void OnCheckNombreApellidos(wxCommandEvent &event);

				void OnCheckIdPaciente(wxCommandEvent &event);

				void OnCheckInstituciones(wxCommandEvent &event);

				void OnCheckComentarios(wxCommandEvent &event);

				void OnCheckConfiguracion(wxCommandEvent &event);

				void Anonimizar(std::string& clave, bool anonimizar);

				void OnPropertyChanged(wxPropertyGridEvent& event);

				void OnPropertyDobleClick(wxPropertyGridEvent& event);

		};
	};
};
