/*
 *  
 *  $Id: panelconfiguracionrenderingoptions.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>
#include <sstream>

#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <wx/confbase.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/xml/xml.h>
#include <api/internacionalizacion.h>


#include "panelconfiguracionrenderingoptions.h"

namespace GNC {
	namespace GUI {

		PanelConfiguracionRenderingOptions::PanelConfiguracionRenderingOptions(wxWindow* pParent,IDialogoConfiguracion* pDialogo): PanelConfiguracionRenderingOptionsBase(pParent), IPasoConfiguracion(pDialogo)
		{
			Recargar();
		}

		PanelConfiguracionRenderingOptions::~PanelConfiguracionRenderingOptions()
		{

		}

		void PanelConfiguracionRenderingOptions::Recargar()
		{
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/RenderingOptions"));

			bool valor;
			config->Read(wxT("VisionEstereoscopica"),&valor,false);
			m_pCheckEstereoscopica->SetValue(valor);
		}

		//region "Metodos de IPasoConfiguracion"
		wxWindow* PanelConfiguracionRenderingOptions::GetPanel()
		{
			return this;
		}

		std::string PanelConfiguracionRenderingOptions::GetTitle()
		{
			return _Std("Rendering options");
		}

		std::string PanelConfiguracionRenderingOptions::GetCabecera()
		{
			return _Std("Setting display options");
		}

		bool PanelConfiguracionRenderingOptions::Validar()
		{
			return true;
		}

		bool PanelConfiguracionRenderingOptions::Guardar()
		{
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/RenderingOptions"));

			config->Write(wxT("VisionEstereoscopica"),m_pCheckEstereoscopica->IsChecked());

			return true;
		}

		void PanelConfiguracionRenderingOptions::Exportar(wxXmlNode* pNodo)
		{
			wxXmlNode* pRenderingOptions = NULL;
			for(pRenderingOptions=pNodo->GetChildren(); pRenderingOptions!=NULL; pRenderingOptions = pRenderingOptions->GetNext()) {
				if(pRenderingOptions->GetName() == wxT("RenderingOptions")) {
					break;
				}
			}
			if(pRenderingOptions == NULL) {
				pRenderingOptions = new wxXmlNode(pNodo,wxXML_ELEMENT_NODE,wxT("RenderingOptions"));
			}

			wxXmlNode* nodo  = new wxXmlNode(pRenderingOptions,wxXML_ELEMENT_NODE,wxT("VisionEstereoscopica"));
			if(m_pCheckEstereoscopica->IsChecked()) {
				new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),wxT("TRUE"));
			} else {
				new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),wxT("FALSE"));
			}
		}

		void PanelConfiguracionRenderingOptions::Importar(wxXmlNode* pNodo)
		{
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/RenderingOptions"));
			config->DeleteEntry(wxT("VisionEstereoscopica"));

			wxXmlNode* pRenderingOptions = NULL;
			for(pRenderingOptions=pNodo->GetChildren(); pRenderingOptions!=NULL; pRenderingOptions = pRenderingOptions->GetNext()) {
				if(pRenderingOptions->GetName() == wxT("RenderingOptions")) {
					break;
				}
			}
			if(pRenderingOptions != NULL) {
				if(pRenderingOptions->GetChildren()!=NULL) {
					if(pRenderingOptions->GetChildren()->GetName() == wxT("VisionEstereoscopica"))
					{
						if(pRenderingOptions->GetChildren()->GetChildren()!=NULL) {
							config->SetPath(wxT("/GinkgoCore/RenderingOptions"));
							if(pRenderingOptions->GetChildren()->GetChildren()->GetContent() == wxT("TRUE"))
							{
								config->Write(wxT("VisionEstereoscopica"),true);
							} else {
								config->Write(wxT("VisionEstereoscopica"),false);
							}
						}
					}
				}
			}
		}
		//endregion

		void PanelConfiguracionRenderingOptions::OnSize(wxSizeEvent& event) {
			wxSize oldSize = m_staticTextExplicacion->GetSize();
			Freeze();
			m_staticTextExplicacion->Freeze();
			m_staticTextExplicacion->SetLabel(_("This option enables stereoscopic vision (must bear the graphics card and requires the use of 3D glasses)"));
			m_staticTextExplicacion->Wrap( event.GetSize().x-25 );
			m_staticTextExplicacion->Thaw();
			Thaw();
			wxSize newSize = m_staticTextExplicacion->GetSize();
			if (newSize != oldSize) {
				Layout();
				event.Skip(false);
			} else {
				event.Skip(true);
			}
		}

		void PanelConfiguracionRenderingOptions::OnCheckRendering(wxCommandEvent &)
		{
			OnPropiedadCambiada();
		}

	};

};
