/*
 *  
 *  $Id: panelconfiguracionhce.cpp 3714 2011-04-15 13:07:01Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>
#include <sstream>

#include <endpoint/endpoint.h>

#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <wx/confbase.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/log.h>
#include <wx/busyinfo.h>
#include <wx/xml/xml.h>
#include <api/internacionalizacion.h>
#include <main/controllers/xmlrpccontroller.h>

#ifndef _WIN32
#include <signal.h>
#endif

#include "panelconfiguracionhce.h"


GNC::GUI::PanelConfiguracionHCE::PanelConfiguracionHCE(wxWindow* pParent,IDialogoConfiguracion* pDialogo): PanelConfiguracionHCEBase(pParent), IPasoConfiguracion(pDialogo)
{
	Recargar();
}

GNC::GUI::PanelConfiguracionHCE::~PanelConfiguracionHCE()
{
}

void GNC::GUI::PanelConfiguracionHCE::Recargar()
{
	wxConfigBase * config = wxConfigBase::Get();
	//se actualiza el fichero de configuracion
	config->SetPath(wxT("/GinkgoCore/HCE"));

	wxString valor;
	config->Read(wxT("Environment"),&valor, wxT("SACYL"));
	if (valor.CmpNoCase(wxT("SACYL")) == 0) {
		m_pEnvironment->SetSelection(0);
	}
	else {
		m_pEnvironment->SetSelection(1);
	}

	config->Read(wxT("IDOrganizacionReceptora"),&valor,wxEmptyString);

	m_pIdOrganizacionReceptora->SetValue(valor);

	config->Read(wxT("IDSistemaPeticionario"),&valor,wxEmptyString);

	m_pIdSistemaPeticionario->SetValue(valor);

	config->Read(wxT("IDAplicacionRellenadora"),&valor,wxEmptyString);

	m_pIdAplicacionRellenadora->SetValue(valor);

	config->Read(wxT("IDGinkgoApplication"),&valor,wxT("GINKGO"));

	m_pIdGinkgoAplication->SetValue(valor);

	config->Read(wxT("HostnameMI"),&valor,wxEmptyString);

	m_pHostnameMI->SetValue(valor);

	config->Read(wxT("PuertoMI"),&valor,wxEmptyString);

	m_pPuertoMI->SetValue(valor);

	bool boolValue;
	config->Read(wxT("XMLRPCServerEnabled"),&boolValue,false);
	m_pCheckXMLRPC->SetValue(boolValue);

	config->Read(wxT("XMLRPCServerPort"),&valor,wxEmptyString);
	m_pRPCPort->SetValue(valor);
	
	m_pPortXMLPanel->Enable(m_pCheckXMLRPC->GetValue());
}

//region "Metodos de IPasoConfiguracion"
wxWindow* GNC::GUI::PanelConfiguracionHCE::GetPanel()
{
	return this;
}

std::string GNC::GUI::PanelConfiguracionHCE::GetTitle()
{
	return _Std("Electronic Medical History");
}

std::string GNC::GUI::PanelConfiguracionHCE::GetCabecera()
{
	return _Std("Setting the Electronic Health System");
}

bool GNC::GUI::PanelConfiguracionHCE::Validar()
{
	bool ok = true;
	std::stringstream sstream;

	long tmpLong;
	if (m_pPortXMLPanel->IsEnabled()) {
		if (!m_pRPCPort->GetValue().ToLong(&tmpLong)) {
			ok = false;
			sstream << _Std("You have to set a valid port") ;
		}
	} else {
		if (!m_pRPCPort->GetValue().ToLong(&tmpLong)) {
			m_pRPCPort->SetValue(wxEmptyString);
		}
	}
	if (!ok) {
		wxMessageBox(wxString::FromUTF8(sstream.str().c_str()),_("Info"),wxOK | wxICON_INFORMATION, this);
	}

	//reset xml-rpc server
	return ok;
}

bool GNC::GUI::PanelConfiguracionHCE::Guardar()
{
	wxConfigBase * config = wxConfigBase::Get();
	//se actualiza el fichero de configuracion
	config->SetPath(wxT("/GinkgoCore/HCE"));

	wxString valor;
	if (m_pEnvironment->GetSelection() == 0) {
		config->Write(wxT("Environment"), wxT("SACYL"));
	}
	else {
		config->Write(wxT("Environment"), wxT("OTHER"));
	}

	config->Write(wxT("IDOrganizacionReceptora"), m_pIdOrganizacionReceptora->GetValue());
	config->Write(wxT("IDSistemaPeticionario"), m_pIdSistemaPeticionario->GetValue());
	config->Write(wxT("IDAplicacionRellenadora"), m_pIdAplicacionRellenadora->GetValue());
	config->Write(wxT("IDGinkgoApplication"), m_pIdGinkgoAplication->GetValue());
	config->Write(wxT("HostnameMI"), m_pHostnameMI->GetValue());
	config->Write(wxT("PuertoMI"), m_pPuertoMI->GetValue());
	config->Write(wxT("XMLRPCServerEnabled"), m_pCheckXMLRPC->GetValue());
	config->Write(wxT("XMLRPCServerPort"), m_pRPCPort->GetValue());
	m_pRPCPort->Enable(m_pCheckXMLRPC->GetValue());

	if (m_pCheckXMLRPC->GetValue()) {
		GIL::XMLRPC::XMLRPCController::StartServer();
	} else {
		GIL::XMLRPC::XMLRPCController::FreeInstance();
	}
	
	return true;
}

void GNC::GUI::PanelConfiguracionHCE::Exportar(wxXmlNode* pNodo)
{
	wxXmlNode* pHCE = NULL;
	for(pHCE =pNodo->GetChildren(); pHCE!=NULL; pHCE = pHCE->GetNext()) {
		if(pHCE->GetName() == wxT("HCE")) {
			break;
		}
	}
	if(pHCE == NULL) {
		pHCE = new wxXmlNode(pNodo,wxXML_ELEMENT_NODE,wxT("HCE"));
	}

	wxXmlNode* nodo  = new wxXmlNode(pHCE,wxXML_ELEMENT_NODE,wxT("Environment"));
	if (m_pEnvironment->GetSelection() == 0) {
		new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),wxT("SACYL"));
	}
	else {
		new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),wxT("OTHER"));
	}

	nodo  = new wxXmlNode(pHCE,wxXML_ELEMENT_NODE,wxT("IDOrganizacionReceptora"));
	new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""), m_pIdOrganizacionReceptora->GetValue());

	nodo  = new wxXmlNode(pHCE,wxXML_ELEMENT_NODE,wxT("IDSistemaPeticionario"));
	new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""), m_pIdSistemaPeticionario->GetValue());

	nodo  = new wxXmlNode(pHCE,wxXML_ELEMENT_NODE,wxT("IDAplicacionRellenadora"));
	new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""), m_pIdAplicacionRellenadora->GetValue());

	nodo  = new wxXmlNode(pHCE,wxXML_ELEMENT_NODE,wxT("IDGinkgoApplication"));
	new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""), m_pIdGinkgoAplication->GetValue());

	nodo  = new wxXmlNode(pHCE,wxXML_ELEMENT_NODE,wxT("HostnameMI"));
	new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""), m_pHostnameMI->GetValue());

	nodo  = new wxXmlNode(pHCE,wxXML_ELEMENT_NODE,wxT("PuertoMI"));
	new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""), m_pPuertoMI->GetValue());

	nodo  = new wxXmlNode(pHCE,wxXML_ELEMENT_NODE,wxT("XMLRPCServerEnabled"));
	new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""), m_pCheckXMLRPC->GetValue()?wxT("true"):wxT("false"));

	nodo  = new wxXmlNode(pHCE,wxXML_ELEMENT_NODE,wxT("XMLRPCServerPort"));
	new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""), m_pRPCPort->GetValue());
}

void GNC::GUI::PanelConfiguracionHCE::Importar(wxXmlNode* pNodo)
{
	wxConfigBase * config = wxConfigBase::Get();
	//se actualiza el fichero de configuracion
	config->SetPath(wxT("/GinkgoCore/HCE"));
	config->DeleteEntry(wxT("IDOrganizacionReceptora"));
	config->DeleteEntry(wxT("IDSistemaPeticionario"));
	config->DeleteEntry(wxT("IDAplicacionRellenadora"));
	config->DeleteEntry(wxT("IDGinkgoApplication"));
	config->DeleteEntry(wxT("HostnameMI"));
	config->DeleteEntry(wxT("PuertoMI"));	
	config->DeleteEntry(wxT("XMLRPCServerEnabled"));
	config->DeleteEntry(wxT("XMLRPCServerPort"));


	wxXmlNode* pHCE = NULL;
	for(pHCE =pNodo->GetChildren(); pHCE!=NULL; pHCE = pHCE->GetNext()) {
		if(pHCE->GetName() == wxT("HCE")) {
			break;
		}
	}
	if(pHCE != NULL) {
		for(wxXmlNode* nodo = pHCE->GetChildren(); nodo!= NULL; nodo =nodo->GetNext())
		{
			if(nodo->GetChildren()!=NULL) {
				if(nodo->GetName() == wxT("Environment")) {
					config->Write(wxT("Environment"),nodo->GetChildren()->GetContent());
				}
				if(nodo->GetName() == wxT("IDOrganizacionReceptora")) {
					config->Write(wxT("IDOrganizacionReceptora"),nodo->GetChildren()->GetContent());
				}
				if(nodo->GetName() == wxT("IDSistemaPeticionario")) {
					config->Write(wxT("IDSistemaPeticionario"),nodo->GetChildren()->GetContent());
				}
				if(nodo->GetName() == wxT("IDAplicacionRellenadora")) {
					config->Write(wxT("IDAplicacionRellenadora"),nodo->GetChildren()->GetContent());
				}
				if(nodo->GetName() == wxT("IDGinkgoApplication")) {
					config->Write(wxT("IDGinkgoApplication"),nodo->GetChildren()->GetContent());
				}
				if(nodo->GetName() == wxT("HostnameMI")) {
					config->Write(wxT("HostnameMI"),nodo->GetChildren()->GetContent());
				}
				if(nodo->GetName() == wxT("PuertoMI")) {
					config->Write(wxT("PuertoMI"),nodo->GetChildren()->GetContent());
				}
				if(nodo->GetName() == wxT("XMLRPCServerEnabled")) {
					config->Write(wxT("XMLRPCServerEnabled"),pNodo->GetChildren()->GetContent()==wxT("true"));
				}
				if(nodo->GetName() == wxT("XMLRPCServerPort")) {
					config->Write(wxT("XMLRPCServerPort"),pNodo->GetChildren()->GetContent());
				}
			}
		}
	}
}

void GNC::GUI::PanelConfiguracionHCE::OnTextoCambiado(wxCommandEvent &)
{
	OnPropiedadCambiada();
}

void GNC::GUI::PanelConfiguracionHCE::OnCambioSistema(wxCommandEvent &)
{
	OnPropiedadCambiada();
}

void GNC::GUI::PanelConfiguracionHCE::OnTestClick(wxCommandEvent &)
{
	//se abre una conexión tcp al host(puerto...)
	std::string url;
	{
		std::ostringstream ostr;
		ostr << m_pHostnameMI->GetValue().ToUTF8()<< ":" << m_pPuertoMI->GetValue().ToUTF8();
		url = ostr.str();
	}
	#ifndef _WIN32
	signal(SIGPIPE, SIG_IGN);
	#endif
	EndpointAddrlist::g_default_family = AF_INET;

	Endpoint::Initialize();

	wxBusyInfo* info = new wxBusyInfo(_("Testing conectivity with the server..."));
	Endpoint ep(TCP | CLIENT, url);
	delete info;

	if (!ep) {
		wxLogError(wxString::FromUTF8(ep.m_error_str.c_str()));
		std::stringstream ostr;
		ostr << _Std("Error connecting to url") << url;
		wxMessageBox(wxString::FromUTF8(ostr.str().c_str()), _("Connection test fail"), wxICON_ERROR, this);
	} else {
		wxMessageBox(_("Connection test successful"),_("Info"),wxOK | wxICON_INFORMATION, this);
	}
	ep.Close();
}

void GNC::GUI::PanelConfiguracionHCE::OnCheckXMLRPC(wxCommandEvent&)
{
	OnPropiedadCambiada();
	m_pPortXMLPanel->Enable(m_pCheckXMLRPC->GetValue());
}

//endregion
