/*
 *  
 *  $Id: panelconfiguracionextensiones.cpp 3667 2011-04-11 08:58:02Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>
#include <sstream>
#include <limits>

#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <wx/confbase.h>
#include <wx/valtext.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/log.h>
#include <wx/busyinfo.h>
#include <wx/xml/xml.h>
#include "panelconfiguracionextensiones.h"
#include <api/internacionalizacion.h>


#include <main/entorno.h>
#include <main/controllers/controladorextensiones.h>


#define COLUMNA_EXTENSION         0
#define COLUMNA_ACTIVATED         1
#define COLUMNA_VERSION           2
#define COLUMNA_FECHA_COMPILACION 3
#define COLUMNA_PROVEEDOR         4
#define COLUMNA_DESCRIPCION       5


namespace GNC {
	namespace GUI {

		PanelConfiguracionExtensiones::PanelConfiguracionExtensiones(wxWindow* pParent,IDialogoConfiguracion* pDialogo): PanelConfiguracionExtensionesBase(pParent), IPasoConfiguracion(pDialogo)
		{
			m_hasBeenChanged = false;
			Recargar();
			m_pListaExtensiones->Connect(wxEVT_COMMAND_TREE_ITEM_ACTIVATED, wxTreeEventHandler( PanelConfiguracionExtensiones::OnActivateItem ), NULL, this );
		}

		PanelConfiguracionExtensiones::~PanelConfiguracionExtensiones()
		{
			m_pListaExtensiones->Disconnect(wxEVT_COMMAND_TREE_ITEM_ACTIVATED, wxTreeEventHandler( PanelConfiguracionExtensiones::OnActivateItem ), NULL, this );
		}

		void PanelConfiguracionExtensiones::Recargar()
		{
			m_pRutaDirectorioGlobal->SetValue(
				wxString::FromUTF8(GNC::Entorno::Instance()->GetPluginsPath().c_str()));

			m_pListaExtensiones->DeleteRoot();
			wxTreeItemId topTreeId = m_pListaExtensiones->AddRoot(wxT("Top"));

			GADVAPI::PrivateExtensionManager& mgr = GNC::ControladorExtensiones::Instance()->GetPrivateExtensionsManager();
			//mgr.Reload();

			for (GADVAPI::PrivateExtensionManager::iterator it = mgr.begin(); it != mgr.end(); it++)
			{
				wxTreeItemId extensionTreeId = m_pListaExtensiones->AppendItem(topTreeId, wxString::FromUTF8((*it).first.c_str()));

				m_pListaExtensiones->SetItemText(extensionTreeId, COLUMNA_VERSION,
					wxString::Format(wxT("%d.%d.%d"), (*it).second->GetVersion(), (*it).second->GetSubVersion(), (*it).second->GetSubRelease()) );
				m_pListaExtensiones->SetItemText(extensionTreeId, COLUMNA_FECHA_COMPILACION, wxString::FromUTF8((*it).second->GetFechaCompilacion().c_str()));
				m_pListaExtensiones->SetItemText(extensionTreeId, COLUMNA_PROVEEDOR, wxString::FromUTF8((*it).second->GetProvider().c_str()));
				m_pListaExtensiones->SetItemText(extensionTreeId, COLUMNA_DESCRIPCION, wxString::FromUTF8((*it).second->GetDescription().c_str()));
				if ((*it).second->IsActivated()) {
					m_pListaExtensiones->SetItemText(extensionTreeId, COLUMNA_ACTIVATED, _("Yes"));
				} else {
					m_pListaExtensiones->SetItemText(extensionTreeId, COLUMNA_ACTIVATED, _("No"));
				}	
				//falta la ruta
			}		
		}

		//region "Metodos de IPasoConfiguracion"
		wxWindow* PanelConfiguracionExtensiones::GetPanel()
		{
			return this;
		}

		std::string PanelConfiguracionExtensiones::GetTitle()
		{
			return _Std("Extensions");
		}

		std::string PanelConfiguracionExtensiones::GetCabecera()
		{
			return _Std("Extensions settings");
		}

		bool PanelConfiguracionExtensiones::Validar()
		{
			if(m_hasBeenChanged) {
				wxMessageBox(_("Ginkgo CADx must restart for the extensions changes to take effect"),_("Info"));
			}
			return true;
		}

		bool PanelConfiguracionExtensiones::Guardar()
		{
			return true;
		}

		void PanelConfiguracionExtensiones::Exportar(wxXmlNode* /*pNodo*/)
		{
		}

		void PanelConfiguracionExtensiones::Importar(wxXmlNode* /*pNodo*/)
		{
		}
		//endregion

		void PanelConfiguracionExtensiones::OnListaPACSChoice(wxCommandEvent &){
			//se carga la descripcion
		}

		void PanelConfiguracionExtensiones::OnShowActivationDialog(wxCommandEvent& )
		{
			ShowActivation();
		}

		void PanelConfiguracionExtensiones::OnActivateItem(wxTreeEvent &)
		{
			ShowActivation();
		}

		void PanelConfiguracionExtensiones::ShowActivation()
		{
			wxTreeItemId item = m_pListaExtensiones->GetSelection();
			if (item.IsOk()) {
				//TODO 
				bool isActivated = m_pListaExtensiones->GetItemText(item, COLUMNA_ACTIVATED) == _("Yes");

				std::string sid(m_pListaExtensiones->GetItemText(item).ToUTF8());
				GADVAPI::PrivateExtensionManager& mgr = GNC::ControladorExtensiones::Instance()->GetPrivateExtensionsManager();
				PrivateExtension* prvExt = mgr.GetExtension(sid);
				if (prvExt == NULL) {
					return;
				}
				prvExt->ShowActivationDialog(this);
				bool newState = prvExt->IsActivated();
				if (newState) {
					m_pListaExtensiones->SetItemText(item, COLUMNA_ACTIVATED, _("Yes"));
				} else {
					m_pListaExtensiones->SetItemText(item, COLUMNA_ACTIVATED, _("No"));
				}
				if (newState != isActivated) {
					m_hasBeenChanged = true;
					IPasoConfiguracion::OnPropiedadCambiada();
				}
			}
		}	

		void PanelConfiguracionExtensiones::OnSize(wxSizeEvent & event){
			wxSize oldSize = m_staticTextExplicacion->GetSize();
			Freeze();
			m_staticTextExplicacion->Freeze();
			m_staticTextExplicacion->SetLabel(_("The functional extensions are plugins that perform advanced procedures."));
			m_staticTextExplicacion->Wrap( event.GetSize().x-25 );
			m_staticTextExplicacion->Thaw();
			Thaw();
			wxSize newSize = m_staticTextExplicacion->GetSize();
			if (newSize != oldSize) {
				Layout();
				event.Skip(false);
			} else {
				event.Skip(true);
			}			
		}
	}
}
