/*
 *  
 *  $Id: panelconfiguracionestacion.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <vector>

#include <wx/checkbox.h>
#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/dirdlg.h>
#include <wx/filename.h>
#include <wx/confbase.h>
#include <sstream>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/xml/xml.h>
#include <api/internacionalizacion.h>
#include <wx/ginkgostyle/ginkgostyle.h>

#include "panelconfiguracionestacion.h"

#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorvistas.h>
#include <main/controllers/controladorcomandos.h>
#include <main/gui/history/ipanelhistorial.h>
#include <main/entorno.h>
#include <api/icontroladorinternacionalizacion.h>

namespace GNC {
	namespace GUI {

		PanelConfiguracionEstacion::PanelConfiguracionEstacion(wxWindow* pParent,IDialogoConfiguracion* pDialogo): PanelConfiguracionEstacionBase(pParent), IPasoConfiguracion(pDialogo)
		{
			Recargar();
			Layout();
		}

		PanelConfiguracionEstacion::~PanelConfiguracionEstacion()
		{

		}

		void PanelConfiguracionEstacion::Recargar()
		{
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/Estacion"));

			wxString valor;
			config->Read(wxT("NombreMedico"),&valor,wxEmptyString);
			m_pMedicoNombre->SetValue(valor);

			config->Read(wxT("IdMedico"),&valor,wxEmptyString);
			m_pMedicoId->SetValue(valor);

			config->Read(wxT("NombreServicio"),&valor,wxEmptyString);
			m_pServicioNombre->SetValue(valor);

			config->Read(wxT("IdServicio"),&valor,wxEmptyString);
			m_pServicioId->SetValue(valor);

			config->Read(wxT("CentroNombre"),&valor,wxEmptyString);
			m_pCentroNombre->SetValue(valor);

			config->Read(wxT("CentroId"),&valor,wxEmptyString);
			m_pCentroId->SetValue(valor);
		}

		//region "Metodos de IPasoConfiguracion"
		wxWindow* PanelConfiguracionEstacion::GetPanel()
		{
			return this;
		}

		std::string PanelConfiguracionEstacion::GetTitle()
		{
			return _Std("Workstation");
		}

		std::string PanelConfiguracionEstacion::GetCabecera()
		{
			return _Std("Configuration parameters of the local station");
		}

		bool PanelConfiguracionEstacion::Validar()
		{
			return true;
		}

		bool PanelConfiguracionEstacion::Guardar()
		{
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/Estacion"));

			config->Write(wxT("IdMedico"),m_pMedicoId->GetValue());
			config->Write(wxT("NombreMedico"),m_pMedicoNombre->GetValue());

			config->Write(wxT("IdServicio"),m_pServicioId->GetValue());
			config->Write(wxT("NombreServicio"),m_pServicioNombre->GetValue());

			config->Write(wxT("CentroNombre"),m_pCentroNombre->GetValue());

			config->Write(wxT("CentroId"),m_pCentroId->GetValue());

			return true;
		}
		//endregion


		void PanelConfiguracionEstacion::OnTextoCambiado(wxCommandEvent &)
		{
			if(IsShown()){
				OnPropiedadCambiada();
			}
		}

		void PanelConfiguracionEstacion::Exportar(wxXmlNode* pRaiz)
		{
			wxXmlNode* pEstacion = NULL;
			for(pEstacion =pRaiz->GetChildren(); pEstacion!=NULL; pEstacion = pEstacion->GetNext()) {
				if(pEstacion->GetName() == wxT("Estacion")) {
					break;
				}
			}
			if(pEstacion == NULL) {
				pEstacion = new wxXmlNode(pRaiz,wxXML_ELEMENT_NODE,wxT("Estacion"));
			}

			wxXmlNode* nodo  = new wxXmlNode(pEstacion,wxXML_ELEMENT_NODE,wxT("IdMedico"));
			new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),m_pMedicoId->GetValue());

			nodo  = new wxXmlNode(pEstacion,wxXML_ELEMENT_NODE,wxT("NombreMedico"));
			new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),m_pMedicoNombre->GetValue());

			nodo  = new wxXmlNode(pEstacion,wxXML_ELEMENT_NODE,wxT("IdServicio"));
			new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),m_pServicioId->GetValue());

			nodo  = new wxXmlNode(pEstacion,wxXML_ELEMENT_NODE,wxT("NombreServicio"));
			new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),m_pServicioNombre->GetValue());

			nodo  = new wxXmlNode(pEstacion,wxXML_ELEMENT_NODE,wxT("CentroNombre"));
			new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),m_pCentroNombre->GetValue());

			nodo  = new wxXmlNode(pEstacion,wxXML_ELEMENT_NODE,wxT("CentroId"));
			new wxXmlNode(nodo,wxXML_TEXT_NODE,wxT(""),m_pCentroId->GetValue());
		}

		void PanelConfiguracionEstacion::Importar(wxXmlNode* pRaiz)
		{
			wxXmlNode* pEstacion = NULL;
			for(pEstacion =pRaiz->GetChildren(); pEstacion!=NULL; pEstacion = pEstacion->GetNext()) {
				if(pEstacion->GetName() == wxT("Estacion")) {
					break;
				}
			}

			if(pEstacion != NULL) {
				wxConfigBase * config = wxConfigBase::Get();
				//se actualiza el fichero de configuracion
				config->SetPath(wxT("/GinkgoCore/Estacion"));
				config->DeleteEntry(wxT("IdMedico"));
				config->DeleteEntry(wxT("NombreMedico"));
				config->DeleteEntry(wxT("IdServicio"));
				config->DeleteEntry(wxT("NombreServicio"));
				config->DeleteEntry(wxT("CentroNombre"));
				config->DeleteEntry(wxT("CentroId"));

				for(wxXmlNode* pNodo = pEstacion->GetChildren(); pNodo!= NULL; pNodo =pNodo->GetNext())
				{
					config->SetPath(wxT("/GinkgoCore/Estacion"));
					if(pNodo->GetChildren()!=NULL){
						if(pNodo->GetName() == wxT("NombreMedico")) {
							config->Write(wxT("NombreMedico"),pNodo->GetChildren()->GetContent());
						}
						if(pNodo->GetName() == wxT("IdMedico")) {
							config->Write(wxT("IdMedico"),pNodo->GetChildren()->GetContent());
						}
						if(pNodo->GetName() == wxT("CentroNombre")) {
							config->Write(wxT("CentroNombre"),pNodo->GetChildren()->GetContent());
						}
						if(pNodo->GetName() == wxT("IdServicio")) {
							config->Write(wxT("IdServicio"),pNodo->GetChildren()->GetContent());
						}
						if(pNodo->GetName() == wxT("NombreServicio")) {
							config->Write(wxT("NombreServicio"),pNodo->GetChildren()->GetContent());
						}
						if(pNodo->GetName() == wxT("CentroId")) {
							config->Write(wxT("CentroId"),pNodo->GetChildren()->GetContent());
						}
					}
				}
			}
		}
	}
}
