/*
 *  
 *  $Id: panelconfiguracionanonimizacion.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/confbase.h>
#include <vector>
#include <sstream>
#include <wx/valtext.h>
#include <wx/xml/xml.h>
#include <api/internacionalizacion.h>

#include "panelconfiguracionanonimizacion.h"


namespace GNC {
	namespace GUI {
		class DialogoAddTag : public DialogoAddTagBase{
		public:
			DialogoAddTag(wxWindow* pParent):DialogoAddTagBase(pParent){
				InicializaValidadores();
			}

			DialogoAddTag(wxWindow* pParent, wxString grupo, wxString elemento):DialogoAddTagBase(pParent){
				InicializaValidadores();
				m_pGrupo->SetValue(grupo);
				m_pElemento->SetValue(elemento);
			}

			void InicializaValidadores(){
				wxTextValidator OnlyNum = wxTextValidator(wxFILTER_INCLUDE_CHAR_LIST);
				wxArrayString arr;
				arr.push_back(wxT("0"));
				arr.push_back(wxT("1"));
				arr.push_back(wxT("2"));
				arr.push_back(wxT("3"));
				arr.push_back(wxT("4"));
				arr.push_back(wxT("5"));
				arr.push_back(wxT("6"));
				arr.push_back(wxT("7"));
				arr.push_back(wxT("8"));
				arr.push_back(wxT("9"));
				arr.push_back(wxT("A"));
				arr.push_back(wxT("B"));
				arr.push_back(wxT("C"));
				arr.push_back(wxT("D"));
				arr.push_back(wxT("E"));
				arr.push_back(wxT("F"));
				arr.push_back(wxT("a"));
				arr.push_back(wxT("b"));
				arr.push_back(wxT("c"));
				arr.push_back(wxT("d"));
				arr.push_back(wxT("e"));
				arr.push_back(wxT("f"));
				OnlyNum.SetIncludes(arr);
				m_pGrupo->SetValidator(OnlyNum);
				m_pElemento->SetValidator(OnlyNum);
			}

			~DialogoAddTag(){}

			wxString GetGrupo(){
				wxString grupo = m_pGrupo->GetValue().Upper();
				while(grupo.size()<4){
					grupo = wxT("0") + grupo;
				}
				return grupo;
			}

			wxString GetElemento(){
				wxString elemento = m_pElemento->GetValue().Upper();
				while(elemento.size()<4){
					elemento = wxT("0") + elemento;
				}
				return elemento;
			}

			void OnAceptarClick(wxCommandEvent &event){
				if(m_pElemento->GetValue().size() == 0 || m_pGrupo->GetValue().size() == 0 ){
					wxMessageBox(_("Fill the fields to continue."), _("Info"),
						 wxOK | wxICON_INFORMATION, this);
					event.Skip(false);
				} else {
					EndModal(wxID_OK);
				}
			}

		};

		PanelConfiguracionAnonimizacion::PanelConfiguracionAnonimizacion(wxWindow* pParent,IDialogoConfiguracion* pDialogo):PanelConfiguracionAnonimizacionBase(pParent),IPasoConfiguracion(pDialogo)
		{
			Recargar();
		}

		void PanelConfiguracionAnonimizacion::Recargar()
		{
			while(m_pListaCampos->GetCount()>0) {
				m_pListaCampos->Delete(0);
			}
			//se cargan los servidores desde el fichero de configuracion
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/Exportacion/TagsAnonimizacion"));
			wxString str;
			long dummy;

			bool bCont = config->GetFirstGroup(str, dummy);
			while ( bCont ) {
				config->SetPath(str);
				wxString grupo;
				wxString elemento;
				config->Read(wxT("Grupo"),&grupo,wxEmptyString);
				config->Read(wxT("Elemento"),&elemento,wxEmptyString);

				m_pListaCampos->AppendString(grupo + wxT("|") + elemento);

				config->SetPath(wxT(".."));
				bCont = config->GetNextGroup(str, dummy);
			}

			config->SetPath(wxT("/GinkgoCore/Exportacion/"));
			wxString valor;
			config->Read(wxT("ValorDefectoAnonimizacion"),&valor,wxEmptyString);
			m_pValorDefecto->SetValue(valor);
		}

		PanelConfiguracionAnonimizacion::~PanelConfiguracionAnonimizacion()
		{

		}

		//region "Metodos de IPasoConfiguracion"
		wxWindow* PanelConfiguracionAnonimizacion::GetPanel()
		{
			return this;
		}

		std::string PanelConfiguracionAnonimizacion::GetTitle()
		{
			return _Std("Anonymization Options");
		}

		std::string PanelConfiguracionAnonimizacion::GetCabecera()
		{
			return _Std("Setting tags on export will be anonymized");
		}

		bool PanelConfiguracionAnonimizacion::Validar()
		{
			return true;
		}

		bool PanelConfiguracionAnonimizacion::Guardar()
		{
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->DeleteGroup(wxT("/GinkgoCore/Exportacion/TagsAnonimizacion"));
			config->SetPath(wxT("/GinkgoCore/Exportacion/TagsAnonimizacion"));
			int i=0;

			wxArrayString campos = m_pListaCampos->GetStrings();

			for(wxArrayString::iterator it =campos.begin(); it!=campos.end(); it++,i++){
				wxString grupo = (*it).SubString(0,(*it).find_first_of(wxT("|"))-1);
				wxString elemento = (*it).SubString((*it).find_first_of(wxT("|"))+1,(*it).size()-1);

				wxString clave = wxString::Format(wxT("Tag%d/Grupo"),i);
				config->Write(clave,grupo);
				clave = wxString::Format(wxT("Tag%d/Elemento"),i);
				config->Write(clave,elemento);
			}

			config->SetPath(wxT("/GinkgoCore/Exportacion/"));
			wxString valor;
			config->Write(wxT("ValorDefectoAnonimizacion"),m_pValorDefecto->GetValue());

			return true;
		}
		//endregion

		void PanelConfiguracionAnonimizacion::OnListBoxClick(wxCommandEvent &){
			int seleccionado = m_pListaCampos->GetSelection();
			m_pBotonEliminar->Enable(seleccionado>=0);
			m_pBotonModificar->Enable(seleccionado>=0);
		}

		void PanelConfiguracionAnonimizacion::OnListBoxDClick(wxCommandEvent &event){
			OnModificarClick(event);
		}

		void PanelConfiguracionAnonimizacion::OnAddClick(wxCommandEvent &)
		{
			DialogoAddTag dlg(this);
			int answer = dlg.ShowModal();
			if(answer == wxID_OK){
				wxString grupo = dlg.GetGrupo();
				wxString elemento = dlg.GetElemento();
				m_pListaCampos->AppendString(grupo + wxT("|") + elemento);
				OnPropiedadCambiada();
			}

		}

		void PanelConfiguracionAnonimizacion::OnEliminarClick(wxCommandEvent &)
		{
			int seleccionado = m_pListaCampos->GetSelection();
			if(seleccionado>=0){
				int answer = wxMessageBox(_("Are you sure to delete the tag") + m_pListaCampos->GetString(m_pListaCampos->GetSelection()) + wxString::FromUTF8("?"), _("Data modified"), wxYES_NO | wxCANCEL, this);
				if(answer == wxYES){
					m_pListaCampos->Delete(seleccionado);
					seleccionado--;
					if(seleccionado>=0){
						m_pListaCampos->Select(seleccionado);
					} else {
						if(m_pListaCampos->GetCount()>0){
							m_pListaCampos->Select(0);
						}
					}
					OnPropiedadCambiada();
				}
			}
		}

		void PanelConfiguracionAnonimizacion::OnModificarClick(wxCommandEvent &)
		{
			int seleccionado = m_pListaCampos->GetSelection();
			if(seleccionado>=0){
				wxString wxStr =  m_pListaCampos->GetString(seleccionado);
				wxString grupo = wxStr.SubString(0,wxStr.find_first_of(wxT("|"))-1);
				wxString elemento = wxStr.SubString(wxStr.find_first_of(wxT("|"))+1,wxStr.size()-1);

				DialogoAddTag dlg(this,grupo,elemento);
				int answer = dlg.ShowModal();
				if(answer == wxID_OK){
					grupo = dlg.GetGrupo();
					elemento = dlg.GetElemento();
					m_pListaCampos->SetString(seleccionado,grupo + wxT("|") + elemento);
					OnPropiedadCambiada();
				}
			}
		}

		void PanelConfiguracionAnonimizacion::OnValorAnonimizarDefecto(wxCommandEvent &)
		{
			OnPropiedadCambiada();
		}

		void PanelConfiguracionAnonimizacion::Exportar(wxXmlNode* pNodo)
		{
			wxXmlNode* pExportacion = NULL;
			for(pExportacion =pNodo->GetChildren(); pExportacion!=NULL; pExportacion = pExportacion->GetNext()) {
				if(pExportacion->GetName() == wxT("Exportacion")) {
					break;
				}
			}
			if(pExportacion == NULL) {
				pExportacion = new wxXmlNode(pNodo,wxXML_ELEMENT_NODE,wxT("Exportacion"));
			}

			wxXmlNode* pTagsAnonimizacion = NULL;
			for(pTagsAnonimizacion =pExportacion->GetChildren(); pTagsAnonimizacion!=NULL; pTagsAnonimizacion = pTagsAnonimizacion->GetNext()) {
				if(pTagsAnonimizacion->GetName() == wxT("TagsAnonimizacion")) {
					break;
				}
			}
			if(pTagsAnonimizacion == NULL) {
				pTagsAnonimizacion = new wxXmlNode(pExportacion,wxXML_ELEMENT_NODE,wxT("TagsAnonimizacion"));
			}

			wxArrayString campos = m_pListaCampos->GetStrings();

			for(wxArrayString::iterator it =campos.begin(); it!=campos.end(); it++){
				wxString grupo = (*it).SubString(0,(*it).find_first_of(wxT("|"))-1);
				wxString elemento = (*it).SubString((*it).find_first_of(wxT("|"))+1,(*it).size()-1);

				wxXmlNode* pTag = new wxXmlNode(pTagsAnonimizacion,wxXML_ELEMENT_NODE,wxT("Tag"));
				pTag->AddProperty(wxT("Grupo"),grupo);
				pTag->AddProperty(wxT("Elemento"),elemento);
			}

			wxXmlNode* pValorDefectoAnonimizacion = NULL;
			for(pValorDefectoAnonimizacion =pExportacion->GetChildren(); pValorDefectoAnonimizacion!=NULL; pValorDefectoAnonimizacion = pValorDefectoAnonimizacion->GetNext()) {
				if(pValorDefectoAnonimizacion->GetName() == wxT("ValorDefectoAnonimizacion")) {
					break;
				}
			}
			if(pValorDefectoAnonimizacion == NULL) {
				pValorDefectoAnonimizacion = new wxXmlNode(pNodo,wxXML_ELEMENT_NODE,wxT("ValorDefectoAnonimizacion"));
			}
			if(pValorDefectoAnonimizacion->GetChildren() == NULL) {
				new wxXmlNode(pValorDefectoAnonimizacion,wxXML_TEXT_NODE,wxT(""),m_pValorDefecto->GetValue());
			} else {
				pValorDefectoAnonimizacion->GetChildren()->SetContent(m_pValorDefecto->GetValue());
			}
		}


		void PanelConfiguracionAnonimizacion::Importar(wxXmlNode* pNodo)
		{
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/Exportacion/"));
			config->DeleteEntry(wxT("ValorDefectoAnonimizacion"));
			config->DeleteGroup(wxT("/GinkgoCore/Exportacion/TagsAnonimizacion"));
			config->SetPath(wxT("/GinkgoCore/Exportacion/TagsAnonimizacion"));

			wxXmlNode* pExportacion = NULL;
			for(pExportacion =pNodo->GetChildren(); pExportacion!=NULL; pExportacion = pExportacion->GetNext()) {
				if(pExportacion->GetName() == wxT("Exportacion")) {
					break;
				}
			}
			if(pExportacion == NULL) {
				return;
			}

			wxXmlNode* pTagsAnonimizacion = NULL;
			for(pTagsAnonimizacion =pExportacion->GetChildren(); pTagsAnonimizacion!=NULL; pTagsAnonimizacion = pTagsAnonimizacion->GetNext()) {
				if(pTagsAnonimizacion->GetName() == wxT("TagsAnonimizacion")) {
					break;
				}
			}
			if(pTagsAnonimizacion != NULL) {
				int i=0;
				for(wxXmlNode* pTag=pTagsAnonimizacion->GetChildren(); pTag!=NULL; pTag = pTag->GetNext(),i++) {
					wxString grupo;
					pTag->GetPropVal(wxT("Grupo"),&grupo);
					wxString elemento;
					pTag->GetPropVal(wxT("Elemento"),&elemento);

					wxString clave = wxString::Format(wxT("Tag%d/Grupo"),i);
					config->Write(clave,grupo);
					clave = wxString::Format(wxT("Tag%d/Elemento"),i);
					config->Write(clave,elemento);
				}
			}

			wxXmlNode* pValorDefectoAnonimizacion = NULL;
			for(pValorDefectoAnonimizacion =pExportacion->GetChildren(); pValorDefectoAnonimizacion!=NULL; pValorDefectoAnonimizacion = pValorDefectoAnonimizacion->GetNext()) {
				if(pValorDefectoAnonimizacion->GetName() == wxT("ValorDefectoAnonimizacion")) {
					break;
				}
			}
			if(pValorDefectoAnonimizacion != NULL) {
				config->SetPath(wxT("/GinkgoCore/Exportacion/"));
				wxString valor;
				if(pValorDefectoAnonimizacion->GetChildren()!=NULL){
					config->Write(wxT("ValorDefectoAnonimizacion"),pValorDefectoAnonimizacion->GetChildren()->GetContent());
				}
			}
		}
	};
};
