/*
 *  
 *  $Id: dialogoconfiguracion.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/msgdlg.h>
#include <wx/msgout.h>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/confbase.h>
#include <wx/xml/xml.h>
#include <wx/sstream.h>
#include <wx/filedlg.h>
#include <api/internacionalizacion.h>

#include "dialogoconfiguracion.h"
#include "panelconfiguracionestacion.h"
#include "panelconfiguracionhce.h"
#include "panelconfiguracionpacs.h"
#include "panelconfiguracionanonimizacion.h"
#include "panelconfiguracionrenderingoptions.h"
#include "panelconfiguracionextensiones.h"
#include "panelconfiguracionpermisos.h"
#include "panelconfiguracionseguridad.h"
#include "panelconfiguracionubicaciones.h"
#include "panelconfiguraciongeneral.h"

#include <main/entorno.h>
#include <main/controllers/controladorvistas.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorpermisos.h>

#include <resources/ginkgoresourcemanager.h>

#include <wx/ginkgostyle/ginkgostyle.h>

#include <vector>
#include <sstream>

namespace GNC {
	namespace GUI {

		DialogoConfiguracion::DialogoConfiguracion(wxWindow* pParent):DialogoConfiguracionBase(pParent)
		{
			wxTreeItemId raiz = m_pTreeNavegacion->AddRoot(wxT("raiz"));
			wxTreeItemId ginkgo = m_pTreeNavegacion->AppendItem(raiz,wxT("Ginkgo"));

			//se añade el primer paso de ginkgo
			wxTreeItemId primerId;
			IPasoConfiguracion* pPaso = new PanelConfiguracionGeneral(m_pPanelConfig,this);;
			pPaso->GetPanel()->Hide();
			wxTreeItemId id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
			m_MapaPasos[id.m_pItem] = pPaso;

			primerId = id;

			pPaso = new PanelConfiguracionEstacion(m_pPanelConfig,this);
			pPaso->GetPanel()->Hide();
			id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
			m_MapaPasos[id.m_pItem] = pPaso;

			pPaso = new PanelConfiguracionHCE(m_pPanelConfig,this);
			pPaso->GetPanel()->Hide();
			id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
			m_MapaPasos[id.m_pItem] = pPaso;

			pPaso = new PanelConfiguracionPACS(m_pPanelConfig,this);
			pPaso->GetPanel()->Hide();
			id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
			m_MapaPasos[id.m_pItem] = pPaso;

/*			DE MOMENTO NO SE AÑADE PORQUE NO HAY OPCIONES DE RENDERIZADO QUE SE APLIQUEN
			pPaso = new PanelConfiguracionRenderingOptions(m_pPanelConfig,this);
			pPaso->GetPanel()->Hide();
			id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
			m_MapaPasos[id.m_pItem] = pPaso;
			*/

			pPaso = new PanelConfiguracionAnonimizacion(m_pPanelConfig,this);
			pPaso->GetPanel()->Hide();
			id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
			m_MapaPasos[id.m_pItem] = pPaso;

			pPaso = new PanelConfiguracionExtensiones(m_pPanelConfig,this);
			pPaso->GetPanel()->Hide();
			id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
			m_MapaPasos[id.m_pItem] = pPaso;

			pPaso = new PanelConfiguracionPermisos(m_pPanelConfig,this);
			pPaso->GetPanel()->Hide();
			id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
			m_MapaPasos[id.m_pItem] = pPaso;

			if (GNC::GCS::ControladorPermisos::Instance()->Get("core.seguridad","setup_security"))
			{
				pPaso = new PanelConfiguracionSeguridad(m_pPanelConfig,this);
				pPaso->GetPanel()->Hide();
				id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
				m_MapaPasos[id.m_pItem] = pPaso;
			}

			pPaso = new PanelConfiguracionUbicaciones(m_pPanelConfig,this);
			pPaso->GetPanel()->Hide();
			id = m_pTreeNavegacion->AppendItem(ginkgo,wxString::FromUTF8(pPaso->GetTitle().c_str()));
			m_MapaPasos[id.m_pItem] = pPaso;

			m_currentPaso = NULL;
			m_pTreeNavegacion->SelectItem(primerId);
			m_pBAplicar->Enable(false);

			CargarCurrent();

			Layout();
		}

		DialogoConfiguracion::~DialogoConfiguracion()
		{

		}

		void DialogoConfiguracion::CargarCurrent()
		{
			wxTreeItemId id = m_pTreeNavegacion->GetSelection();
			if(id.IsOk()){
				if(m_MapaPasos.find(id.m_pItem) != m_MapaPasos.end()){
					IPasoConfiguracion* pCurrent = m_MapaPasos[id.m_pItem];
					if( pCurrent!=NULL && pCurrent!=m_currentPaso){
						Freeze();
						if(m_currentPaso!=NULL){
							if(!m_currentPaso->Validar()){
								if(m_pTreeNavegacion->GetSelection() != id){
									m_pTreeNavegacion->SelectItem(id);
								}
								Thaw();
								return;
							}
							m_currentPaso->GetPanel()->Hide();
							m_pSizerPaneles->Detach(m_currentPaso->GetPanel());
						}
						m_currentPaso = pCurrent;
						m_currentPaso->GetPanel()->Show();
						m_pSizerPaneles->Add(m_currentPaso->GetPanel(),10, wxEXPAND|wxALL, 10);
						m_pTitledPanelConfig->SetTitle(wxString::FromUTF8(m_currentPaso->GetCabecera().c_str()));

						m_pPanelConfig->Layout();
						m_pPanelConfig->SetScrollbars(20, 20, 50, 50, 0, 0, false);
						m_pPanelConfig->AdjustScrollbars();
						m_pTitledPanelConfig->Layout();
						Thaw();					
					}
				}
			}
		}

		void DialogoConfiguracion::OnPropiedadCambiada()
		{
			if(!m_pBAplicar->IsEnabled()) {
				m_pBAplicar->Enable();
			}
		}

		void DialogoConfiguracion::OnCancelarClick(wxCommandEvent &)
		{
			Close();
		}

		void DialogoConfiguracion::OnAceptarClick(wxCommandEvent &)
		{
			if(m_pBAplicar->IsEnabled()){
				bool validar=true;
				for(MapaPasos::iterator it = m_MapaPasos.begin(); it != m_MapaPasos.end(); it++){
					validar = validar && (*it).second->Validar();
				}

				if(validar){
					for(MapaPasos::iterator it = m_MapaPasos.begin(); it != m_MapaPasos.end(); it++){
						(*it).second->Guardar();
					}

					wxConfigBase::Get()->Flush();

					GNC::GCS::ControladorVistas* pC = GNC::GCS::ControladorVistas::Instance();
					if (pC != NULL) {
						pC->PropagarConfiguracionCambiada();
					}
					m_pBAplicar->Disable();
					Close();
				}
			} else {
				Close();
			}
		}

		void DialogoConfiguracion::OnAplicarClick(wxCommandEvent &)
		{
			bool validar=true;
			for(MapaPasos::iterator it = m_MapaPasos.begin(); it != m_MapaPasos.end(); it++){
				validar = validar && (*it).second->Validar();
			}

			if(validar){
				for(MapaPasos::iterator it = m_MapaPasos.begin(); it != m_MapaPasos.end(); it++){
					(*it).second->Guardar();
				}

				wxConfigBase::Get()->Flush();

				GNC::GCS::ControladorVistas* pC = GNC::GCS::ControladorVistas::Instance();
				if (pC != NULL) {
					pC->PropagarConfiguracionCambiada();
				}
				m_pBAplicar->Disable();
			}
		}

		void DialogoConfiguracion::OnCambioNodoNavegacion(wxTreeEvent &){
			CargarCurrent();
		}

		void DialogoConfiguracion::OnExportarClick(wxCommandEvent &)
		{
			wxFileDialog seleccionarFichero (this, _("Export Configuration"), wxT(""), wxT(""), _("XML Files(*.xml)|*.xml"),wxFD_SAVE);
			int response = seleccionarFichero.ShowModal();
			if (response == wxID_OK) {
				if(wxFileExists(seleccionarFichero.GetPath())) {
					response = wxMessageBox(_("File exists\nWould you like to overwrite it?"), _("Existing file"), wxYES_NO | wxCANCEL,this);
					if(response != wxYES) {
						return;
					}
				}

				wxXmlNode* nodoRaiz = new wxXmlNode(NULL,wxXML_ELEMENT_NODE,wxT("ginkgo_config"));

				for(MapaPasos::iterator it = m_MapaPasos.begin(); it != m_MapaPasos.end(); it++){
					(*it).second->Exportar(nodoRaiz);
				}
				wxXmlDocument documento;
				documento.SetFileEncoding(wxT("UTF-8"));
				documento.SetRoot(nodoRaiz);
				if(!documento.Save(seleccionarFichero.GetPath())) {
					wxMessageBox(_("Failed to save the file"),_("Error"),wxOK,this);
				}

				wxMessageBox(_("Export successfully completed"),_("Info"),wxOK,this);
			}
		}

		void DialogoConfiguracion::OnImportarClick(wxCommandEvent &)
		{
			wxFileDialog seleccionarFichero (this, _("Import Configuration"), wxT(""), wxT(""), _("XML Files(*.xml)|*.xml"),wxFD_FILE_MUST_EXIST|wxFD_OPEN);
			int response = seleccionarFichero.ShowModal();
			if (response == wxID_OK) {
				wxXmlDocument documento;
				if(!documento.Load(seleccionarFichero.GetPath())) {
					wxMessageBox(_("There was an error loading the file"),_("Error"),wxOK,this);
					return;
				}
				if(documento.GetRoot()->GetName() != wxT("ginkgo_config")) {
					wxMessageBox(_("The xml format is not correct"),_("Error"),wxOK,this);
					return;
				}

				for(MapaPasos::iterator it = m_MapaPasos.begin(); it != m_MapaPasos.end(); it++){
					(*it).second->Importar(documento.GetRoot());
				}

				wxConfigBase::Get()->Flush();

				for(MapaPasos::iterator it = m_MapaPasos.begin(); it != m_MapaPasos.end(); it++){
					(*it).second->Recargar();
				}

				GNC::GCS::ControladorVistas* pC = GNC::GCS::ControladorVistas::Instance();
				if (pC != NULL) {
					pC->PropagarConfiguracionCambiada();
				}
				m_pBAplicar->Disable();

				wxMessageBox(_("Import successfully completed"),_("Information"),wxOK,this);
			}
		}

	}

}
