/*
 *  
 *  $Id: dialogoadquisicion.h 3653 2011-04-06 08:35:25Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <string>
#include <list>
#include <yasper/yasper.h>
#include <api/icontroladormodulo.h>
#include <api/imodelointegracion.h>
#include <api/icontroladoreventos.h>

#include <main/controllers/controladorimportacionpacs.h>
#include <commands/comandopacs.h>

#include "dialogoadquisicionbase.h"

class IModeloDicom;
class wxAnimationCtrl;

namespace Descargas {
	class DescargasGridTable;
}

namespace GNC {

	namespace GUI {

		class DialogoAdquisicion: public DialogoAdquisicionBase, public GADAPI::PACS::IComandoPACSNotificador, public GNC::GCS::IObservador
		{
			public:
				static DialogoAdquisicion* Instance();
				static void FreeInstance();

				DialogoAdquisicion(wxWindow* pParent);
				~DialogoAdquisicion();

				virtual bool Show(bool show = true);

			//---------------------------------------------------------------------------
			//region Eventos de interfaz
				virtual void OnPACSChanged(wxTreeEvent & event);
				virtual void OnKeyDownFormulario( wxKeyEvent& event );
				virtual void OnFechaDesdeDateChanged( wxDateEvent& event );
				virtual void OnFechaHastaDateChanged( wxDateEvent& event );
				virtual void OnBusquedaClick( wxCommandEvent& event );
				virtual void OnCancelClick( wxCommandEvent& event);
				std::string GetModalities();
				virtual void OnLimpiarClick( wxCommandEvent& event );
				virtual void OnIniciarPararTasksClick( wxCommandEvent& event );
				virtual void OnDeleteTasksClick( wxCommandEvent& event );
				virtual void OnOpenTasksClick( wxCommandEvent& event );
				virtual void OnClearTasksClick( wxCommandEvent& event );
				virtual void OnCloseClick( wxCommandEvent& event );
				virtual void OnDescargarClick( wxCommandEvent& event);

				virtual void OnTreeSelChanged(wxTreeEvent& event);
				virtual void OnTreeItemActivated(wxTreeEvent& event);
				virtual void OnTreeItemMenu(wxTreeEvent& event);
				virtual void OnTreeItemExpanded(wxTreeEvent& event);
				virtual void OnTreeBeginDrag(wxTreeEvent& event);

				void UpdateButtons();
			
				virtual void OnGridSelect(wxGridRangeSelectEvent& event);
				virtual void OnGridKeyDown(wxKeyEvent& event);
				virtual void OnGridDClick(wxGridEvent& event);
				virtual void OnGridMenu(wxGridEvent& event);
				virtual void OnGridSize( wxSizeEvent& event );

			//---------------------------------------------------------------------------
			//region Helpers
			void AutoSizeGrid();
			std::string GetServerSeleccionado();
			void AddDescarga(bool lanzarBusqueda);
			void ShowProperties();
			void ShowAnimation(bool show);

			void LimpiarBusquedas(bool lock = true);
			//endregion

			//---------------------------------------------------------------------------
			//region realizacion de la interfaz IComandoPACSNotificador
				virtual void PACSCargarListado(IModeloDicom *);
			//endregion

				//para enterarse si ha parado un comando...
			virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);
				//

			private:
				static DialogoAdquisicion* m_pInstance;

				wxString m_SelectedPACS;
				
				wxAnimationCtrl* m_pAnimation;

				GIL::DICOM::ContextoResultado* m_pResultado;
				wxImageList*                   m_pImageList;
				GADAPI::ComandoPACS*           m_pComandoPACS;
				wxTreeItemId                   m_lastExpanded;
				GnkPtr<IModeloDicom>           m_pModeloDicom;

				std::string m_HardCodedPatientId;
				bool        m_HardCodedPatientSearch;

				bool        m_SizeRestriction;
				bool        m_SizeOK;

				bool         m_AutoAddSeries;     // Indica que se auto-anyadiran a las descargas todas las series del proximo despliegue
				wxTreeItemId m_AutoAddSeriesItem; // Elemento desplegado sobre el que se auto-anyadira

				typedef enum TDialogMode
				{
					TD_SERIES,
					TD_STUDIES
				}TDialogMode;
				TDialogMode m_Mode;

				Descargas::DescargasGridTable* m_pDescargasGridTable;
				GNC::GCS::ILockable m_TreeListResultadosLocker; // Necesario para evitar problemas con el treelistcontrol.

				typedef std::vector<wxCheckBox*>  TModalitiesVector;
				TModalitiesVector m_modalitiesList;

		};
	}
}
