/*
 *  
 *  $Id: ifiltro.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "ifiltro.h"
#include "filtros.h"
#include <api/internacionalizacion.h>
#include <api/icontextoestudio.h>
//------------------------------------------------------------------------------------------

#define ID_F_MRIBIAS        0
#define ID_F_MEDIANA        1
#define ID_F_GAUSSIANO      2
#define ID_F_CURVATUREFLOW  3
#define ID_F_SOBEL          4
#define ID_F_AUTONIVELES    5
#define ID_F_PEGADO		    6

GNC::IFiltrosManager::IFiltrosManager() {

	// Categorias
	m_Categorias[0] = _Std("Correction");
	m_Categorias[1] = _Std("Smooth");
	m_Categorias[2] = _Std("Edges");
	m_Categorias[3] = _Std("Levels");

	// Filtros de tipo corrector
	//m_Filtros.push_back(TipoFiltro(ID_F_MRIBIAS, 0, "Corrector de tendencia MRI (MRI Bias Correction)", "Correccion de tendencia en Imagenes de Resonancia Magnetica"));

	// Filtros de tipo suavizado (orden 1)
	m_Filtros.push_back(TipoFiltro(ID_F_MEDIANA, 1, _Std("Median 3x3"), _Std("Median smooth filter")));
	m_Filtros.push_back(TipoFiltro(ID_F_GAUSSIANO, 1, _Std("Gaussian 3x3"), _Std("Gaussian smooth filter")));
	m_Filtros.push_back(TipoFiltro(ID_F_CURVATUREFLOW, 1, _Std("Curvature Flow"), _Std("Edge preserving smooth filter")));

	// Filtros de tipo borde (orden 2)
	m_Filtros.push_back(TipoFiltro(ID_F_SOBEL, 2,  _Std("Sobel edges 3x3"), _Std("Sobel filter 3x3")));

	// Filtros de acondicionamiento luminico
	m_Filtros.push_back(TipoFiltro(ID_F_AUTONIVELES, 3,  _Std("Auto Levels"), _Std("Histogram equalization")));

}

GNC::IFiltrosManager::~IFiltrosManager()
{

}

GNC::IFiltrosManager::ListaFiltros& GNC::IFiltrosManager::GetListaFiltros()
{
	return m_Filtros;
}

GNC::IFiltrosManager::MapaCategorias& GNC::IFiltrosManager::GetMapaCategorias()
{
	return m_Categorias;
}

GNC::IFiltro* GNC::IFiltrosManager::CrearFiltro(long id)
{
	switch (id) {
		case ID_F_MRIBIAS:
			return new GNC::FiltroMRIBias();
		case ID_F_MEDIANA:
			return new GNC::FiltroMediana();
		case ID_F_GAUSSIANO:
			return new GNC::FiltroGaussiano();
		case ID_F_CURVATUREFLOW:
			return new GNC::FiltroCurvatureFlow();
		case ID_F_SOBEL:
			return new GNC::FiltroSobel();
		case ID_F_AUTONIVELES:
			return new GNC::FiltroAutoNiveles();
		default:
			return new GNC::FiltroNulo();
	}
}

void GNC::IFiltrosManager::DestruirFiltro(GNC::IFiltro* pFiltro)
{
	delete pFiltro;
}
