/*
 *  
 *  $Id: filtros.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "filtros.h"

#include <cmath>

#include <vtkPointData.h>
#include <itkExceptionObject.h>
#include <itkImageRegionIterator.h>
#include <itkMRIBiasFieldCorrectionFilter.h>
#include <itkMedianImageFilter.h>
#include <itkDiscreteGaussianImageFilter.h>
#include <itkCurvatureFlowImageFilter.h>
#include <itkSobelEdgeDetectionImageFilter.h>
#include <itkScalarImageToHistogramGenerator.h>
#include <itkCastImageFilter.h>
#include <itkImageFileWriter.h>
#include <api/icontextoestudio.h>
//#include <AVL.h>
#include <math.h>
#include <api/icontroladorcomandos.h>

//funciones utiles
inline long double Log (long double d, float dBase)
{
  return (log (d) / log ((long double) dBase));
}
//

GNC::FiltroNulo::TImagenITKIntensidad3D::Pointer GNC::FiltroMRIBias::ProcesarImagen(GNC::FiltroNulo::TImagenITKIntensidad3D::Pointer imagen)
{
	return imagen;
}


//-----------------------------------------------------------------------

GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer GNC::FiltroMediana::ProcesarImagen(GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer imagen)
{
	typedef itk::MedianImageFilter<GNC::FiltroNulo::TImagenITKIntensidad2D, GNC::FiltroNulo::TImagenITKIntensidad2D> TFiltroMedianaImagenIntensidad;

	TFiltroMedianaImagenIntensidad::Pointer filtro = TFiltroMedianaImagenIntensidad::New();
	filtro->SetInput(imagen);

	GNC::FiltroNulo::TImagenITKIntensidad2D::SizeType radio;
	radio[0] = 1;
	radio[1] = 1;

	filtro->SetRadius(radio);
	filtro->Update();
	return filtro->GetOutput();
}

//-----------------------------------------------------------------------

GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer GNC::FiltroGaussiano::ProcesarImagen(GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer imagen)
{
	typedef itk::DiscreteGaussianImageFilter<GNC::FiltroNulo::TImagenITKIntensidad2D, GNC::FiltroNulo::TImagenITKIntensidad2D> TFiltroGaussianoImagenIntensidad;


	TFiltroGaussianoImagenIntensidad::Pointer filtro = TFiltroGaussianoImagenIntensidad::New();
	filtro->SetInput(imagen);
	filtro->SetVariance(0.5f);
	filtro->SetUseImageSpacingOff();
	filtro->Update();

	return filtro->GetOutput();
}

//-----------------------------------------------------------------------

GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer GNC::FiltroCurvatureFlow::ProcesarImagen(GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer imagen)
{
	typedef itk::CurvatureFlowImageFilter<GNC::FiltroNulo::TImagenITKIntensidad2D, GNC::FiltroNulo::TImagenITKIntensidad2D> TFiltroCurvatureFlowIntensidad;

	TFiltroCurvatureFlowIntensidad::Pointer filtro = TFiltroCurvatureFlowIntensidad::New();
	filtro->SetInput(imagen);

	filtro->SetNumberOfIterations( 10 );
	filtro->SetTimeStep( 0.125f );

	filtro->Update();
	return filtro->GetOutput();
}

//-----------------------------------------------------------------------

GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer GNC::FiltroSobel::ProcesarImagen(GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer imagen)
{
	typedef itk::SobelEdgeDetectionImageFilter<GNC::FiltroNulo::TImagenITKIntensidad2D, GNC::FiltroNulo::TImagenITKIntensidad2D> TFiltroSobelIntensidad;


	TFiltroSobelIntensidad::Pointer filtro = TFiltroSobelIntensidad::New();
	filtro->SetInput(imagen);

	filtro->Update();
	return filtro->GetOutput();
}

//-----------------------------------------------------------------------

GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer GNC::FiltroAutoNiveles::ProcesarImagen(GNC::FiltroNulo::TImagenITKIntensidad2D::Pointer imagen)
{
	/* Deprecated
	typedef itk::Statistics::ScalarImageToHistogramGenerator<GNC::FiltroNulo::TImagenITKIntensidad2D> HistogramGeneratorType;
	typedef HistogramGeneratorType::HistogramType HistogramType;
	typedef itk::ImageRegionIterator<GNC::FiltroNulo::TImagenITKIntensidad2D> ImageIterator;

	const float  dPercentil = 0.005f;
	float clrRngDest = 0.0f;
	float clrRgnStart = 0.0f;
	unsigned int numColores = 0;

	int ctype = m_pImagen->GetScalarType();
	if (ctype == VTK_UNSIGNED_SHORT) {
		clrRngDest = 65535.0f;
		numColores = 65536;
	}
	else if (ctype == VTK_SHORT) {
		clrRngDest = 32767.0f;
		clrRgnStart = -32767.0f;
		numColores = 65536;
	}
	else if (ctype == VTK_UNSIGNED_CHAR) {
		clrRngDest = 255;
		numColores = 256;
	}
	else if (ctype == VTK_CHAR) {
		clrRngDest = 127.0f;
		clrRgnStart = -127.0f;
		numColores = 256;
	}
	else {
		std::cerr << "El Filtro de niveles automaticos no tiene implementado soportepara el tipo de componente de la imagen. Accion ignorada." << std::endl;
		return imagen;
	}

	ImageIterator it (imagen, imagen->GetLargestPossibleRegion());

	for(it.GoToBegin(); !it.IsAtEnd(); ++it) { // Normaliza entre 0.0f y 1.0f
		GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType pixel = it.Get();
		pixel = (pixel - clrRgnStart) / (clrRngDest - clrRgnStart);
		it.Set(pixel);
	}

	/ *
	 GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType media;
	 GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType varianza;

	 GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType sumas;
	 GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType sumasCuadrado;

	 float numPixels = 0.0f;

	 for(it.GoToBegin(); !it.IsAtEnd(); ++it) {
	 GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType pixel = it.Get();
	 sumas += pixel;
	 sumasCuadrado += pixel * pixel;
	 numPixels += 1.0f;
	 }
	 media = sumas / numPixels;
	 varianza = (sumasCuadrado / numPixels)  - (media*media);

	 std::cout << "Media = " << media << std::endl;
	 std::cout << "Varianza = " << varianza << std::endl;
	 * /

	HistogramGeneratorType::Pointer histogramGenerator = HistogramGeneratorType::New();
	histogramGenerator->SetNumberOfBins( numColores );
	//histogramGenerator->SetMarginalScale( 10.0 );

	histogramGenerator->SetInput(imagen);
	histogramGenerator->Compute();

	const HistogramType *histogram = histogramGenerator->GetOutput();
	HistogramType::ConstIterator ith;

	GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType clrMinOrig;
	GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType clrMaxOrig;
	//GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType clrMed;
	GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType clrRngOrig = 1.0f;
	GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType clrGamma   = 1.0f;

	// Calcula los factores de escala y el valor gamma

	// Calcula el percentil inferior
	const float dMin = histogram->Quantile(0, dPercentil);

	// Calcula la mediana
	const float dMed = histogram->Quantile(0, 0.5f);

	// Calcula el percentil superior
	const float dMax = histogram->Quantile(0, 1.0f - dPercentil);

	if (dMax > dMin)
	{
		// Calcula el valor del gamma
		float  dGamma = Log(0.5f, (dMed - dMin) / (dMax - dMin));
		if (dGamma <  0.1f) dGamma =  0.1f;
		if (dGamma > 10.0f) dGamma = 10.0f;
		clrGamma = dGamma;
		clrRngOrig = dMax - dMin;
	}

	clrMinOrig = dMin;
	clrMaxOrig = dMax;

	// Escala los datos
	for(it.GoToBegin(); !it.IsAtEnd(); ++it) {
		GNC::FiltroNulo::TImagenITKIntensidad2D::PixelType  pixel = it.Get();

		// Normaliza el valor del pixel
		const float p = clrRgnStart + (clrRngDest - clrRgnStart) * pow((pixel - clrMinOrig) / clrRngOrig, clrGamma);
		//pixel = std::min(std::max(clrRgnStart, p), clrRngDest);
		pixel	= p;
		it.Set(pixel);
	}
	/ *
	 typedef itk::Image<unsigned short> TImageOut;
	 typedef itk::CastImageFilter<GNC::FiltroNulo::TImagenITKIntensidad2D, TImageOut> TCastImageFilter;
	 typedef itk::ImageFileWriter<TCastImageFilter::OutputImageType> TWriter;

	 TCastImageFilter::Pointer c = TCastImageFilter::New();
	 TWriter::Pointer w = TWriter::New();

	 c->SetInput(imagen);
	 w->SetInput(c->GetOutput());
	 w->SetFileName("/tmp/foobar.png");
	 w->Update();
	 * /
	*/
	return imagen;
}

GNC::FiltroNulo::TImagenITKRGB2D::Pointer GNC::FiltroAutoNiveles::ProcesarImagen(TImagenITKRGB2D::Pointer imagen)
{
	/*AVL_Imagen<AVL_Color_Gris_601_1> img;

	img.LeerBMP("/tmp/test_autoniveles.bmp");
	img.NivelesAutomaticos();
	img.GuardarBMP("/tmp/test_autoniveles_out.bmp");*/
	return NULL;
}

GNC::FiltroNulo::TImagenITKRGB3D::Pointer GNC::FiltroAutoNiveles::ProcesarImagen(TImagenITKRGB3D::Pointer imagen)
{
	/*AVL_Imagen<AVL_Color_Gris_601_1> img;

	img.LeerBMP("/tmp/test_autoniveles.bmp");
	img.NivelesAutomaticos();
	img.GuardarBMP("/tmp/test_autoniveles_out.bmp");*/
	return NULL;
}

//-----------------------------------------------------------------------

/*
void GNC::FiltroPegado::Procesar(IVista * pVista){
	if(pVista == NULL){
		return;
	}
	GNC::GUI::wxWidzardPegadoGinkgo dlg(GNC::Entorno::Instance()->GetVentanaRaiz(), pVista);
	dlg.ShowModal();
	if(dlg.IsOK()){
		//se pilla el directorio destino y los tags dicom
		std::string pathSeleccionado = dlg.GetPathDestino();
		GIL::DICOM::TipoJerarquia base = dlg.GetTagsDicom();


		//lanzamos el comando....
		vtkImageData* pImagenOriginal;
		vtkImageData* pImagenChroma;
		int slice = 0;
		pVista->AsignarConexionesDeFiltrado(&pImagenOriginal, &slice,&pImagenChroma);
		try{
			GADAPI::ComandoPegadoParams* pPegadoParams = new GADAPI::ComandoPegadoParams(pImagenOriginal,pImagenChroma,base,pathSeleccionado,GNC::Entorno::Instance());
			GADAPI::ComandoPegado* pPegadoCmd = new GADAPI::ComandoPegado(pPegadoParams);
			GNC::Entorno::Instance()->GetControladorComandos()->ProcessAsync(std::string("Pegado de imagenes..."),pPegadoCmd,NULL);

			wxMessageBox(wxT("El comando de pegado se ejecutara en segundo plano"),wxT("Info Pegado"),wxOK | wxICON_INFORMATION, GNC::Entorno::Instance()->GetVentanaRaiz());
		} catch (GADAPI::PegadoParamsException &ex){
			wxString message = wxString::FromUTF8(ex.GetMensage().c_str());
			wxMessageBox(message,wxT("Info Pegado"),wxOK | wxICON_INFORMATION, GNC::Entorno::Instance()->GetVentanaRaiz());
		}

	}
}*/
