/*
 *
 *  $Id: entorno.cpp 3787 2011-04-29 06:38:01Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <string>
#include <sstream>
#include <wx/filename.h>
#include <wx/dir.h>
#include <wx/stdpaths.h>
#include <wx/confbase.h>

#include <main/licencia.h>

#include "entorno.h"

#include <api/icontextoestudio.h>
#include <api/imodelointegracion.h>
#include <api/aetwildcards.h>
#include <api/internacionalizacion.h>

#include <main/controllers/controladorimportacionpacs.h>
#include <main/controllers/controladorvistas.h>
#include <main/controllers/controladorcomandos.h>
#include <main/controllers/controladorherramientas.h>
#include <main/controllers/controladoreventos.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorcarga.h>
#include <main/controllers/controladorpermisos.h>
#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladoracciones.h>
#include <main/controllers/controladorinternacionalizacion.h>
#include <main/managers/widgetsmanager.h>


#include <dcmtk/dcmjpeg/djdecode.h>
#include <dcmtk/dcmjpeg/djencode.h>
#include <dcmtk/dcmdata/dcrledrg.h>
#include <dcmtk/dcmdata/dcrleerg.h>

// Definicion de variables static
#define GINKGO_LOCALAET    "GINKGO_%IP4"

//helper
bool RemoveTempDir(const wxString& dirPath)
{
	//borra en cascada
	if(!wxRmdir(dirPath)){
		//vaciar
		wxDir dir;
		if (dir.Open(dirPath)) {
			wxString fileName;
			bool cont = dir.GetFirst(&fileName);
			while (cont) {
				fileName=dir.GetName()+ wxFileName::GetPathSeparator(wxPATH_NATIVE) +fileName;
				if(wxDir::Exists(fileName)){
					if (RemoveTempDir(fileName)) {
						cont = dir.GetFirst(&fileName);
					} else {
						cont = dir.GetNext(&fileName);
					}
				}else{
					if (wxRemoveFile(fileName)) {
						cont = dir.GetFirst(&fileName);
					} else {
						cont = dir.GetNext(&fileName);
					}
				}
			}
		}
	}
	if(wxDir::Exists(dirPath)){
		return wxRmdir(dirPath);
	}
	return true;
}

GNC::Entorno* GNC::Entorno::m_pInstancia = NULL;

GNC::Entorno::Entorno()
{
	DJEncoderRegistration::registerCodecs();
	DJDecoderRegistration::registerCodecs();

	DcmRLEEncoderRegistration::registerCodecs();
	DcmRLEDecoderRegistration::registerCodecs();

	m_pApp = NULL;
	m_pVentanaPrincipal = NULL;
	m_pVentanaRaiz = NULL;
	m_pPanelHerramientasSuperior = NULL;
	m_pSizerHerramientas = NULL;
	m_pSizerOpcionesHerramientas = NULL;
	
	m_isChildInstance = false;
	
	std::ostringstream os;
	os << GINKGO_VERSION << "." << GINKGO_SUB_VERSION << "." << GINKGO_SUB_RELEASE << " " << GINKGO_CODENAME;

	m_GinkgoVersion = os.str();

	m_GinkgoCopyRight = GINKGO_COPYRIGHT;
	
	wxFileName executable_path = wxStandardPaths::Get().GetExecutablePath();
	//executable_path.SetFullName(wxEmptyString);
	
	wxString pluginsDir;
	wxString langDir;
	
	#if defined(_WINDOWS) || defined(LINUX)
		pluginsDir = executable_path.GetPath() + wxFileName::GetPathSeparator() + wxT("Plugins");
		langDir = executable_path.GetPath() + wxFileName::GetPathSeparator() + wxT("lang");
		
	#else
		pluginsDir = wxStandardPaths::Get().GetPluginsDir();
		langDir = wxStandardPaths::Get().GetResourcesDir() + wxFileName::GetPathSeparator() + wxT("lang");
		
	#endif
	
	
	
	m_GinkgoPluginsDir = TOPATH(pluginsDir);
	m_GinkgoLanguageDir = TOPATH(langDir);
	
	//std::cout << "PLUGINS_DIR = " << m_GinkgoPluginsDir.c_str() << std::endl;
	//std::cout << "LANGUAGE_DIR = " << m_GinkgoLanguageDir.c_str() << std::endl;

	wxString wxTempDir = wxStandardPaths::Get().GetTempDir() + wxFileName::GetPathSeparator() + wxT("GinkgoCADx");
	m_GinkgoTempDir = TOPATH(wxTempDir);
	if (!wxDirExists(wxTempDir)) {
		#ifdef _WIN32
		wxMkdir(wxTempDir,511);
		#else
		wxMkDir(wxTempDir.ToUTF8(), 0770);
		#endif
	}
	
	m_GinkgoUserDir = TOPATH(wxStandardPaths::Get().GetUserDataDir());
	
	{
		wxString directorioUser = FROMPATH(m_GinkgoUserDir);
		//se crea el user dir
		if(!wxDirExists(directorioUser)) {
			#ifdef _WIN32
			wxMkdir(directorioUser,511);
			#else
			wxMkDir(directorioUser.ToUTF8(), 0770);
			#endif
		}
	}

	// Carga de ubicaciones
	wxConfigBase * config = wxConfigBase::Get();

	config->SetPath(wxT("/GinkgoCore/Locations"));
	wxString str;

	long dummy = 0;

	bool bCont = config->GetFirstGroup(str, dummy);
	while ( bCont ) {
		config->SetPath(str);
		config->Read(wxT("Title"),&str);
		std::string titulo(str.ToUTF8());
		config->Read(wxT("Path"),&str);
		std::string path(str.ToUTF8());
		config->Read(wxT("Description"),&str);
		std::string descr(str.ToUTF8());

		m_Ubicaciones[titulo] = GIL::Ubicacion(titulo, path, descr);

		config->SetPath(wxT(".."));
		bCont = config->GetNextGroup(str, dummy);
	}

	// Refrescar Dicom dir

	RefrescarDicomDir();


}

GNC::Entorno::~Entorno()
{
	DJEncoderRegistration::cleanup();
	DJDecoderRegistration::cleanup();

	DcmRLEEncoderRegistration::cleanup();
	DcmRLEDecoderRegistration::cleanup();

	ObservadoresExtensiones.clear();
	ObservadoresVistas.clear();

	//remove temp dir
	if (!m_isChildInstance) {
		RemoveTempDir(FROMPATH(m_GinkgoTempDir));	
	}

	m_ModelosIntegracion.clear();
	m_pApp = NULL;
	m_pVentanaPrincipal = NULL;
	m_pVentanaRaiz = NULL;
	m_pPanelHerramientasSuperior = NULL;
	m_pSizerHerramientas = NULL;
	m_pSizerOpcionesHerramientas = NULL;

}

GNC::Entorno* GNC::Entorno::Instance()
{
	if (m_pInstancia == NULL) {
		m_pInstancia = new GNC::Entorno();
	}
	return m_pInstancia;
}

void GNC::Entorno::FreeInstance()
{
	if (m_pInstancia != NULL) {
		delete m_pInstancia;
	}
	m_pInstancia = NULL;
}

const std::string GNC::Entorno::GetGinkgoRegisteredUser()
{
	return GINKGO_REGISTERED_USER;
}

const std::string GNC::Entorno::GetGinkgoRegisteredOrganization()
{
	return GINKGO_REGISTERED_ORGANIZATION;
}

const std::string& GNC::Entorno::GetGinkgoVersion()
{
	return m_GinkgoVersion;
}

void GNC::Entorno::GetGinkgoVersionAsTuple(int* version, int* subversion, int* release, int* build, std::string* codename)
{
	if (version != NULL) {
		*version = GINKGO_VERSION;
	}
	if (subversion != NULL) {
		*subversion = GINKGO_SUB_VERSION;
	}
	if (release != NULL) {
		*release = GINKGO_SUB_RELEASE;
	}
	if (build != NULL) {
		*build = GINKGO_BUILD;
	}
	if (codename != NULL) {
		*codename = GINKGO_CODENAME;
	}
}

const std::string& GNC::Entorno::GetGinkgoCopyRight()
{
	return m_GinkgoCopyRight;
}

std::string GNC::Entorno::GetGinkgoDicomDir(bool barraAlFinal)
{
	if(barraAlFinal) {
		std::ostringstream out;
		out << m_GinkgoDicomDir << (char) wxFileName::GetPathSeparator(wxPATH_NATIVE);
		return out.str();
	} else {
		return m_GinkgoDicomDir;
	}
}

void GNC::Entorno::RefrescarDicomDir()
{
	wxString valor;
	//se lee de la configuracion
	wxConfigBase * config = wxConfigBase::Get();
	//se actualiza el fichero de configuracion

	if(config == NULL || !config->Read(wxT("/GinkgoCore/Estacion/DicomDir"),&valor))
	{
		std::ostringstream out;
		out << GetGinkgoUserDir() << (char) wxFileName::GetPathSeparator(wxPATH_NATIVE) << "DICOMDIR";
		m_GinkgoDicomDir = out.str();
	} else {
		m_GinkgoDicomDir = TOPATH(valor);
	}
}

std::string GNC::Entorno::GetPathAbsolutoFichero(const std::string& pathRelativo)
{
	std::ostringstream out;
	out << GetGinkgoDicomDir(true) << pathRelativo;
	return out.str();
}

std::string GNC::Entorno::GetPathRelativoFichero(const std::string& pathAbsoluto)
{
	wxFileName fileName(FROMPATH(pathAbsoluto));
	fileName.MakeRelativeTo(FROMPATH(GetGinkgoDicomDir()));
	return std::string(TOPATH(fileName.GetFullPath()));
}

const std::string& GNC::Entorno::GetGinkgoTempDir()
{
	return m_GinkgoTempDir;
}
const std::string& GNC::Entorno::GetGinkgoLanguageDir()
{
	return m_GinkgoLanguageDir;
}

std::string GNC::Entorno::CrearDirectorioTemporal()
{
	wxString dirTmp;
	do {
		std::ostringstream ostr;
		ostr << GetGinkgoTempDir() << (char)wxFileName::GetPathSeparator() << "_gnktmp_" << rand();
		dirTmp = FROMPATH(ostr.str());
	} while (wxDirExists(dirTmp));

	#if defined(_WINDOWS)
	wxMkDir(dirTmp);
	#else
	wxMkDir(dirTmp.ToUTF8(), 0770);
	#endif

	std::string resultado(TOPATH(dirTmp));
	return resultado;
}

const std::string& GNC::Entorno::GetPluginsPath()
{
	return m_GinkgoPluginsDir;
}

const std::string& GNC::Entorno::GetGinkgoUserDir()
{
	return m_GinkgoUserDir;
}

std::string GNC::Entorno::GetDicomLocalAET()
{
	wxConfigBase * config = wxConfigBase::Get();
	//se actualiza el fichero de configuracion
	config->SetPath(wxT("/GinkgoCore/PACS/Local"));
	wxString valor;
	config->Read(wxT("AET"),&valor,wxT(GINKGO_LOCALAET));
	std::string localAET(valor.ToUTF8());

	return ParseAET(localAET);
}

std::string GNC::Entorno::ParseAET(const std::string& AET)
{
	return GNC::GCS::AETWildcards::Parse(AET);
}

wxApp* GNC::Entorno::GetApp()
{
	return m_pApp;
}

void GNC::Entorno::YieldApp()
{
	//DEPRECATED
	//m_pApp->Yield();
}


void GNC::Entorno::SetApp(wxApp* app)
{
	m_pApp = app;
}

VentanaPrincipal* GNC::Entorno::GetVentanaPrincipal()
{
	return m_pVentanaPrincipal;
}

void GNC::Entorno::SetVentanaPrincipal(VentanaPrincipal* ventana)
{
	m_pVentanaPrincipal = ventana;
}

wxWindow* GNC::Entorno::GetVentanaRaiz()
{
	return m_pVentanaRaiz;
}

void GNC::Entorno::SetVentanaRaiz(wxWindow* ventana)
{
	m_pVentanaRaiz = ventana;
}

wxPanel* GNC::Entorno::GetPanelHerramientasSuperior()
{
	return m_pPanelHerramientasSuperior;
}

void GNC::Entorno::SetPanelHerramientasSuperior(wxPanel* panel)
{
	m_pPanelHerramientasSuperior = panel;
}

wxSizer* GNC::Entorno::GetSizerHerramientas()
{
	return m_pSizerHerramientas;
}

void GNC::Entorno::SetSizerHerramientas(wxSizer* sizer)
{
	m_pSizerHerramientas = sizer;
}

wxSizer* GNC::Entorno::GetSizerHerramientasOpciones()
{
	return m_pSizerOpcionesHerramientas;
}

void GNC::Entorno::SetSizerHerramientasOpciones(wxSizer* sizer)
{
	m_pSizerOpcionesHerramientas = sizer;
}

GNC::GCS::IControladorComandos* GNC::Entorno::GetControladorComandos()
{
	return GNC::GCS::ControladorComandos::Instance();
}

GNC::GCS::IControladorHerramientas* GNC::Entorno::GetControladorHerramientas()
{
	return GNC::ControladorHerramientas::Instance();
}

GIL::DICOM::IControladorImportacionPACS* GNC::Entorno::GetControladorImportacionPACS()
{
	return GIL::DICOM::ControladorImportacionPACS::Instance();
}

GNC::GCS::IControladorVistas* GNC::Entorno::GetControladorVistas()
{
	return GNC::GCS::ControladorVistas::Instance();
}

GNC::GCS::IControladorEventos* GNC::Entorno::GetControladorEventos()
{
	return GNC::GCS::ControladorEventos::Instance();
}

GNC::GCS::IControladorCarga* GNC::Entorno::GetControladorCarga()
{
	return GNC::GCS::ControladorCarga::Instance();
}

GNC::GCS::IControladorPermisos* GNC::Entorno::GetControladorPermisos()
{
	return GNC::GCS::ControladorPermisos::Instance();
}

GNC::GCS::IControladorLog* GNC::Entorno::GetControladorLog()
{
	return GNC::GCS::ControladorLog::Instance();
}

GNC::GCS::IControladorExtensiones* GNC::Entorno::GetControladorExtensiones()
{
	return GNC::ControladorExtensiones::Instance();
}

GNC::GCS::IControladorHistorial* GNC::Entorno::GetControladorHistorial()
{
	return GNC::GCS::ControladorHistorial::Instance();
}

GNC::GCS::IControladorAcciones* GNC::Entorno::GetControladorAcciones()
{
	return GNC::GCS::ControladorAcciones::Instance();
}

GNC::GCS::IControladorInternacionalizacion* GNC::Entorno::GetControladorInternacionalizacion()
{
	return GNC::GCS::ControladorInternacionalizacion::Instance();
}

GNC::GCS::IWidgetsManager* GNC::Entorno::NewWidgetsManager(GNC::GCS::IVista* pVista)
{
	return new GNC::WidgetsManager(pVista);
}

void GNC::Entorno::FreeWidgetsManager(GNC::GCS::IWidgetsManager* pManager)
{
	if (pManager != NULL) {
		delete pManager;
	}
}
