/*
 *  
 *  $Id: parserxmlspanish.cpp 3720 2011-04-15 13:39:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <string>
#include <map>
#include <ctime>
#include <sstream>

#include <wx/xml/xml.h>
#include <wx/file.h>
#include <wx/sstream.h>
#include <wx/msgdlg.h>
#ifndef _WIN32
#include <signal.h>
#endif
#include <wx/tokenzr.h>
#include <wx/config.h>
#include <wx/filename.h>
#include <api/internacionalizacion.h>

#include "parserxmlspanish.h"
#include <api/globals.h>
#include <api/imodelohl7.h>
#include <api/icontroladormodulo.h>
#include <api/icontroladorhl7.h>
#include <api/iguiasmensajeriasacyl.h>
#include <api/aetwildcards.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorlog.h>
#include <main/entorno.h>
#include "dcmtk/dicomservers.h"

//creacion de la base de datos de mensajes
GIL::HL7::ParserXMLSpanish::ParserXMLSpanish()
{
}

GIL::HL7::ParserXMLSpanish::~ParserXMLSpanish()
{
}

//region "Interfaz generica"

std::string GIL::HL7::ParserXMLSpanish::GetKey()
{
	return "getcontextresult";
}

/* Parsea la cadena XML y construye el modelo de integracion. Los parametros no encontrados se asignan por defecto segun lo especificado en la configuracion global */
void GIL::HL7::ParserXMLSpanish::ParseIntegrationXML(GNC::GCS::IEntorno::ListaModelosIntegracion& models, wxXmlNode* pRoot) 
{
	std::string xpp; // XML Pretty Printed for extended information info.
	if (pRoot->GetName().CmpNoCase(wxT("getcontextresult")) == 0) {

		wxString propVal;
		typedef std::map<std::string, GIL::IModeloPACSServer> MapaServers;

		MapaServers servers;

		// PreCargamos la lista de PACS de la configuracion
		for (DicomServerHolder* sl = DicomServerList::Instance()->GetList(); sl != NULL; sl = sl->next) {
			IModeloPACSServer pacs;
			pacs.sid = sl->server.ID;
			pacs.AET = sl->server.AET;
			pacs.hostname = sl->server.HostName;
			pacs.puerto = sl->server.Port;

			servers[pacs.sid] = pacs;
		}
		//

		// Parseamos los PACS especificados por fichero
		for (wxXmlNode* nodo = pRoot->GetChildren(); nodo != NULL; nodo = nodo->GetNext()) {
			if (nodo->GetName().CmpNoCase(wxT("pacs")) == 0) { // Configuracion de PACS
				GIL::IModeloPACSServer pacsServer;

				propVal = nodo->GetPropVal(wxT("sid"), wxEmptyString);
				if( !propVal.empty() ) {
					pacsServer.sid = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("Omitted Identificator"), xpp, "CONF/pacs");
				}

				propVal = nodo->GetPropVal(wxT("aet"), wxEmptyString);
				if( !propVal.empty() ) {
					pacsServer.AET = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("Omitted AET"), xpp, "CONF/pacs");
				}

				propVal = nodo->GetPropVal(wxT("hostname"), wxEmptyString);
				if( !propVal.empty() ) {
					pacsServer.hostname = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("Hostname missing"), xpp, "CONF/pacs");
				}

				propVal = nodo->GetPropVal(wxT("puerto"), wxEmptyString);
				if( !propVal.empty() ) {
					pacsServer.puerto = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("Omitted port"), xpp, "CONF/pacs");
				}
				
				propVal = nodo->GetPropVal(wxT("tls"), wxEmptyString);
				if( propVal.CmpNoCase(wxT("yes")) == 0 || propVal.CmpNoCase(wxT("true")) == 0 || propVal.CmpNoCase(wxT("si")) == 0 || propVal.CmpNoCase(wxT("1")) == 0 ) {
					pacsServer.tls = true;
				}
				else {
					pacsServer.tls = false;
				}

				propVal = nodo->GetPropVal(wxT("usuario-pacs"), wxEmptyString);
				if( !propVal.empty()) {
					pacsServer.user = propVal.ToUTF8();
				}

				propVal = nodo->GetPropVal(wxT("password-pacs"), wxEmptyString);
				if( !propVal.empty()) {
					pacsServer.password = propVal.ToUTF8();
				}

				propVal = nodo->GetPropVal(wxT("verify-credentials"), wxEmptyString);
				if( propVal.CmpNoCase(wxT("yes")) == 0 || propVal.CmpNoCase(wxT("true")) == 0 || propVal.CmpNoCase(wxT("si")) == 0 || propVal.CmpNoCase(wxT("1")) == 0 ) {
					pacsServer.verify = true;
				}
				else {
					pacsServer.verify = false;
				}

				propVal = nodo->GetPropVal(wxT("metodo"), wxEmptyString);
				if( propVal.CmpNoCase(wxT("get")) == 0 ) {
					pacsServer.metodo = GIL::IModeloPACSServer::IMPS_GET;
				}
				else {
					pacsServer.metodo = GIL::IModeloPACSServer::IMPS_MOVE;
				}
				
				propVal = nodo->GetPropVal(wxT("pdu"), wxEmptyString);
				if( propVal.empty()) {
					pacsServer.pdu = "16384";
				}
				else {
					pacsServer.pdu = propVal.ToUTF8();
				}

				propVal = nodo->GetPropVal(wxT("nivel-recuperacion"), wxEmptyString);
				if( propVal.empty()) {
					pacsServer.retrieveLevel = "SERIES";
				}
				else {
					pacsServer.retrieveLevel = propVal.ToUTF8();
				}

				for (wxXmlNode* subnodo = nodo->GetChildren(); subnodo != NULL; subnodo = subnodo->GetNext()) {
					if (subnodo->GetName().CmpNoCase(wxT("client-cert")) == 0) {
						pacsServer.cert = subnodo->GetNodeContent().ToUTF8();
					}
					else if (subnodo->GetName().CmpNoCase(wxT("client-key")) == 0) {
						pacsServer.key = subnodo->GetNodeContent().ToUTF8();
					}
				}

				servers[pacsServer.sid] = pacsServer;
				try{
					DicomServer* server = DicomServerList::Instance()->GetServer(pacsServer.sid);
					server->AET = pacsServer.AET;
					server->HostName = pacsServer.hostname;
					long puerto;
					long pdu;
					if(!wxString::FromUTF8(pacsServer.pdu.c_str()).ToLong(&pdu)) {
						throw HL7XMLException(_Std("The pdu size is not a valid number"), xpp, "CONF/pacs");
					}
					server->PDU = pdu;
					if(wxString::FromUTF8(pacsServer.puerto.c_str()).ToLong(&puerto)) {
						server->Port = puerto;
					} else {
						throw HL7XMLException(_Std("Port is not a valid number"), xpp, "CONF/pacs");
					}
					if (pacsServer.metodo == GIL::IModeloPACSServer::IMPS_GET) {
						server->retrieveWithMove = false;
					}
					else {
						server->retrieveWithMove = true;
					}
					{
						wxString strTmp = wxString::FromUTF8(pacsServer.retrieveLevel.c_str());
						server->retrieveSeries = strTmp.CmpNoCase(wxT("SERIES")) == 0;
					}
					server->useTLS = pacsServer.tls;
					server->verifyCredentials = pacsServer.verify;
					server->certificate = pacsServer.cert;
					server->privateKey  = pacsServer.key;
					server->pacsUser = pacsServer.user;
					server->pacsPass = pacsServer.password;

					DicomServerList::Instance()->SetDefaultServer(server->ID);

				} catch (GinkgoNoServerFoundException& ){
					long puerto;
					long pdu;
					if(!wxString::FromUTF8(pacsServer.pdu.c_str()).ToLong(&pdu)) {
						throw HL7XMLException(_Std("The pdu size is not a valid number"), xpp, "CONF/pacs");
					}
					if(wxString::FromUTF8(pacsServer.puerto.c_str()).ToLong(&puerto)) {
						DicomServerList::Instance()->AddServer( DicomServer(pacsServer.sid, pacsServer.AET, pacsServer.hostname, (int)puerto, 0, true, pdu, pacsServer.tls, pacsServer.user, pacsServer.password, pacsServer.metodo == GIL::IModeloPACSServer::IMPS_MOVE, wxString::FromUTF8(pacsServer.retrieveLevel.c_str()).Upper() == wxT("SERIES"), pacsServer.verify, pacsServer.cert, pacsServer.key), true );
					} else {
						throw HL7XMLException(_Std("The port is not a valid number"), xpp, "CONF/pacs");
					}
				}
			}
		}

		std::string codigoAplicacion;
		//se extrae de la configuracion el codigo de aplicacion
		wxString valor;
		wxConfigBase* config = wxConfigBase::Get();
		config->SetPath(wxT("/GinkgoCore/HCE"));

		config->Read(wxT("CodigoAplicacion"), &valor, wxEmptyString);
		codigoAplicacion = valor.ToUTF8();

		// Parseamos las plantillas
		for (wxXmlNode* nodo = pRoot->GetChildren(); nodo != NULL; nodo = nodo->GetNext()) {
			if (nodo->GetName().CmpNoCase(wxT("plantilla")) == 0)  { // Plantilla

				GIL::IModeloIntegracion* modelo = new IModeloIntegracion();
				//se copia el raw data
				{
					wxXmlNode* pNodo = new wxXmlNode(*nodo);
					wxXmlDocument docTmp;
					docTmp.SetRoot(pNodo);
					wxStringOutputStream out;
					docTmp.Save(out,wxXML_NO_INDENTATION);
					modelo->rawXmlData = out.GetString().ToUTF8();
				}
				//

				propVal = nodo->GetPropVal(wxT("pid"), wxEmptyString);
				if( !propVal.empty() ) {
					modelo->idPlantilla = propVal.ToUTF8();
				} else {
					modelo->idPlantilla = "";
				}

				propVal = nodo->GetPropVal(wxT("accion"), wxEmptyString).Lower();
				if ( !propVal.empty() ) {

					if (propVal.CmpNoCase(wxT("obtener")) == 0){
						modelo->accion = GIL::IModeloIntegracion::TA_Obtener;
					}
					else if (propVal.CmpNoCase(wxT("dicomizar")) == 0 ) {
						modelo->accion = GIL::IModeloIntegracion::TA_Dicomizar;
					}
					else if (propVal.CmpNoCase(wxT("imprimir")) == 0) {
						modelo->accion = GIL::IModeloIntegracion::TA_Imprimir;
					}
					else {
						throw HL7XMLException(_Std("\"accion\" attribute invalid at \"plantilla\" scope" ), xpp, "CONF/template");
					}
				}
				else {
					throw HL7XMLException(_Std("\"accion\" attribute expected at \"plantilla\" scope"), xpp, "CONF/template");
				}

				propVal = nodo->GetPropVal(wxT("id_peticion"), wxEmptyString);
				if( !propVal.empty() ) {
					modelo->idPeticion = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("\"id_peticion\" attribute expected at \"plantilla\" scope"), xpp, "CONF/template");
				}

				propVal = nodo->GetPropVal(wxT("ambito"), wxEmptyString);
				if( !propVal.empty() ) {
					modelo->idAmbitoPeticion = propVal.ToUTF8();
				}
				else {
					throw HL7XMLException(_Std("\"ambito\" attribute expected at \"plantilla\" scope"), xpp, "CONF/template");
				}

				if( nodo->HasProp(wxT("pacs_retrieve_sid")) ) {
					propVal = nodo->GetPropVal(wxT("pacs_retrieve_sid"), wxEmptyString);
					if (!propVal.IsEmpty()) {
						modelo->PACSObtencion = propVal.ToUTF8();
					}
					else {
						throw HL7XMLException(_Std("\"pacs_retrieve_sid\" attribute empty at \"plantilla\" scope"), xpp, "CONF/template");
					}					
				}

				if( nodo->HasProp(wxT("pacs_store_sid")) ) {
					propVal = nodo->GetPropVal(wxT("pacs_store_sid"), wxEmptyString);
					if (!propVal.IsEmpty()) {
						modelo->PACSAlmacenamiento = propVal.ToUTF8();
					}
					else {
						throw HL7XMLException(_Std("\"pacs_store_sid\" attribute empty at \"plantilla\" scope"), xpp, "CONF/template");
					}					
				}

				//recorremos los hijos de las plantillas
				for (wxXmlNode* hijo = nodo->GetChildren(); hijo != NULL; hijo = hijo->GetNext()) {
					
					if(hijo->GetName().CmpNoCase(wxT("dimse")) == 0){
						//parseamos los campos dimse
						std::string uid;
						propVal = hijo->GetPropVal(wxT("uid"), wxEmptyString);
						if ( !propVal.empty() ) {
							uid =  propVal.ToUTF8();
						}
						else {
							uid = "";
							if(modelo->accion != GIL::IModeloIntegracion::TA_Dicomizar) {
								throw HL7XMLException(_Std("\"uid\" attribute expected at \"dimse\" scope"), xpp, "CONF/template");
							}
						}

						propVal = hijo->GetPropVal(wxT("ambito"), wxEmptyString).Lower();
						if ( !propVal.empty() ) {
							if (propVal.CmpNoCase(wxT("study")) == 0){
								modelo->ambitoDIMSE = "STUDY";
								//study instance uid
								modelo->Metadatos.push_back(IModeloTupla("DICOM","0020|000d", uid,""));
							}
							else if (propVal.CmpNoCase(wxT("series")) == 0) {
								modelo->ambitoDIMSE = "SERIES";
								//series instance uid
								modelo->Metadatos.push_back(IModeloTupla("DICOM","0020|000e", uid,""));
							}
							else if (propVal.CmpNoCase(wxT("image")) == 0) {
								//sop instance uid
								modelo->Metadatos.push_back(IModeloTupla("DICOM","0008|0018", uid,""));
								modelo->ambitoDIMSE = "IMAGE";
							}
							else {
								throw HL7XMLException(_Std("\"ambito\" attribute invalid at \"dimse\" scope"), xpp, "CONF/template");
							}
						}
						else {
							modelo->ambitoDIMSE = "STUDY";
							if(modelo->accion != GIL::IModeloIntegracion::TA_Dicomizar) {
								throw HL7XMLException(_Std("\"ambito\" attribute expected at \"dimse\" scope"), xpp, "CONF/template");
							}
						}
						
					}

					//parseamos los campos d paciente
					if(hijo->GetName().CmpNoCase(wxT("paciente")) == 0) {
						for (wxXmlNode* hijosPaciente = hijo->GetChildren(); hijosPaciente != NULL; hijosPaciente = hijosPaciente->GetNext()) {
							if(hijosPaciente->GetName().CmpNoCase(wxT("nombre")) == 0) {
								if(hijosPaciente->GetChildren() != NULL){
									modelo->Paciente.nombre = hijosPaciente->GetChildren()->GetContent().ToUTF8();
								}
							} else if(hijosPaciente->GetName().CmpNoCase(wxT("apellido1")) == 0) {
								if(hijosPaciente->GetChildren() != NULL){
									modelo->Paciente.apellido1 = hijosPaciente->GetChildren()->GetContent().ToUTF8();
								}
							} else if(hijosPaciente->GetName().CmpNoCase(wxT("apellido2")) == 0) {
								if(hijosPaciente->GetChildren() != NULL){
									modelo->Paciente.apellido2 = hijosPaciente->GetChildren()->GetContent().ToUTF8();
								}
							} else if(hijosPaciente->GetName().CmpNoCase(wxT("numero_episodio")) == 0) {
								if(hijosPaciente->GetChildren() != NULL){
									modelo->Paciente.numEpisodio = hijosPaciente->GetChildren()->GetContent().ToUTF8();
								}
							}else if(hijosPaciente->GetName().CmpNoCase(wxT("id")) == 0) {
								std::string codigo(propVal.ToUTF8());
								std::string valor(propVal.ToUTF8());
								propVal = hijosPaciente->GetPropVal(wxT("codigo"), wxEmptyString);
								if ( !propVal.empty() ) {
									codigo =  propVal.ToUTF8();
								}
								else {
									throw HL7Exception(_Std("\"codigo\" attribute expected at \"paciente\" scope"), xpp, "CONF/template");
								}
								propVal = hijosPaciente->GetPropVal(wxT("valor"), wxEmptyString);
								if ( !propVal.empty() ) {
									valor =  propVal.ToUTF8();
									modelo->Paciente.listaIdentificadores.push_back(IModeloIdentificador(codigo,valor));
								}								
							}
						}
					}//fin paciente

					//parseamos los campos d medico
					if(hijo->GetName().CmpNoCase(wxT("medico")) == 0) {
						for (wxXmlNode* hijosMedico = hijo->GetChildren(); hijosMedico != NULL; hijosMedico = hijosMedico->GetNext()) {
							if(hijosMedico->GetName().CmpNoCase(wxT("nombre")) == 0) {
								if(hijosMedico->GetChildren() != NULL){
									modelo->Medico.nombre = hijosMedico->GetChildren()->GetContent().ToUTF8();
								}
							} else if(hijosMedico->GetName().CmpNoCase(wxT("apellido1")) == 0) {
								if(hijosMedico->GetChildren() != NULL){
									modelo->Medico.apellido1 = hijosMedico->GetChildren()->GetContent().ToUTF8();
								}
							} else if(hijosMedico->GetName().CmpNoCase(wxT("apellido2")) == 0) {
								if(hijosMedico->GetChildren() != NULL){
									modelo->Medico.apellido2 = hijosMedico->GetChildren()->GetContent().ToUTF8();
								}
							} else if(hijosMedico->GetName().CmpNoCase(wxT("id")) == 0) {
								std::string codigo(propVal.ToUTF8());
								std::string valor(propVal.ToUTF8());
								propVal = hijosMedico->GetPropVal(wxT("codigo"), wxEmptyString);
								if ( !propVal.empty() ) {
									codigo =  propVal.ToUTF8();
								}
								else {
									throw HL7XMLException(_Std("\"codigo\" attribute expected at \"medico\" scope"), xpp, "CONF/template");
								}
								propVal = hijosMedico->GetPropVal(wxT("valor"), wxEmptyString);
								if ( !propVal.empty() ) {
									valor =  propVal.ToUTF8();
								}
								else {
									throw HL7XMLException(_Std("\"valor\" attribute expected at \"medico\" scope"), xpp, "CONF/template");
								}
								modelo->Medico.listaIdentificadores.push_back(IModeloIdentificador(codigo,valor));
							} else if(hijosMedico->GetName().CmpNoCase(wxT("centro")) == 0) {
								propVal = hijosMedico->GetPropVal(wxT("cid"), wxEmptyString);
								if ( !propVal.empty() ) {
									modelo->Medico.idCentro =  propVal.ToUTF8();
								}
								else {
									throw HL7XMLException(_Std("\"cid\" atribute expected at \"centro\" scope"), xpp, "CONF/template");
								}

								if(hijosMedico->GetChildren() != NULL){
									modelo->Medico.nombreCentro = hijosMedico->GetChildren()->GetContent().ToUTF8();
								}
							}
						}
					}//fin medico

					if(hijo->GetName().CmpNoCase(wxT("hce")) == 0) {
						propVal = hijo->GetPropVal(wxT("aid"), wxEmptyString);
						if ( !propVal.empty() ) {
							modelo->HCE.Sid =  propVal.ToUTF8();
						}
						else {
							throw HL7XMLException(_Std("\"aid\" attribute expected at \"hce\" scope"), xpp, "CONF/template");
						}
					}

					if (hijo->GetName().CmpNoCase(wxT("metadato")) == 0) {
						std::string codigo;
						std::string clave;
						std::string valor;
						std::string descripcion;

						propVal = hijo->GetPropVal(wxT("codigo"), wxEmptyString);
						if ( !propVal.empty() ) {
							codigo = propVal.ToUTF8();
						}else {
							throw HL7XMLException(_Std("\"codigo\" attribute expected at \"metadato\" scope"), xpp, "CONF/template");
						}

						propVal = hijo->GetPropVal(wxT("clave"), wxEmptyString);
						if ( !propVal.empty() ) {
							clave = propVal.ToUTF8();
						}else {
							throw HL7XMLException(_Std("\"clave\" attribute expected at \"metadato\" scope"), xpp, "CONF/template");
						}

						propVal = hijo->GetPropVal(wxT("valor"), wxEmptyString);
						if ( !propVal.empty() ) {
							valor = propVal.ToUTF8();
						}

						propVal = hijo->GetPropVal(wxT("descripcion"), wxEmptyString);
						if ( !propVal.empty() ) {
							descripcion = propVal.ToUTF8();
						}

						IModeloTupla tupla(codigo,clave, valor,descripcion);
						modelo->Metadatos.push_back(tupla);
					}

					if (hijo->GetName().CmpNoCase(wxT("observaciones")) == 0) {
						if(hijo->GetChildren() != NULL) {
							modelo->observaciones = hijo->GetChildren()->GetContent().ToUTF8();
						}
					}
				}//fin hijos plantilla
				if (modelo->accion == GIL::IModeloIntegracion::TA_Obtener && modelo->Paciente.listaIdentificadores.size() != 0)
				{
					modelo->Metadatos.push_back(IModeloTupla("DICOM","0010|0020", modelo->Paciente.GetIdentificadorPreferido().valor,""));
				}
				if (modelo->accion == GIL::IModeloIntegracion::TA_Dicomizar && modelo->idPlantilla == "") {
					throw HL7XMLException(_Std("\"tid\" attribute omitted"), xpp, "CONF/template");
				}
				if(modelo->HCE.Sid == "") {
					throw HL7XMLException(_Std("id_application expected"), xpp, "CONF/template");
				}
				if(modelo->Medico.listaIdentificadores.size() == 0) {
					throw HL7XMLException(_Std("It has been read a \"medico\" tag without identifiers"), xpp, "CONF/template");
				}
				if(modelo->Paciente.listaIdentificadores.size() == 0 && modelo->accion == GIL::IModeloIntegracion::TA_Dicomizar) {
					throw HL7XMLException(_Std("It has been read a \"paciente\" tag without identifiers"), xpp, "CONF/template");
				}
				/*
				if(modelo->Paciente.numEpisodio.size() == 0) {
					throw HL7Exception(_Std("It has been read a \"paciente\" tag without episode number"), "CONF/template");
				}
				*/
				//se pone el codigo de aplicacion y el primer PACS de la configuracion si no nos ha venido  ninguno
				modelo->CodigoAplicacion = codigoAplicacion;
				if(servers.size() > 0) {
					DicomServer* pServer = DicomServerList::Instance()->GetDefaultServer();
					if (modelo->PACSObtencion.size() == 0 && pServer != NULL) {
						modelo->PACSObtencion = pServer->ID;
					}
					if (modelo->PACSAlmacenamiento.size() == 0 && pServer != NULL) {
						modelo->PACSAlmacenamiento = pServer->ID;
					}
				}
				if ( (modelo->accion == GIL::IModeloIntegracion::TA_Dicomizar && modelo->PACSAlmacenamiento.size() == 0) || 
					(modelo->accion == GIL::IModeloIntegracion::TA_Obtener && modelo->PACSObtencion.size() == 0) ) 
				{
					throw HL7XMLException(_Std("You must define a default PACS in the integration XML or in the settings menu"), xpp, "CONF/template");
				}
				models.push_back(modelo);
			} //fin plantilla
		} //fin de parseo de plantillas
	}
	else {
		throw HL7XMLException(_Std("Setting not found"), xpp, "CONF");
	}
}
