/*
 *  
 *  $Id: dicomservers.cpp 3787 2011-04-29 06:38:01Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "dicomservers.h"
#include <iostream>
#include <wx/filename.h>
#include <wx/file.h>
#include <wx/textfile.h>
#include <wx/dir.h>
#include <wx/confbase.h>
#include <main/entorno.h>
#include <api/globals.h>
#include <api/icontextoestudio.h>

DicomServerList* DicomServerList::m_pInstance = 0;

DicomServerList::DicomServerList()
{
	serverHolders = NULL;
	localServer = NULL;
	lastInsertedHolder = NULL;
	Reload();
	//std::cout << "DicomServerList construido" << std::endl;
}

DicomServerList::~DicomServerList()
{
	//std::cout << "DicomServerList destruyendose" << std::endl;
	DicomServerHolder* holder = NULL;
	DicomServerHolder* tempHolder = NULL;
	for (holder = serverHolders; holder != NULL;) {
		tempHolder = holder->next;
		holder->next = NULL;
		delete holder;
		holder = tempHolder;
	}
	if (localServer != NULL) {
		delete localServer;
		localServer = NULL;
	}
	serverHolders = NULL;
	lastInsertedHolder = NULL;
	//std::cout << "DicomServerList destruido" << std::endl;
}

DicomServerList* DicomServerList::Instance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new DicomServerList();
	}
	return m_pInstance;
}

void DicomServerList::FreeInstance()
{
	if (m_pInstance != NULL) {
		delete m_pInstance;
		m_pInstance = 0;
	}

}

void DicomServerList::AddServer(const DicomServer& newServer, bool isDefault)
{
	if (isDefault) {
		for (DicomServerHolder* sl = GetList(); sl != NULL; sl = sl->next) {
			sl->server.isDefault = false;
		}
	}
	if (TieneServer(newServer.ID)) {
		DicomServer* server = GetServer(newServer.ID);
		*server = newServer;
		server->isDefault = isDefault;
	}
	else {
		DicomServerHolder* newServerHolder = new DicomServerHolder(newServer.ID, newServer.AET, newServer.HostName, newServer.Port, newServer.Lossy, newServer.isDefault, newServer.PDU, newServer.useTLS, newServer.pacsUser, newServer.pacsPass, newServer.retrieveWithMove, newServer.retrieveSeries, newServer.verifyCredentials, newServer.certificate, newServer.privateKey);
		newServerHolder->server.isDefault = isDefault;
		if (serverHolders == NULL) {
			lastInsertedHolder = serverHolders = newServerHolder;
		} else {
			lastInsertedHolder->next = newServerHolder;
			lastInsertedHolder = lastInsertedHolder->next;
		}
	}
	
}

bool DicomServerList::TieneServer(const std::string& ID)
{
	DicomServerHolder* it;

	bool found = false;

	for (it = serverHolders; it != NULL && !found; it = it->next) {
		if (it->server.ID == ID) {
			found = true;
		}
	}

	return found;
}

DicomServer* DicomServerList::GetServer(const std::string& ID)
{
	DicomServer* server = NULL;

	DicomServerHolder* it;

	bool found = false;

	for (it = serverHolders; it != NULL && !found; it = it->next) {
		if (it->server.ID == ID) {
			found = true;
			server = &it->server;
		}
	}

	if (server == NULL) {
		throw GinkgoNoServerFoundException();
	}

	return server;
}

DicomServer* DicomServerList::GetLocalServer()
{
	if (localServer == NULL) {
		throw GinkgoNoServerFoundException();
	}
	return localServer;
}

DicomServerHolder* DicomServerList::GetList()
{
	return serverHolders;
}

DicomServer* DicomServerList::GetDefaultServer()
{
	if (serverHolders != NULL) {
		for (DicomServerHolder* it = serverHolders; it != NULL; it = it->next) {
			if (it->server.isDefault) {
				return &it->server;
			}
		}
	}
	if (serverHolders != NULL) {
		return &serverHolders->server;
	} else {
		return NULL;
	}
}

void DicomServerList::SetDefaultServer(const std::string& ID)
{
	if (serverHolders != NULL) {
		for (DicomServerHolder* it = serverHolders; it != NULL; it = it->next) {
			if (it->server.ID == ID) {
				it->server.isDefault = true;
			} else {
				it->server.isDefault = false;
			}
		}
	}
}

DicomServer* DicomServerList::GetFirst()
{
	DicomServer* server = NULL;
	if (serverHolders != NULL) {
		server = &serverHolders->server;
	}
	return server;
}

DicomServer* DicomServerList::GetLast()
{
	return &lastInsertedHolder->server;
}

void DicomServerList::Reload(){
	DicomServerHolder* holder = NULL;
	DicomServerHolder* tempHolder = NULL;
	for (holder = serverHolders; holder != NULL;) {
		tempHolder = holder->next;
		holder->next = NULL;
		delete holder;
		holder = tempHolder;
	}
	serverHolders = NULL;
	lastInsertedHolder = NULL;

	//se cargan los servidores desde el fichero de configuracion
	wxConfigBase * config = wxConfigBase::Get();
	//se actualiza el fichero de configuracion
	config->SetPath(wxT("/GinkgoCore/PACS/Servidores"));
	wxString str;
	long dummy;

	bool bCont = config->GetFirstGroup(str, dummy);
	bool existDefault = false;
	while ( bCont ) {
		config->SetPath(str);
		config->Read(wxT("Identificador"),&str);
		std::string id(str.ToUTF8());
		config->Read(wxT("AET"),&str);
		std::string aet(str.ToUTF8());
		config->Read(wxT("Host"),&str);
		std::string host(str.ToUTF8());
		int puerto=0;
		config->Read(wxT("Puerto"),&puerto);
		int pdu=DEFAULT_PDU_LENGTH;
		config->Read(wxT("PDU"),&pdu,DEFAULT_PDU_LENGTH);

		DicomServer server(id, aet, host, puerto, 0, false, pdu, false, "", "", false, true, false, "", "");
		config->Read(wxT("isDefault"), &server.isDefault, false);
		config->Read(wxT("useTLS"),&server.useTLS, false);
		config->Read(wxT("pacsUser"),&str, wxT(""));
		server.pacsUser = str.ToUTF8();
		config->Read(wxT("pacsPass"),&str, wxT(""));
		server.pacsPass = str.ToUTF8();
		config->Read(wxT("verifyCredentials"), &server.verifyCredentials, false);
		config->Read(wxT("certificate"), &str, wxT(""));
		server.certificate = str.ToUTF8();
		config->Read(wxT("privateKey"), &str, wxT(""));
		server.privateKey = str.ToUTF8();
		config->Read(wxT("retrieveWithMove"),&server.retrieveWithMove, true);
		config->Read(wxT("retrieveSeries"),&server.retrieveSeries, true);
		AddServer(server, server.isDefault);
		existDefault = existDefault || server.isDefault;

		config->SetPath(wxT(".."));
		bCont = config->GetNextGroup(str, dummy);
	}

	if (!existDefault) {
		if (serverHolders != NULL) {
			serverHolders->server.isDefault = true;
		}
	}

	//local server
	//se actualiza el fichero de configuracion
	config->SetPath(wxT("/GinkgoCore/PACS/Local"));
	int puerto = 0;
	puerto = (int)config->Read(wxT("Puerto"),11112);
	std::string localAet = GNC::Entorno::Instance()->GetDicomLocalAET();
	
	localServer = new DicomServer("ginkgo",localAet, "localhost", puerto, 0, false, 16384,false, "", "", false, true, false, "", "");
	config->Read(wxT("useTLS"),&localServer->useTLS, false);
	config->Read(wxT("verifyCredentials"), &localServer->verifyCredentials, false);
	wxString clavePrivada;
#ifdef GINKGO_PRIVATE_KEY
	clavePrivada = wxString::FromUTF8(GINKGO_PRIVATE_KEY);
#endif
	config->Read(wxT("privateKey"), &str, clavePrivada);
	localServer->privateKey = str.ToUTF8();
	wxString clavePublica;
#ifdef GINKGO_PUBLIC_KEY
	clavePublica = wxString::FromUTF8(GINKGO_PUBLIC_KEY);
#endif
	config->Read(wxT("certificate"), &str, clavePublica);
	localServer->certificate = str.ToUTF8();
}

