/*
 *
 *  $Id: dicomechoassociation.cpp 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/icontroladorlog.h>
#include <main/controllers/controladorlog.h>
#include "dicomechoassociation.h"
#include <api/internacionalizacion.h>

#ifdef verify
#define MACRO_QUE_ESTORBA verify
#undef verify
#endif


#ifdef MACRO_QUE_ESTORBA
#define verify MACRO_QUE_ESTORBA
#endif

EchoAssociation::EchoAssociation(const std::string& ambitolog) : Association(ambitolog) {
	m_abstractSyntax = UID_VerificationSOPClass;
}

EchoAssociation::~EchoAssociation() {
}

void EchoAssociation::OnAddPresentationContext(T_ASC_Parameters* params) {
	CONDITION cond = ASC_addPresentationContext(params, 1, m_abstractSyntax, AllTransferSyntaxes, 3);
	if (cond.bad()) {
		LOG_ERROR(ambitolog, "Unable to add default presentation context");
	}
}
