/*
 *  
 *  $Id: controladorinternacionalizacion.cpp 3649 2011-04-04 13:03:14Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include "controladorinternacionalizacion.h"
#include <wx/intl.h>
#include <wx/confbase.h>
#include <main/entorno.h>


namespace GNC {
	namespace GCS {
		ControladorInternacionalizacion* ControladorInternacionalizacion::Instance()
		{
			if (m_pInstance == NULL) {
				m_pInstance = new ControladorInternacionalizacion();
			}
			return m_pInstance;
		}

		void ControladorInternacionalizacion::FreeInstance()
		{
			if(m_pInstance!=NULL){
				delete m_pInstance;
				m_pInstance = NULL;
			}
		}

		ControladorInternacionalizacion* ControladorInternacionalizacion::m_pInstance = NULL;

		ControladorInternacionalizacion::ControladorInternacionalizacion()
		{
			m_idiomaInterfazSesion = GetIdiomaInterfaz();
			//se inicializa el soporte de idioma, leyendolo de la configuracion...
			wxLocale *pLoc = wxGetLocale();
			wxString pathLang = FROMPATH(GNC::Entorno::Instance()->GetGinkgoLanguageDir());
			if (pLoc == NULL) {
				pLoc = new wxLocale();
			}			
			pLoc->AddCatalogLookupPathPrefix(pathLang);
			pLoc->Init(m_idiomaInterfazSesion);
			setlocale(LC_NUMERIC, "C");
		}
		ControladorInternacionalizacion::~ControladorInternacionalizacion()
		{
			wxLocale *pLoc = wxGetLocale();
			if(pLoc != NULL) {
				pLoc->DestroyLanguagesDB();
				delete pLoc;
			}
		}

		void ControladorInternacionalizacion::AddCatalog(const std::string& catalogName)
		{
			wxString strTmp = FROMPATH(catalogName);
			wxLocale *pLoc = wxGetLocale();
			if (pLoc != NULL) {
				pLoc->AddCatalog(strTmp);
			}
		}

		//se lee de la configuracion
		int ControladorInternacionalizacion::GetIdiomaInterfaz()
		{
			wxConfigBase * config = wxConfigBase::Get();
			//se actualiza el fichero de configuracion
			config->SetPath(wxT("/GinkgoCore/Station"));
			int language;
			config->Read(wxT("Language"),&language,-1);
			if (language == -1) 
			{
				//se pilla el de la maquina
				language = wxLocale::GetSystemLanguage();
			}
			return language;
		}
	}
}
