/*
 *  
 *  $Id: controladorhl7.cpp 3681 2011-04-12 10:53:31Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
//#define _GINKGO_TRACE

#include <string>
#include <map>
#include <ctime>
#include <sstream>

#include <wx/xml/xml.h>
#include <wx/file.h>
#include <wx/sstream.h>
#include <wx/msgdlg.h>
#ifndef _WIN32
#include <signal.h>
#endif
#include <wx/tokenzr.h>
#include <wx/config.h>
#include <wx/filename.h>
#include <api/internacionalizacion.h>

#include "controladorhl7.h"
#include "parserxmlspanish.h"
#include "parserxmlenglish.h"
#include "controladorbbddhl7.h"
#include <api/globals.h>
#include <api/imodelohl7.h>
#include <api/icontroladormodulo.h>
#include <api/icontroladorhl7.h>
#include <api/iguiasmensajeriasacyl.h>
#include <api/aetwildcards.h>
#include <main/controllers/controladorextensiones.h>
#include <main/controllers/controladorlog.h>
#include <main/entorno.h>
#include "dcmtk/dicomservers.h"

//creacion de la base de datos de mensajes
GIL::HL7::ControladorHL7::ControladorHL7(TipoInterpretacion interpretacion, TipoProtocolo protocolo) : GIL::HL7::IControladorHL7(interpretacion, protocolo)
{
	GnkPtr<GIL::HL7::IXMLIntegrationParser> spanish(new GIL::HL7::ParserXMLSpanish());
	RegisterParser(spanish->GetKey(), spanish);
	GnkPtr<GIL::HL7::IXMLIntegrationParser> english(new GIL::HL7::ParserXMLEnglish());
	RegisterParser(english->GetKey(), english);
}

GIL::HL7::ControladorHL7::~ControladorHL7()
{
}

void GIL::HL7::TestHL7()
{
	/*GIL::IModeloIntegracion mi;
	GIL::HL7::ControladorHL7 ch(GIL::HL7::IControladorHL7::TI_SACYL, GIL::HL7::IControladorHL7::TP_MLLP);
	GIL::HL7::Message msg;
	ch.ConstruirMensajeDeEvidencias( msg, mi);
	ch.EnviarMensaje(msg, true);*/
}

//region "Interfaz generica"

/* Parsea la cadena XML y construye el modelo de integracion. Los parametros no encontrados se asignan por defecto segun lo especificado en la configuracion global */
void GIL::HL7::ControladorHL7::ParsearModeloIntegracion(GNC::GCS::IEntorno::ListaModelosIntegracion& modelos, const std::string& xmlString) const
{
	GTRACE("GIL::HL7::ControladorHL7::ParsearModeloIntegracion( modelo, [\n" << xmlString.c_str() << "\n] )");
	wxXmlDocument xml;
	std::string xpp; // XML Pretty Printed for extended information info.

	wxStringInputStream flujoEntrada(wxString::FromUTF8(xmlString.c_str()));

	xml.Load(flujoEntrada,wxT("UTF 8"));

	wxXmlNode* raiz = xml.GetRoot();

	if (raiz == NULL) {
		throw HL7Exception(_Std("Empty configuration"), "CONF");
	}
	else {
		wxString xmlPrettyPrint;
		wxStringOutputStream wsos;
		if (xml.Save(wsos, 1)) {
			xpp = wsos.GetString().ToUTF8();
			LOG_TRACE("Integration", "Parsing XML Integration: " << std::endl << xpp.c_str());
		}
	}

	std::string parserKey (raiz->GetName().ToUTF8());

	if (m_mapParsers.find(parserKey) != m_mapParsers.end()) {
		m_mapParsers.find(parserKey)->second->ParseIntegrationXML(modelos, raiz);
	} else {
		std::ostringstream ostr;
		ostr << _Std("XML Parser Not Found. Key=") << parserKey; 
		throw HL7XMLException(ostr.str(), xpp, "CONF");
	}
}

std::string GIL::HL7::ControladorHL7::GetUID(const std::string& idPlantilla) const
{
	wxConfigBase* config = wxConfigBase::Get();
	wxString uid;
	wxString plantillawx(idPlantilla.c_str(), wxConvUTF8);

	wxStringTokenizer tkid(plantillawx,wxString::FromUTF8("^"));

	size_t numTokens = tkid.CountTokens();

	if (numTokens != 3){
		std::ostringstream os;
		os << _Std("Malformed template Id (") << idPlantilla.c_str() << _Std("):\nIs not a valid HL7 identifier (ie: code^description^namespaceId)");
		throw HL7Exception(os.str(),"PID");
	}
	std::string codigo(tkid.GetNextToken().ToUTF8());
	std::string descripcion(tkid.GetNextToken().ToUTF8());
	std::string namespaceid(tkid.GetNextToken().ToUTF8());

	config->SetPath(wxString::FromUTF8("/GinkgoCore/HCE/Plantillas"));

	GNC::ControladorExtensiones* pCE = GNC::ControladorExtensiones::Instance();

	for (GNC::ControladorExtensiones::IteradorConstanteListaModulos it = pCE->Modulos().begin(); it != pCE->Modulos().end(); it++) {
		const GNC::GCS::IControladorModulo* m = (*it).second;

		LOG_TRACE("HL7", "Parsing module: " << m->GetSID().c_str() << ", " << m->GetUID().c_str() );

		std::string entradaConf = "TUID" + m->GetSID();

		LOG_TRACE("HL7", "EntradaConf = TUID" << m->GetSID().c_str() ); 

		config->Read(wxString::FromUTF8(entradaConf.c_str()), &uid, wxEmptyString);

		LOG_TRACE("HL7", "tuid = " << uid.ToUTF8()); 

		wxStringTokenizer tkz(uid, wxT(";"));

		while (tkz.HasMoreTokens()){
			wxString token = tkz.GetNextToken();
			wxStringTokenizer tkidmodulo(token,wxString::FromUTF8("^"));
			numTokens = tkidmodulo.CountTokens();
			if (numTokens != 3){
				std::ostringstream os;
				os << _Std("Id malformed template in the module configuration") << m->GetNombre() << "(" << (std::string(uid.ToUTF8())).c_str() << _Std("):\nIs not a valid HL7 identifier (ie: code^description^namespaceId)");
				throw HL7Exception(os.str(),"PID");
			}

			std::string codigo_m(tkidmodulo.GetNextToken().ToUTF8());
			std::string descripcion_m(tkidmodulo.GetNextToken().ToUTF8());
			std::string namespaceid_m(tkidmodulo.GetNextToken().ToUTF8());
			if ( (codigo_m == codigo) && (namespaceid_m == namespaceid) )
			{
				std::ostringstream os;
				LOG_TRACE("HL7", "Found entry:" << m->GetUID().c_str());
				os << m->GetUID();
				return os.str();
			}
		}
	}

	throw HL7Exception(_Std("Template Id unsupported (") + (idPlantilla) + _Std("):\nCheck the configuration and attach it if necessary"),"PID");

}

std::string GIL::HL7::ControladorHL7::GetNombreModulo(const std::string& idPlantilla) const
{
	std::string uidModulo = GetUID(idPlantilla);
	std::string nombreModulo("");

	GNC::ControladorExtensiones::ListaModulos listaModulos = GNC::ControladorExtensiones::Instance()->Modulos();
	for(GNC::ControladorExtensiones::IteradorListaModulos itModulos=listaModulos.begin();itModulos!=listaModulos.end();++itModulos){
		std::ostringstream os;
		os << itModulos->first;
		if(os.str() == uidModulo) {
			return itModulos->second->GetNombre();
		}
	}
	return nombreModulo;
}

std::string GIL::HL7::ControladorHL7::GetSIDModulo(const std::string& idPlantilla) const
{
	std::string uidModulo = GetUID(idPlantilla);
	std::string sidModulo("");

	GNC::ControladorExtensiones::ListaModulos listaModulos = GNC::ControladorExtensiones::Instance()->Modulos();
	for(GNC::ControladorExtensiones::IteradorListaModulos itModulos=listaModulos.begin();itModulos!=listaModulos.end();++itModulos){
		std::ostringstream os;
		os << itModulos->first;
		if(os.str() == uidModulo) {
			return itModulos->second->GetSID();
		}
	}
	return sidModulo;
}


void GIL::HL7::ControladorHL7::ConstruirMensajeDeEvidencias(GIL::HL7::Message& msg, const GIL::IModeloIntegracion* const modelo) const
{

	GNC::GCS::IControladorModulo* pCM = GNC::ControladorExtensiones::Instance()->ObtenerModulo(modelo->UIDModulo);

	if (pCM == NULL) {
		LOG_ERROR("HL7", "Error interno: No se pudo obtener el módulo asociado (" << modelo->UIDModulo << ")");
		throw GIL::HL7::HL7Exception(_Std("Could not get the associated module"), "HL7");
	}


	if (m_Interpretacion == TI_SACYL) {

		msg.Clear();

		time_t         timestamp = std::time(NULL);

		wxString       valor;

		std::string    idOrganizacionReceptora;
		std::string    idSistemaPeticionario;
		std::string    idAplicacionRellenadora;
		std::string    idAplicacionPACS;

		std::string    nombreCentroLocal;
		std::string    idCentroLocal;

		std::string    processingId;
		std::string    fillerId;

		wxConfigBase* config = wxConfigBase::Get();
		config->SetPath(wxT("/GinkgoCore/HCE"));

		config->Read(wxT("IDOrganizacionReceptora"), &valor, wxEmptyString);
		idOrganizacionReceptora = valor.ToUTF8();

		config->Read(wxT("IDSistemaPeticionario"), &valor, wxEmptyString);
		idSistemaPeticionario = valor.ToUTF8();

		config->Read(wxT("IDAplicacionRellenadora"), &valor, wxEmptyString);
		idAplicacionRellenadora = valor.ToUTF8();

		if (modelo->PACSAlmacenamiento.size() > 0) {
			idAplicacionPACS = modelo->PACSAlmacenamiento;			
		}
		else {
			if (modelo->PACSObtencion.size() > 0)  {
				idAplicacionPACS = modelo->PACSObtencion;
			}
			else {
				LOG_WARN("HL7", "There is no PACS specified");
			}
		}

		config->SetPath(wxT("/GinkgoCore/Estacion"));

		config->Read(wxT("CentroNombre"),&valor,wxEmptyString);
		nombreCentroLocal = valor.ToUTF8();

		config->Read(wxT("CentroId"),&valor,wxEmptyString);
		idCentroLocal = valor.ToUTF8();

		{
			std::stringstream ss;

			std::string sidModulo = GetSIDModulo(modelo->idPlantilla);
			ss << "GNK_" << sidModulo << "." << timestamp;

			processingId = ss.str();
		}

		{
			std::stringstream ss;

			config->SetPath(wxT("/GinkgoCore/PACS/Local"));

			config->Read(wxT("AET"),&valor,wxEmptyString);
			std::string aetLocal( GNC::GCS::AETWildcards::Parse(std::string(valor.ToUTF8())) );

			ss << timestamp << "." << aetLocal;

			fillerId = ss.str();
		}

		GIL::Sacyl::Messages::ORU_R01Interpreter oi;

			config->SetPath(wxT("/GinkgoCore/HCE"));
			config->Read(wxT("IDGinkgoApplication"),&valor,wxT("GINKGO"));
			oi.SetSendingApplication(std::string(valor.ToUTF8()));
			oi.SetSendingFacility(modelo->Medico.idCentro);

			oi.SetReceivingApplication(modelo->HCE.Sid);
			oi.SetReceivingFacility(idOrganizacionReceptora);

			oi.SetMessageControlId(processingId);

			GIL::Sacyl::Messages::ORU_R01Interpreter::PatientResult result;
				result.patient.patientIdentification.SetSetId(1);
				bool inserted = false;
				result.patient.patientIdentification.SetPatientName(modelo->Paciente.nombre, modelo->Paciente.apellido1, modelo->Paciente.apellido2);
				for(TListaIdentificadores::const_iterator it = modelo->Paciente.listaIdentificadores.begin(); it != modelo->Paciente.listaIdentificadores.end(); it++) {
					const IModeloIdentificador& id = (*it);

					//a sugerencia de alberto enviamos solo NHC y CIP
					if(id.tipoId == "PI") {
						if (!inserted) {
							inserted = true;
							result.patient.patientIdentification.SetPatientNHC(id.valor, modelo->Medico.idCentro);
						}
						else {
							result.patient.patientIdentification.AddPatientNHC(id.valor, modelo->Medico.idCentro);
						}
					}
					else if(id.tipoId == "HC") {
						if (!inserted) {
							inserted = true;
							result.patient.patientIdentification.SetPatientCIP(id.valor);
						}
						else {
							result.patient.patientIdentification.AddPatientCIP(id.valor);
						}
					}
					else if(id.tipoId == "JHN") {
						if (!inserted) {
							inserted = true;
							result.patient.patientIdentification.SetPatientSacylCIP(id.valor);
						}
						else {
							result.patient.patientIdentification.AddPatientSacylCIP(id.valor);
						}
					}
				}

				result.patient.patientVisit.SetSetId(1);
				result.patient.patientVisit.SetEpisodeNumber(modelo->Paciente.numEpisodio, modelo->idAmbitoPeticion, modelo->Medico.idCentro);
				//cambio a sugerencia de Alberto Saez: Cambiar de externo a ingresado
				//cambio a sugerencia de Alberto Saez: El PV1.2 no tiene sentido si el ambito no es hospitalario
				if (modelo->idAmbitoPeticion == "HOS") {
					result.patient.patientVisit.SetPatientTypeAdmitted();
				}

				//------------------------------ Evidencias
				for(GIL::IModeloIntegracion::ListaEvidencias::const_iterator itEvidencias = modelo->Evidencias.begin(); itEvidencias != modelo->Evidencias.end(); itEvidencias++){
					const GIL::IModeloEvidenciaEstudio& evidenciaEstudio = (*itEvidencias);


					GNC::GCS::IdHL7 idHL7Estudio = pCM->GetIdEstudioHL7("EstudioOriginal");
					GNC::GCS::IdHL7 idHL7Series = pCM->GetIdRegistroHL7("SerieOriginal");
					GNC::GCS::IdHL7 idHL7IDPACS = pCM->GetIdRegistroHL7("IDPacs");
					GNC::GCS::IdHL7 idHL7Imagen = pCM->GetIdRegistroHL7("Imagen");
					GNC::GCS::IdHL7 idHL7SOPClass = pCM->GetIdRegistroHL7("SOPClass");


					//en cada order va un ORC (notificacion de la peticion), un OBR (es cada prueba accession number) y uno o mas OBX(con uids y sopinstances uids...)
					GIL::Sacyl::Messages::ORU_R01Interpreter::PatientResult::Order order;
					order.orderCommon.SetStatusCompleted();

					order.orderCommon.SetOrderingUID(modelo->idPeticion);
					order.orderCommon.SetProducerUID(fillerId, idAplicacionRellenadora);
					
					order.orderCommon.SetOrderingCenter(idCentroLocal, nombreCentroLocal);
					order.orderCommon.SetOrderingProviderName(modelo->Medico.nombre, modelo->Medico.apellido1, modelo->Medico.apellido2);
					order.orderCommon.SetOrderingProviderNIF(modelo->Medico.GetNIF());

					order.timingQuantity.SetSetId(1);
					order.timingQuantity.SetUrgencyNormal();

					order.observationRequest.SetSetId(1);
					order.observationRequest.SetOrderingUID(modelo->idPeticion);
					order.observationRequest.SetProducerUID(fillerId, idAplicacionRellenadora);

					/* la lateralidad es por imagen
					if(modelo->lateralidad == GIL::IModeloIntegracion::TL_Derecha) {
						order.observationRequest.SetLateralityRight();
					} else if(modelo->lateralidad == GIL::IModeloIntegracion::TL_Izquierda) {
						order.observationRequest.SetLateralityLeft();
					}*/

					order.observationRequest.SetIdentifier(modelo->idPlantilla);
					order.observationRequest.SetPlacerField1(evidenciaEstudio.AccessionNumber);



					// Inicialmente insertamos dos observaciones. Una del Study Instance UID y otra del Acc#:
					int i = 1;
					int idGrupo = 1;

					GIL::Sacyl::Messages::ORU_R01Interpreter::PatientResult::Order::ObservationGroup::Observation observacionEstudio;
					observacionEstudio.SetDataType(idHL7Estudio.tipoobservacion);
					observacionEstudio.SetIdentifier(idHL7Estudio.codigo, idHL7Estudio.descripcion, idHL7Estudio.namespaceid);
					observacionEstudio.SetValue("^" + evidenciaEstudio.StudyInstanceUID + "^ISO");
					observacionEstudio.SetResponsiveObserverName(modelo->Medico.nombre, modelo->Medico.apellido1, modelo->Medico.apellido2);
					observacionEstudio.SetResponsiveObserverNIF(modelo->Medico.GetNIF());
					observacionEstudio.SetFinal();
					

					GIL::Sacyl::Messages::ORU_R01Interpreter::PatientResult::Order::ObservationGroup::Observation observacionPACS;					
					observacionPACS.SetDataType(idHL7IDPACS.tipoobservacion);
					observacionPACS.SetIdentifier(idHL7IDPACS.codigo, idHL7IDPACS.descripcion, idHL7IDPACS.namespaceid);
					observacionPACS.SetValue(idAplicacionPACS + "^" + idAplicacionPACS + "^DNS");
					observacionPACS.SetResponsiveObserverName(modelo->Medico.nombre, modelo->Medico.apellido1, modelo->Medico.apellido2);
					observacionPACS.SetResponsiveObserverNIF(modelo->Medico.GetNIF());

					if (evidenciaEstudio.ListaSeries.size() == 0) {
						//se introduce un único grupo con la observacion de estudio y la de pacs
						observacionEstudio.SetSetId(i++);
						observacionEstudio.SetSubIdentifier(idGrupo);
						order.observationGroup.AddObservation(observacionEstudio);
						observacionPACS.SetSetId(i++);
						observacionPACS.SetSubIdentifier(idGrupo++);
						order.observationGroup.AddObservation(observacionPACS);						
					} else {
						for (GIL::IModeloEvidenciaEstudio::ListaEvidenciasSeries::const_iterator itSeries = evidenciaEstudio.ListaSeries.begin(); itSeries != evidenciaEstudio.ListaSeries.end(); ++itSeries)
						{
							const GIL::IModeloEvidenciaSerie& evidenciaSerie = (*itSeries);
							GIL::Sacyl::Messages::ORU_R01Interpreter::PatientResult::Order::ObservationGroup::Observation observacionSerie;
							observacionSerie.SetDataType(idHL7Series.tipoobservacion);
							observacionSerie.SetIdentifier(idHL7Series.codigo, idHL7Series.descripcion, idHL7Series.namespaceid);
							observacionSerie.SetValue("^" + evidenciaSerie.SeriesInstanceUID + "^ISO");
							observacionSerie.SetResponsiveObserverName(modelo->Medico.nombre, modelo->Medico.apellido1, modelo->Medico.apellido2);
							observacionSerie.SetResponsiveObserverNIF(modelo->Medico.GetNIF());
							observacionSerie.SetFinal();

							if (evidenciaSerie.ListaImagenes.size() == 0) {
								//se introduce un único grupo con la observacion de estudio, serie y la de pacs
								observacionEstudio.SetSetId(i++);
								observacionEstudio.SetSubIdentifier(idGrupo);
								order.observationGroup.AddObservation(observacionEstudio);
								observacionSerie.SetSetId(i++);
								observacionSerie.SetSubIdentifier(idGrupo);
								order.observationGroup.AddObservation(observacionSerie);
								observacionPACS.SetSetId(i++);
								observacionPACS.SetSubIdentifier(idGrupo++);
								order.observationGroup.AddObservation(observacionPACS);
							} else {
								for (GIL::IModeloEvidenciaSerie::ListaEvidenciasImagenes::const_iterator itImagenes = evidenciaSerie.ListaImagenes.begin();itImagenes != evidenciaSerie.ListaImagenes.end(); ++itImagenes) 
								{
									const GIL::IModeloEvidenciaImagen& evidenciaImagen = (*itImagenes);
									//se introduce la evidencia de estudio, serie, pacs, imagen y sopclasuid de imagen
									GIL::Sacyl::Messages::ORU_R01Interpreter::PatientResult::Order::ObservationGroup::Observation observacionImagen;
									observacionImagen.SetDataType(idHL7Imagen.tipoobservacion);
									observacionImagen.SetIdentifier(idHL7Imagen.codigo, idHL7Imagen.descripcion, idHL7Imagen.namespaceid);
									observacionImagen.SetValue("^" + evidenciaImagen.SOPInstanceUID + "^ISO");
									observacionImagen.SetResponsiveObserverName(modelo->Medico.nombre, modelo->Medico.apellido1, modelo->Medico.apellido2);
									observacionImagen.SetResponsiveObserverNIF(modelo->Medico.GetNIF());
									observacionImagen.SetFinal();
									for (GIL::TListaModificadores::const_iterator itModificador = evidenciaImagen.Modificadores.begin(); itModificador != evidenciaImagen.Modificadores.end(); itModificador++)
									{
										const GIL::IModeloModificador& modificador = *itModificador;
										const GNC::GCS::IdHL7& id = pCM->GetIdRegistroHL7(modificador.Etiqueta);
										observacionImagen.AddObservationMethod(id.codigo, id.descripcion, id.namespaceid);
									}

									GIL::Sacyl::Messages::ORU_R01Interpreter::PatientResult::Order::ObservationGroup::Observation observacionSopClass;
									observacionSopClass.SetDataType(idHL7SOPClass.tipoobservacion);
									observacionSopClass.SetIdentifier(idHL7SOPClass.codigo, idHL7SOPClass.descripcion, idHL7SOPClass.namespaceid);
									observacionSopClass.SetValue("^" + evidenciaImagen.SOPClassUID + "^ISO");
									observacionSopClass.SetResponsiveObserverName(modelo->Medico.nombre, modelo->Medico.apellido1, modelo->Medico.apellido2);
									observacionSopClass.SetResponsiveObserverNIF(modelo->Medico.GetNIF());
									observacionSopClass.SetFinal();

									observacionEstudio.SetSetId(i++);
									observacionEstudio.SetSubIdentifier(idGrupo);
									order.observationGroup.AddObservation(observacionEstudio);
									observacionSerie.SetSetId(i++);
									observacionSerie.SetSubIdentifier(idGrupo);
									order.observationGroup.AddObservation(observacionSerie);
									observacionImagen.SetSetId(i++);
									observacionImagen.SetSubIdentifier(idGrupo);
									order.observationGroup.AddObservation(observacionImagen);
									observacionSopClass.SetSetId(i++);
									observacionSopClass.SetSubIdentifier(idGrupo);
									order.observationGroup.AddObservation(observacionSopClass);
									observacionPACS.SetSetId(i++);
									observacionPACS.SetSubIdentifier(idGrupo++);
									order.observationGroup.AddObservation(observacionPACS);
								}
							}


						}
					}

					result.AddOrder(order);
				}

		oi.AddPatientResult(result);

		oi.Build(msg);

		//std::cout << msg << std::endl;
	}
}

/* Envia el mensaje por MLLP */
void GIL::HL7::ControladorHL7::EnviarMensaje(const GIL::HL7::Message& msg, bool procesarACK) const
{
	wxString hostname;
	wxString puerto;

	wxConfigBase* config = wxConfigBase::Get();
	config->SetPath(wxT("/GinkgoCore/HCE"));

	config->Read(wxT("HostnameMI"), &hostname, wxEmptyString);

	config->Read(wxT("PuertoMI"), &puerto, wxEmptyString);

	std::string url( (hostname + wxT(":") + puerto).ToUTF8());

	if (hostname.empty()) {
		throw HL7Exception(_Std("Integration engine hostname not set"), "NET");
	}
	if (puerto.empty()) {
		throw HL7Exception(_Std("Integration engine port not set"), "NET");
	}

	std::string msgControlId("");
	switch(m_Protocolo) {
		case GIL::HL7::IControladorHL7::TP_MLLP:
			//se inserta en la BBDD de mensajes
			if(procesarACK){
				msgControlId = msg.GetSegment("MSH").GetField(10).GetComponent(1);
			}
			InsertarMensajeBBDD(msg,url,procesarACK,(int)TP_MLLP,msgControlId);
			//EnviarMensajeMLLP(msg, url, procesarACK);
			break;
		default:
			throw HL7Exception(_Std("Unsupported protocol"), "NET");
	}
}

//endregion
void GIL::HL7::ControladorHL7::InsertarMensajeBBDD(const GIL::HL7::Message& msg, const std::string& url,const bool procesarACK,const int protocolo,const std::string& msgControlId) const
{
	std::stringstream outputStream;
	outputStream << msg;
	std::string str = outputStream.str();

	try{
		GIL::HL7::MensajeHL7 mensaje(0,str,"",url,GIL::HL7::MensajeHL7::TE_Pendiente,"",protocolo,procesarACK,msgControlId);
		GIL::HL7::ControladorBBDDHl7::Instance()->InsertarMensaje(mensaje);
	}catch (GIL::HL7::HL7Exception& ) {
		throw HL7Exception(_Std("Error queueing message. Check your supplier"), "NET");
	}
}
