/*
 *
 *  $Id: controladorhistorial.h 3669 2011-04-11 10:59:33Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <string>
#include <api/api.h>
#include <api/globals.h>
#include <api/icontroladorhistorial.h>
#include <list>
#include <wx/datetime.h>

class wxSQLite3Database;
class wxCriticalSection;

namespace GNC {
	class IProxyNotificadorProgreso;
	namespace GCS {
		class EXTAPI ControladorHistorial: public GNC::GCS::IControladorHistorial {
		public:

			void RecargarHistorial();

	//region "Patron singleton"
		public:
			static ControladorHistorial* Instance();
			static void FreeInstance();

			static ControladorHistorial* m_pInstance;
	//endregion

			//region "metodos propios del historial"
			bool AddFiles(const ListaPaths& listaPaths,ListaModelosDCM& listaModelos, ListaPaths& listaSobreescritos, bool forzarSobreescribir, GNC::IProxyNotificadorProgreso* pNotificador = NULL, bool soloLeer = false, bool mover = false);

			bool EliminarFichero(const std::string& pathAbsolutoFichero, bool eliminarDelDisco);
			bool EliminarPaciente(const std::string& idPaciente, bool eliminarDelDisco);
			bool EliminarEstudio(const std::string& uidEstudio, bool eliminarDelDisco);
			bool DeleteSeriesList(const ListaStrings& uids, bool removeFromDisk);
			bool DeleteFilesList(const std::string& patientID, const std::string& studyId, const std::string& seriesID, const ListaStrings& listaSopInstancesUIDS, bool removeFromDisk = true);
			bool EliminarSerie(const std::string& uidSerie, bool eliminarDelDisco);
			bool VaciarHistorial(bool eliminarDelDisco);

			bool ExistePaciente(const std::string& idPaciente);
			bool ExisteEstudio(const std::string& uidEstudio);
			bool ExisteSerie(const std::string& uidSerie);
			bool ExisteFichero(const std::string& pathRelativoFichero);
			bool ReferenciaResuelta(const std::string& uidFichero);

			ModeloDCM GetModeloDCM(const std::string& pathAbsoluto);
			//trhows exception
			void GetDCMModelSql(const std::string& sql, ListaModelosDCM& dcmList);

			//Get todos los ficheros excepto los sr
			void GetModelosSeriePacienteModalidad(const std::string& idPaciente, const std::string& modalidad, const wxDateTime& from, const wxDateTime& to, const std::string& timeFrom, const std::string& timeTo,ListaModelosSeries& listaModelos);
			//throws exception
			void GetStudyModelSql(const std::string& sql, ListaModelosEstudios& listaModelos);
			//trhows exception
			void GetSeriesModelSql(const std::string& sql, ListaModelosSeries& listaModelos);
			//uidsSeries->restricted to this uids			
			void GetAllModelosSerieSeries(const ListaStrings& listaUIDSeriess, ListaModelosSeries& listaModelos);
			void GetAllModelosSeriePatient(const std::string& patientID, ListaModelosSeries& listaModelos);
			void GetAllModelosSerieStudy(const std::string& studyInstanceUID, ListaModelosSeries& listaModelos);
			void GetAllModelosSerie(ListaModelosSeries& listaModelos, const ListaStrings& uidsSeries = ListaStrings(), const std::string& studyInstanceUID = "", const std::string& patientId = "");
			void GetAllModelosSerieDiagnostico(ListaModelosSeries& listaModelos, const ListaStrings& uidsSeries = ListaStrings());
			//

			void GetAllPatients(ListaModelosPaciente& listaPacientes);
			void GetAllModalities(ListaStrings& modalitiesList);


			//Get dcms de un estudio
			void GetModelosSerieEstudio(std::string& uidEstudio, ListaModelosSeries& listaModelos);

			int GetSlicesCount(const std::string& uidSerie);

			std::string GetPathFrameOfReference(const std::string& uidSerie);

			/*obtiene los diagnosticos asociados a un fichero con un importador dado*/
		//	ListaModelosDCM GetDiagnosticos(const std::string& pathFichero, const std::string& uidImportador);

			/*obtiene los diagnosticos asociados a un fichero con un importador dado y una estudio dado*/
			ModeloDCM GetDiagnostico(const std::string& pathFicheroAbsoluto,const std::string& uidEstudio, const std::string& uidImportador="");

			/*obtiene los diagnosticos asociados a una serie con un importador dado y una estudio dado*/
			virtual ModeloDCM GetDiagnosticoSerie(const std::string& uidSerie,const std::string& uidEstudio, const std::string& uidImportador="");

			/* Obtiene el diagnostico que apunta a diagnosticos de la serie indicada */
			ModeloDCM GetDiagnosticoClave(const std::string& uidEstudio, const std::string& uidImportador);

			/*Obtiene los diagnosticos del estudio del fichero*/
			ListaModelosEstudios GetEstudiosDiagnosticosFichero(const std::string& pathAbsoluto, const std::string& uidImportador = "");
			ListaModelosEstudios GetEstudiosDiagnosticosSerie(const std::string& uidSerie, const std::string& uidImportador = "");
			ListaModelosEstudios GetEstudiosDiagnosticosEstudioPath(const std::string& pathAbsoluto, const std::string& uidImportador = "");
			ListaModelosEstudios GetEstudiosDiagnosticosSeriePath(const std::string& pathAbsoluto, const std::string& uidImportador = "");
			ListaModelosEstudios GetEstudiosDiagnosticosEstudio(const std::string& uidEstudio, const std::string& uidImportador = "");

			/*modalidades para el abrir con*/
			std::string GetModalidadSerie(const std::string& uidSerie);
			ListaStrings GetModalidadesEstudio(const std::string& uidEstudio);
			std::string GetUIDImporterFromDiagnosticStudy(const std::string& uidStudy);
			void GetReferencedFiles(const std::string& uidDiagnosticStudy, ListaStrings& pathList);


			ListaPaths GetPathsFichero(std::string uidFichero);

			//endregion
			//sopInstance uid de un fichero
			virtual std::string GetSopInstanceUID(const std::string& pathAbsoluto);
			virtual std::string GetPathAbsoluto(const std::string& sopInstanceUID) ;

			virtual char GetSeriesOrientation(const std::string& uidSerie);

			virtual VectorPaths GetPathsSerieOrdenados(const std::string& uidSerie);


			//thumbnails...
			void SetThumbnail(const std::string& idPaciente, const std::string& uidEstudio, const std::string& uidSerie, const std::string& pathRelativo, int ancho, int alto, const unsigned char* imagen);
			void GetThumbnail(const std::string& pathRelativo, int& ancho, int& alto, unsigned char*& imagen);
			//
		protected:
			/* Constructor*/
			ControladorHistorial();
			~ControladorHistorial();

			//region "helpers"
			//devuelve false si !copia y no esta donde deberia
			bool RellenaDCM(ModeloDCM& modelo,const std::string& pathAbsoluto,ListaPaths& listaSobreescritos, bool forzarSobreescribir = false, bool copia = false, bool mover = false);

			bool EliminarFicheros(const std::list<std::string>& pathsRelativosFicheros, bool eliminarDeDisco);
			bool QuitarFicheros(const std::list<std::string>& pathsFicheros);

			bool InsertarPaciente(const std::string& idPaciente, const std::string& nombre, const std::string& fechaNacimento,const char& sexo);
			bool InsertarEstudio(const std::string& uidEstudio, const std::string& descripcion, const std::string& m_nombreMedico, const std::string& fecha,const std::string& hora,const std::string& idPaciente);
			bool InsertarSerie(const std::string& uidSerie, const std::string& descripcion, const std::string& fecha,const std::string& hora,const std::string& uidEstudio);
			bool InsertarFichero(const std::string& pathRelativo, const std::string& uidFichero, const std::string& modalidad,const std::string& descripcion,
				const std::string& uidImportador, const std::string& fecha,const std::string& hora, const std::string& transferSyntax, const std::string& uidSerie);
			bool InsertarTagsOrdenacion(const std::string& pathRelativo, const char orientacion, double posicion[3], double sliceLocation, const std::string& height,
				const std::string& width, double instanceNumber, const std::string& fecha,const std::string& hora);
			void InstertarReferencias(const std::string& uidOrigen, const std::string& uidDestino);

			bool ActualizarEstudio(const std::string& uidEstudio, const std::string& descripcion, const std::string& m_nombreMedico, const std::string& fecha,const std::string& hora);
			bool ActualizarSerie(const std::string& uidSerie, const std::string& descripcion, const std::string& fecha,const std::string& hora);
			bool ActualizarFichero(const std::string& pathRelativo,const std::string& descripcion,
				const std::string& uidImportador, const std::string& fecha,const std::string& hora);
			void ActualizarReferencias(const std::string& uidOrigen, const std::string& uidDestino);

			//sincrono con la interfaz
			void PurgarHistorial();

			void EliminarFicherosDisco(std::list<std::string>&listaFicherosRelativos);

			//endergion

			wxSQLite3Database* m_pConexion;
			wxSQLite3Database* m_pConexionThumbnails;
			wxCriticalSection* m_pCriticalSection;
		};
	}
}
