/*
 *
 *  $Id: controladorherramientas.cpp 3746 2011-04-19 10:41:32Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <api/globals.h>
#include <api/ientorno.h>
#include <wx/aui/aui.h>
#include <wx/aui/auibar.h>
#include <api/icontroladorvistas.h>
#include <main/barraherramientasderecha.h>
#include <main/entorno.h>
#include "controladorherramientas.h"
#include <api/ientorno.h>
#include <resources/ginkgoresourcemanager.h>
#include <api/icontextoestudio.h>
#include "controladorherramientas.h"
#include <wx/xml/xml.h>
#include <api/internacionalizacion.h>

#include <main/entorno.h>
#include <main/gui/mainwindow/ventanaprincipal.h>

//region "Patron singleton"
// <editor-fold defaultstate="collapsed" desc="patron singleton">
#define ID_WX_HERRAMIENTA 1001

class BarraHerramientasControlador:public AUI_NAMESPACE wxAuiToolBar{
public:
	BarraHerramientasControlador(wxWindow* pParent,GNC::ControladorHerramientas* pControlador,const GNC::GCS::IHerramienta::TFamiliasHerramientas& familia):AUI_NAMESPACE wxAuiToolBar(pParent,wxID_ANY, wxDefaultPosition, wxDefaultSize,AUI_NAMESPACE wxAUI_TB_DEFAULT_STYLE )
	{
		this->Connect(wxID_ANY,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( BarraHerramientasControlador::OnActivarHerramienta));
		SetToolBitmapSize(wxSize(16,16));
		m_pControlador = pControlador;
		AUI_NAMESPACE wxAuiDefaultToolBarArt* pToolArt= new AUI_NAMESPACE wxAuiDefaultToolBarArt();
#if !defined(__WXOSX__) && defined(USE_PATCHED_LIBS)
		wxColor color = pToolArt->GetDefaultBaseColor();
		switch(familia) {
			case GNC::GCS::IHerramienta::TFamiliaVisualizacion:
				color = wxColor(255,255,186);
				break;
			case GNC::GCS::IHerramienta::TFamiliaAnotacion:
				color = wxColor(255,186,186);
				break;
			case GNC::GCS::IHerramienta::TFamiliaMedicion:
				color = wxColor(217,255,186);
				break;
			case GNC::GCS::IHerramienta::TFamiliaVision:
				color = wxColor(186,230,255);
				break;
			case GNC::GCS::IHerramienta::TFamiliaChroma:
				color = wxColor(230,181,242);
				break;
			case GNC::GCS::IHerramienta::TMenuVer:
				break;
			case GNC::GCS::IHerramienta::TMenuImagen:
				break;
			case GNC::GCS::IHerramienta::TMenuHerramientas:
				break;
			case GNC::GCS::IHerramienta::TMenuEdicion:
				break;
			case GNC::GCS::IHerramienta::TMenu3D:
				break;
		}
		pToolArt->SetBaseColor(color);
#endif

		SetArtProvider(pToolArt);
	}

	~BarraHerramientasControlador()
	{
		this->Disconnect(wxID_ANY,wxEVT_COMMAND_TOOL_CLICKED, wxCommandEventHandler( BarraHerramientasControlador::OnActivarHerramienta));
		m_pControlador=NULL;
	}

	void OnActivarHerramienta(wxCommandEvent& event)
	{
		m_pControlador->OnActivarHerramienta(event);
	}


	GNC::ControladorHerramientas* m_pControlador;

};

GNC::ControladorHerramientas::ControladorHerramientas()
{
	m_pVistaActiva = NULL;
	m_pModuloActivo = NULL;
	GNC::Entorno* pEntorno = GNC::Entorno::Instance();

	pEntorno->ObservadoresExtensiones.push_back(this);
	pEntorno->ObservadoresVistas.push_back(this);

	m_contadorHerramientas = ID_WX_HERRAMIENTA;

	m_pBarraSinOpciones = new AUI_NAMESPACE wxAuiToolBar(pEntorno->GetPanelHerramientasSuperior(),wxID_ANY, wxDefaultPosition, wxDefaultSize,AUI_NAMESPACE wxAUI_TB_DEFAULT_STYLE | AUI_NAMESPACE wxAUI_TB_HORZ_TEXT);
	m_pBarraSinOpciones->AddTool(wxID_ANY,_("No options"),GinkgoResourcesManager::IconosHerramientas::GetIcoSinOpciones());
	m_pBarraSinOpciones->EnableTool(wxID_ANY,false);
	m_pBarraSinOpciones->Realize();
	pEntorno->GetSizerHerramientasOpciones()->Add(m_pBarraSinOpciones, 1, wxEXPAND, 0);
	m_pBarraSinOpciones->Show(false);

	//ñapa para que se inserten en orden las barras de herramientas
	for(int familia = GNC::GCS::IHerramienta::TFamiliaVisualizacion; familia<= GNC::GCS::IHerramienta::TFamiliaVision; ++familia)
	{
		BarraHerramientasControlador* pBarraHerramientas = new BarraHerramientasControlador(pEntorno->GetPanelHerramientasSuperior(),this,(GNC::GCS::IHerramienta::TFamiliasHerramientas)familia);
		pBarraHerramientas->SetAutoLayout(true);
		pEntorno->GetSizerHerramientas()->Add(pBarraHerramientas, 0, wxEXPAND, 0);
		m_MapaBarrasHerramientas[(GNC::GCS::IHerramienta::TFamiliasHerramientas)familia] = pBarraHerramientas;
	}

	m_pBarraHerramientasDerecha = new GNC::GUI::BarraHerramientasDerecha(pEntorno->GetPanelHerramientasSuperior(), pEntorno->GetVentanaPrincipal());
	pEntorno->GetPanelHerramientasSuperior()->GetSizer()->Add( m_pBarraHerramientasDerecha, 0, wxEXPAND, 0 );
}

GNC::ControladorHerramientas::~ControladorHerramientas()
{
	bool found;

	GNC::Entorno* pEntorno = GNC::Entorno::Instance();

	GNC::Entorno::ListaObservadoresVistas::iterator it1;
	GNC::Entorno::ListaObservadoresExtensiones::iterator it2;

	found = false;
	for (it1 = pEntorno->ObservadoresVistas.begin(); !found && it1 != pEntorno->ObservadoresVistas.end(); it1++) {
		if (*it1 == this) {
			pEntorno->ObservadoresVistas.erase(it1);
			break;
		}
	}
	found = false;
	for (it2 = pEntorno->ObservadoresExtensiones.begin(); !found && it2 != pEntorno->ObservadoresExtensiones.end(); it2++) {
		if (*it2 == this) {
			pEntorno->ObservadoresExtensiones.erase(it2);
			break;
		}
	}

	for(MapaHerramientas::iterator it = m_Herramientas.begin(); it!= m_Herramientas.end(); it++) {
		delete (*it).second;
	}
	m_Herramientas.clear();
	m_MapaIdsHerramientas.clear();
}

GNC::ControladorHerramientas* GNC::ControladorHerramientas::Instance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new GNC::ControladorHerramientas();
	}
	return m_pInstance;
}

void GNC::ControladorHerramientas::FreeInstance()
{
	if (m_pInstance != NULL) {
		delete m_pInstance;
		m_pInstance = NULL;
	}

}

GNC::ControladorHerramientas* GNC::ControladorHerramientas::m_pInstance = 0;

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Realizacion de la interfaz IControladorHerramientas"
// <editor-fold defaultstate="collapsed" desc="gestion de herramientas">

/* Registra una herramienta */
void GNC::ControladorHerramientas::RegistrarHerramienta(GNC::GCS::IHerramienta* pHerramienta)
{

	GTRACE("GNC::ControladorHerramientas::RegistrarHerramienta( Herramienta = " << pHerramienta << ")");
	if (pHerramienta == NULL) {
		throw GNC::GCS::ControladorHerramientasException(_Std("Null Tool"));
	}

	MapaHerramientas::const_iterator it = m_Herramientas.find(pHerramienta->ID);

	if (it != m_Herramientas.end()) {
		throw GNC::GCS::ControladorHerramientasException(_Std("Duplicate Tool"));
	}
	m_Herramientas[pHerramienta->ID] = pHerramienta;

	//m_Herramientas.put(pHerramienta->ID, pHerramienta);

	//Se le da un id wxWidgets y se mete en el mapa
	int idWx = m_contadorHerramientas++;
	m_MapaIdsHerramientas[idWx++] = pHerramienta->ID;

	pHerramienta->SetSolicitadorCambioHerramienta(this);
	pHerramienta->DoCrearPaneles(GNC::Entorno::Instance()->GetPanelHerramientasSuperior(), GNC::Entorno::Instance()->GetSizerHerramientasOpciones());

	RefrescarHerramientas();
}

/* Des-Registra una herramienta */
void GNC::ControladorHerramientas::DesRegistrarHerramienta(GNC::GCS::IHerramienta* pHerramienta)
{
	for (MapaIdsHerramientas::iterator it = m_MapaIdsHerramientas.begin(); it != m_MapaIdsHerramientas.end(); it++) {
		if ((*it).second == pHerramienta->ID) {
			m_MapaIdsHerramientas.erase(it);
			break;
		}
	}
	//GTRACE("GNC::ControladorHerramientas::DesRegistrarHerramienta( Herramienta = " << pHerramienta << ")");
	for (MapaHerramientas::iterator it = m_Herramientas.begin(); it != m_Herramientas.end(); it++) {
		if ((*it).second == pHerramienta) {
			pHerramienta->Activar(false);
			pHerramienta->SetSolicitadorCambioHerramienta(NULL);
			m_Herramientas.erase(it);
			break;
		}
	}
}

GNC::GCS::IHerramienta* GNC::ControladorHerramientas::ObtenerHerramienta(GNC::GCS::IHerramienta::UID id)
{
	GNC::GCS::IHerramienta* pHerramienta = NULL;
	MapaHerramientas::iterator it = m_Herramientas.find(id);
	if (it != m_Herramientas.end()) {
		pHerramienta = (*it).second;
	}
	return pHerramienta;
}

bool GNC::ControladorHerramientas::MostrarHerramientaBarra(GNC::GCS::IHerramienta* pHerramienta, bool mostrar)
{
	AUI_NAMESPACE wxAuiToolBar* pBarraHerramientas = GetBarraHerramientasFamilia(pHerramienta->IDFamilia);
	const int idWx = GetIdWx(pHerramienta->ID);
	if(mostrar){
		if(pBarraHerramientas->FindTool(idWx)==NULL && !pHerramienta->IsMenu()){
			//si no esta metida...
			pBarraHerramientas->AddTool(idWx,wxString::FromUTF8(pHerramienta->Nombre.c_str()),pHerramienta->GetIcono(),wxString::FromUTF8(pHerramienta->GetDescripcion().c_str()),wxITEM_CHECK);

			return true;
		}
	}
	else{
		if(pBarraHerramientas->FindTool(idWx)!=NULL){
			//si esta metida...
			pBarraHerramientas->DeleteTool(idWx);
			return true;
		}
	}
	return false;
}

void GNC::ControladorHerramientas::HabilitarHerramientaBarra(GNC::GCS::IHerramienta* pHerramienta, bool habilitar)
{
	AUI_NAMESPACE wxAuiToolBar* pBarraHerramientas = GetBarraHerramientasFamilia(pHerramienta->IDFamilia);
	const int idWx = GetIdWx(pHerramienta->ID);
	pBarraHerramientas->EnableTool(idWx,habilitar);
}
void GNC::ControladorHerramientas::ActivarHerramientaBarra(GNC::GCS::IHerramienta* pHerramienta, bool activar)
{
	AUI_NAMESPACE wxAuiToolBar* pBarraHerramientas = GetBarraHerramientasFamilia(pHerramienta->IDFamilia);
	AUI_NAMESPACE wxAuiToolBar* barraOpciones = pHerramienta->GetPanelHerramientaOpciones();
	const int idWx = GetIdWx(pHerramienta->ID);
	pBarraHerramientas->ToggleTool(idWx,activar);
	if(barraOpciones!=NULL){
		barraOpciones->Show(activar);
		if (activar) {
			//barraOpciones->Layout();
                        //barraOpciones->Refresh(true);
		}
	} else {
		m_pBarraSinOpciones->Show(activar);
		if (activar) {
			//m_pBarraSinOpciones->Layout();
                        //m_pBarraSinOpciones->Refresh(true);
		}
	}
}

unsigned long GNC::ControladorHerramientas::GetIdWx(unsigned long idHerramienta)
{
	for (MapaIdsHerramientas::iterator it = m_MapaIdsHerramientas.begin(); it != m_MapaIdsHerramientas.end(); it++) {
		if ((*it).second == idHerramienta) {
			return (*it).first;
		}
	}
	std::cerr << "Error al registrar herramientas se ha pedido la herramienta no registrada con id: " << idHerramienta << std::endl;
	return 0;
}


/* Refresca las propiedades (visibilidad, etc) de las herramientas frente a cambios de estado */
void GNC::ControladorHerramientas::RefrescarHerramientas()
{
	GTRACE("GNC::ControladorHerramientas::RefrescarHerramientas()");
	// Obtenemos la herramienta activa en el módulo
	GNC::GCS::IHerramienta* pHerramientaActivaEnModulo = NULL;
	if (m_pModuloActivo != NULL && m_pVistaActiva != NULL) {
		pHerramientaActivaEnModulo = m_HerramientaActiva[m_pModuloActivo];
	}

	#ifdef _GINKGO_TRACE
	std::cout << "RefrescarHerramientas() HerramientaActivaEnModulo = ";
	if (pHerramientaActivaEnModulo != NULL ) {
		std::cout << pHerramientaActivaEnModulo->Nombre.c_str();
	}
	else {
		std::cout << "NULL";
	}
	std::cout << std::endl;
	#endif
	//si se ha añadido/eliminado alguna pues habra que hacer rebuild...
	bool rebuild=false;

	GNC::GCS::IHerramienta* pHerramientaActiva = NULL;

	for (MapaHerramientas::iterator it = m_Herramientas.begin(); it != m_Herramientas.end(); it++) {
		GNC::GCS::IHerramienta* pHerramienta = (*it).second;

		if (pHerramienta != NULL) {
			pHerramienta->SetVistaActiva(m_pVistaActiva);
			pHerramienta->Conectar(false);
			bool validaContratos = pHerramienta->ValidaContratos(m_pVistaActiva);

			if ( pHerramientaActivaEnModulo == NULL || pHerramienta == pHerramientaActivaEnModulo) {
				if (!validaContratos) {
					//no se muestra, no hace falta desactivarla
					pHerramienta->Habilitar(false);
					pHerramienta->Mostrar(false);
					GTRACE("Asignada HerramientaActivaModulo = NULL, por no validar contratos.");

					rebuild = MostrarHerramientaBarra(pHerramienta,false) || rebuild ;
				}
				else {
					rebuild = MostrarHerramientaBarra(pHerramienta,true) || rebuild ;

					if (m_pVistaActiva != NULL && m_pVistaActiva->SoportaHerramienta(pHerramienta)) {
						pHerramienta->Activar(true);
						pHerramienta->Habilitar(true);
						pHerramienta->Mostrar(true);
						pHerramienta->Conectar(true);

						HabilitarHerramientaBarra(pHerramienta,true);
						ActivarHerramientaBarra(pHerramienta,true);
						pHerramientaActiva = pHerramienta;

						if(pHerramientaActivaEnModulo == NULL){
							pHerramientaActivaEnModulo = pHerramientaActiva;
							m_HerramientaActiva[m_pModuloActivo] = pHerramientaActiva;
						}
					}
					else {
						pHerramienta->Activar(false);
						pHerramienta->Habilitar(false);
						pHerramienta->Mostrar(true);
						pHerramienta->Conectar(true);

						HabilitarHerramientaBarra(pHerramienta,false);
						ActivarHerramientaBarra(pHerramienta,false);
					}
				}
			}
			else if (pHerramienta->Habilitada()) {
				if (!validaContratos) {
					pHerramienta->Activar(false);
					pHerramienta->Habilitar(false);
					pHerramienta->Mostrar(false);

					rebuild = MostrarHerramientaBarra(pHerramienta,false) || rebuild ;
				}
				else if (m_pVistaActiva != NULL && m_pVistaActiva->SoportaHerramienta(pHerramienta)) {
					pHerramienta->Activar(false);
					pHerramienta->Habilitar(true);
					pHerramienta->Mostrar(true);

					rebuild = MostrarHerramientaBarra(pHerramienta,true) || rebuild ;
					HabilitarHerramientaBarra(pHerramienta,true);
					ActivarHerramientaBarra(pHerramienta,false);
				}
				else {
					pHerramienta->Activar(false);
					pHerramienta->Habilitar(false);
					pHerramienta->Mostrar(true);

					rebuild = MostrarHerramientaBarra(pHerramienta,true) || rebuild ;
					HabilitarHerramientaBarra(pHerramienta,false);
					ActivarHerramientaBarra(pHerramienta,false);
				}
			}
			else {
				if (!validaContratos) {
					pHerramienta->Activar(false);
					pHerramienta->Habilitar(false);
					pHerramienta->Mostrar(false);

					rebuild = MostrarHerramientaBarra(pHerramienta,false) || rebuild ;
				}
				else if (m_pVistaActiva != NULL && m_pVistaActiva->SoportaHerramienta(pHerramienta)) {
					pHerramienta->Activar(false);
					pHerramienta->Habilitar(true);
					pHerramienta->Mostrar(true);

					rebuild = MostrarHerramientaBarra(pHerramienta,true) || rebuild ;
					HabilitarHerramientaBarra(pHerramienta,true);
					ActivarHerramientaBarra(pHerramienta,false);
				}
				else {
					pHerramienta->Activar(false);
					pHerramienta->Habilitar(false);
					pHerramienta->Mostrar(true);

					rebuild = MostrarHerramientaBarra(pHerramienta,true) || rebuild ;
					HabilitarHerramientaBarra(pHerramienta,false);
					ActivarHerramientaBarra(pHerramienta,false);
				}
			}
		}
	}

	//si no tiene opciones hay q darle otro toque
	if(m_pVistaActiva == NULL)
	{
		m_pBarraHerramientasDerecha->Show(false);
		m_pBarraSinOpciones->Show(false);
	} else {
		if((pHerramientaActiva == NULL) || (pHerramientaActiva != NULL && pHerramientaActiva->GetPanelHerramientaOpciones() == NULL) ) {
			m_pBarraSinOpciones->Show(true);
		} else {
			m_pBarraSinOpciones->Show(false);
		}
		m_pBarraHerramientasDerecha->Show(true);
	}

	ReconstruirBarrasHerramientas(rebuild);
	GNC::Entorno::Instance()->GetPanelHerramientasSuperior()->Layout();

	#ifdef _GINKGO_TRACE
	std::cout << "--" << std::endl;
	#endif
}

GNC::ControladorHerramientas::ListaHerramientas GNC::ControladorHerramientas::GetHerramientas(){
	ListaHerramientas lista;
	for(MapaHerramientas::iterator it = m_Herramientas.begin(); it!= m_Herramientas.end(); it++){
		lista.push_back((*it).second);
	}
	return lista;
}

GNC::ControladorHerramientas::TMapaHerramientasOrdenadas GNC::ControladorHerramientas::GetHerramientasOrdenadas(){
	TMapaHerramientasOrdenadas mapa;
	for(MapaHerramientas::iterator it = m_Herramientas.begin(); it!= m_Herramientas.end(); it++){
		GNC::GCS::IHerramienta * pHerramienta = (*it).second;
		if(mapa.find(pHerramienta->IDFamilia) == mapa.end()) {
			mapa[pHerramienta->IDFamilia] = TMapaSubConjuntosHerramientas();
		}
		mapa[pHerramienta->IDFamilia][pHerramienta->IDSubFamilia].push_back(pHerramienta);
	}

	return mapa;
}

void GNC::ControladorHerramientas::Deserializar(GNC::GCS::IVista* pVista, int posicion, wxXmlNode* root, const std::string& sopInstanceUID)
{
	wxXmlNode *child = root->GetChildren();
	wxString wxSopInstance = wxString::FromUTF8(sopInstanceUID.c_str());
	wxString propVal;

	while(child) {
		if(child->GetName() == wxT("tools")){
			propVal = child->GetPropVal(wxT("sop_instance_uid"), wxEmptyString);
			if (propVal == wxSopInstance)
				break;
		}
		child = child->GetNext();
	}

	if(child == NULL){
		//se buscan nodos tools sin identificar (deprecated)
		child = root->GetChildren();
		while(child) {
			if(child->GetName() == wxT("tools")){
				propVal = child->GetPropVal(wxT("sop_instance_uid"), wxT("undefined"));
				if (propVal == wxEmptyString)
					break;
			}
			child = child->GetNext();
		}
		if (child == NULL)
			return;
	}

	child = child->GetChildren();
	while (child) {
		//se pilla el id de la herramienta
		wxString strTmp = child->GetPropVal(wxT("id"),wxT(""));
		double doubleTmp;
		if(strTmp.ToDouble(&doubleTmp)){
			int id = (int) doubleTmp;
			//se busca la herramienta con ese id y se desserializa
			GNC::GCS::IHerramienta* pH = ObtenerHerramienta(id);
			if(pH != NULL) {
				pH->Deserializar(pVista, posicion,child);
			}
		}
		child = child->GetNext();
	}

}

/*Serializa las herramientas asociadas a la vista y posicion que se le pasa como parametro y lo agrega al nodo*/
void GNC::ControladorHerramientas::Serializar(GNC::GCS::IVista* pVista, int posicion, wxXmlNode* root, const std::string& nombreMedicoSerializa, const std::string& sopInstanceUID)
{
	wxString propVal;
	wxString wxSopInstance = wxString::FromUTF8(sopInstanceUID.c_str());

	//se busca en la raiz un nodo "tools" con sop_instance_uid == al que nos pasan y se borra
	for (wxXmlNode* nodo = root->GetChildren(); nodo != NULL; nodo = nodo->GetNext()) {
		if (nodo->GetName() == wxT("tools")) {
			propVal = nodo->GetPropVal(wxT("sop_instance_uid"), wxEmptyString);
			if( propVal == wxSopInstance ) {
				root->RemoveChild(nodo);
				break;
			}
		}
	}

	wxXmlNode* nodoHerramientas = new wxXmlNode(NULL,wxXML_ELEMENT_NODE,wxT("tools"));
	nodoHerramientas->AddProperty(wxT("sop_instance_uid"), wxSopInstance);

	/*se recorren todas las herramientas y se les pide que serialicen para la vista que se le pasa como parametro*/
	for(MapaHerramientas::iterator it = m_Herramientas.begin(); it != m_Herramientas.end(); it++){
		wxXmlNode* nodo = (*it).second->Serializar(pVista,posicion,nombreMedicoSerializa);
		if(nodo!=NULL){
			nodoHerramientas->AddChild(nodo);
		}
	}
	root->AddChild(nodoHerramientas);
}

// </editor-fold>
//endregion

//region "Realizacion de interfaz de observacion de extensiones"
// <editor-fold defaultstate="collapsed" desc="Realizacion de interfaz IObservadorExtensiones...">

void GNC::ControladorHerramientas::OnModuloCargado(GNC::GCS::IControladorModulo* pModulo)
{
	GTRACE("GNC::ControladorHerramientas::OnModuloCargado(" << pModulo << ")");
	m_HerramientaActiva[pModulo] = NULL;
}

void GNC::ControladorHerramientas::OnModuloDescargado(GNC::GCS::IControladorModulo* pModulo)
{
	GTRACE("GNC::ControladorHerramientas::OnModuloDescargado(" << pModulo << ")");
	HerramientaActivas::iterator it = m_HerramientaActiva.find(pModulo);
	if (it != m_HerramientaActiva.end()) {
		m_HerramientaActiva.erase(it);
	}
}

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Realizacion de interfaz de observacion de vistas"
// <editor-fold defaultstate="collapsed" desc="Realizacion de interfaz de observacion de vistas...">

void GNC::ControladorHerramientas::OnVistaActivada(GNC::GCS::IVista* pVista)
{

	wxWindowDisabler dis;
	GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperFreeze();

	//antes de activar... desactivar si es preciso
	if (m_pVistaActiva != NULL)
	{
		#ifdef _GINKGO_TRACE
		std::cout << "OnVistaDesactivada( " << pVista->GetTitulo().c_str() << ") Modulo = " << pVista->GetControlador()->GetModulo()->GetNombre().c_str() << std::endl;
		std::cout << "  ANT: VistaActiva = " << pVista->GetTitulo().c_str() << ", ModuloActivo = " << m_pModuloActivo->GetNombre().c_str() << std::endl;
		#endif

		GNC::GCS::IHerramienta* pH = m_HerramientaActiva[m_pModuloActivo];
		if (pH != NULL) {
			pH->SetVistaActiva(pVista);
			pH->Conectar(false);
			pH->Activar(false);
			ActivarHerramientaBarra(pH,false);
		}
		m_pVistaActiva = NULL;
		m_pModuloActivo = NULL;

		#ifdef _GINKGO_TRACE
		std::cout << "  DES: VistaActiva = NULL, ModuloActivo = NULL" << std::endl;
		#endif

		RefrescarHerramientas();

		m_pVistaActiva = NULL;
	}


	#ifdef _GINKGO_TRACE
	std::cout << "OnVistaActivada( " << pVista->GetTitulo().c_str() << " ) Modulo = " << pVista->GetControlador()->GetModulo()->GetNombre().c_str() << std::endl;
	std::cout << "  ANT: VistaActiva = ";
	if (m_pVistaActiva != NULL) {
		std::cout << m_pVistaActiva->GetTitulo().c_str();
	}
	else {
		std::cout << "NULL";
	}
	std::cout << ", ModuloActivo = ";
	if (m_pModuloActivo != NULL) {
		m_pModuloActivo->GetNombre().c_str();
	}
	else {
		std::cout << "NULL";
	}
	std::cout << std::endl;
	#endif

	m_pVistaActiva = pVista;
	if(m_pVistaActiva !=NULL){
		m_pModuloActivo = m_pVistaActiva->GetModulo();
	}else{
		m_pModuloActivo = NULL;
	}

	#ifdef _GINKGO_TRACE
	std::cout << "  DES: VistaActiva = " << m_pVistaActiva->GetTitulo().c_str() << ", ModuloActivo = " << m_pModuloActivo->GetNombre().c_str() << std::endl;
	#endif

	RefrescarHerramientas();


	GNC::Entorno::Instance()->GetVentanaPrincipal()->SuperThaw();
}

/*
void GNC::ControladorHerramientas::OnVistaDesactivada(GNC::GCS::IVista* pVista)
{
	#ifdef _GINKGO_TRACE
	std::cout << "OnVistaDesactivada( " << pVista->GetTitulo().c_str() << ") Modulo = " << pVista->GetControlador()->GetModulo()->GetNombre().c_str() << std::endl;
	std::cout << "  ANT: VistaActiva = " << pVista->GetTitulo().c_str() << ", ModuloActivo = " << m_pModuloActivo->GetNombre().c_str() << std::endl;
	#endif

	if (m_pVistaActiva == pVista) {
		GNC::GCS::IHerramienta* pH = m_HerramientaActiva[m_pModuloActivo];
		if (pH != NULL) {
			pH->SetVistaActiva(pVista);
			pH->Conectar(false);
			pH->Activar(false);
			ActivarHerramientaBarra(pH,false);
		}
		m_pVistaActiva = NULL;
		m_pModuloActivo = NULL;

		#ifdef _GINKGO_TRACE
		std::cout << "  DES: VistaActiva = NULL, ModuloActivo = NULL" << std::endl;
		#endif

		RefrescarHerramientas();
	}
}*/

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Interactuacion con herramientas"
// <editor-fold defaultstate="collapsed" desc="Interactuacion con herramientas...">

void GNC::ControladorHerramientas::ActivarHerramientaPorDefecto(GNC::GCS::IControladorModulo* )
{
	;
}

/* Activa la herramienta especificada al módulo especificado. pHerramienta puede ser NULL */
void GNC::ControladorHerramientas::ActivarHerramienta(GNC::GCS::IControladorModulo* , GNC::GCS::IHerramienta::UID )
{
	;
}

/* Obtiene la herramienta activa del módulo especificado. Puede devolver NULL */
GNC::GCS::IHerramienta* GNC::ControladorHerramientas::GetHerramientaActiva(GNC::GCS::IControladorModulo* )
{
	return NULL;
}

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Interfaz de ISolicitadorCambioHerramienta"
// <editor-fold defaultstate="collapsed" desc="Realizacion de interfaz ISolicitadorCambioHerramienta...">

/* Recepción de solicitud de cambio de herramienta */
void GNC::ControladorHerramientas::SolicitarActivacion(GNC::GCS::IHerramienta* herramienta)
{
	GNC::Entorno* pEntorno = GNC::Entorno::Instance();

	wxWindowDisabler dis;

	pEntorno->GetVentanaPrincipal()->SuperFreeze();

	#ifdef _GINKGO_TRACE
	std::cout << "SolicitarActivacion( " << herramienta->Nombre.c_str() << " ). Modulo activo = ";
	if (m_pModuloActivo != NULL) {
		std::cout << m_pModuloActivo->GetNombre().c_str();
	}
	else {
		std::cout << "NULL";
	}
	std::cout  << std::endl;
	if (m_pModuloActivo == NULL) {
		std::cerr << "Aviso: ModuloActivo == NULL. Solicitud ignorada" << std::endl;
		return;
	}
	#endif

	if (herramienta != NULL && (!herramienta->Habilitada() || !herramienta->Mostrada()) ) { // No permitimos activar herramientas no habilitadas u ocultas
		std::cerr << "Herramienta no activada u oculta: " << herramienta->Nombre.c_str() << std::endl;
		pEntorno->GetVentanaPrincipal()->SuperFreeze();
		return;
	}

	HerramientaActivas::iterator it = m_HerramientaActiva.find(m_pModuloActivo);
	if (it == m_HerramientaActiva.end()) {
		pEntorno->GetVentanaPrincipal()->SuperFreeze();
		throw GNC::GCS::ControladorHerramientasException("No se encontro el modulo asociado a la herramienta");
	}

	GNC::GCS::IHerramienta* herramientaAnterior = (*it).second;
	m_pBarraSinOpciones->Show(false);

	if (herramientaAnterior != NULL) { // Deshabilitamos la herramienta anterior
		herramientaAnterior->Conectar(false);
		herramientaAnterior->Activar(false);

		ActivarHerramientaBarra(herramientaAnterior,false);
	}
	if (herramienta != NULL) {
		if (herramienta->Habilitada()) {
			herramienta->Activar(true);
			ActivarHerramientaBarra(herramienta,true);
		}
		herramienta->Conectar(true);

		m_HerramientaActiva[m_pModuloActivo] = herramienta;
	}



	//pEntorno->GetPanelHerramientasSuperior()->GetParent()->Layout();

        pEntorno->GetPanelHerramientasSuperior()->Layout();
       // pEntorno->GetPanelHerramientasSuperior()->GetParent()->Refresh();

	pEntorno->GetVentanaPrincipal()->SuperThaw();


	#ifdef _GINKGO_TRACE
	std::cout << "--" << std::endl;
	#endif

}


void GNC::ControladorHerramientas::OnActivarHerramienta(wxCommandEvent& event)
{
	if(m_MapaIdsHerramientas.find(event.GetId()) != m_MapaIdsHerramientas.end()){
		int idHerramienta = m_MapaIdsHerramientas[event.GetId()];
		SolicitarActivacion(m_Herramientas[idHerramienta]);
	}
}

// </editor-fold>
//endregion

//------------------------------------------------------------------------------
//region "Helpers"
// <editor-fold defaultstate="collapsed" desc="Helpers privados...">
AUI_NAMESPACE wxAuiToolBar* GNC::ControladorHerramientas::GetBarraHerramientasFamilia(GNC::GCS::IHerramienta::TFamiliasHerramientas familia)
{
	if(m_MapaBarrasHerramientas.find(familia) == m_MapaBarrasHerramientas.end()) {
		GNC::GCS::IEntorno* pEntorno = GNC::Entorno::Instance();
		BarraHerramientasControlador* pBarraHerramientas = new BarraHerramientasControlador(pEntorno->GetPanelHerramientasSuperior(),this,familia);
		pBarraHerramientas->SetAutoLayout(true);
		GNC::Entorno::Instance()->GetSizerHerramientas()->Add(pBarraHerramientas, 0, wxEXPAND, 0);
		m_MapaBarrasHerramientas[familia] = pBarraHerramientas;
		return pBarraHerramientas;
	} else {
		return (*m_MapaBarrasHerramientas.find(familia)).second;
	}
}

void GNC::ControladorHerramientas::FreezeBarrasHerramientas()
{
	/*
	for(MapaBarrasHerramientas::iterator it = m_MapaBarrasHerramientas.begin(); it!= m_MapaBarrasHerramientas.end(); it++) {
		(*it).second->Freeze();
	}
	*/
}

void GNC::ControladorHerramientas::ThawBarrasHerramientas()
{
	/*
	for(MapaBarrasHerramientas::iterator it = m_MapaBarrasHerramientas.begin(); it!= m_MapaBarrasHerramientas.end(); it++) {
		if((*it).second->IsFrozen()) {
			(*it).second->Thaw();
		}
	}
	*/
}
void GNC::ControladorHerramientas::ReconstruirBarrasHerramientas(bool rebuild)
{
	for(MapaBarrasHerramientas::iterator it = m_MapaBarrasHerramientas.begin(); it!= m_MapaBarrasHerramientas.end(); it++) {
		if((*it).second->GetToolCount() == 0){
			(*it).second->Show(false);
		} else {
			if(rebuild)
			{
				(*it).second->Realize();
			} else {
				(*it).second->Refresh(true);
			}
			(*it).second->Show(true);
		}
	}
	if (rebuild) {
		m_pBarraHerramientasDerecha->Refresh(true);
	}
}
// </editor-fold>
//endregion
