/*
 *  
 *  $Id: controladorextensiones.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <api/icontroladorextensiones.h>
#include <api/icontroladormodulo.h>
#include <map>
#include <string>

namespace GNC {

	class EXTAPI ControladorExtensiones : public GNC::GCS::IControladorExtensiones {
	public:

		static ControladorExtensiones* Instance();
		static void FreeInstance();

		void RegistrarModulo(GNC::GCS::IControladorModulo* pCtrlModulo);
		void DesRegistrarModulo(GNC::GCS::IControladorModulo* pCtrlModulo);
		void DesRegistrarModulos();

		GNC::GCS::IControladorModulo* ObtenerModulo(const std::string& idModulo);
		GNC::GCS::IControladorModulo* ObtenerModuloSID(const std::string& sidModulo);

		typedef std::map<std::string, GNC::GCS::IControladorModulo*> ListaModulos;
		typedef ListaModulos::iterator IteradorListaModulos;
		typedef ListaModulos::const_iterator IteradorConstanteListaModulos;
		typedef std::map<std::string, std::string> ListaSIDModulos;
		typedef ListaSIDModulos::iterator IteradorListaSIDModulos;
		typedef ListaSIDModulos::const_iterator IteradorConstanteListaSIDModulos;

		std::list<GNC::GCS::IControladorModulo*> ModulosOrdenados();
		const ControladorExtensiones::ListaModulos& Modulos() const;
		const ControladorExtensiones::ListaSIDModulos& SIDModulos() const;

		// Realizacin de la interfaz IControladorExtensiones
		virtual GADVAPI::PrivateExtensionManager& GetPrivateExtensionsManager();

	protected:
		ControladorExtensiones();
		~ControladorExtensiones();

		void NotificarRegistro(GNC::GCS::IControladorModulo* pModulo);
		void NotificarDesRegistro(GNC::GCS::IControladorModulo* pModulo);

	protected:
		static ControladorExtensiones* m_pInstance;
		ListaModulos m_Modulos;
		ListaSIDModulos m_SIDModulos;

		GADVAPI::PrivateExtensionManager m_Manager;

	};
}
