/*
 *  
 *  $Id: controladorcomandos.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/api.h>
#include <api/icontroladorcomandos.h>
#include <api/icomando.h>
#include <api/icontroladorprogreso.h>
#include <api/ilock.h>
//

#include <list>
#include <map>
#include <wx/thread.h>

//----------------------------------------------------------------------------------------------------
//region forward declarations
namespace GNC {

	namespace GCS {
		class ControladorComandos;
	}
}

class wxWindow;
//endregion

namespace GNC {

	//----------------------------------------------------------------------------------------------------
	//----------------------------------------------------------------------------------------------------
	class EXTAPI LanzadorComandos : public wxThread, public GNC::GCS::WaitQueueTask, public GNC::INotificadorProgreso {
	public:
		//id Ginkgo
		unsigned long m_idThreadGinkgo;

		GNC::GCS::IComando* GetComando(){
			return m_pComando;
		}

		virtual void* Entry();

		virtual void OnExit();

		bool RecalcularDependencias();

		void IniciarUnlocker();

	protected:

		virtual void DoTerminar();

	private:

		LanzadorComandos(GNC::GCS::IComando* pComando);

		~LanzadorComandos();

		virtual bool NotificarProgreso(float progresoNormalizado, const std::string& texto);


	private:

		GNC::GCS::IComando*    m_pComando;

		GNC::GCS::WaitQueue m_Dependencias;

		// Esta variable controla si el hilo debe enviar el mensaje de finalizacion o no
		bool                m_Abortar;

		#if defined(_WINDOWS)
		//HANDLE              m_hEventoCancelacion;
		#else

		#endif

		friend class GNC::GCS::ControladorComandos;
	};

	namespace GCS {

		//----------------------------------------------------------------------------------------------------
		//----------------------------------------------------------------------------------------------------
		class EXTAPI ControladorComandos : public IControladorComandos, public GNC::GCS::ILockable {
		public:

			typedef std::map<long, LanzadorComandos*> MapaComandos;
			typedef std::map<long, GNC::GCS::IComando*> MapaComandosTerminados;
			typedef std::list<long> ListaHilos;
			typedef std::map<void*, ListaHilos > MapaOwners;
			typedef std::list<std::string> ListaNombreComandos;

			static ControladorComandos *Instance();
			static void FreeInstance();

			~ControladorComandos();
			virtual void Process(GNC::GCS::IComando* cmd);
			virtual void ProcessAsync(std::string str, GNC::GCS::IComando* cmd, void* owner);
			virtual void AbortarComando(GNC::GCS::IComando* pComando, bool sincrono = true);
			virtual void AbortarComando(long threadId, bool sincrono = true);
			virtual void AbortarComandosDeOwner(void* owner);
			virtual void AbortarComandosDeOwnerAsincrono(void* owner);

			void RegistrarVentana(wxWindow* win)
			{
				m_pWin = win;
			}

			wxWindow* GetVentanaRegistrada()
			{
				return m_pWin;
			}

			void RegistrarProgreso(GNC::IControladorProgreso* pProgreso)
			{
				m_pProgreso = pProgreso;
			}

			GNC::IControladorProgreso* GetProgresoRegistrado()
			{
				return m_pProgreso;
			}

			void OnComandoLanzado(long threadId);
			void OnComandoProgreso(long threadId);
			void OnComandoFinalizado(long threadId, bool lock=true);

			ListaNombreComandos GetComandosActivos();

		protected:

			ControladorComandos();

			static ControladorComandos* m_psInstancia;
			bool m_Destroying;

			MapaComandos m_ComandosLanzados;
			MapaComandosTerminados m_ComandosTerminados;
			MapaOwners m_MapaOwners;
			bool m_EsperarComandos;

			wxWindow* m_pWin;
			GNC::IControladorProgreso* m_pProgreso;

			unsigned long m_idThreads;

			friend class GNC::LanzadorComandos;
		};
	}
}
