/*
*  
*  $Id: comandopacs.h 3700 2011-04-15 07:34:44Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/icomando.h>
#include <api/ivista.h>
#include <api/imodelodicom.h>
#include <api/icontroladorimportacionpacs.h>
#include <api/internacionalizacion.h>
#include <main/controllers/dcmtk/dicomservers.h>



namespace GIL{
	class IModeloIntegracion;
	namespace DICOM{
		class IControladorImportacionPACS;
	}
}

namespace GADAPI {

	namespace PACS {

		typedef enum TipoAccion {
			TAC_Buscar,
			TAC_Descargar,
			TAC_Subir,
			TAC_AbortarTodos
		} TipoAccion;

		class IComandoPACSNotificador{
		public:
			virtual void PACSCargarListado(IModeloDicom* pModelo) = 0;
		};
	}

	class ComandoPACSParams : public GNC::GCS::IComandoParams {

	public:

		typedef enum TipoAmbito {
			TA_Paciente,
			TA_Estudio,
			TA_Serie,
			TA_Imagen,
			TA_NotSpecified
		} TipoAmbito;

		ComandoPACSParams(const std::string& pacienteID, const std::string& pacienteNombre, const std::string& studyUID,
			const std::string& estudioAccNumber, const std::string& estudioModalidad, const std::string& estudioFechaDesde,
			const std::string& estudioFechaHasta, const std::string& studyTimeFrom, const std::string& studyTimeTo, const std::string& serverSeleccionado,
			TipoAmbito ambito, GnkPtr<IModeloDicom> pModeloDicom, GADAPI::PACS::IComandoPACSNotificador* pNotificador)
		{
			m_pacienteID = pacienteID;
			m_pacienteNombre = pacienteNombre;
			m_studyUID = studyUID;
			m_accessionNumber = estudioAccNumber;
			m_estudioModalidad = estudioModalidad;
			m_estudioFechaDesde = estudioFechaDesde;
			m_estudioFechaHasta = estudioFechaHasta;
			m_studyTimeFrom = studyTimeFrom;
			m_studyTimeTo = studyTimeTo;
			m_pNotificador = pNotificador;
			m_pModelo =pModeloDicom;
			m_Ambito = ambito;

			if(serverSeleccionado == "") {
				if(DicomServerList::Instance()->GetList() != NULL) {
					m_serverSeleccionado = DicomServerList::Instance()->GetDefaultServer()->ID;
				} else {
					throw GIL::DICOM::PACSException(_Std("There is not any Remote PACS configured"));
				}
			} else {
				m_serverSeleccionado = serverSeleccionado;
			}
			m_informar=true;
			m_error = "";

			m_TipoAccion=GADAPI::PACS::TAC_Buscar;
			GTRACE("<< ComandoPACSParams::ComandoPACSParams(): " << this);
		}

		//download only specifying 
		ComandoPACSParams(const std::string& serverSeleccionado, const GIL::DICOM::TipoJerarquia& base)
		{
			m_Ambito = TA_NotSpecified;
			
			m_base = base;
			m_pModelo = GnkPtr<IModeloDicom>(new IModeloDicom());

			if(serverSeleccionado == "") {
				//usaremos el primer servidor (por defecto)
				if(DicomServerList::Instance()->GetFirst() !=NULL) {
					m_serverSeleccionado = DicomServerList::Instance()->GetDefaultServer()->ID;
				} else {
					throw GIL::DICOM::PACSException(_Std("There is not any Remote PACS configured"));
				}
			} else {
				m_serverSeleccionado = serverSeleccionado;
			}

			m_informar = false;
			m_error = "";

			m_TipoAccion=GADAPI::PACS::TAC_Descargar;
			GTRACE("<< ComandoPACSParams::ComandoPACSParams(): " << this);
		}

		ComandoPACSParams(const std::string& serverSeleccionado, const std::string uid, TipoAmbito tAm)
		{
			m_pModelo = GnkPtr<IModeloDicom>(new IModeloDicom());
			m_listaUID.push_back(uid);

			m_Ambito = tAm;

			if(serverSeleccionado == "") {
				//usaremos el primer servidor (por defecto)
				if(DicomServerList::Instance()->GetFirst() !=NULL) {
					m_serverSeleccionado = DicomServerList::Instance()->GetDefaultServer()->ID;
				} else {
					throw GIL::DICOM::PACSException(_Std("There is not any Remote PACS configured"));
				}
			} else {
				m_serverSeleccionado = serverSeleccionado;
			}
			m_pNotificador = NULL;
			m_informar = false;
			m_error = "";

			m_TipoAccion = GADAPI::PACS::TAC_Descargar;
			GTRACE("<< ComandoPACSParams::ComandoPACSParams(): " << this);
		}

		ComandoPACSParams(const std::string& serverSeleccionado, const std::vector<std::string>& rutas, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion,GIL::DICOM::TipoTransferSyntaxEnvio transferSyntax = GIL::DICOM::SendDefault)
		{
			if(serverSeleccionado == "") {
				//usaremos el primer servidor (por defecto)
				if(DicomServerList::Instance()->GetFirst() !=NULL) {
					m_serverSeleccionado = DicomServerList::Instance()->GetDefaultServer()->ID;
				} else {
					throw GIL::DICOM::PACSException(_Std("There is not any Remote PACS configured"));
				}
			} else {
				m_serverSeleccionado = serverSeleccionado;
			}
			m_listaRutas = rutas;

			m_pNotificador = NULL;
			m_pModeloIntegracion = pModeloIntegracion;
			m_transferSyntax = transferSyntax;

			m_Ambito = TA_Estudio;
			m_informar=false;
			m_error = "";

			m_TipoAccion=GADAPI::PACS::TAC_Subir;
		}


		virtual ~ComandoPACSParams() {
			GTRACE(">> ComandoPACSParams::~ComandoPACSParams(): " << this);
			m_pNotificador = NULL;
			m_listaRutas.clear();
			GTRACE("<< ComandoPACSParams::~ComandoPACSParams(): " << this);
		}

	public:
		std::string              m_pacienteID;
		std::string              m_pacienteNombre;
		std::string              m_accessionNumber;;
		std::string              m_estudioModalidad;
		std::string              m_estudioFechaDesde;
		std::string              m_estudioFechaHasta;
		std::string					 m_studyTimeFrom;
		std::string					 m_studyTimeTo;
		std::string					 m_studyUID;

		std::list<std::string>   m_listaUID;
		std::list<std::string>   m_listaUIDImagenes;

		std::string              m_serverSeleccionado;

		std::vector<std::string> m_listaRutas;

		bool                     m_informar;

		TipoAmbito               m_Ambito;
		std::string              m_error;

		GADAPI::PACS::IComandoPACSNotificador* m_pNotificador;
		GnkPtr<IModeloDicom> m_pModelo;

		GnkPtr<GIL::IModeloIntegracion> m_pModeloIntegracion;

		GIL::DICOM::TipoJerarquia m_base;

		GADAPI::PACS::TipoAccion m_TipoAccion;
		GIL::DICOM::TipoTransferSyntaxEnvio m_transferSyntax;
	};

	class ComandoPACSResult : public GNC::GCS::IComandoResult {
	public:
		ComandoPACSResult() {
		}

	};

	class EXTAPI ComandoPACS : public GNC::GCS::IComando {
	public:
		ComandoPACS(ComandoPACSParams* pParams);

    protected:
		virtual void Execute();
		virtual void Update();

		virtual void Search();
		virtual void Download();
		virtual void Upload();

    public:

		virtual bool NotificarProgreso(float progresoNormalizado, const std::string &texto);

		void LiberarRecursos();

		ComandoPACSParams* m_pPACSParams;
	};
}
