/*
*  
*  $Id: comandoincluirhistorial.h 3630 2011-03-29 11:28:08Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/icomando.h>
#include <api/icontroladorvistas.h>
#include <main/controllers/controladorhistorial.h>
#include <set>

namespace GNC {
	namespace GCS {
		class IVista;
	}
	namespace GUI {
		class PanelHistorial2;
	}
}

namespace GADAPI {
	//lee un directorio en profundidad y lo incluye en el dicomdir
	namespace ComandoIncluirHistorial
		{
		class ComandoIncluirHistorial;
		class ComandoIncluirHistorialParams : public GNC::GCS::IComandoParams {
		public:
			ComandoIncluirHistorialParams(const std::string& path, bool recursivo = false, bool forzarSobreescribir = false);
			ComandoIncluirHistorialParams(const std::list<std::string>& listaPaths, bool abrirDespuesDeCargar = false, bool forzarSobreescribir = false, GnkPtr<GIL::IModeloIntegracion> pModeloIntegracion = NULL);
			virtual ~ComandoIncluirHistorialParams();

			std::set<std::string> m_listaEstudios;
			std::set<std::string> m_listaSeries;
			std::set<std::string> m_listaImagenes;
			std::string m_path;
			std::list<std::string> m_listaPaths;
			std::list<std::string> m_listaPathsSobreescriben;
			bool m_forzarSobreescribir;
			bool m_recursivo;
			GNC::GCS::ControladorHistorial::ListaModelosDCM m_modelosDCM;
			GnkPtr<GIL::IModeloIntegracion> m_pModeloIntegracion;
			bool m_abrirDespuesDeCargar;
			bool m_informar;
			bool m_borrarDespuesDeIncluir;
		};

		class ComandoIncluirHistorial : public GNC::GCS::IComando {
		public:
			typedef std::list<std::string> TListaPaths;
			typedef std::list<TListaPaths> TListaListas;

			ComandoIncluirHistorial(ComandoIncluirHistorialParams* pParams);

        protected:
			virtual void Execute();
			virtual void Update();

        private:
			void LeerDirectorioRecursivo(wxString& path, TListaListas& listaListasPaths, const int profundidadMaxima = 10, const int profundidadActual=0);



		protected:

			ComandoIncluirHistorialParams* m_pIncluirParams;
		};
	}
}
