/*
*
*  $Id: comandogenerarthumbnails.cpp 3681 2011-04-12 10:53:31Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
//#define _GINKGO_TRACE
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif

#include <cmath>
#include "comandogenerarthumbnails.h"
#include <api/globals.h>

#include <wx/filename.h>
#include <wx/file.h>
#include <wx/image.h>
#include <api/internacionalizacion.h>
#include <resources/ginkgoresourcemanager.h>

#include <main/entorno.h>
#include <main/controllers/controladorhistorial.h>
#include <main/controllers/controladorcarga.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/streaming/streamingloader.h>

#include <vtkSmartPointer.h>
#include <vtkImageData.h>
#include <vtkImageCast.h>
#include <vtkAlgorithmOutput.h>
#include <vtkImageShiftScale.h>
#include <vtkImageMapToRGBA.h>
#include <vtkImageMapToWindowLevelColors.h>
#include <vtkMatrix4x4.h>
#include <vtkImageReslice.h>
#include <vtkExecutive.h>
#include <vtkInformationVector.h>
#include <itk/itkVTKImageToImageFilter.h>
#include <vtkVISUManagement/vtkLookupTableManager.h>
#include <vtkJPEGWriter.h>


#include <itkExceptionObject.h>
#include <itkImage.h>
#include <itkOrientedImage.h>
#include <itkRGBPixel.h>
#include <itkGDCMImageIO.h>
#include <itkImageFileReader.h>
#include <itkVectorResampleImageFilter.h>
#include <itkLinearInterpolateImageFunction.h>
#include <itkImageDuplicator.h>

#define UID_MPEG2MainProfileAtMainLevelTransferSyntax "1.2.840.10008.1.2.4.100"
#define UID_MPEG2MainProfileAtHighLevelTransferSyntax "1.2.840.10008.1.2.4.101"

#define IDC_GENERAR_THUMBNAILS       81
#define SIZE_THUMBNAILS 96

namespace GADAPI {
	class ComandoGenerarThumbnailsParams: public GNC::GCS::IComandoParams {
	public:
		ComandoGenerarThumbnailsParams(const std::string& ruta, INotificadorThumbnail* pNotificador)
		{
			m_ruta = ruta;
			m_wxImg = NULL;
			m_pNotificadorThumbnail = pNotificador;
		}

		virtual ~ComandoGenerarThumbnailsParams() {
			if (m_wxImg != NULL) {
				delete m_wxImg;
				m_wxImg = NULL;
			}
		}

		std::string m_ruta;
		GNC::GCS::ControladorHistorial::ModeloDCM m_modeloDCM;
		wxImage*                        m_wxImg;
		INotificadorThumbnail*			m_pNotificadorThumbnail;

	};

	ComandoGenerarThumbnails::ComandoGenerarThumbnails(const std::string& ruta, INotificadorThumbnail* pNotificador) : IComando(NULL, "GenerarThumbnails")
	{
		m_Error = false;
		GTRACE(">> ComandoGenerarThumbnails::ComandoGenerarThumbnails(): " << this);
		m_pThumbParams = new ComandoGenerarThumbnailsParams(ruta, pNotificador);
		m_pParams = m_pThumbParams;
		SetId(IDC_GENERAR_THUMBNAILS);
		EsperaA(IDC_GENERAR_THUMBNAILS);
		GTRACE("<< ComandoGenerarThumbnails::ComandoGenerarThumbnails(): " << this);
	}

	void ComandoGenerarThumbnails::Execute()
	{
		m_Error = true;
		GTRACE("Arrancando comando generar thumbnails  " << m_pThumbParams->m_ruta)
		//std::string tarea_Std("Generando thumbnails...");
		//pillamos el uid
		m_pThumbParams->m_modeloDCM = GNC::GCS::ControladorHistorial::Instance()->GetModeloDCM(m_pThumbParams->m_ruta);
		if(m_pThumbParams->m_modeloDCM.m_uidImagen == "") {
			GTRACE("Saliendo generar thumbnails salida1  " << m_pThumbParams->m_ruta);

			return;
		}
		//comprobar si el thumbnail ya estaba generado
		m_pThumbParams->m_wxImg = GetImageFromBD();
		if(m_pThumbParams->m_wxImg != NULL) {
			GTRACE("Saliendo generar thumbnails salida2  " << m_pThumbParams->m_ruta);
			NotificarProgreso(1.0f,_Std("Creating Thumbnail..."));
			m_Error = false;
			return;
		} else {
			//TODO special case video preview...
			if (m_pThumbParams->m_modeloDCM.m_uidTransferSyntax == UID_MPEG2MainProfileAtMainLevelTransferSyntax || 
				m_pThumbParams->m_modeloDCM.m_uidTransferSyntax == UID_MPEG2MainProfileAtHighLevelTransferSyntax) 
			{
				wxBitmap bmp = GinkgoResourcesManager::PanelHistorial::GetMoviePreview();
				m_pThumbParams->m_wxImg = new wxImage();
				(*m_pThumbParams->m_wxImg) = bmp.ConvertToImage();
				GuardarImagen();
				m_Error = false;
				return;
			}

			double size[2]   = {0.0, 0.0};
			unsigned int dimensions[3] = {0, 0, 0};
			double spacing[3] = {0.0, 0.0, 0.0};
			double origin[3] = {0.0, 0.0, 0.0};

			size[0] = SIZE_THUMBNAILS;
			size[1] = SIZE_THUMBNAILS;

			{
				//esto es una nyapa para recuperarnos de errores, antes de leer guardamos en bbdd una imagen negra, si finalmente
				//el thumbnail se genera bien pues se mete, si no pues se quedara negro
				wxImage img(SIZE_THUMBNAILS,SIZE_THUMBNAILS);
				m_pThumbParams->m_wxImg = &img;
				GuardarImagen();
				m_pThumbParams->m_wxImg = NULL;
			}

			typedef itk::RGBPixel<unsigned char> PixelType;
			typedef itk::Image< PixelType,  2 > ImageType;

			typedef itk::VectorResampleImageFilter< ImageType, ImageType > FilterType;
			typedef itk::ImageRegionIterator< ImageType > ImageIteratorType;
			typedef itk::ImageDuplicator< ImageType > DuplicatorType;

			typedef itk::VTKImageToImageFilter<ImageType> TipoFiltro;

			ImageType::SizeType outputSize;
			ImageType::SpacingType outputSpacing;
			ImageType::PointType outputOrigin;

			vtkSmartPointer<vtkImageShiftScale> normalizeFilter = vtkSmartPointer<vtkImageShiftScale>::New();

			outputSize[0] = size[0];
			outputSize[1] = size[1];

			unsigned long imgsize = outputSize[0] * outputSize[1] * sizeof(unsigned char) * 3;
			unsigned char* data = (unsigned char*) malloc (imgsize * sizeof(unsigned char));

			try {

				GNC::StreamingLoader loader;

				loader.SetInput(m_pThumbParams->m_ruta);

				loader.GetDimensions(dimensions);
				loader.GetSpacing(spacing);
				loader.SetOutputOrigin(origin);

				vtkSmartPointer<vtkImageReslice> pReslice = vtkSmartPointer<vtkImageReslice>::New();
				TipoFiltro::Pointer VTK2ITKfiltro = TipoFiltro::New();

				vtkSmartPointer<vtkMatrix4x4> resliceAxes = vtkSmartPointer<vtkMatrix4x4>::New();


				if ( dimensions[0] == 0 || dimensions[1] == 0 || spacing[0] == 0 || spacing[1] == 0) {
					if ( !loader.IsSignalFile()) {
						m_Error = true;
						delete[] data;
						LOG_WARN("GenerarThumbnails", "Error: Imagen de tamao 0. Generacin ignorada.");
						return;
					}

					NotificarProgreso(0.8f,_Std("Creating Thumbnail..."));

					memset(data, 0, imgsize);
					double x, y;
					unsigned int ix, iy;
					const double resx = M_PI * 4.0 / (double) outputSize[0];
					const double resy = (double) 0.25 * outputSize[1];
					const double sy = (double) 0.5 * outputSize[1];

					for (ix = 0; ix < outputSize[0]; ++ix)
					{

						x = ((double) ix);
						y = resy * std::sin(x * resx);
						y += sy;
						iy = std::max<int>(0, std::min<int>(outputSize[0] - 1, (int) std::floor(y + 0.5)) );

						unsigned char* pixel = data + (3 * (iy * outputSize[0] + ix));
						pixel[0] = 0;
						pixel[1] = 255;
						pixel[2] = 128;
					}

				}
				else {


					pReslice->SetInputConnection(loader.GetOutputPort());
					pReslice->SetOutputDimensionality(2);
					pReslice->SetResliceAxesDirectionCosines(
						1, 0, 0,
						0, 1, 0,
						0, 0, 1);
					outputSize[0] = size[0];
					outputSize[1] = size[1];

					double dInputSize[3];
					dInputSize[0] = (double)dimensions[0];
					dInputSize[1] = (double)dimensions[1];

					double dOutputSize[2];
					dOutputSize[0] = (double)outputSize[0];
					dOutputSize[1] = (double)outputSize[1];

					double sX = dOutputSize[0] / dInputSize[0];
					double sY = dOutputSize[1] / dInputSize[1];

					double s = std::min<double>(sX, sY);

					double dOutputSpacing[3];
					dOutputSpacing[0] = spacing[0] / s;
					dOutputSpacing[1] = spacing[1] / s;
					dOutputSpacing[2] = spacing[2];

					pReslice->SetOutputExtent(0, dOutputSize[0] - 1, 0, dOutputSize[1] - 1,  0, 1);
					pReslice->SetOutputSpacing(dOutputSpacing);
					//moves image vertical or horizontal to center thumbnail. x + => left; - => right. y + => up; - => down
					//formula is tested with color images and images with spacing and origin
					origin[0] = (((s - sX) * dInputSize[0] / 2.0f) / s) * spacing[0];
					origin[1] = (((s - sY) * dInputSize[1] / 2.0f) / s)  * spacing[0];
					pReslice->SetOutputOrigin(origin);

					pReslice->SetInterpolationModeToCubic();

					vtkSmartPointer<vtkImageData> timg = pReslice->GetOutput();
					timg->UpdateInformation();

					if(timg->GetNumberOfScalarComponents() > 1) {
						normalizeFilter->SetInputConnection(pReslice->GetOutputPort());
						normalizeFilter->SetOutputScalarTypeToUnsignedChar();

						if (timg->GetScalarType() != VTK_UNSIGNED_CHAR) {

							timg->Update();
							double range[2];
							timg->GetScalarRange(range);

							double diff = range[1]-range[0];
							if (diff > std::numeric_limits<double>::epsilon()) {
								normalizeFilter->SetShift(-range[0]);
								normalizeFilter->SetScale(255.0/(range[1]-range[0]));
							}
						}

						VTK2ITKfiltro->SetInput(normalizeFilter->GetOutput());

					}
					else {
						vtkSmartPointer<vtkImageMapToWindowLevelColors> pImageMap = vtkSmartPointer<vtkImageMapToWindowLevelColors>::New();

						pImageMap->SetInputConnection(pReslice->GetOutputPort());

						vtkSmartPointer<vtkLookupTable> pLookupTable = vtkLookupTableManager::GetLinearLookupTable();

						pLookupTable->UnRegister(NULL);

						pImageMap->SetLookupTable(pLookupTable);

						pImageMap->SetOutputFormatToRGB();

						if (timg->GetScalarType() != VTK_UNSIGNED_CHAR) {
							timg->Update();
							double range[2];
							timg->GetScalarRange(range);

							double diff = range[1]-range[0];

							if (diff > std::numeric_limits<double>::epsilon()) {
								pImageMap->GetLookupTable()->SetRange(range);

								pImageMap->SetWindow(range[1] - range[0]);
								pImageMap->SetLevel(0.5f * (range[0] + range[1]));
							}
						}


						VTK2ITKfiltro->SetInput( pImageMap->GetOutput());

					}
					NotificarProgreso(0.6f,_Std("Creating Thumbnail..."));

					ImageType::Pointer img = VTK2ITKfiltro->GetImporter()->GetOutput();

					VTK2ITKfiltro->GetImporter()->UpdateLargestPossibleRegion();

					NotificarProgreso(0.8f,_Std("Creating Thumbnail..."));

					ImageType::RegionType region = img->GetLargestPossibleRegion();

					ImageIteratorType it (img, region);

					unsigned long off = 0;
					for (it.GoToBegin(); !it.IsAtEnd() && off < imgsize; ++it) {
						ImageType::PixelType& pixel = it.Value();
						data[off++] = pixel.GetRed();
						data[off++] = pixel.GetGreen();
						data[off++] = pixel.GetBlue();
					}
				}

				m_pThumbParams->m_wxImg = new wxImage(outputSize[0], outputSize[1], data, false);
				GuardarImagen();
				NotificarProgreso(1.0f,_Std("Generating thumbnail ..."));

				m_Error = false;

			}
			catch (GNC::GCS::ControladorCargaException &ex1){
				LOG_ERROR("GenerarThumnails", "No se pudo crear el thumbnail para la imagen con ruta [" << m_pThumbParams->m_ruta.c_str() << "]: " << ex1);
				delete[] data;
				//si se cancela el comando
				return;
			}
			catch(itk::ExceptionObject& ex2) {
				LOG_ERROR("GenerarThumnails", "No se pudo crear el thumbnail para la imagen con ruta [" << m_pThumbParams->m_ruta.c_str() << "]: " << ex2.GetDescription());
				std::string descr = ex2.GetDescription();
				delete[] data;
				return;
			}
			catch(std::exception &ex3){
				LOG_ERROR("GenerarThumnails", "No se pudo crear el thumbnail para la imagen con ruta [" << m_pThumbParams->m_ruta.c_str() << "]: " << ex3.what());
				std::string descr = ex3.what();
				//si se cancela el comando
				delete[] data;
				return;
			}
			catch(...){
				LOG_ERROR("GenerarThumnails", "No se pudo crear el thumbnail para la imagen con ruta [" << m_pThumbParams->m_ruta.c_str() << "]: Error interno");
				//si se cancela el comando
				delete[] data;
				return;
			}
		}

		GTRACE("Saliendo generar thumbnails salida correcta  " << m_pThumbParams->m_ruta)
	}

	void ComandoGenerarThumbnails::Update() {
		if (!m_Error) {
			if (m_pThumbParams == NULL || m_pThumbParams->m_wxImg == NULL || !m_pThumbParams->m_wxImg->IsOk()) {
				LOG_ERROR("GenerarThumbnails", "No se pudo establecer la previsualizacion: La imagen es invalida o no fue generada correctamente");
			}
			else {
				GTRACE("ACTUALIZANDO comando generar thumbnails  " << m_pThumbParams->m_ruta)
				m_pThumbParams->m_pNotificadorThumbnail->SetImage(m_pThumbParams->m_ruta, m_pThumbParams->m_wxImg);
			}
		}
	}

	wxImage* ComandoGenerarThumbnails::GetImage()
	{
		return m_pThumbParams->m_wxImg;
	}

	wxImage* ComandoGenerarThumbnails::GetImageFromBD()
	{
		int ancho,alto = 0;
		unsigned char* data = NULL;
		GNC::GCS::ControladorHistorial::Instance()->GetThumbnail(m_pThumbParams->m_ruta, ancho, alto, data);
		if(data != NULL) {
			wxImage* img = new wxImage(ancho,alto,data,false);
			return img;
		} else {
			return NULL;
		}
	}


	unsigned char ClampToByte(int a)
	{
		if (a > 255)
			return 255;
		else if (a < 0)
			return 0;
		else
			return a;
	}

	void ComandoGenerarThumbnails::GuardarImagen()
	{
		if (m_pThumbParams->m_wxImg->IsOk()){

			unsigned char *pixelData = m_pThumbParams->m_wxImg->GetData();


			// Aplicamos un gradiente vertical
			int anchura = m_pThumbParams->m_wxImg->GetWidth();
			int altura = m_pThumbParams->m_wxImg->GetHeight();


			// Aplicamos desde el origen hasta la mitad en altura (255, 255, 255, 100) -> (255, 255, 255, 0)

			for (int y = 0, pos = 0; y < altura; ++y)
			{
				if (y < altura/2)
				{
					const int yNuevo = y*2;
					int factorAlpha = (1.0f - ((float) yNuevo / ((float) altura))) * 72.0f;

					for (int x = 0; x < anchura; ++x, pos+=3)
					{
						pixelData[pos+0] = ClampToByte((int) pixelData[pos+0] + factorAlpha);
						pixelData[pos+1] = ClampToByte((int) pixelData[pos+1] + factorAlpha);
						pixelData[pos+2] = ClampToByte((int) pixelData[pos+2] + factorAlpha);
					}

				} // if altura
			} // for y

			GNC::GCS::ControladorHistorial::Instance()->SetThumbnail(
				m_pThumbParams->m_modeloDCM.m_idPaciente,
				m_pThumbParams->m_modeloDCM.m_uidEstudio,
				m_pThumbParams->m_modeloDCM.m_uidSerie,
				m_pThumbParams->m_modeloDCM.m_pathRelativo,
				m_pThumbParams->m_wxImg->GetWidth(),
				m_pThumbParams->m_wxImg->GetHeight(),
				m_pThumbParams->m_wxImg->GetData());
		}
	}

}
