/*
*  
*  $Id: comandoexportacion.h 3521 2011-03-16 14:54:22Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/icomando.h>
#include <yasper/yasper.h>
#include <main/gui/export/datospersistentesexportacion.h>

namespace GNC {
	namespace GCS {
		class IVista;
	}
}

namespace GADAPI {
	class ComandoExportacion;

	class ComandoExportacionParams : public GNC::GCS::IComandoParams {
	public:
		ComandoExportacionParams(GnkPtr<GNC::GUI::TipoWizardExportacion>& pDatosPersistentes){
			m_pDatosPersistentes = pDatosPersistentes;
			m_hasError = false;
		}

		virtual ~ComandoExportacionParams() {}

		GnkPtr<GNC::GUI::TipoWizardExportacion> m_pDatosPersistentes;
		std::string m_Error;
		bool m_hasError;
	};

	class ComandoExportacion : public GNC::GCS::IComando {
	public:

		ComandoExportacion(ComandoExportacionParams* pParams);

    protected:

		virtual void Execute();
		virtual void Update();

	protected:
		void ExportarDICOM();
		void ExportarImagenes();
		wxString ExportarImage(GNC::GCS::IContratoExportacionImages::ImageType::Pointer img);
		wxString GetFichero(const wxString& dir, const wxString& extension);

		ComandoExportacionParams* m_pExportacionParams;
	};
}
