/*
*  
*  $Id: comandochroma.h 3521 2011-03-16 14:54:22Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/icomando.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtkSmartPointer.h>
#include <vtkImageData.h>

class wxCriticalSection;
class vtkGinkgoImageViewer;

class INotificadorChroma;
namespace GNC {
	namespace GCS {
		class Nodo;
		class IElementoCache;
	}
}

namespace GADAPI {

	namespace Chroma {

		typedef enum TipoAccion {
			TAC_Resetear,
			TAC_Todo,
			TAC_Invertir,
			TAC_SegmentarPunto,
			TAC_CancelarSegmentacion,
			TAC_InsertarRegion,
			TAC_EliminarRegion,
			TAC_SegmentarLazo
		} TipoAccion;

		typedef enum TipoAmbito {
			TAC_Contiguo,
			TAC_Global
		} TipoAmbito;

		class TipoPunto {

		public:

			double coord[3];
			unsigned long UID;

			TipoPunto() {
				coord[0] = 0.0f;
				coord[1] = 0.0f;
				coord[2] = 0.0f;
				UID = 0;
			}

			TipoPunto(unsigned long uid, float x, float y, float z) {
				coord[0] = x;
				coord[1] = y;
				coord[2] = z;
				UID = uid;
			}

			inline friend std::ostream & operator <<(std::ostream& out, const TipoPunto& c) {
				out << "[ x = " << c.coord[0] << ", y = " << c.coord[1] << ", UID = " << c.UID << " ]";

				return out;
			}

			inline friend std::ostream & operator <<(std::ostream& out, TipoPunto* c) {
				if (c == NULL) {
					out << "[ NULL ]";
				}
				else {
					out << *c;
				}
				return out;
			}
		};
	}

	typedef enum {
		MASCARA_SET_CHROMA = 0x80, //un uno en el chroma
		MASCARA_SET_PRESELECCION = 0x40, //un uno en la preseleccion
		MASCARA_UNSET_CHROMA = 0x7F, //un cero en el chroma
		MASCARA_UNSET_PRESELECCION = 0xBF	//un cero en la preseleccion
	} TSeleccion;


	class ComandoChromaParams : public GNC::GCS::IComandoParams {
	public:
		typedef std::list<GNC::GCS::Nodo> TVerticesLazo;

		ComandoChromaParams( GNC::GCS::IElementoCache* pImagen,
			vtkSmartPointer<vtkImageData> pMapaValoracion,
			GADAPI::Chroma::TipoAccion tipoAccion,
			wxCriticalSection* pMEF_CriticalSection,
			INotificadorChroma*  pNotificador,
			float sensibilidad,
			GADAPI::Chroma::TipoAmbito tipoAmbito = GADAPI::Chroma::TAC_Contiguo);

		ComandoChromaParams( GNC::GCS::IElementoCache* pImagen,
			vtkSmartPointer<vtkImageData> pMapaValoracion,
			wxCriticalSection* pMEF_CriticalSection,
			INotificadorChroma*  pNotificador,
			const TVerticesLazo& vertices, vtkGinkgoImageViewer* pVista);

		virtual ~ComandoChromaParams();

	public:

		GNC::GCS::IElementoCache* m_pImagen;
		vtkSmartPointer<vtkImageData> m_pMapaValoracion;
		wxCriticalSection* m_pMEFCriticalSection;
		INotificadorChroma* m_pNotificador;
		float m_sensibilidad;

		GADAPI::Chroma::TipoAccion m_TipoAccion;
		GADAPI::Chroma::TipoAmbito m_TipoAmbito;
		double x;
		double y;
		bool bloqueado;
		bool empty;

		TVerticesLazo         m_Vertices;
		vtkGinkgoImageViewer* m_pVista;
	};

	class ComandoChromaResult : public GNC::GCS::IComandoResult {
	public:
		ComandoChromaResult() {
		}

	};

	class ComandoChroma : public GNC::GCS::IComando {
	public:
		ComandoChroma(ComandoChromaParams* pParams);

    protected:
		void Execute();
		void Update();

	protected:
		ComandoChromaParams* m_pChromaParams;
	};
}
