/*
*  
*  $Id: comandoavisarficheros.cpp 3527 2011-03-16 21:45:37Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
//#define _GINKGO_TRACE
//#define DUMP_IMAGENES
#include <api/globals.h>
#include "comandoavisarficheros.h"
#include <main/controllers/controladoreventos.h>
#include <eventos/eventosginkgo.h>

#define IDC_COMANDO_AVISAR_FICHEROS           113

// Singleton de persistencia
namespace GADAPI {
	ComandoAvisarFicherosParams::ComandoAvisarFicherosParams(const TipoListaFicheros& listaFicheros)
	{
		m_listaFicheros = listaFicheros;
	}

	ComandoAvisarFicheros::ComandoAvisarFicheros(ComandoAvisarFicherosParams* pParams):IComando(pParams)
	{
		SetId(IDC_COMANDO_AVISAR_FICHEROS);
		m_pAvisarParams = pParams;
	}

	void ComandoAvisarFicheros::Execute()
	{
	}

	void ComandoAvisarFicheros::Update()
	{
		//se avisa
		GNC::GCS::Eventos::EventoAddFicheroHistorial::ListaRutas listaRutas;
		for(ComandoAvisarFicherosParams::TipoListaFicheros::iterator it=m_pAvisarParams->m_listaFicheros.begin(); it!=m_pAvisarParams->m_listaFicheros.end(); it++) {
			listaRutas.push_back((*it));
		}
		GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoAddFicheroHistorial(listaRutas,false));
	}

	void ComandoAvisarFicheros::LiberarRecursos()
	{
	}

}


